<?php
class Timeadjustment_model extends CI_Model
{
    public function __construct()
    {
        parent::__construct();
        
        $this->load->model('notification/notification_model');
    }
    public function add($post)
    {
        $full_name = $this->session->userdata('fullname');
        $supervisor_id = !empty($this->session->userdata('direct_supervisor')) ? $this->session->userdata('direct_supervisor') : $this->session->userdata('indirect_supervisor');
        if ($this->session->userdata('isAdmin')) {
            $employee_details = $this->get_employee($post['employee_id']);
            $full_name = [];
            $full_name[] = $employee_details->first_name;
            $full_name[] = $employee_details->middle_name;
            $full_name[] = $employee_details->last_name;
            $full_name = ucwords(implode(' ', $full_name));
            $supervisor_id = !empty($employee_details->super_visor_id) ? $employee_details->super_visor_id : $employee_details->indirect_super_visor_id;
        }
        $add = [
            'checkin' => date('Y-m-d H:i:s', strtotime($post['checkin'])),
            'checkout' => date('Y-m-d H:i:s', strtotime($post['checkout'])),
            'reason' => strip_tags($post['reason']),
            'employee_id' => $this->session->userdata('isAdmin') ? $post['employee_id'] : $this->session->userdata('employee_id'),
            'supervisor' => $supervisor_id,
        ];
        $add = $this->add_fields($add);

        $res = $this->db->insert('time_adjustment', $add);
        if ($res) {
            $notif_data = [
                'text' => $full_name . ' added a Time Adjustment Request ID# ' . $this->db->insert_id(),
                'url' => 'attendance/timeadjustment/all_requests',
                'date' => date('Y-m-d'),
                'created_by' => $this->session->userdata('employee_id') ? $this->session->userdata('employee_id') : $this->session->userdata('id')
            ];
            if(intval($supervisor_id) > 0){
                $notif_data['emp_id'] = $supervisor_id;
            }else{
                $notif_data['dept_id'] = $this->notification_model->hr_id;
            }
            $this->notification_model->notification_create($notif_data);
            return $this->db->insert_id();
        } else {
            return false;
        }
    }
    public function get($id)
    {
        return $this->db->where('id', $id)->get('time_adjustment')->row_array();
    }
    public function update($id, $data)
    {
        return $this->db->where('id', $id)->update('time_adjustment', $data);
    }
    public function process($id, $type)
    {
        $data = $this->get($id);

        if (!$data) {
            return;
        }
        if ($data['supervisor_status'] == 'pending' && $data['supervisor'] == $this->session->userdata('employee_id')) {
            $this->update($id, [
                'supervisor_status' => $type ? 'approved' : 'denied',
            ]);
            $notif_data = [
                'text' => 'Supervisor ' . ($type ? 'Approved' : 'Denied') . ' Time Adjustment Request #' . $id,
                'url' => 'attendance/timeadjustment/all_requests',
                'date' => date('Y-m-d'),
                'created_by' => $this->session->userdata('employee_id') ? $this->session->userdata('employee_id') : $this->session->userdata('id')
            ];
            $notif_data['dept_id'] = $this->notification_model->hr_id;
            $this->notification_model->notification_create($notif_data);
        } elseif ($this->permission->method('atn_time_adjustment_list', 'update')->access() || $this->session->userdata('isAdmin')) {
            if ($type == 'approved') {
                $this->modify_attendance($data);
            }
            $this->update($id, [
                'hr_status' => $type ? 'approved' : 'denied',
                'hr_approver' => $this->session->userdata('employee_id'),
            ]);
            $notif_data = [
                'text' => 'HR ' . ($type ? 'Approved' : 'Denied') . ' Time Adjustment Request #' . $id,
                'url' => 'attendance/timeadjustment/all_requests',
                'date' => date('Y-m-d'),
                'created_by' => $this->session->userdata('employee_id') ? $this->session->userdata('employee_id') : $this->session->userdata('id')
            ];
            $notif_data['emp_id'] = $data['employee_id'];
            $this->notification_model->notification_create($notif_data);
        }
    }
    public function modify_attendance($new_record)
    {
        $date = explode(' ', $new_record['checkin'])[0];
        $old_records = getByWhereAsArray('attendance_history', 'group_no', ['DATE(punchin_time)' => $date, 'uid' => $new_record['employee_id']]);
        $this->db->where_in('group_no', array_column($old_records, 'group_no'))->update('attendance_history', ['active' => 0]);

        $this->load->model('attendence_model');
        return $this->attendence_model->custom_punch($new_record['employee_id'], $new_record['checkin'], $new_record['checkout'], $this->session->userdata('employee_id'));
    }
    public function get_table()
    {
        $where = [];
        if ($this->session->userdata('isAdmin') || $this->permission->method('atn_time_adjustment_list', 'update')->access()) {
        }else{
            $this->db->or_where('tb1.employee_id', $this->session->userdata('employee_id'));
            if ($this->session->userdata('supervisor')) {
                $this->db->or_where('tb1.supervisor', $this->session->userdata('employee_id'));
            }
        }
        return getByWhereAsArray(
            'time_adjustment tb1,
            employee_history tb2-tb1.employee_id=tb2.employee_id-left,
            employee_history tb3-tb1.supervisor=tb3.employee_id-left,
            employee_history tb4-tb1.hr_approver=tb4.employee_id-left',
            'tb1.*,
            CONCAT_WS(\' \', tb2.first_name, tb2.last_name) as employee_name, tb2.email,
            CONCAT_WS(\' \', tb3.first_name, tb3.last_name) as supervisor_name,
            CONCAT_WS(\' \', tb4.first_name, tb4.last_name) as hr_name',
            $where,
            ['added_at', 'DESC']
        );
    }
    private function add_fields($data)
    {
        $data['added_at'] = date('Y-m-d H:i:s');
        $data['modified_at'] = date('Y-m-d H:i:s');
        return $data;
    }
    public function get_employee($id)
    {
        return $this->db->where('employee_id', $id)->get('employee_history')->row();
    }
}
