<?php
class Attendence_model extends CI_Model
{
    public $enums = [
        'P' => 'Present',
        'LA' => 'Late Arrival',
        'EC' => 'Early Checkout',
        'UH-D' => 'Unpaid Half-Day',
        'A' => 'Absent',
        'FD' => 'Full Day',
        'OT' => 'Overtime',
    ];
    public function get_shift($id)
    {
        return $this->db->where('id', $id)->get('shift')->row();
    }
    public function get_shift_by_employee($uid)
    {
        return $this->db->where('employee_history.employee_id', $uid)->select('shift.*')->join('shift', 'employee_history.shift = shift.id', 'left')->get('employee_history')->row();
    }
    public function get_current_status($shift_id, $last_check_type, $punch_time = null, $punchout_time = null, $emp_id = null)
    {
        $shift = $this->get_shift($shift_id);
        if ($shift->flexible_shift) {
            return $this->get_current_status_flexible($shift, $last_check_type, $punch_time, $punchout_time, $emp_id);
        } else {
            return $this->get_current_status_fixed($shift, $last_check_type, $punch_time, $punchout_time, $emp_id);
        }
    }
    public function get_current_status_flexible($shift, $last_check_type, $punch_time, $punchout_time = null, $emp_id = null)
    {
        $status = null;
        switch ($last_check_type) {
            case "out":
                $status = [
                    'flag' => 'P',
                    'note_required' => false,
                ];
                break;
            case "in":
                $shift_percenage = $this->shift_percentage($shift, $punch_time, $punchout_time, $emp_id);
                if ($shift_percenage < 18) {
                    $status = [
                        'flag' => 'A',
                        'note_required' => true,
                    ];
                }
                if ($shift_percenage >= 18 && $shift_percenage < 67) {
                    $status = [
                        'flag' => 'UH-D',
                        'note_required' => true,
                    ];
                }
                if ($shift_percenage >= 67 && $shift_percenage <= 109) {
                    $status = [
                        'flag' => 'FD',
                        'note_required' => false,
                    ];
                }
                if ($shift_percenage > 109) {
                    $status = [
                        'flag' => 'OT',
                        'note_required' => false,
                    ];
                }
                break;
        }
        return $status;
    }
    public function get_current_status_fixed($shift, $last_check_type, $punch_time, $punchout_time = null, $emp_id = null)
    {
        $time = time();
        if ($punch_time) {
            $time = strtotime($punch_time);
        }

        //$todays_shift = $this->shift_to_time($shift);
        $shift_time = $this->shift_to_time($shift, $last_check_type == "in" ? $punch_time : '');

        $start = $shift_time['start'];

        $status = null;
        switch ($last_check_type) {
            case "out":
                /* if (strtotime($punch_time) >= $todays_shift['start'] && strtotime($punch_time) <= $todays_shift['end']) {
                $status = null;
                } else */
                $diff = $time - $start;
                if ($diff < 900) {
                    $status = [
                        'flag' => 'P',
                        'note_required' => false,
                    ];
                }
                if ($diff >= 900 && $diff < 28800) {
                    $status = [
                        'flag' => 'LA',
                        'note_required' => true,
                    ];
                }
                break;
            case "in":
                $shift_percenage = $this->shift_percentage($shift, $punch_time, $punchout_time, $emp_id);
                if ($shift_percenage < 18) {
                    $status = [
                        'flag' => 'A',
                        'note_required' => true,
                    ];
                }
                if ($shift_percenage >= 18 && $shift_percenage < 67) {
                    $status = [
                        'flag' => 'UH-D',
                        'note_required' => true,
                    ];
                }
                if ($shift_percenage >= 67 && $shift_percenage <= 109) {
                    $status = [
                        'flag' => 'FD',
                        'note_required' => false,
                    ];
                }
                if ($shift_percenage > 109) {
                    $status = [
                        'flag' => 'OT',
                        'note_required' => false,
                    ];
                }
                break;
        }
        return $status;
    }
    public function is_nightsift($shift)
    {
        if ($shift->flexible_shift) {
            return false;
        }
        $start = intval(str_replace(':', '', $shift->start));
        $end = intval(str_replace(':', '', $shift->end));

        if ($start > $end) {
            return true;
        }
        return false;
    }
    public function shift_to_time($shift, $punch_time = null)
    {
        if ($shift->flexible_shift) {
            return [];
        }
        if (!$punch_time) {
            $punch_time = date('Y-m-d h:i:s A');
        }

        $punch_date = explode(' ', $punch_time)[0] . ' ';

        if ($this->is_nightsift($shift)) {
            $start = strtotime($punch_date . $shift->start);

            $end = new DateTime($punch_date . $shift->end);
            $end = $end->modify('+1 day')->format('U');
        } else {
            $start = strtotime($punch_date . $shift->start);
            $end = strtotime($punch_date . $shift->end);
        }
        return [
            'start' => $start,
            'end' => $end,
        ];
    }
    public function shift_percentage_by_emp_id($emp_id, $punch_time)
    {

    }
    public function shift_percentage($shift, $punch_time, $punchout = null, $emp_id = null)
    {
        if ($shift->flexible_shift) {
            $shift_period = $shift->flexible_hours * 3600; //convert hours to seconds
        } else {
            $shift_time = $this->shift_to_time($shift, $punch_time);
            $shift_period = $shift_time['end'] - $shift_time['start'];
        }
        $time = $punchout ? strtotime($punchout) : time();
        $current_shift_period = $time - strtotime($punch_time);

        $current_shift_period += $this->previous_punch_sum($emp_id);

        $perc = ($current_shift_period / $shift_period) * 100;

        return is_finite($perc) && $perc >= 1 ? round($perc) : 0;
    }
    public function custom_punch($uid, $start, $end, $author)
    {
        $shift = $this->get_shift_by_employee($uid);

        $percentage = $this->shift_percentage($shift, $start, $end);

        $group_no = $this->db->select('group_no')->order_by('group_no', 'DESC')->get('attendance_history')->first_row();

        if ($group_no) {
            $group_no = intval($group_no->group_no) + 1;
        } else {
            $group_no = 1;
        }
        $flag = '';
        if ($percentage < 18) {
            $flag = 'A';
        } elseif ($percentage >= 18 && $percentage < 67) {
            $flag = 'UH-D';
        } elseif ($percentage >= 67) {
            $flag = 'FD';
        }
        $attendence_data = [
            'group_no' => $group_no,
            'uid' => $uid,
            'id' => 0,
            'state' => 1,
            'time' => date('Y-m-d h:i:s A'),
            'punch_author' => $author,
            'active' => 1,
        ];

        $insert_data = [
            array_merge($attendence_data, ['punchin_time' => $start, 'status' => 'in']),
            array_merge($attendence_data, ['punchout_time' => $end, 'duration' => strtotime($end) - strtotime($start), 'status' => 'out', 'flag' => $flag]),
        ];

        foreach ($insert_data as $ins_data) {
            $this->db->insert('attendance_history', $ins_data);
        }
        return true;
    }
    public function previous_punch_sum($id = null)
    {
        if (!$id) {
            $id = $this->session->userdata('employee_id');
        }
        $res = $this->db
            ->select('SUM(duration) as duration')
            ->where('uid', $id)
            ->where('status', 'out')
            ->where('active', '1')
            ->where('DATE(punchin_time)', date('Y-m-d'))
            ->group_by('group_no')
            ->get('attendance_history')
            ->row();
        if ($res) {
            return intval($res->duration);
        }
        return 0;
    }

    public function employeeAttendanceCheck($get)
    {
        if(!emptyArrayElements($get, ['employee_id', 'dept_id', 'supervisorid'])){
            $this->db->group_start();
            if ($get['employee_id']) {
                $this->db->where_in('employee_id', $get['employee_id']);
            }
            if ($get['dept_id']) {
                $this->db->where_in('dept_id', $get['dept_id']);
            }
            if ($get['supervisorid']) {
                $this->db->where_in('super_visor_id', $get['supervisorid']);
            }
            $this->db->group_end();
        }
        $admin = $this->session->userdata('isAdmin');
        $is_supervisor = $this->session->userdata('supervisor');
        if ($admin != 1 && !$this->permission->method('atn_log_datewise', 'update')->access()) {
            $this->db->group_start();
            $employee_id = $this->session->userdata('employee_id');
            if ($is_supervisor == 1) {
                $this->db->where('super_visor_id', $employee_id);
                $this->db->or_where('employee_id', $employee_id);
                $this->db->or_where('indirect_super_visor_id', $employee_id);
            } else {
                $this->db->where('employee_id', $employee_id);
            }
            $this->db->group_end();
        }
        $this->db->select('employee_id');
        $emp = $this->db->get('employee_history')->result_array();
        return array_column($emp, 'employee_id');
    }

    public function get_report($emp_ids, $start, $end)
    {
        if (!empty($start)) {
            $start .= ' 00:00:00 AM';
            $start = date('Y-m-d H:i:s', strtotime($start));
        }
        if (!empty($end)) {
            $end .= ' 11:59:59 PM';
            $end = date('Y-m-d H:i:s', strtotime($end));
        }

        $emp_data = [];
        foreach ($emp_ids as $emp_id) {
            $emp_details = @getByWhereAsArray(
                'employee_history,
                shift-shift.id=employee_history.shift-left,
                department-employee_history.dept_id=department.dept_id-left',
                'first_name as firstname, last_name as lastname, hrm_id, employee_history.shift, shift.name as shift_name, department_name as department',
                ['employee_id' => $emp_id]
            )[0];
            if ($emp_details) {
                $emp_details = [
                    'employee_id' => $emp_id,
                    'shift_name'=>$emp_details['shift_name'],
                    'department'=>$emp_details['department'],
                    'firstname' => $emp_details['firstname'],
                    'lastname' => $emp_details['lastname'],
                    'hrm_id' => $emp_details['hrm_id'],
                    'attendence' => [],
                ];
            }

            $attendence = $this->db->query(
                "SELECT
                    DATE(punchin_time) as day,
                    MIN(punchin_time) AS punchin_time,
                    MAX(punchout_time) AS punchout_time,
                    SUM(duration) AS duration,
                    GROUP_CONCAT(status) AS status
                FROM (SELECT
                        MIN(punchin_time) AS punchin_time,
                        MAX(punchout_time) AS punchout_time,
                        SUM(duration) AS duration,
                        GROUP_CONCAT(flag) AS status
                    FROM `attendance_history`
                        WHERE `uid` = '$emp_id'
                        AND `active` = '1'
                        GROUP BY `group_no`) attendence
                WHERE COALESCE(`punchin_time`, 0) >= '$start'
                AND COALESCE(`punchin_time`, 0) <= '$end'
                GROUP BY DATE(`punchin_time`)
                ORDER BY `punchin_time` ASC"
            )->result_array();
            foreach ($attendence as $attn) {
                $attn['status'] = array_unique(explode(',', $attn['status']));
                $emp_details['attendence'][$attn['day']] = $attn;
            }
            $emp_data[] = $emp_details;
        }
        return $emp_data;
    }
    public function get_user_day_report($id, $date)
    {
        $emp_details = @getByWhereAsArray(
            'employee_history',
            'first_name as firstname, last_name as lastname, hrm_id',
            ['employee_id' => $id]
        )[0];
        if ($emp_details) {
            $emp_details = [
                'employee_id' => $id,
                'firstname' => $emp_details['firstname'],
                'lastname' => $emp_details['lastname'],
                'hrm_id' => $emp_details['hrm_id'],
                'attendence' => [],
            ];
        }

        $day_recs = $this->db->query(
            "SELECT
                `group_no`
            FROM `attendance_history`
            WHERE DATE(`punchin_time`) = ?
            AND `uid` = ?
            AND `active` = 1",
            [$date, $id]
        )->result_array();
        if ($day_recs) {
            $day_recs = array_column($day_recs, 'group_no');
            $day_recs = implode(',', $day_recs);
            $attendence = $this->db->query(
                "SELECT
                group_no,
                MIN(punchin_time) as punchin_time,
                MAX(punchout_time) as punchout_time,
                SUM(duration) as duration,
                DATE(COALESCE(punchin_time, punchout_time)) as day,
                GROUP_CONCAT( flag SEPARATOR ',') as flag
            FROM `attendance_history`
            WHERE `uid` = '$id'
            AND `active` = 1
            AND `group_no` IN ($day_recs)
            GROUP BY `group_no`
            ORDER BY punchin_time ASC"
            )->result_array();
            foreach ($attendence as $attn) {
                $attn['flag'] = array_unique(explode(',', $attn['flag']));
                $emp_details['attendence'][] = $attn;
            }
        }
        return $emp_details;
    }
    public function get_user_day_report2($id, $date)
    {
        $emp_details = @getByWhereAsArray(
            'employee_history',
            'first_name as firstname, last_name as lastname, hrm_id',
            ['employee_id' => $id]
        )[0];
        if ($emp_details) {
            $emp_details = [
                'employee_id' => $id,
                'firstname' => $emp_details['firstname'],
                'lastname' => $emp_details['lastname'],
                'hrm_id' => $emp_details['hrm_id'],
                'attendence' => [],
            ];
        }

        $day_recs = $this->db->query(
            "SELECT
                `group_no`
            FROM `attendance_history`
            WHERE DATE(`punchin_time`) = ?
            AND `uid` = ?
            AND `active` = 1",
            [$date, $id]
        )->result_array();
        if ($day_recs) {
            $day_recs = array_column($day_recs, 'group_no');
            $day_recs = implode(',', $day_recs);
            $attendence = $this->db->query(
                "SELECT
                group_no,
                MAX(punchin_time) as punchin_time,
                MAX(punchout_time) as punchout_time,
                MAX(duration) as duration,
                DATE(COALESCE(punchin_time, punchout_time)) as day
            FROM `attendance_history`
            WHERE `uid` = '$id'
            AND `active` = 1
            AND `group_no` IN ($day_recs)
            GROUP BY `group_no`
            ORDER BY punchin_time ASC"
            )->result_array();
            foreach ($attendence as $attn) {
                $attn['flag'] = array_unique(explode(',', $attn['flag']));
                $emp_details['attendence'][] = $attn;
            }
        }
        return $emp_details;
    }
    public function get_group($id)
    {
        $attendence = $this->db->query(
            "SELECT
            MAX(punchin_time) as punchin_time,
            MAX(punchout_time) as punchout_time
        FROM `attendance_history`
        WHERE `active` = 1
        AND `group_no` = '$id'
        GROUP BY `group_no`
        ORDER BY punchin_time ASC"
        )->row_array();
        $attendence['flag'] = array_unique(explode(',', $attendence['flag']));
        return $attendence;
    }
    public function delete_group($emp_id, $gid)
    {
        return $this->db->delete('attendance_history', [
            'group_no' => $gid,
            'uid' => $emp_id,
        ]);
    }
    public function update_group($id, $start, $end, $emp_id)
    {
        $start = date('Y-m-d H:i:s', strtotime($start));
        if ($end) {
            $end = date('Y-m-d H:i:s', strtotime($end));
        }
        $this->db->trans_begin();
        $this->db->where([
            'group_no' => $id,
            'punchin_time !=' => null,
            'active' => 1,
        ])->update('attendance_history', [
            'punchin_time' => $start,
        ]);
        if ($end) {
            $shift = $this->get_shift_by_employee($emp_id);
            $status = $this->get_current_status($shift->id, 'in', $start, $end, $emp_id)['flag'];
            $author = empty($this->session->userdata('employee_id')) ? $this->session->userdata('id') : $this->session->userdata('employee_id');

            $old_punchout = $this->db->where([
                'group_no' => $id,
                'punchout_time !=' => null,
                'active' => 1,
            ])->get('attendance_history')->row();
            if ($old_punchout) {
                $this->db->where('atten_his_id', $old_punchout->atten_his_id)
                    ->update('attendance_history', [
                        'punchout_time' => $end,
                        'flag' => $status,
                        'duration' => strtotime($end) - strtotime($start),
                        'punch_author' => $author,
                    ]);
            } else {
                $this->db->insert('attendance_history', [
                    'group_no' => $id,
                    'uid' => $emp_id,
                    'id' => 0,
                    'state' => 1,
                    'time' => date('Y-m-d H:i:s'),
                    'punchout_time' => $end,
                    'duration' => strtotime($end) - strtotime($start),
                    'status' => 'out',
                    'punch_author' => $author,
                    'flag' => $status,
                ]);
            }
        }
        if ($this->db->trans_status() === false) {
            $this->db->trans_rollback();
        } else {
            $this->db->trans_commit();
        }
        return $this->db->trans_status();
    }
}
