<?php
class Timeadjustment extends MX_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->db->query('SET SESSION sql_mode = ""');
        $this->load->helper('url');
        $this->load->model(['timeadjustment_model', 'Csv_model']);
        if (!$this->session->userdata('isLogIn')) {
            redirect('login?rback=' . uri_string());
        }
    }
    public function add_request()
    {
        if ($this->input->post()) {
            $this->create();
        }
        $data['dropdownatn'] = $this->Csv_model->Employeename();
        $data['title'] = 'Time Adjustment: Add Request';
        $data['module'] = "attendance";
        $data['page'] = "adjustment/add_request";
        echo Modules::run('template/layout', $data);
    }
    public function all_requests()
    {
        $data['title'] = 'All Time Adjustment Requests';
        $data['module'] = "attendance";
        $data['page'] = "adjustment/requests_list";

        $data['all_requests'] = $this->timeadjustment_model->get_table();

        echo Modules::run('template/layout', $data);
    }
    public function process()
    {
        if ($this->input->post('process') == 'approve') {
            $this->timeadjustment_model->process($this->input->post('id'), true);
        } else {
            $this->timeadjustment_model->process($this->input->post('id'), false);
        }
        redirect($_SERVER['HTTP_REFERER']);
    }
    private function create()
    {
        $this->form_validation->CI = &$this;
        $rules_config = array(
            array(
                'field' => 'checkin',
                'label' => 'Check In Time',
                'rules' => 'trim|required|callback_valid_datetime',
            ),
            array(
                'field' => 'checkout',
                'label' => 'Check Out Time',
                'rules' => 'trim|required|callback_valid_datetime',
            ),
            array(
                'field' => 'reason',
                'label' => 'Reason',
                'rules' => 'strip_tags|trim|required',
            ),
        );
        if($this->session->userdata('isAdmin')){
            $rules_config[] = [
                'field' => 'employee_id',
                'label' => 'Employee Name',
                'rules' => 'trim|required|is_natural',
            ];
        }
        if(strtotime($this->input->post('checkout')) - strtotime($this->input->post('checkin')) < 0){
            $this->session->set_flashdata('exception', 'Checkin date should be smaller than Checkout date');return;
        }
        $this->form_validation->set_message('valid_datetime', '{field} must have valid date and time.');
        $this->form_validation->set_rules($rules_config);
        if ($this->form_validation->run() === true) {
            if ($this->timeadjustment_model->add($this->input->post())) {
                $this->session->set_flashdata('message', 'Request added successfully');
            } else {
                $this->session->set_flashdata('exception', 'Error while submitting request try again later!');
            }
        }
    }
    public function valid_datetime($str)
    {
        $res = preg_match('/\b\d{2}-\d{2}-\d{4}\s\d{2}:\d{2}\b/', $str);
        return is_numeric($res) && $res > 0 ? true : false;
    }
}
