<?php
defined('BASEPATH') or exit('No direct script access allowed');
class Home extends MX_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->db->query('SET SESSION sql_mode = ""');
        $this->load->helper('url');
        $this->load->model(array(
            'Csv_model',
            'attendence_model',
        ));
        $this->load->library('excel');
        $this->load->library('zklibrary');
        if (!$this->session->userdata('isLogIn')) {
            redirect('login?rback=' . uri_string());
        }

    }
    public function index($id = null)
    {
        if ($this->session->userdata('isAdmin') == 1) {
            redirect('attendance/home/admin_attendance');
        } else {
            $data['page'] = "user_checkin";
            $data['last_attendence'] = $this->db->query("SELECT * FROM `attendance_history` WHERE active = 1 AND uid = '" . $this->session->userdata('employee_id') . "' ORDER BY time DESC")->first_row();
            if ($data['last_attendence']) {
                switch ($data['last_attendence']->status) {
                    case "in":
                        $data['title'] = display('check_out');
                        break;
                    case "out":
                        $data['title'] = display('check_in');
                        break;
                    default:
                        $data['title'] = 'Attendence';
                }
            } else {
                $data['title'] = display('check_in');
            }
        }
        $data['module'] = "attendance";
        echo Modules::run('template/layout', $data);
    }
    public function admin_attendance($id = null, $date = null)
    {
        /**
         * Step 1: Select Employee and Date
         */
        $data['module'] = "attendance";
        $data['title'] = 'Attendence Management';
        if (!$id || !$date) {
            if ($this->input->post()) {
                $rules_config = array(
                    array(
                        'field' => 'id',
                        'label' => 'Employee',
                        'rules' => 'trim|required|is_natural',
                    ),
                    array(
                        'field' => 'date',
                        'label' => 'Date',
                        'rules' => 'trim|required',
                    ),
                );
                $this->form_validation->set_rules($rules_config);
                if ($this->form_validation->run() === false) {
                    $this->session->set_flashdata('exception', validation_errors());
                    redirect($_SERVER['HTTP_REFERER']);
                }
                $id = $this->input->post('id');
                $date = date('d-m-Y', strtotime($this->input->post('date')));
                redirect("attendance/home/admin_attendance/$id/$date");
            }
            $data['dropdownatn'] = $this->Csv_model->Employeename();
            $data['page'] = "attendance/select_employee";
        } elseif ($id && $date) {
            if ($this->input->post()) {
                $author = empty($this->session->userdata('employee_id')) ? $this->session->userdata('id') : $this->session->userdata('employee_id');
                if ($_POST['dates']['in'] && $_POST['dates']['out']) {
                    if(strtotime($_POST['dates']['out']) - strtotime($_POST['dates']['in']) < 0){
                        $this->session->set_flashdata('exception', 'Checkin date should be smaller than Checkout date');
                        redirect($_SERVER['HTTP_REFERER']);
                    }
                    $start = date('Y-m-d H:i:s', strtotime($_POST['dates']['in']));
                    $end = date('Y-m-d H:i:s', strtotime($_POST['dates']['out']));
                    $this->attendence_model->custom_punch($id, $start, $end, $author);
                } else {
                    $att_insertdata = [
                        'uid' => $id,
                        'id' => 0,
                        'state' => 1,
                        'time' => date('Y-m-d h:i:s A'),
                        'punch_author' => $author,
                        'active' => 1,
                        'flag' => '',
                    ];
                    $where = [];
                    $group_no = getByWhereAsArray('attendance_history', '*, MAX(group_no) as group_no', $where, ['group_no', 'desc'], 1)[0]['group_no'];
                    if ($_POST['dates']['in']) {
                        $att_insertdata['status'] = 'in';
                        $att_insertdata['punchin_time'] = date('Y-m-d H:i:s', strtotime($_POST['dates']['in']));
                    } elseif ($_POST['dates']['out']) {
                        $where['status'] = 'in';
                        $where['uid'] = $id;
                        $where['DATE(punchin_time) <='] = date('Y-m-d', strtotime($date));

                        $att_insertdata['status'] = 'out';
                        $att_insertdata['punchout_time'] = date('Y-m-d H:i:s', strtotime($_POST['dates']['out']));
                    } else {
                        $this->session->set_flashdata('exception', 'At least one of the checkin or checkout field is required');
                        redirect($_SERVER['HTTP_REFERER']);
                    }
                    $last_rec = getByWhereAsArray('attendance_history', '*', $where, ['punchin_time', 'desc'], 1)[0];
                    if ($last_rec && $_POST['dates']['out']) {
                        if(strtotime($_POST['dates']['out']) - strtotime($last_rec['punchin_time']) < 0){
                            $this->session->set_flashdata('exception', 'Checkin date should be smaller than checkout date');
                            redirect($_SERVER['HTTP_REFERER']);
                        }
                        $group_no = $last_rec['group_no'];
                        $shift = $this->attendence_model->get_shift_by_employee($id);
                        $flag = $this->attendence_model->get_current_status(
                            $shift->id,
                            'in',
                            $last_rec['punchin_time'],
                            $att_insertdata['punchout_time'],
                            $id
                        );
                        $att_insertdata['duration'] = strtotime($_POST['dates']['out']) - strtotime($last_rec['punchin_time']);
                        $att_insertdata['flag'] = $flag['flag'];
                    }else{
                        $group_no++;
                    }
                    $att_insertdata['group_no'] = $group_no;
                    $this->db->insert('attendance_history', $att_insertdata);
                }
                $this->session->set_flashdata('message', display('save_successfull'));
                redirect($_SERVER['HTTP_REFERER']);
            }
            $date = date('Y-m-d', strtotime($date));
            $data['date'] = $date;
            $data['emp_id'] = $id;
            $data['attendence'] = $this->attendence_model->get_user_day_report2($id, $date);
            $data['page'] = "attendance/update_attendance";
        }
        echo Modules::run('template/layout', $data);
    }
    public function manageatn()
    {
        $data['title'] = display('attendance_list');
        $data['addressbook'] = $this->Csv_model->get_addressbook();
        $data['module'] = "attendance";
        $data['page'] = "manage_attendance";
        echo Modules::run('template/layout', $data);
    }
    public function importcsv()
    {
        if (isset($_FILES["upload_csv_file"]["name"])) {
            $path = $_FILES["upload_csv_file"]["tmp_name"];
            $object = PHPExcel_IOFactory::load($path);
            foreach ($object->getWorksheetIterator() as $sale) {
                $highestRow = $sale->getHighestRow();
                $highestColumn = $sale->getHighestColumn();
                for ($row = 2; $row <= $highestRow; $row++) {
                    $employee_id = $sale->getCellByColumnAndRow(0, $row)->getValue();
                    $date = $sale->getCellByColumnAndRow(1, $row)->getValue();
                    // print_r($date);exit();
                    $atn_time = date('Y-m-d H:i:s', strtotime($date));
                    $attendance = array(
                        'uid' => $employee_id,
                        'time' => $date,
                        'id' => 0,
                        'state' => 1,
                    );
                    $this->db->insert('attendance_history', $attendance);
                }
            }
            $this->session->set_flashdata('message', display('successfully_uploaded'));
            redirect('attendance/home/att_log_report');
        }
    }
    public function create_atten()
    {
        date_default_timezone_set("Asia/karachi");
        $data['title'] = display('employee');
        $in = $this->input->post('in');
        $out = $this->input->post('out');
        #-------------------------------#intime
        $this->form_validation->set_rules('employee_id', display('employee_id'), 'required');
        if ($this->session->userdata('isAdmin')) {
            $this->form_validation->set_rules('inday', 'Day', 'required');
            $this->form_validation->set_rules('intime', display('time'), 'required');
        } else {
            $data['last_attendence'] = $this->db->query("SELECT * FROM `attendance_history` WHERE uid = '" . $this->session->userdata('employee_id') . "' AND uid = punch_author ORDER BY time DESC")->first_row();
            $attendence_status = [];
            if ($data['last_attendence']) {
                switch ($data['last_attendence']->status) {
                    case "in":
                        $attendence_status[] = $this->attendence_model->get_current_status($this->session->userdata('shift'), $data['last_attendence']->status, $data['last_attendence']->punchin_time);
                        break;
                    case "out":
                        $attendence_status[] = $this->attendence_model->get_current_status($this->session->userdata('shift'), $data['last_attendence']->status, $data['last_attendence']->punchout_time);
                        break;
                }
            } else {
                $as = $this->attendence_model->get_current_status($this->session->userdata('shift'), 'out', date('Y-m-d h:i:s A'));
                if ($as) {
                    $attendence_status[] = $as;
                }
            }
        }
        //
        #-------------------------------#
        if ($this->form_validation->run() === true) {
            if ($this->session->userdata('isAdmin')) {
                $max_group_no = $this->db->query("select Max(attendance_history.group_no) as group_no  from `attendance_history`")->first_row();
                $attendance_history = [
                    'uid' => $this->input->post('employee_id', true),
                    'state' => 1,
                    'id' => 0,
                    'punch_author' => empty($this->session->userdata('employee_id')) ? $this->session->userdata('id') : $this->session->userdata('employee_id'),
                ];
                $userId = $this->input->post('employee_id', true);
                $shift = $this->attendence_model->get_shift_by_employee($userId);
                if (emptyArray($shift)) {
                    $this->session->set_flashdata('exception', 'Invalid Shift. Please correct Employee shift first in their profile');
                    redirect("attendance/Home/index");
                }
                $inday = Datetime::createFromFormat('d-m-Y H:i', $this->input->post('inday') . ' ' . $this->input->post('intime'));
                if (isset($out) && $this->attendence_model->is_nightsift($shift)) {
                    $inday->modify('+1 day');
                }
                $att_time = $inday->format('Y-m-d H:i:s');
                if (isset($in) && $in == "in") {
                    $status = $this->attendence_model->get_current_status($shift->id, "out", $att_time, null, $userId);
                    $group_nos_checkin = getByWhereAsArray(
                        'attendance_history',
                        'group_no',
                        [
                            'uid' => $userId,
                            'Date(punchin_time)' => date("Y-m-d", strtotime($att_time)),
                            'status' => 'in',
                        ],
                        ['punchin_time', 'ASC'],
                        1
                    );
                    if ($group_nos_checkin) {
                        $group_nos_checkin = array_column($group_nos_checkin, 'group_no');
                        $group_nos_checkin = $group_nos_checkin[0];
                        $attendance_history['flag'] = $status['flag'];
                        $attendance_history['punchin_time'] = $att_time;
                        $attendance_history['time'] = date('Y-m-d H:i:s');

                        $res = $this->db->where(
                            [
                                'status' => 'in',
                                'group_no' => $group_nos_checkin,
                            ]
                        )->update('attendance_history', $attendance_history);
                        if ($res) {
                            $out_rec = $this->db->where(['group_no' => $group_nos_checkin, 'status' => 'out'])->order_by('time', 'desc')->get('attendance_history')->first_row();
                            $status = $this->attendence_model->get_current_status($shift->id, "out", $att_time, $out_rec->punchout_time, $userId);
                            $this->db->where('atten_his_id', $out_rec->atten_his_id)
                                ->update('attendance_history', [
                                    'flag' => $status['flag'],
                                    'duration' => strtotime($out_rec->punchout_time) - strtotime($att_time),
                                ]);
                        }
                    } else {
                        if (empty($status)) {
                            $status = ['flag' => 'P'];
                        }
                        $attendance_history['status'] = 'in';
                        $attendance_history['flag'] = $status['flag'];
                        $attendance_history['punchin_time'] = $att_time;
                        $attendance_history['time'] = date('Y-m-d H:i:s');
                        $attendance_history['group_no'] = ($max_group_no) ? (int) $max_group_no->group_no + 1 : 0;
                        $this->db->insert('attendance_history', $attendance_history);
                    }

                    $this->session->set_flashdata('message', display('save_successfull'));
                    redirect("attendance/Home/index");
                } else {
                    $inday = date('Y-m-d', strtotime($this->input->post('inday')));
                    $result = $this->db->query("SELECT * FROM `attendance_history` WHERE DATE(punchin_time) = '$inday' AND uid = '$userId' AND status = 'in' AND active = 1 ORDER BY time DESC")->first_row();
                    if (strtotime($att_time) - strtotime($result->punchin_time) < 0) {
                        $this->session->set_flashdata('exception', 'Checkout time must be less than checkin time');
                        redirect("attendance/Home/index");
                    }
                    if (!$result) {
                        $this->session->set_flashdata('exception', display('please_checkin_first_before_checkout'));
                        redirect("attendance/Home/index");
                    } else {
                        $this->db->where('uid', $userId);
                        $this->db->where('group_no', $result->group_no);
                        $this->db->where('status', "out");
                        $this->db->update('attendance_history', ['active' => 0]);
                    }
                    $status = $this->attendence_model->get_current_status($shift->id, "in", $result->punchin_time, $att_time, $userId);
                    $attendance_history['status'] = 'out';
                    $attendance_history['flag'] = $status['flag'];
                    $attendance_history['duration'] = strtotime($att_time) - strtotime($result->punchin_time);
                    $attendance_history['punchout_time'] = $att_time;
                    $attendance_history['time'] = date('Y-m-d H:i:s');
                    $attendance_history['group_no'] = (int) $result->group_no;
                    $this->db->insert('attendance_history', $attendance_history);
                    $this->session->set_flashdata('message', display('save_successfull'));
                    redirect("attendance/Home/index");
                }
            } else {
                $max_group_no = $this->db->query("select Max(attendance_history.group_no) as group_no  from `attendance_history`")->first_row();
                $att_time = date('Y-m-d H:i:s');
                $userId = $this->session->userdata('employee_id');
                $attendance_history = [
                    'uid' => $userId,
                    'state' => 1,
                    'id' => 0,
                ];
                $result = $this->db->query("SELECT * FROM `attendance_history` WHERE uid = '$userId' AND active = 1 ORDER BY time DESC")->first_row();
                if (!$result || $result->status == 'out') {
                    $attendance_history['status'] = 'in';
                    $attendance_history['punchin_time'] = $att_time;
                    $attendance_history['time'] = $att_time;
                    $attendance_history['uid'] = $userId;
                    $attendance_history['remarks_in'] = strip_tags($this->input->post('remarks'));
                    $attendance_history['punch_author'] = $userId;
                    $attendance_history['group_no'] = ($max_group_no) ? (int) $max_group_no->group_no + 1 : 0;
                    $attendance_history['flag'] = $attendence_status ? implode(',', array_column($attendence_status, 'flag')) : null;
                } else {
                    $shift_percentage = $this->attendence_model->shift_percentage($this->attendence_model->get_shift($this->session->userdata('shift')), $result->punchin_time);

                    if ($shift_percentage < 18) {
                        $attendence_status[] = ['flag' => 'A'];
                    }
                    if ($shift_percentage >= 18 && $shift_percentage < 67) {
                        $attendence_status[] = ['flag' => 'UH-D'];
                    }
                    if ($shift_percentage >= 67) {
                        $attendence_status[] = ['flag' => 'FD'];
                    }
                    $attendance_history['punchout_time'] = $att_time;
                    $attendance_history['status'] = 'out';
                    $attendance_history['group_no'] = (int) $result->group_no;
                    $attendance_history['time'] = $att_time;
                    $attendance_history['remarks_out'] = strip_tags($this->input->post('remarks'));
                    $attendance_history['duration'] = strtotime($att_time) - strtotime($result->punchin_time);
                    $attendance_history['punch_author'] = $userId;
                    $attendance_history['flag'] = $attendence_status ? implode(',', array_column($attendence_status, 'flag')) : null;
                    $last_status = $result->atten_his_id;
                }
                if ($this->Csv_model->atten_create($attendance_history, $last_status)) {
                    $this->session->set_flashdata('message', display('save_successfull'));
                } else {
                    $this->session->set_flashdata('exception', display('please_try_again'));
                }
                redirect("attendance/Home/index");
            }
        } elseif ($this->form_validation->run() === false) {
            $this->session->set_flashdata('exception', validation_errors(' ', ' '));
            redirect("attendance/Home/index");
        } else {
            $data['title'] = display('create');
            $data['module'] = "attendance";
            $data['page'] = "attendance_form";
            $data['dropdownatn'] = $this->Csv_model->Employeename();
            echo Modules::run('template/layout', $data);
        }
    }
    public function delete_group($emp_id, $gid)
    {
        $this->permission->method('attendance', 'delete')->redirect();
        if ($this->attendence_model->delete_group($emp_id, $gid)) {
            #set success message
            $this->session->set_flashdata('message', display('delete_successfully'));
        } else {
            #set exception message
            $this->session->set_flashdata('exception', display('please_try_again'));
        }
        redirect($_SERVER['HTTP_REFERER']);
    }
    public function edit_group($emp_id, $gid)
    {
        $this->permission->method('attendance', 'update')->redirect();
        if($this->input->post()){
            $rules_config = array(
               array(
                  'field' => 'checkin',
                  'label' => 'Checkin',
                  'rules' => 'trim|required',
               ),
            );
            $this->form_validation->set_rules($rules_config);
            if ($this->form_validation->run() === false) {
                $this->session->set_flashdata('exception', display('please_try_again'));
            }else{
                if(strtotime($this->input->post('checkout')) - strtotime($this->input->post('checkin')) < 0){
                    $this->session->set_flashdata('exception', 'Checkin time should be smaller than checkout time');
                    redirect("attendance/home/admin_attendance/$emp_id/" . date('d-m-Y', strtotime($this->input->post('checkin'))));
                }
                $res = $this->attendence_model->update_group(
                    $gid,
                    $this->input->post('checkin'),
                    $this->input->post('checkout'),
                    $emp_id
                );
                if($res){
                    $this->session->set_flashdata('message', display('successfully_updated'));                    
                }else{                    
                    $this->session->set_flashdata('exception', display('please_try_again'));
                }
            }
            redirect("attendance/home/admin_attendance/$emp_id/" . date('d-m-Y', strtotime($this->input->post('checkin'))));
        }
        $data['module'] = "attendance";
        $data['title'] = 'Attendence Management';
        $data['page'] = "attendance/update_group";
        $data['group'] = $this->attendence_model->get_group($gid);
        echo Modules::run('template/layout', $data);
    }
    public function delete_atn($id = null)
    {
        $this->permission->method('attendance', 'delete')->redirect();
        if ($this->Csv_model->delete_attn($id)) {
            #set success message
            $this->session->set_flashdata('message', display('delete_successfully'));
        } else {
            #set exception message
            $this->session->set_flashdata('exception', display('please_try_again'));
        }
        redirect($_SERVER['HTTP_REFERER']);
    }
    public function update_atn_form($id = null)
    {
        $this->permission->method('attendance', 'update')->redirect();
        $this->form_validation->set_rules('att_id', null, 'required|max_length[11]');
        $this->form_validation->set_rules('employee_id', display('employee_id'), 'required');
        $this->form_validation->set_rules('date', display('date'), 'required');
        $this->form_validation->set_rules('sign_in', display('sign_in'), 'required');
        $this->form_validation->set_rules('sign_out', display('sign_out'));
        $this->form_validation->set_rules('staytime', display('staytime'));
        #-------------------------------#
        if ($this->form_validation->run() === true) {
            $postData = [
                'att_id' => $this->input->post('att_id', true),
                'employee_id' => $this->input->post('employee_id', true),
                'date' => $this->input->post('date', true),
                'sign_in' => $this->input->post('sign_in', true),
                'sign_out' => $this->input->post('sign_out', true),
                'staytime' => $this->input->post('staytime', true),
            ];
            if ($this->Csv_model->update_attn($postData)) {
                $this->session->set_flashdata('message', display('successfully_updated'));
            } else {
                $this->session->set_flashdata('exception', display('please_try_again'));
            }
            redirect("attendance/Home/index");
        } else {
            $data['data'] = $this->Csv_model->attn_updateForm($id);
            $data['module'] = "attendance";
            $data['dropdownatn'] = $this->Csv_model->Employeename();
            $data['query'] = $this->Csv_model->get_atn_dropdown($id);
            $data['page'] = "update_atn";
            echo Modules::run('template/layout', $data);
        }
    }
    //// checkout atn ///
    public function checkout()
    {
        $timezone = $this->db->select('timezone')->from('setting')->get()->row();
        date_default_timezone_set($timezone->timezone);
        $sign_out = date("h:i:s a", time());
        $sign_in = $this->input->post('sign_in', true);
        $in = new DateTime($sign_in);
        $Out = new DateTime($sign_out);
        $interval = $in->diff($Out);
        $stay = $interval->format('%H:%I:%S');
        $postData = [
            'att_id' => $this->input->post('att_id', true),
            'sign_out' => $sign_out,
            'staytime' => $stay,
        ];
        $update = $this->db->where('att_id', $this->input->post('att_id', true))
            ->update("emp_attendance", $postData);
        if ($update) {
            $this->session->set_flashdata('message', display('successfully_checkout'));
            redirect("attendance/Home/index");
        }
    }
/* ########## Report Start ####################*/
    public function report_user()
    {
        $data['title'] = display('attendance_list');
        $data['module'] = "attendance";
        $data['page'] = "user_views_report";
        echo Modules::run('template/layout', $data);
    } //
    public function report_byId()
    {
        $data['title'] = display('attendance_list');
        $data['module'] = "attendance";
        $data['page'] = "attn_Id_report";
        echo Modules::run('template/layout', $data);
    } //
    public function report_view()
    {
        $this->permission->module('attendance', 'read')->redirect();
        $format_start_date = $this->input->post('start_date');
        $format_end_date = $this->input->post('end_date');
        $data['date'] = $format_start_date;
        $data['date'] = $format_end_date;
        $data['query'] = $this->Csv_model->userReport($format_start_date, $format_end_date);
        $data['module'] = "attendance";
        $data['page'] = "user_views_report";
        echo Modules::run('template/layout', $data);
    }
    public function AtnReport_view()
    {
        $this->permission->module('attendance', 'read')->redirect();
        $data['title'] = display('attendance_repor');
        $id = $this->input->post('employee_id');
        $start_date = $this->input->post('s_date');
        $end_date = $this->input->post('e_date');
        $data['employee_id'] = $id;
        $data['date'] = $start_date;
        $data['date'] = $end_date;
        $data['ab'] = $this->Csv_model->atnrp($id);
        $data['query'] = $this->Csv_model->search($id, $start_date, $end_date);
        $data['module'] = "attendance";
        $data['page'] = "att_reportview";
        echo Modules::run('template/layout', $data);
    }
    public function atntime_report()
    {
        $data['title'] = display('attendance_list');
        $data['module'] = "attendance";
        $data['page'] = "Date_time_report";
        echo Modules::run('template/layout', $data);
    } //
    public function AtnTimeReport_view()
    {
        $this->permission->module('attendance', 'read')->redirect();
        $data['title'] = display('attendance_repor');
        $date = $this->input->post('date');
        $start_time = $this->input->post('s_time');
        $end_time = $this->input->post('e_time');
        $data['date'] = $date;
        $data['sign_in'] = $start_time;
        $data['sign_in'] = $end_time;
        $data['query'] = $this->Csv_model->search_intime($date, $start_time, $end_time);
        $data['module'] = "attendance";
        $data['page'] = "Date_time_report";
        echo Modules::run('template/layout', $data);
    }
    /**** ###### Id checking ######### */
    public function attenlist()
    {
        $data['title'] = display('attendance_report');
        $data['addressbook'] = $this->Csv_model->get_addressbook();
        $data['module'] = "attendance";
        $data['page'] = "attendance_list";
        $data['dropdownatn'] = $this->Csv_model->Employeename();
        echo Modules::run('template/layout', $data);
    }
    /*  atn edit */
    public function edit_atn_form($id = null)
    {
        $this->permission->method('attendance', 'delete')->redirect();
        $this->form_validation->set_rules('att_id', null, 'required|max_length[11]');
        $this->form_validation->set_rules('employee_id', display('employee_id'), 'required');
        $this->form_validation->set_rules('date', display('date'), 'required');
        $this->form_validation->set_rules('sign_in', display('sign_in'), 'required');
        $this->form_validation->set_rules('sign_out', display('sign_out'));
        $this->form_validation->set_rules('staytime', display('staytime'));
        #-------------------------------#
        if ($this->form_validation->run() === true) {
            $postData = [
                'att_id' => $this->input->post('att_id', true),
                'employee_id' => $this->input->post('employee_id', true),
                'date' => $this->input->post('date', true),
                'sign_in' => $this->input->post('sign_in', true),
                'sign_out' => $this->input->post('sign_out', true),
                'staytime' => $this->input->post('staytime', true),
            ];
            if ($this->Csv_model->update_attn($postData)) {
                $this->session->set_flashdata('message', display('successfully_updated'));
            } else {
                $this->session->set_flashdata('exception', display('please_try_again'));
            }
            redirect("attendance/Home/index");
        } else {
            $data['data'] = $this->Csv_model->attn_updateForm($id);
            $data['module'] = "attendance";
            $data['dropdownatn'] = $this->Csv_model->Employeename();
            $data['query'] = $this->Csv_model->get_atn_dropdown($id);
            $data['page'] = "edit_attendance";
            echo Modules::run('template/layout', $data);
        }
    }
    /*
    |-----------------------------------------------------------
    |   Device Connectivity
    |
    |------------------------------------------------------------
     */
    public function device_connection()
    {
        $div_data = $this->db->count_all('deviceinfo');
        if (!empty($div_data)) {
            $id = 1;
        } else {
            $id = null;
        }
        $this->form_validation->set_rules('device_ip', display('device_ip'), 'required|max_length[50]');
        $data['device_data'] = (Object) $postData = [
            'id' => $this->input->post('id'),
            'device_ip' => $this->input->post('device_ip'),
        ];
        #-------------------------------#
        if ($this->form_validation->run()) {
            if (empty($postData['id'])) {
                $this->permission->method('attendance', 'create')->redirect();
                if ($this->Csv_model->create_device_ip($postData)) {
                    $this->session->set_flashdata('message', display('save_successfully'));
                } else {
                    $this->session->set_flashdata('exception', display('please_try_again'));
                }
                redirect("attendance/home/device_connection");
            } else {
                $this->permission->method('attendance', 'update')->redirect();
                if ($this->Csv_model->update_device_ip($postData)) {
                    $this->session->set_flashdata('message', display('update_successfully'));
                } else {
                    $this->session->set_flashdata('exception', display('please_try_again'));
                }
                redirect("attendance/home/device_connection/" . $postData['id']);
            }
        } else {
            if (!empty($id)) {
                $data['title'] = display('update');
                $data['deviceinfo'] = $this->Csv_model->devicinfoById($id);
            }
            $data['module'] = "attendance";
            $data['page'] = "device_connect_form";
            echo Modules::run('template/layout', $data);
        }
    }
    /*
    |--------------------------------------------------------
    | Finger print Device information
    |--------------------------------------------------------
     */
    public function deviceData()
    {
        return $this->db->select('*')->from('deviceinfo')->get()->row();
    }
    /*
    |-----------------------------------------------------------
    | Attendance Log
    |-----------------------------------------------------------
     */
    public function atten_log()
    {
        $device_ip = $this->deviceData()->device_ip;
        $zk = new ZKLibrary($device_ip, 4370);
        $zk->connect();
        $zk->disableDevice();
        $attendanced = $zk->getAttendance();
        foreach ($attendanced as $attendancedata) {
            $attdata = [
                'uid' => $attendancedata[1],
                'id' => $attendancedata[0],
                'state' => $attendancedata[2],
                'time' => $attendancedata[3],
            ];
            $att_insertdata = $this->db->insert('attendance_history', $attdata);
            if (!empty($attendancedata[0])) {
                $zk->deleteAttendance($attendancedata[0]);
            }
        }
        $this->session->set_flashdata('message', "Succesfully Uploaded");
        redirect("attendance/Home/att_log_report");
        // $data['title']   = 'Attendance Log';
        // $config["base_url"] = base_url('attendance/home/atten_log');
        // $config["total_rows"]  = $this->Csv_model->count_atn();
        // $config["per_page"]    = 20;
        // $config["uri_segment"] = 4;
        // $config["last_link"] = "Last";
        // $config["first_link"] = "First";
        // $config['next_link'] = 'Next';
        // $config['prev_link'] = 'Prev';
        // $config['full_tag_open'] = "<ul class='pagination col-xs pull-right'>";
        // $config['full_tag_close'] = "</ul>";
        // $config['num_tag_open'] = '<li>';
        // $config['num_tag_close'] = '</li>';
        // $config['cur_tag_open'] = "<li class='disabled'><li class='active'><a href='#'>";
        // $config['cur_tag_close'] = "<span class='sr-only'></span></a></li>";
        // $config['next_tag_open'] = "<li>";
        // $config['next_tag_close'] = "</li>";
        // $config['prev_tag_open'] = "<li>";
        // $config['prev_tagl_close'] = "</li>";
        // $config['first_tag_open'] = "<li>";
        // $config['first_tagl_close'] = "</li>";
        // $config['last_tag_open'] = "<li>";
        // $config['last_tagl_close'] = "</li>";
        // /* ends of bootstrap */
        // $this->pagination->initialize($config);
        // $page = ($this->uri->segment(4)) ? $this->uri->segment(4) : 0;
        // $data["links"] = $this->pagination->create_links();
        // $data['module']  = "attendance";
        // $data['attendance']=$this->Csv_model->att_log($config["per_page"], $page);
        // $data['page']   = "attendance_log";
        $zk->enableDevice();
        $zk->disconnect();
        // echo Modules::run('template/layout', $data);
    }
    //Attendance Log report
    public function att_log_report()
    {
        // print_r(($this->session->userdata()));
        $data['title'] = 'Attendance Log';
        $config["base_url"] = base_url('attendance/home/att_log_report/');
        $config["total_rows"] = $this->Csv_model->count_att_report();
        $config["per_page"] = 10;
        $config["uri_segment"] = 4;
        $config["last_link"] = "Last";
        $config["first_link"] = "First";
        $config['next_link'] = 'Next';
        $config['prev_link'] = 'Prev';
        $config['full_tag_open'] = "<ul class='pagination col-xs pull-right'>";
        $config['full_tag_close'] = "</ul>";
        $config['num_tag_open'] = '<li>';
        $config['num_tag_close'] = '</li>';
        $config['cur_tag_open'] = "<li class='disabled'><li class='active'><a href='#'>";
        $config['cur_tag_close'] = "<span class='sr-only'></span></a></li>";
        $config['next_tag_open'] = "<li>";
        $config['next_tag_close'] = "</li>";
        $config['prev_tag_open'] = "<li>";
        $config['prev_tagl_close'] = "</li>";
        $config['first_tag_open'] = "<li>";
        $config['first_tagl_close'] = "</li>";
        $config['last_tag_open'] = "<li>";
        $config['last_tagl_close'] = "</li>";
        /* ends of bootstrap */
        $this->pagination->initialize($config);
        $page = ($this->uri->segment(4)) ? $this->uri->segment(4) : 0;
        $data["links"] = $this->pagination->create_links();
        $data['module'] = "attendance";
        $data['queryd'] = $this->Csv_model->att_report($config["per_page"], $page);
        $data['userlist'] = $this->Csv_model->userlist();
        $data['supervisors'] =$this->Csv_model->all_supervisors();
        $data['departments'] = $this->Csv_model->departments_list();
        $data['page'] = "attendance_log_datewise";
        echo Modules::run('template/layout', $data);
    }
    //Attendance Log report userwise
    public function user_attendanc_details($id, $date)
    {
        $data['title'] = 'Attendance Log';
        $data['module'] = "attendance";
        $data['id'] = $id;
        $data['company'] = $this->Csv_model->company_info();
        $data['day'] = $date;
        $data['attendence'] = $this->attendence_model->get_user_day_report($id, $date);
        $data['page'] = "attendance_log_userdetails";
        echo Modules::run('template/layout', $data);
    }
    // Date between and user wise attendance log
    public function datebetween_attendance()
    {
        $id = $this->input->get('employee_id');
        $from_date = $this->input->get('start_date');
        $to_date = $this->input->get('end_date');
        $data['module'] = "attendance";
        $data['atten_in'] = $this->Csv_model->att_log_datebetween($id, $from_date, $to_date);
        $data['userlist'] = $this->Csv_model->userlist();
        $data['supervisors'] =$this->Csv_model->all_supervisors();
        $data['start'] = $from_date;
        $data['end'] = $to_date;
        $data['user'] = $this->Csv_model->deviceuser($id);
        $data['company'] = $this->Csv_model->company_info();
        $this->load->library('pdfgenerator');
        $dompdf = new DOMPDF();
        $page = $this->load->view('attendance/individual_att_history_pdf', $data, true);
        $dompdf->load_html($page);
        $dompdf->render();
        $output = $dompdf->output();
        file_put_contents('assets/data/pdf/attendance/Attendance History of ' . $id . ' ' . $from_date . ' To ' . $to_date . '.pdf', $output);
        $data['pdf'] = 'assets/data/pdf/attendance/Attendance History of ' . $id . ' ' . $from_date . ' To ' . $to_date . '.pdf';
        $data['page'] = "attendance_log_datebetween";
        echo Modules::run('template/layout', $data);
    }
    public function delete_attendance($id, $user_id)
    {
        if ($this->Csv_model->attendance_delete($id)) {
            #set success message
            $this->session->set_flashdata('message', display('delete_successfully'));
        } else {
            #set exception message
            $this->session->set_flashdata('exception', display('please_try_again'));
        }
        redirect("attendance/home/user_attendanc_details/" . $user_id);
    }
    public function searchEmployee()
    {
        if ($this->input->get('download')) {
            $this->download_report($this->input->get('download'));return;
        }
        $data['title'] = 'Attendance Log';
        $data['module'] = "attendance";
        $users = $this->input->get('employee_id');
        $data['selected_dept'] = $this->input->get('dept_id');
        $data['selected_supervisor'] = $this->input->get('supervisorid');
        $users = $this->input->get('employee_id');
        $start_date = $this->input->get('start_date');
        $end_date = $this->input->get('end_date');
        $data['days_selected'] = daysBetween($start_date, $end_date);
        $data['start'] = $start_date;
        $data['end'] = $end_date;
        $data['user_id'] = $users;
        $data['users'] = implode(',', $users);
        $data['userlist'] = $this->Csv_model->userlist();
        $data['supervisors'] =$this->Csv_model->all_supervisors();
        $data['departments'] = $this->Csv_model->departments_list();

        $where = [];
        $emp_ids = $this->attendence_model->employeeAttendanceCheck($this->input->get());

        // print_r($emp_ids);die;

        // $emp_ids = array_column(getByWhereAsArray('employee_history', 'employee_id', $where), 'employee_id');
        // $array = array_intersect($emp_ids, $this->input->post('employee_id'));

        // print_r($where);exit;


        $data['attendence_data'] = $this->attendence_model->get_report($emp_ids,$this->input->get('start_date'),$this->input->get('end_date'));
        $data['weekend_days'] = get_weekend();
        $data['page'] = "attendance_log_datewise";
        echo Modules::run('template/layout', $data);
    }
    private function download_report($type)
    {

        $this->load->library('excel');

        $this->excel->setActiveSheetIndex(0)
            ->setCellValue('A1', 'Employee ID')
            ->setCellValue('B1', 'Employee Name')
            ->setCellValue('C1', 'Department')
            ->setCellValue('D1', 'Shift');

        $emp_ids = $this->attendence_model->employeeAttendanceCheck($this->input->get());

        $days = daysBetween($this->input->get('start_date'), $this->input->get('end_date'));
        (int)$days+=1;
        if($days == 0){
            $days++;
        }

        $data = $this->attendence_model->get_report(
            $emp_ids,$this->input->get('start_date'),$this->input->get('end_date'));
        $alpha_header = range('A', 'Z');

        //Generate cross multiplication of columns if data is bigger than 25 columns
        $alp_i = 0;
        while ($days + 3 > count($alpha_header)) {
            $alphabet = $alpha_header[$alp_i];
            $new_range = range('A', 'Z');
            foreach ($new_range as $alp) {
                $alpha_header[] = $alphabet . $alp;
            }
            $alp_i++;
        }

        $weekend_days = get_weekend();

        foreach ($data as $key => $emp_data) {
            $this->excel->setActiveSheetIndex(0)
            ->setCellValue('A' . ($key + 2), $emp_data['hrm_id'])
            ->setCellValue('B' . ($key + 2), $emp_data['firstname'] . ' ' . $emp_data['lastname'])
            ->setCellValue('C' . ($key + 2), $emp_data['department'])
            ->setCellValue('D' . ($key + 2), $emp_data['shift_name']);
        }

        $column_offset = 3;
        for ($i = 1; $i <= $days; $i++) {
            $current_column = $column_offset + $i;
            $full_date = date('Y-m-d', strtotime('+' . ($i - 1) . ' day', strtotime($this->input->get('start_date'))));
            $this->excel->setActiveSheetIndex(0)
                ->setCellValue($alpha_header[$current_column] . '1', date('d/m/Y', strtotime($full_date)));

            $Today = date('l', strtotime('+' . ($i - 1) . ' day', strtotime($this->input->get('start_date'))));
            $this->db->where('start_date <=', $full_date);
            $this->db->where('end_date >=', $full_date);
            $payroll_holiday = $this->db->get('payroll_holiday')->first_row();

            foreach ($data as $key => $emp_data) {
                $this->db->select('*')->from('leave_apply');
                $this->db->where('employee_id', $emp_data['employee_id']);
                $this->db->where('leave_aprv_strt_date <= ', $full_date);
                $this->db->where('leave_aprv_end_date >= ', $full_date);
                $this->db->where('approved_by is not null');
                $leave = $this->db->get()->first_row();

                $col_text = 'Absent';
                if ($leave) {
                    $col_text = 'Paid Leave';
                } elseif ($payroll_holiday) {
                    $col_text = $payroll_holiday->holiday_name;
                } elseif (in_array($Today, $weekend_days)) {
                    $col_text = $Today;
                } elseif (isset($emp_data['attendence'][$full_date])) {
                    $status = $emp_data['attendence'][$full_date]['status'];
                    $col_text = [];
                    if (in_array('LA', $status)) {
                        $col_text[] = 'Late Arrival';
                    }
                    if (in_array('FD', $status)) {
                        $col_text[] = 'Full Day';
                    } elseif (in_array('UH-D', $status) && !in_array('OT', $status)) {
                        $col_text[] = 'Unpaid Half-Day';
                    } elseif (in_array('A', $status)) {
                        $col_text[] = 'Absent';
                    } elseif (in_array('P', $status)) {
                        $col_text[] = 'Present';
                    }
                    if (in_array('OT', $status)) {
                        $col_text[] = 'Overtime';
                    }
                    $col_text = implode(' / ', $col_text);
                }
                $this->excel->setActiveSheetIndex(0)->setCellValue($alpha_header[$current_column] . ($key + 2), $col_text);
            }
        }
        if ($type == 'csv') {
            $this->excel->download_csv('attendance_' . $this->input->get('start_date'));
        } else {
            $this->excel->download_excel('attendance_' . $this->input->get('start_date'));
        }
    }
    public function resultData()
    {
        $data['title'] = 'Attendance Log';
        $config["base_url"] = base_url('attendance/home/att_log_report/');
        $config["total_rows"] = $this->Csv_model->count_att_report();
        $config["per_page"] = 10;
        $config["uri_segment"] = 4;
        $config["last_link"] = "Last";
        $config["first_link"] = "First";
        $config['next_link'] = 'Next';
        $config['prev_link'] = 'Prev';
        $config['full_tag_open'] = "<ul class='pagination col-xs pull-right'>";
        $config['full_tag_close'] = "</ul>";
        $config['num_tag_open'] = '<li>';
        $config['num_tag_close'] = '</li>';
        $config['cur_tag_open'] = "<li class='disabled'><li class='active'><a href='#'>";
        $config['cur_tag_close'] = "<span class='sr-only'></span></a></li>";
        $config['next_tag_open'] = "<li>";
        $config['next_tag_close'] = "</li>";
        $config['prev_tag_open'] = "<li>";
        $config['prev_tagl_close'] = "</li>";
        $config['first_tag_open'] = "<li>";
        $config['first_tagl_close'] = "</li>";
        $config['last_tag_open'] = "<li>";
        $config['last_tagl_close'] = "</li>";
        /* ends of bootstrap */
        $this->pagination->initialize($config);
        $page = ($this->uri->segment(4)) ? $this->uri->segment(4) : 0;
        $data["links"] = $this->pagination->create_links();
        $data['module'] = "attendance";
        $users = $this->input->post('employee_id');
        // print_r($this->input->post());exit;
        $start_date = $this->input->post('start_date');
        $end_date = $this->input->post('end_date');
        $data['start'] = $start_date;
        $data['end'] = $end_date;
        $data['user_id'] = $users;
        $data['users'] = implode(',', $users);
        $data['queryd'] = $this->Csv_model->att_report_ajax($config["per_page"], $page, $users, $start_date, $end_date);
        $data['supervisors'] =$this->Csv_model->all_supervisors();
        $data['userlist'] = $this->Csv_model->userlist();
        $data['page'] = "result_data";
        echo Modules::run($data);
    }
}
