<?php
if (!function_exists('getByWhere')) {
    function getByWhere($table, $select = '*', $where = array(), $order_by = array(), $limit = null, $offset = null, $where_like = array(), $group_by = '')
    {
        return __sel_q($table, $select, $where, $order_by, $limit, $offset, $where_like, $group_by)->get()->result();
    }
}
if (!function_exists('myArrayContainsWord')) {

    function myArrayContainsWord($myArray, $word)
    {
        foreach ($myArray as $element) {
            if ($element['selected'] == $word || $element->slug == $word ||
                (!empty($myArray['childs']) && myArrayContainsWord($myArray['childs'], $word))) {
                return true;
            }
        }
        return false;
    }
}
if (!function_exists('getByWhereAsArray')) {
    function getByWhereAsArray($table, $select = '*', $where = array(), $order_by = array(), $limit = null, $offset = null, $where_like = array(), $group_by = '')
    {
        return __sel_q($table, $select, $where, $order_by, $limit, $offset, $where_like, $group_by)->get()->result_array();
    }
}
if (!function_exists('__sel_q')) {
    function __sel_q($table, $select, $where, $order_by, $limit, $offset, $where_like, $group_by)
    {
        $CI = &get_instance();
        $tables = explode(',', $table);
        $CI->db->select($select);
        if (count($tables) > 1) {
            foreach ($tables as $key => $tb) {
                if ($key === 0) {
                    continue;
                }
                $tb = explode('-', $tb);
                $CI->db->join($tb[0], $tb[1], $tb[2]);
            }
        }
        if (count($where)) {
            $CI->db->group_start();
            foreach ($where as $key => $whr) {
                if (is_array($whr)) {
                    foreach ($whr as $value) {
                        $CI->db->or_where($key, $value);
                    }
                } else {
                    $CI->db->where($key, $whr);
                }
            }
            $CI->db->group_end();
        }
        if (count($where_like)) {            
            $CI->db->group_start();
            foreach ($where_like as $key => $whr) {
                if (is_array($whr)) {
                    foreach ($whr as $value) {
                        $CI->db->or_like($key, $value, 'both', false);
                    }
                } else {
                    $CI->db->like($key, $whr, 'both', false);
                }
            }
            $CI->db->group_end();
        }
        if (count($order_by)) {
            $CI->db->order_by($order_by[0], $order_by[1]);
        }
        if ($group_by) {
            $CI->db->group_by($group_by);
        }
        $CI->db->limit($limit);
        $CI->db->offset($offset);
        return $CI->db->from($tables[0]);
    }
}
if (!function_exists('deleteByWhere')) {
    function deleteByWhere($table, $where = array())
    {
        $CI = &get_instance();
        if (count($where)) {
            foreach ($where as $key => $whr) {
                if (is_array($whr)) {
                    foreach ($whr as $value) {
                        $CI->db->or_where($key, $value);
                    }
                } else {
                    $CI->db->where($key, $whr);
                }
            }
        }
        $CI->db->delete($table);
        return $CI->db->affected_rows();
    }
}
if (!function_exists('countTableWhere')) {
    function countTable($table, $where = array())
    {
        $CI = &get_instance();
        if (count($where)) {
            foreach ($where as $key => $whr) {
                if (is_array($whr)) {
                    foreach ($whr as $value) {
                        $CI->db->or_where($key, $value);
                    }
                } else {
                    $CI->db->where($key, $whr);
                }
            }
        }
        $CI->db->from($table);
        return $CI->db->count_all_results();
    }
}
if (!function_exists('sendJson')) {
    function sendJson($data = array(), $code = 200)
    {
        $CI = &get_instance();
        $CI->output
            ->set_status_header($code)
            ->set_content_type('application/json')
            ->set_output(json_encode($data))
            ->_display();exit;
    }
}
if (!function_exists('print_arr')) {
    function print_arr($arr)
    {
        echo '<pre>';
        print_r($arr);
        echo '</pre>';
    }
}
if (!function_exists('searchInArrayChilds')) {
    function searchInArrayChilds($needle, $heystack)
    {
        foreach ($heystack as $key => $arr) {
            if (array_search($needle, $arr)) {
                return $key;
            }
        }
        return null;
    }
}
if(!function_exists('emptyArray')){
    function emptyArray($arr)
    {
        foreach ($arr as $key => $value) {
            if(!empty($value)){
                return false;
            }
        }
        return true;
    }
}
if(!function_exists('emptyArrayElements')){
    function emptyArrayElements($arr, $elem)
    {
        foreach ($elem as $value) {
            if(!empty($arr[$value])){
                return false;
            }
        }
        return true;
    }
}
if(!function_exists('conversation_complete')){
    function conversation_complete($type)
    {
        $CI =& get_instance();
        if($type == 'NewAppConversation'){  
            $CI->load->library('myemail');
            $CI->load->model('chat_visitor_model', 'visitor');   
            $data = $CI->visitor->get($_SESSION['chatbot_userId']);
            $CI->myemail->send($data);
        }
    }
}