<?php if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

if (!function_exists('emp_mapping_result')) {
    function emp_mapping_result($object = null, $behavior = null)
    {
        $mapping_result[] = array('objective' => 1, 'behavior' => 1, 'result' => "Unacceptable");
        $mapping_result[] = array('objective' => 1, 'behavior' => 2, 'result' => "Unacceptable");
        $mapping_result[] = array('objective' => 1, 'behavior' => 3, 'result' => "Unacceptable");
        $mapping_result[] = array('objective' => 1, 'behavior' => 4, 'result' => "Unacceptable");
        $mapping_result[] = array('objective' => 1, 'behavior' => 5, 'result' => "Unacceptable");

        for ($a = 2; $a <= 5; $a++) {
            $mapping_result[] = array('objective' => $a, 'behavior' => 1, 'result' => "Unacceptable");
        }

        for ($b = 2; $b <= 5; $b++) {
            $mapping_result[] = array('objective' => $b, 'behavior' => 2, 'result' => "Needs Improvement");
        }

        for ($c = 3; $c <= 5; $c++) {
            $mapping_result[] = array('objective' => 2, 'behavior' => $c, 'result' => "Needs Improvement");
        }

        for ($d = 3; $d <= 5; $d++) {
            $mapping_result[] = array('objective' => $d, 'behavior' => 3, 'result' => "Fully Effective");
        }

        $mapping_result[] = array('objective' => 3, 'behavior' => 4, 'result' => "Fully Effective");
        $mapping_result[] = array('objective' => 3, 'behavior' => 5, 'result' => "Fully Effective");
        $mapping_result[] = array('objective' => 4, 'behavior' => 4, 'result' => "Commendable");
        $mapping_result[] = array('objective' => 5, 'behavior' => 4, 'result' => "Commendable");
        $mapping_result[] = array('objective' => 4, 'behavior' => 5, 'result' => "Commendable");
        $mapping_result[] = array('objective' => 5, 'behavior' => 5, 'result' => "Exceptional");

        if ($object != null && $behavior != null) {
            foreach ($mapping_result as $key => $value) {
                if (($object == intval($value['objective'])) && ($behavior == intval($value['behavior']))) {
                    return $value['result'];
                }
            }
        } else {
            return "No Value Found";
        }
    }
}

if (!function_exists('get_document_fields')) {
    function get_document_fields($id)
    {
        $ci = &get_instance();
        $ci->load->database();

        $ci->db->select("
            d.department_name
        ")
            ->from('employee_document_fields df')
            ->join('department d', 'df.department_id = d.dept_id');
        $ci->db->order_by('d.department_name', 'asc');
        $ci->db->where("df.employee_document_id", $id);

        return $ci->db->get()->result();
    }
}

if (!function_exists('print_rr')) {
    function print_rr($data = [])
    {
        echo '<pre>' . print_r($data, true) . '</pre>';
    }
}
if (!function_exists('secondsToTime')) {
    function secondsToTime($seconds)
    {
        if (empty($seconds)) {
            return [
                'hours' => 0,
                'minutes' => 0,
                'seconds' => 0,
            ];
        }
        $dtF = new DateTime('@0');
        $dtT = new DateTime("@$seconds");
        $dtT = $dtF->diff($dtT);
        return [
            'hours' => intval($dtT->format('%h')) + (intval($dtT->format('%a')) * 24),
            'minutes' => intval($dtT->format('%i')),
            'seconds' => intval($dtT->format('%s')),
        ];
    }
}
if (!function_exists('get_weekend')) {
    function get_weekend()
    {
        $weekend_days = @getByWhereAsArray('weekly_holiday', 'dayname')[0];
        if ($weekend_days) {
            $weekend_days = explode(',', $weekend_days['dayname']);
        } else {
            $weekend_days = [];
        }
        return $weekend_days;
    }
}
if (!function_exists('daysBetween')) {
    function daysBetween($dt1, $dt2)
    {
        return date_diff(date_create($dt2), date_create($dt1))->format('%a');
    }
}

if(!function_exists('get_js_date_format')){
    function get_js_date_format()
    {
        return 'dd-mm-yy';
    }
}

if(!function_exists('formatted_date')){
    function formatted_date($date_string = '', $time = false)
    {
        $format = 'd-m-Y';
        if($time){
            $format .= ' h:i:s A';
        }
        if(empty($date_string) || $date_string == '0000-00-00'){
            return '';
        }else{
            return date($format, strtotime($date_string));
        }
    }
}
if(!function_exists('formatted_date_now')){
    function formatted_date_now($date_string = '', $time = false)
    {
        $format = 'd-m-Y';
        if($time){
            $format .= ' h:i:s A';
        }
        if(empty($date_string) || $date_string == '0000-00-00'){
            return date($format);
        }else{
            return date($format, strtotime($date_string));
        }
    }
}

if(!function_exists('convert_excel_date')){
    function convert_excel_date($date, $format = 'Y-m-d')
    {
        $src_fmt = 'd/m/Y';
        if(strlen($date) == 8){
            $src_fmt = 'd/m/y';
        }
        $datetime = DATETIME::createFromFormat($src_fmt, $date);
        return $datetime ? $datetime->format($format) : '';
    }
}