<?php /**
 * OrangeHRM is a comprehensive Human Resource Management (HRM) System that captures
 * all the essential functionalities required for any enterprise.
 * Copyright (C) 2006 OrangeHRM Inc., http://www.orangehrm.com
 *
 * OrangeHRM is free software; you can redistribute it and/or modify it under the terms of
 * the GNU General Public License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * OrangeHRM is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this program;
 * if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA
 */
class viewExtraHourAction extends baseAttendanceAction {

    private $employeeService;

    public function getEmployeeService() {

        if (is_null($this->employeeService)) {

            $this->employeeService = new EmployeeService();
        }

        return $this->employeeService;
    }

    public function setEmployeeService(EmployeeService $employeeService) {

        $this->employeeService = $employeeService;
    }
 
	/* Function to see if specific date lies in Weekend (Saturday,Sunday) */
	private function isWeekEnd($date) {
	   $weekend = array("Sat","Sun");
	   $timestamp = strtotime($date);
	   $day= date("D", $timestamp);
	   if(in_array($day,$weekend)) {return true;}
	   return false;	
	}  // isWeekEnd($date)


	/* Function to check if specific employee has leave on specific date */
	private function isLeave($date,$emp_number="") 
	{
		include_once('/var/www/orangehrm/classes/db.php'); 
		$userObj = new Database();

		$leaveRecord = $userObj->getTableData("ohrm_leave","","emp_number='".$emp_number."' AND `date` = '".$date."'","
		*","","1");  
	    if(count($leaveRecord)) {
		   return true;	 // Employee is on leave on this date
		} return false;   // no leave on this date
	} // isLeave()

	/* Function to check if specific employee has holiday on specific date */
	private function isHoliday($date,$emp_number="") 
	{
		include_once('/var/www/orangehrm/classes/db.php'); 
		$userObj = new Database();
		$week_end = array("Sat","Sun");
		//array("month-day",.....) , 8-14(14th August)
		$day_shift_public_holidays =array("05-01","08-14","25-12");   //"month-day" , 8-14(14th August) 
		$night_shift_public_holidays =array("01-01","07-04","11-27","25-12");
		
		/* Accroding to current live DB night and day shift ids  are */
		$night_shifts = array(7,8,10);
		$day_shifts = array(5,9);
		
		$employeeShift = $userObj->getTableData("ohrm_employee_work_shift","","emp_number='".$emp_number."'","
		*","","1");  
		
		$shift_id = "";
		if(count($employeeShift))
		{
		   $shift_id = $employeeShift[0]["work_shift_id"];	
		}
		$qry11 = "SELECT * FROM ohrm_adhoc_holidays WHERE  (shift_id = '".$shift_id."' OR FIND_IN_SET(".$emp_number.",employee_nos)) ";
		
		$adhoc_holidays = $userObj->getResumes($qry11);
		foreach($adhoc_holidays as $item)
		 {   //print_r($adhoc_holidays);
			  
			   if(strtotime($date) >=strtotime($item['from_date']) &&  strtotime($date) <=strtotime($item['to_date']))
			   {
							return true;  // this date lies in adhoc holidays.
			   }
		 }
		/* If date lies in weekend then it is holiday */ 
		if(in_array(date("D",strtotime($date)),$week_end))
		{
			return true;
		}
	  /* Public Holiday will be decided according to emplyee shift day/night */
	  /* If date lies in day shift public holidays then it is holiday (return true)  */
	  if(in_array($employeeShift[0]['id'],$day_shifts)  && in_array(date("m-d",strtotime($date)),$day_shift_public_holidays)){
		return true;  
	  }
	   /* If date lies in night shift public holidays then it is holiday (return true)  */
	  if(in_array($employeeShift[0]['id'],$night_shifts)  && in_array(date("m-d",strtotime($date)),$night_shift_public_holidays)){
		return true;  
	  }
	  return false ; //not any holiday
	}  //isHoliday()

	/* Function to get Array  of all dates between two dates */
	private function dateRange($first, $last, $step = '+1 day', $format = 'Y-m-d' ) { 

	    $dates = array();
	    $current = strtotime($first);
	    $last = strtotime($last);
	    while( $current <= $last ) { 
	        $dates[] = date($format, $current);
	        $current = strtotime($step, $current);
	    }
	    return $dates;
	}  //dateRange()
 
	/* Function to adjsut extra hours of employees he worked  */
	private function adjustExtraHours($emp_number, $attendance_record,$shift_start_time,$shift_hours_per_day,$from_date,$to_date)
	{        
			include_once('/var/www/orangehrm/classes/db.php'); 
			$userObj = new Database();
			$compensation_array = array();
	            /*  Rafaqat - Getting Extra Times Record of  a person  */
			$extraTimes = $userObj->getTableData("ohrm_extra_working_hours","","emp_number=".$emp_number." AND work_date >= '".$from_date."' AND work_date <= '".$to_date."' AND status=1","*","","1");
			$extra_hours_arr = array();
			$total_extra_hours = 0;
			if(count($extraTimes))
			{
			   foreach($extraTimes as $item){
				    // $extra_hours_arr ["2014-10-02"] = 6 ; key=>value pattern
				   $extra_hours_arr[$item['work_date']] = $item['extra_hours']; 
				   $total_extra_hours += $item['extra_hours'];    
			   }
			}	
			
			
		       /*  Ho much time user was late */
			   $start_time = new DateTime($shift_start_time);
			   $present_days = array();  // Days in which user was present/ marked attendance
			   /*  Date range for which we are getting attendace records array() */
			   $date_range = $this->dateRange($from_date,$to_date);
			   foreach($attendance_record as $item)
			   {
				   $punch_in_time = explode(" ",$item["punch_in_user_time"]);  //0=>date, 1=>time
				   $present_days[] = $punch_in_time[0]; // date part
				   $time_diff = $start_time->diff(new DateTime($punch_in_time[1]));
				   $days = $time_diff->d; // days
				   $hours = $time_diff->h; // hours
				   $minutes= $time_diff->i;  //minutes
				   $time_diff_hours = ($days*24)+ $hours + $minutes/60; // hours
				   $day_before =  date("Y-m-d",strtotime("".$punch_in_time[0]." -1 day"));
					/* If day before keeps some extra hours then compensate */
					if(isset($extra_hours_arr[$day_before]) && $extra_hours_arr[$day_before]>=$time_diff_hours && $time_diff_hours  && $punch_in_time[1] > $shift_start_time && $time_diff_hours >= 0.25    && !$this->isLeave($punch_in_time[0],$emp_number))
					{    
						 $extra_hours_arr[$day_before] =  $extra_hours_arr[$day_before]-$time_diff_hours;
						 $total_extra_hours = $total_extra_hours - $time_diff_hours;											                             $sign='P (LA-COMP)';  // Late Arrival Compensated.	
						 $compensation_array["late_arrival"][$punch_in_time[0]] = "P(LA-COMP - ".$shift_hours_per_day." Hours)";
					}
			   }
			  
			   /*HAlf Day solution*/
			   foreach($attendance_record as $item)
			   {       
					       //$item["punch_in_user_time"]."pppp".$item["punch_out_user_time"];
							$punch_in_time = explode(" ",$item["punch_in_user_time"]);  //0=>date, 1=>time
							$punch_in_user_time  = new DateTime($item["punch_in_user_time"]);
							$work_time = $punch_in_user_time->diff(new DateTime($item["punch_out_user_time"]));
							$days = $work_time->d; // days
							$hours = $work_time->h; // hours
							$minutes= $work_time->i;  //minutes
							
							$work_time_hours = ($days*24)+ $hours + $minutes/60; // hours
							  
							  /* $item["punch_out_user_time"]!=" means that empty(Null) punch out time which does'not*/
							  /*calculate work time */ 
							  if( ($work_time_hours/$shift_hours_per_day)*100 < 50  && $item["punch_out_user_time"]!=""  && !$this->isLeave($punch_in_time[0],$emp_number))
								{   
									if($total_extra_hours + $work_time_hours >= $shift_hours_per_day)
									{    
										 $compensation_array["half_days"][$punch_in_time[0]] = "P(HD-COMP - ".$shift_hours_per_day." Hours)";
										 $total_extra_hours = $total_extra_hours - ($shift_hours_per_day-$work_time_hours);
									}
								}
			   }
			   
			   /* Days when user did not punched in. This can be absent or any holiday*/
			   $non_present_days = array_diff($date_range,$present_days);
			   foreach($non_present_days as $np_day){
				    /* if this was not a holiday then it was absent. Try to compensate it */
				   if(!$this->isHoliday($np_day,$emp_number)  && !$this->isLeave($np_day,$emp_number)){
					   if($total_extra_hours >=$shift_hours_per_day){
						  $compensation_array["absents"][$np_day] = "P(A-COMP - ".$shift_hours_per_day." Hours)";
						  $total_extra_hours = $total_extra_hours - $shift_hours_per_day;   
					   }
				   }
			   }
					   
					 // if($emp_number==100) {print_r($compensation_array); exit;  } 
			return $compensation_array;
	}  //adjustExtraHours() ends


    public function execute($request) {

        $loggedInEmpNumber = $this->getContext()->getUser()->getEmployeeNumber();
        $userRoleManager = $this->getContext()->getUserRoleManager();
        $this->parmetersForListCompoment = array();
        $this->showEdit = false;
        $this->attendancePermissions = $this->getDataGroupPermissions('attendance_records');
        if (!$this->attendancePermissions->canRead()) {
            return $this->renderText(__("You are not allowed to view this page") . "!");
        }
        $this->trigger = $request->getParameter('trigger');
        if ($this->trigger) {
            $this->showEdit = true;
        }
        $this->date = $request->getParameter('date');
		
        $this->employeeId = $request->getParameter('employeeId');
        $this->employeeService = $this->getEmployeeService();
        $values = array('date' => $this->date, 'employeeId' => $this->employeeId, 'trigger' => $this->trigger);
        $this->form = new AttendanceRecordSearchForm(array(), $values);
        $this->actionRecorder = "viewEmployee";

        $isPaging = $request->getParameter('pageNo');
        $pageNumber = $isPaging;
        $noOfRecords = $noOfRecords = sfConfig::get('app_items_per_page');
        $offset = ($pageNumber >= 1) ? (($pageNumber - 1) * $noOfRecords) : ($request->getParameter('pageNo', 1) - 1) * $noOfRecords;

        $records = array();

        if ($this->attendancePermissions->canRead()) {
            $this->_setListComponent($records, $noOfRecords, $pageNumber, null, $this->showEdit);
        }
       
        if(!$this->trigger) {
            if($request->isMethod('post')){ 

				include_once('/var/www/orangehrm/classes/db.php'); 
				$userObj = new Database();
				
				/* If employee name is sent empty and employee id is sent then we have to get Employee Name  */
				/*  As we are customizing Ohrms default coding and it is working eith Employee name not employee id  */
				if(!empty($_POST["attendance"]["employeeId"]) && $_POST["attendance"]["employeeName"]["empName"]=="" || trim($_POST["attendance"]["employeeName"]["empName"])=="Type for hints...")
				{  
					//echo'sdsds';exit;
				   $where = "employee_id=".$_POST["attendance"]["employeeId"]; 
				   $userData=$userObj->getTableData('hs_hr_employee','',$where,'emp_number, emp_firstname, emp_middle_name, emp_lastname',1,'');
				   
				   $f_name = $userData[0]['emp_firstname']." ";
				   $mid_name = $userData[0]['emp_middle_name']!=""?$userData[0]['emp_middle_name']." ":"";
				   $l_name = $userData[0]['emp_lastname'];
				   $full_name = $f_name.$mid_name.$l_name;
				   
				   /***  Customize POSTED array as to include employee name and empNumber  ***/
				  $_POST["attendance"]["employeeName"]["empName"] = $full_name;
				  $_POST["attendance"]["employeeName"]["empId"] = $userData[0]['emp_number'];			
				}
				
				//$_POST['empid'] = $_POST["attendance"]["employeeId"];
				/* We unset POSTED employeeId as it is not accepted in default implementation of Orange HRM */
				unset($_POST["attendance"]["employeeId"]);  // new code
				 
				 /* Re- Arrange  form=>systemUser with new values*/
				$request->setParameter('attendance', $_POST["attendance"]);  // new code
						//print_r($request->getParameter('attendance'));exit;
					//echo '<pre>'; print_r($_POST);exit;

	            $this->form->bind($request->getParameter('attendance'));
 	 
    	
                if ($this->form->isValid()){ 
                    $this->allowedToDelete = array();
                    $this->allowedActions = array();

                    $this->allowedActions['Delete'] = false;
                    $this->allowedActions['Edit'] = false;
                    $this->allowedActions['PunchIn'] = false;
                    $this->allowedActions['PunchOut'] = false;

                    $post = $this->form->getValues();

                    if (!$this->employeeId) {
                        $empData = $post['employeeName'];
                        $this->employeeId = $empData['empId'];
                    }

                    if (!$this->date) {
                        $this->date = $post['date'];
                    }

					if(isset($_POST['attType'])){
						if($_POST['attType']=='DempAtt'){
							 $this->city = $post['city'];
						}
					}
				
                    if ($this->employeeId) {
                        $this->showEdit = true;
                    }

                    $isPaging = $request->getParameter('hdnAction') == 'search' ? 1 : $request->getParameter('pageNo', 1);
                    $pageNumber = $isPaging;
                    $noOfRecords = sfConfig::get('app_items_per_page');
                    $offset = ($pageNumber >= 1) ? (($pageNumber - 1) * $noOfRecords) : ($request->getParameter('pageNo', 1) - 1) * $noOfRecords;

                    $empRecords = array();
                    if (!$this->employeeId) {
					//                        $empRecords = $this->employeeService->getEmployeeList('firstName', 'ASC', false);
                        $empRecords = UserRoleManagerFactory::getUserRoleManager()->getAccessibleEntities('Employee'); 
						//getAccessibleEmployees   //getEmployeeList
                        $count = count($empRecords);
                    }
                    else{
                        $empRecords = $this->employeeService->getEmployee($this->employeeId);
                        $empRecords = array($empRecords);
                        $count = 1;
                    }

                    $records = array();
				 	
					foreach ($empRecords as $employee){
						$hasRecords = false;
				
					   	include_once('/var/www/orangehrm/classes/db.php'); 
						$userObj = new Database();
						include_once('/var/www/orangehrm/classes/XLClasses/PHPExcel.php');
						$start = 0;
						// Create new PHPExcel object
						$objPHPExcel = new PHPExcel();
						// Create a first sheet, representing sales data
						$objPHPExcel->setActiveSheetIndex(0);
						//
						$from = $post['date'] . " " . "00:" . "00:" . "00";
       					$end = $post['date2'] . " " . "23:" . "59:" . "59";
						
						$currentDate=date('Y-m-d');
						
						$date_1 = strtotime($post['date']);
						$date_2 = strtotime($post['date2']);
						$total_report_days = ($date_2-$date_1)/(60*60*24);
						$total_report_days = $total_report_days + 1; 

						$datediff = strtotime($end)  - strtotime($from);
						$totalDays= floor($datediff/(60*60*24));
					      
						// Adjusting headers start
						$objPHPExcel->getActiveSheet()->setCellValue('A1', 'S.#')
								  ->setCellValue('B1', "Name")
								  ->setCellValue('C1', "DOJ")
								  ->setCellValue('D1',"E.Code/ID")
								  ->setCellValue('E1',"Center")
								  ->setCellValue('F1',"Designation");
							   
						
						$alpha='F';
						$nextDay=$post['date'];
						
						$nextDay2=strtotime($nextDay);
						$nextDay2=date("D-d-M Y", $nextDay2);
				 
						$arrayStore=array();
						for($ij=0; $ij<=$totalDays;$ij++)
						{
							$alpha++;
							$objPHPExcel->getActiveSheet()->setCellValue($alpha."1", $nextDay2);
							$arrayStore[$ij][0]=$alpha;
							$arrayStore[$ij][1]=$nextDay;
							$date = strtotime("+1 day", strtotime($nextDay));
					    	$nextDay=date("Y-m-d", $date); 
							$nextDay2=strtotime($nextDay);
							$nextDay2=date("D-d-M Y", $nextDay2);
						}
							 
							 
						$bravo= $alpha;
						$bravo++; 

						$IsOne=$bravo++;
						$IsTwo=$bravo++; 	  
						 
					    $objPHPExcel->getActiveSheet()->setCellValue($IsOne.'1',"Approved Extra Hours")
								  	->setCellValue($IsTwo.'1',"Total Hours At Home");
						// Adjusting headers end
						
					  	// $finalCol=$IsEight."1";	
					    $finalCol=$IsTwo."1";	 
						$objPHPExcel->getActiveSheet()->getStyle('A1:'.$finalCol)->getFill()->applyFromArray(
						array(
								'type' => PHPExcel_Style_Fill::FILL_SOLID,
								'color' => array('rgb' => '580623')
							)
						);
						$styleArray = array(
								'font'  => array(
								'bold'  => true,
								'color' => array('rgb' => 'FFFFFF'),
								'size'  => 13,
						));
						$i=1;
						$r=$i+1;
						$objPHPExcel->getActiveSheet()->getStyle('A1:'.$finalCol)->applyFromArray($styleArray);		
						$objPHPExcel->getActiveSheet()->getStyle('A1:'.$finalCol)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
					 
						$subordinates_and = "";
						if($_SESSION['isAdmin'] == "No"){
							$emp_ids = "0"; // jsut initialization to save from DB error
							$subordinates = $userObj->getTableData("hs_hr_emp_reportto","","erep_sup_emp_number = '".$_SESSION['empNumber']."'","erep_sub_emp_number","","");
							if(count($subordinates)){
							   $sub_employees = array();
							   foreach($subordinates as $item){
								  $sub_employees[] = $item['erep_sub_emp_number'];
							   }
							   $emp_ids = implode(",",$sub_employees);
							}
							$subordinates_and =  " AND emp_number IN (".$emp_ids.")"; 
						}
						/* Sub Ordinate handling ends here */
						  
						if($_POST['city']!='all'){
					 		$query = "SELECT 
							emp.emp_number, emp.emp_firstname, 
							emp.emp_lastname, emp.emp_middle_name,
							emp.custom4,emp.employee_id,emp.custom77,
							emp.custom34,emp.custom31, emp.custom30, emp.custom40
							    FROM 
							hs_hr_employee as emp, ohrm_attendance_record as att
								WHERE 
							emp.emp_number = att.employee_id AND
							emp.custom34='".$_POST['city']."' AND emp.custom30='Active' 
							".$subordinates_and."
								OR
								(emp.custom34='".$_POST['city']."' AND emp.custom30 != 'Active' AND att.employee_id=emp.emp_number AND 
								  att.punch_in_user_time  BETWEEN '".$from."' AND '".$end."'
								  
								  ".$subordinates_and."
								)
								GROUP BY emp.emp_number
								ORDER BY emp.emp_firstname ASC
							"; 
						
							$numberOfEmp = $userObj->execQuery($query);									
						}
						else{
							
							$query = "SELECT 
							emp.emp_number, emp.emp_firstname, 
							emp.emp_lastname, emp.emp_middle_name,
							emp.custom4,emp.employee_id,emp.custom77,
							emp.custom34,emp.custom31, emp.custom30, emp.custom40
							    FROM 
							hs_hr_employee as emp, ohrm_attendance_record as att
							WHERE 
							  emp.emp_number = att.employee_id AND
							  emp.custom30='Active'  ".$subordinates_and."
								OR
								(emp.custom30 != 'Active' AND att.employee_id=emp.emp_number AND 
								  att.punch_in_user_time  BETWEEN '".$from."' AND '".$end."'
								  
								  ".$subordinates_and."
								) 
								GROUP BY emp.emp_number 
								ORDER BY emp.emp_firstname ASC
							";
							$numberOfEmp = $userObj->execQuery($query);	
						}
			
						$aBefore=$IsTwo;
						function convertToHoursMins($time, $format = '%02d:%02d') {
						    if ($time < 1) {
						        return;
						    }
						    $hours = floor($time / 60);
						    $minutes = ($time % 60);
						    return sprintf($format, $hours, $minutes);
						}

						foreach ($numberOfEmp as $numOfEmp)
						{
					
							$name	= trim($numOfEmp['emp_firstname']." ".$numOfEmp['emp_middle_name']." ".$numOfEmp['emp_lastname']);
							$status = $numOfEmp['custom30']!='Active'? " (".$numOfEmp['custom30'].")":'Active';
							 
							$doj2	= strtotime($numOfEmp['custom4']);
							$doj2	= date("D-d-M Y", $doj2);
							 							 
						    $objPHPExcel->getActiveSheet()->setCellValue('A'.$r, $i)
										->setCellValue('B'.$r, $name)
										->setCellValue('C'.$r, $doj2)
										->setCellValue('D'.$r, $numOfEmp['employee_id'])
										->setCellValue('E'.$r, $numOfEmp['custom34'])
										->setCellValue('F'.$r, $numOfEmp['custom31']);
        

						  	$countSArr	= count($arrayStore); 
						  	for($ij = 0; $ij < $countSArr; $ij++)
							{
							 	$extWorkHr = "SELECT SUM(extra_hours) AS EXTHR FROM ohrm_extra_working_hours 
												WHERE  emp_number={$numOfEmp['emp_number']} AND work_date = '{$arrayStore[$ij][1]}'";
								$extHrDay = $userObj->getResumes($extWorkHr);
						 
								if(count($extHrDay)>0): 
									$totalHour=($extHrDay[0]['EXTHR']=='')?0:convertToHoursMins($extHrDay[0]['EXTHR'], '%02d hours %02d minutes');
								else:
 									$totalHour=0;
 								endif;							 
								$objPHPExcel->getActiveSheet()->setCellValue($arrayStore[$ij][0].$r,$totalHour);			 
							} 


							$extWorkHr = "SELECT SUM(extra_hours) AS EXTHR FROM ohrm_extra_working_hours WHERE  emp_number={$numOfEmp['emp_number']} AND status=1  AND work_date BETWEEN '".$from."' AND '".$end."'";
							$approvedExtHour = $userObj->getResumes($extWorkHr);
								if(count($approvedExtHour)>0):
									$approvedExtHour=($approvedExtHour[0]['EXTHR']=='')?0:convertToHoursMins($approvedExtHour[0]['EXTHR'], '%02d hours %02d minutes');
								else:
									$approvedExtHour=0;
								endif;
							$objPHPExcel->getActiveSheet()->setCellValue($IsOne.$r, $approvedExtHour);

								
								$extWorkHr = "SELECT SUM(extra_hours) AS EXTHR FROM ohrm_extra_working_hours WHERE  emp_number={$numOfEmp['emp_number']} AND work_date BETWEEN '".$from."' AND '".$end."'";
							$totalExtHour = $userObj->getResumes($extWorkHr);
								if(count($totalExtHour)>0):
									$totalExtHour=($totalExtHour[0]['EXTHR']=='')?0:convertToHoursMins($totalExtHour[0]['EXTHR'], '%02d hours %02d minutes');
								else:
									$totalExtHour=0;
								endif;
							$objPHPExcel->getActiveSheet()->setCellValue($IsTwo.$r, $totalExtHour);


							if($i % 2 == 0){						  
								$objPHPExcel->getActiveSheet()->getStyle('A'.$r.':'.$aBefore.$r)->getFill()->applyFromArray(
								array(
										'type' => PHPExcel_Style_Fill::FILL_SOLID,
										'color' => array('rgb' => 'EEEEEE')
									)
								);
								
								$objPHPExcel->getDefaultStyle()->getAlignment()
																->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
							}
							else{
								$objPHPExcel->getDefaultStyle()->getAlignment()
																->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
							}
							
							$i++; 
							$r++;			
						}  	  
						///////////////////////////////////////////////
										 
						$t = $r+3; 
						$objPHPExcel->getActiveSheet()->setCellValue('C'.$t, 'Total Records:')
													  ->setCellValue('E'.$t, count($numberOfEmp)); 
						$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(10);
						$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(40);
						$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(40);
						$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(40);
						$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(40);
						$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(40);
						
						$alpha='F';
						for($i=0; $i<=$totalDays;$i++)
						{ 
							$alpha++;  
							$objPHPExcel->getActiveSheet()->getColumnDimension($alpha)->setWidth(40); 
						} 
							
								 
						$objPHPExcel->getActiveSheet()->getColumnDimension($IsOne)->setWidth(40); 
						$objPHPExcel->getActiveSheet()->getColumnDimension($IsTwo)->setWidth(40);

						// Add conditional formatting
						$objConditional1 = new PHPExcel_Style_Conditional();
						$objConditional1->setConditionType(PHPExcel_Style_Conditional::CONDITION_CELLIS)
										->setOperatorType(PHPExcel_Style_Conditional::OPERATOR_BETWEEN)
										->addCondition('200')
										->addCondition('400');
						$objConditional1->getStyle()->getFont()->getColor()->setARGB(PHPExcel_Style_Color::COLOR_YELLOW);
						$objConditional1->getStyle()->getFont()->setBold(true);
						$objConditional1->getStyle()->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_CURRENCY_EUR_SIMPLE);
						
						$objConditional2 = new PHPExcel_Style_Conditional();
						$objConditional2->setConditionType(PHPExcel_Style_Conditional::CONDITION_CELLIS)
										->setOperatorType(PHPExcel_Style_Conditional::OPERATOR_LESSTHAN)
										->addCondition('0');
						$objConditional2->getStyle()->getFont()->getColor()->setARGB(PHPExcel_Style_Color::COLOR_RED);
						$objConditional2->getStyle()->getFont()->setItalic(true);
						$objConditional2->getStyle()->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_CURRENCY_EUR_SIMPLE);
						
						$objConditional3 = new PHPExcel_Style_Conditional();
						$objConditional3->setConditionType(PHPExcel_Style_Conditional::CONDITION_CELLIS)
										->setOperatorType(PHPExcel_Style_Conditional::OPERATOR_GREATERTHANOREQUAL)
										->addCondition('0');
						$objConditional3->getStyle()->getFont()->getColor()->setARGB(PHPExcel_Style_Color::COLOR_GREEN);
						$objConditional3->getStyle()->getFont()->setItalic(true);
						$objConditional3->getStyle()->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_CURRENCY_EUR_SIMPLE);
						
						$conditionalStyles = $objPHPExcel->getActiveSheet()->getStyle('B2')->getConditionalStyles();
						array_push($conditionalStyles, $objConditional1);
						array_push($conditionalStyles, $objConditional2);
						array_push($conditionalStyles, $objConditional3);
						
						$objPHPExcel->getDefaultStyle()
							->getAlignment()
							->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
						
					  
						// Set fonts
						$objPHPExcel->getActiveSheet()->getStyle('A1:'.$aBefore."1")->getFont()->setBold(true);
						
						$styleArray1 = array(
								'font'  => array(
								'bold'  => true,
								'color' => array('rgb' => '000000'),
								'size'  => 12,
						));
							
						$objPHPExcel->getActiveSheet()->getStyle('E'.$t.':'.$aBefore.$t)->applyFromArray($styleArray1);	 
						$objPHPExcel->getActiveSheet()->getPageSetup()->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_PORTRAIT);
						$objPHPExcel->getActiveSheet()->getPageSetup()->setPaperSize(PHPExcel_Worksheet_PageSetup::PAPERSIZE_A4);
							
						$city=$_POST['city'];
							
						// Rename worksheet
						//$objPHPExcel->getActiveSheet()->setTitle(date('y-m-d h-i-s').$city.'AttReport');
							
						// Set active sheet index to the first sheet, so Excel opens this as the first sheet
						$objPHPExcel->setActiveSheetIndex(0);
						
							/*			echo $city."hm,mm";*/
						// exit;	
						$dir = '/var/www/orangehrm/reports/';
						$fileName = date('y-m-d h-i-s').$city.'ExtHoursReport'.'.xls'; 
						$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
						$objWriter->save($dir.$fileName);
							
						function force_download($file,$dir)
						{
							if ((isset($file)) && (file_exists($dir.$file)))
							{ //if start
								header("Content-type: application/force-download"); 
								header('Content-Disposition: inline; filename="' . $dir.$file . '"'); 
								header("Content-Transfer-Encoding: Binary"); 
								header("Content-length: ".filesize($dir.$file)); 
								header('Content-Type: application/octet-stream'); 
								header('Content-Disposition: attachment; filename="'.$file.'"'); 
								readfile("$dir$file"); 
							}
							else
							{ 
								echo "Sorry! not found on server";
							} 
						}
							
						force_download($fileName,$dir);
						exit;  
            		}
    			}
    		}
    	}
    }
    private function _setListComponent($records, $noOfRecords, $pageNumber, $count = null, $showEdit = null, $allowedActions = null) {

        $configurationFactory = new AttendanceRecordHeaderFactory();
        $userRoleManager = $this->getContext()->getUserRoleManager();
        $loggedInEmpNumber = $this->getUser()->getEmployeeNumber();

        $notSelectable = array();
        foreach ($records as $record) {
            if (!$userRoleManager->isActionAllowed(WorkflowStateMachine::FLOW_ATTENDANCE, 
                    $record->getState(), WorkflowStateMachine::ATTENDANCE_ACTION_DELETE, 
                    array(), array(), array('Employee' => $this->employeeId))) {          
                $notSelectable[] = $record->getId();
            }
        }

        $buttons = array();
        $canSelect = false;
        if (isset($allowedActions)) {
            if (isset($showEdit) && $showEdit) {
                if ($allowedActions['Edit']) :
                    $buttons['Edit'] = array('label' => __('Edit'), 'type' => 'button',);
                endif;
                if ($allowedActions['PunchIn']) :
                    $buttons['PunchIn'] = array('label' => __('Add Attendance Records'), 'type' => 'button', 'class' => 'punch');
                endif;
                if ($allowedActions['PunchOut']) :
                    $buttons['PunchOut'] = array('label' => __('Add Attendance Records'), 'type' => 'button', 'class' => 'punch');
                endif;
            }
            if ($allowedActions['Delete']) :
                $canSelect = true;
                $buttons['Delete'] = array('label' => __('Delete'),
                    'type' => 'submit',
                    'data-toggle' => 'modal',
                    'data-target' => '#dialogBox',
                    'class' => 'delete');
            endif;
        }
        $configurationFactory->setRuntimeDefinitions(array(
            'buttons' => $buttons,
            'unselectableRowIds' => $notSelectable,
            'hasSelectableRows' => $canSelect
        ));

        ohrmListComponent::setActivePlugin('orangehrmAttendancePlugin');
        ohrmListComponent::setConfigurationFactory($configurationFactory);
        ohrmListComponent::setListData($records);
        ohrmListComponent::setPageNumber($pageNumber);
        ohrmListComponent::setItemsPerPage($noOfRecords);
        ohrmListComponent::setNumberOfRecords($count);
    }
    
}

