<?php /**
 * OrangeHRM is a comprehensive Human Resource Management (HRM) System that captures
 * all the essential functionalities required for any enterprise.
 * Copyright (C) 2006 OrangeHRM Inc., http://www.orangehrm.com
 *
 * OrangeHRM is free software; you can redistribute it and/or modify it under the terms of
 * the GNU General Public License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * OrangeHRM is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this program;
 * if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA
 */
class viewAttendanceRecordAction extends baseAttendanceAction {

    private $employeeService;

    public function getEmployeeService() {

        if (is_null($this->employeeService)) {

            $this->employeeService = new EmployeeService();
        }

        return $this->employeeService;
    }

    public function setEmployeeService(EmployeeService $employeeService) {

        $this->employeeService = $employeeService;
    }
 
	/* Function to see if specific date lies in Weekend (Saturday,Sunday) */
	private function isWeekEnd($date) {
	   $weekend = array("Sat","Sun");
	   $timestamp = strtotime($date);
	   $day= date("D", $timestamp);
	   if(in_array($day,$weekend)) {return true;}
	   return false;	
	}  // isWeekEnd($date)


	/* Function to check if specific employee has leave on specific date */
	private function isLeave($date,$emp_number="") 
	{
		include_once('/var/www/orangehrm/classes/db.php'); 
		$userObj = new Database();

		$leaveRecord = $userObj->getTableData("ohrm_leave","","emp_number='".$emp_number."' AND `date` = '".$date."'","
		*","","1");  
	    if(count($leaveRecord)) {
		   return true;	 // Employee is on leave on this date
		} return false;   // no leave on this date
	} // isLeave()

	/* Function to check if specific employee has holiday on specific date */
	private function isHoliday($date,$emp_number="") 
	{
		include_once('/var/www/orangehrm/classes/db.php'); 
		$userObj = new Database();
		$week_end = array("Sat","Sun");
		//array("month-day",.....) , 8-14(14th August)
		$day_shift_public_holidays =array("05-01","08-14","25-12");   //"month-day" , 8-14(14th August) 
		$night_shift_public_holidays =array("01-01","07-04","11-27","25-12");
		
		/* Accroding to current live DB night and day shift ids  are */
		$night_shifts = array(7,8,10);
		$day_shifts = array(5,9);
		
		$employeeShift = $userObj->getTableData("ohrm_employee_work_shift","","emp_number='".$emp_number."'","
		*","","1");  
		
		$shift_id = "";
		if(count($employeeShift))
		{
		   $shift_id = $employeeShift[0]["work_shift_id"];	
		}
		$qry11 = "SELECT * FROM ohrm_adhoc_holidays WHERE  (shift_id = '".$shift_id."' OR FIND_IN_SET(".$emp_number.",employee_nos)) ";
		
		$adhoc_holidays = $userObj->getResumes($qry11);
		foreach($adhoc_holidays as $item)
		 {   //print_r($adhoc_holidays);
			  
			   if(strtotime($date) >=strtotime($item['from_date']) &&  strtotime($date) <=strtotime($item['to_date']))
			   {
							return true;  // this date lies in adhoc holidays.
			   }
		 }
		/* If date lies in weekend then it is holiday */ 
		if(in_array(date("D",strtotime($date)),$week_end))
		{
			return true;
		}
	  /* Public Holiday will be decided according to emplyee shift day/night */
	  /* If date lies in day shift public holidays then it is holiday (return true)  */
	  if(in_array($employeeShift[0]['id'],$day_shifts)  && in_array(date("m-d",strtotime($date)),$day_shift_public_holidays)){
		return true;  
	  }
	   /* If date lies in night shift public holidays then it is holiday (return true)  */
	  if(in_array($employeeShift[0]['id'],$night_shifts)  && in_array(date("m-d",strtotime($date)),$night_shift_public_holidays)){
		return true;  
	  }
	  return false ; //not any holiday
	}  //isHoliday()

	/* Function to get Array  of all dates between two dates */
	private function dateRange($first, $last, $step = '+1 day', $format = 'Y-m-d' ) { 

	    $dates = array();
	    $current = strtotime($first);
	    $last = strtotime($last);
	    while( $current <= $last ) { 
	        $dates[] = date($format, $current);
	        $current = strtotime($step, $current);
	    }
	    return $dates;
	}  //dateRange()
 
	/* Function to adjsut extra hours of employees he worked  */
	private function adjustExtraHours($emp_number, $attendance_record,$shift_start_time,$shift_hours_per_day,$from_date,$to_date)
	{        
			include_once('/var/www/orangehrm/classes/db.php'); 
			$userObj = new Database();
			$compensation_array = array();
	            /*  Rafaqat - Getting Extra Times Record of  a person  */
			$extraTimes = $userObj->getTableData("ohrm_extra_working_hours","","emp_number=".$emp_number." AND work_date >= '".$from_date."' AND work_date <= '".$to_date."' AND status=1","*","","1");
			$extra_hours_arr = array();
			$total_extra_hours = 0;
			if(count($extraTimes))
			{
			   foreach($extraTimes as $item){
				    // $extra_hours_arr ["2014-10-02"] = 6 ; key=>value pattern
				   $extra_hours_arr[$item['work_date']] = $item['extra_hours']; 
				   $total_extra_hours += $item['extra_hours'];    
			   }
			}	
			
			
		       /*  Ho much time user was late */
			   $start_time = new DateTime($shift_start_time);
			   $present_days = array();  // Days in which user was present/ marked attendance
			   /*  Date range for which we are getting attendace records array() */
			   $date_range = $this->dateRange($from_date,$to_date);
			   foreach($attendance_record as $item)
			   {
				   $punch_in_time = explode(" ",$item["punch_in_user_time"]);  //0=>date, 1=>time
				   $present_days[] = $punch_in_time[0]; // date part
				   $time_diff = $start_time->diff(new DateTime($punch_in_time[1]));
				   $days = $time_diff->d; // days
				   $hours = $time_diff->h; // hours
				   $minutes= $time_diff->i;  //minutes
				   $time_diff_hours = ($days*24)+ $hours + $minutes/60; // hours
				   $day_before =  date("Y-m-d",strtotime("".$punch_in_time[0]." -1 day"));
					/* If day before keeps some extra hours then compensate */
					if(isset($extra_hours_arr[$day_before]) && $extra_hours_arr[$day_before]>=$time_diff_hours && $time_diff_hours  && $punch_in_time[1] > $shift_start_time && $time_diff_hours >= 0.25    && !$this->isLeave($punch_in_time[0],$emp_number))
					{    
						 $extra_hours_arr[$day_before] =  $extra_hours_arr[$day_before]-$time_diff_hours;
						 $total_extra_hours = $total_extra_hours - $time_diff_hours;											                             $sign='P (LA-COMP)';  // Late Arrival Compensated.	
						 $compensation_array["late_arrival"][$punch_in_time[0]] = "P(LA-COMP - ".$shift_hours_per_day." Hours)";
					}
			   }
			  
			   /*HAlf Day solution*/
			   foreach($attendance_record as $item)
			   {       
					       //$item["punch_in_user_time"]."pppp".$item["punch_out_user_time"];
							$punch_in_time = explode(" ",$item["punch_in_user_time"]);  //0=>date, 1=>time
							$punch_in_user_time  = new DateTime($item["punch_in_user_time"]);
							$work_time = $punch_in_user_time->diff(new DateTime($item["punch_out_user_time"]));
							$days = $work_time->d; // days
							$hours = $work_time->h; // hours
							$minutes= $work_time->i;  //minutes
							
							$work_time_hours = ($days*24)+ $hours + $minutes/60; // hours
							  
							  /* $item["punch_out_user_time"]!=" means that empty(Null) punch out time which does'not*/
							  /*calculate work time */ 
							  if( ($work_time_hours/$shift_hours_per_day)*100 < 67  && $item["punch_out_user_time"]!=""  && !$this->isLeave($punch_in_time[0],$emp_number))
								{   
									if($total_extra_hours + $work_time_hours >= $shift_hours_per_day)
									{    
										 $compensation_array["half_days"][$punch_in_time[0]] = "P(HD-COMP - ".$shift_hours_per_day." Hours)";
										 $total_extra_hours = $total_extra_hours - ($shift_hours_per_day-$work_time_hours);
									}
								}
			   }
			   
			   /* Days when user did not punched in. This can be absent or any holiday*/
			   $non_present_days = array_diff($date_range,$present_days);
			   foreach($non_present_days as $np_day){
				    /* if this was not a holiday then it was absent. Try to compensate it */
				   if(!$this->isHoliday($np_day,$emp_number)  && !$this->isLeave($np_day,$emp_number)){
					   if($total_extra_hours >=$shift_hours_per_day){
						  $compensation_array["absents"][$np_day] = "P(A-COMP - ".$shift_hours_per_day." Hours)";
						  $total_extra_hours = $total_extra_hours - $shift_hours_per_day;   
					   }
				   }
			   }
					   
					 // if($emp_number==100) {print_r($compensation_array); exit;  } 
			return $compensation_array;
	}  //adjustExtraHours() ends


    public function execute($request) {

        $loggedInEmpNumber = $this->getContext()->getUser()->getEmployeeNumber();
        $userRoleManager = $this->getContext()->getUserRoleManager();
        $this->parmetersForListCompoment = array();
        $this->showEdit = false;
        $this->attendancePermissions = $this->getDataGroupPermissions('attendance_records');
        if (!$this->attendancePermissions->canRead()) {
            return $this->renderText(__("You are not allowed to view this page") . "!");
        }
        $this->trigger = $request->getParameter('trigger');
        if ($this->trigger) {
            $this->showEdit = true;
        }
        $this->date = $request->getParameter('date');
		
        $this->employeeId = $request->getParameter('employeeId');
        $this->employeeService = $this->getEmployeeService();
        $values = array('date' => $this->date, 'employeeId' => $this->employeeId, 'trigger' => $this->trigger);
        $this->form = new AttendanceRecordSearchForm(array(), $values);
        $this->actionRecorder = "viewEmployee";

        $isPaging = $request->getParameter('pageNo');
        $pageNumber = $isPaging;
        $noOfRecords = $noOfRecords = sfConfig::get('app_items_per_page');
        $offset = ($pageNumber >= 1) ? (($pageNumber - 1) * $noOfRecords) : ($request->getParameter('pageNo', 1) - 1) * $noOfRecords;

        $records = array();

        if ($this->attendancePermissions->canRead()) {
            $this->_setListComponent($records, $noOfRecords, $pageNumber, null, $this->showEdit);
        }

        if(!$this->trigger) {
            if ($request->isMethod('post')) 
			{ 
				include_once('/var/www/orangehrm/classes/db.php'); 
				$userObj = new Database();
				
				/* If employee name is sent empty and employee id is sent then we have to get Employee Name  */
				/*  As we are customizing Ohrms default coding and it is working eith Employee name not employee id  */
				if(!empty($_POST["attendance"]["employeeId"]) && $_POST["attendance"]["employeeName"]["empName"]=="" || trim($_POST["attendance"]["employeeName"]["empName"])=="Type for hints...")
				{  
					//echo'sdsds';exit;
				   $where = "employee_id=".$_POST["attendance"]["employeeId"]; 
				   $userData=$userObj->getTableData('hs_hr_employee','',$where,'emp_number, emp_firstname, emp_middle_name, emp_lastname',1,'');
				   
				   $f_name = $userData[0]['emp_firstname']." ";
				   $mid_name = $userData[0]['emp_middle_name']!=""?$userData[0]['emp_middle_name']." ":"";
				   $l_name = $userData[0]['emp_lastname'];
				   $full_name = $f_name.$mid_name.$l_name;
				   
				   /***  Customize POSTED array as to include employee name and empNumber  ***/
				  $_POST["attendance"]["employeeName"]["empName"] = $full_name;
				  $_POST["attendance"]["employeeName"]["empId"] = $userData[0]['emp_number'];			
				}
				
				//$_POST['empid'] = $_POST["attendance"]["employeeId"];
				/* We unset POSTED employeeId as it is not accepted in default implementation of Orange HRM */
				unset($_POST["attendance"]["employeeId"]);  // new code
				 
				 /* Re- Arrange  form=>systemUser with new values*/
				$request->setParameter('attendance', $_POST["attendance"]);  // new code
						//print_r($request->getParameter('attendance'));exit;
					//echo '<pre>'; print_r($_POST);exit;

	            $this->form->bind($request->getParameter('attendance'));
 	
				/*if($_POST['downExtHr']==1):
		    		die('123');
		    	endif;*/
    	
                if ($this->form->isValid()){ 
                    $this->allowedToDelete = array();
                    $this->allowedActions = array();

                    $this->allowedActions['Delete'] = false;
                    $this->allowedActions['Edit'] = false;
                    $this->allowedActions['PunchIn'] = false;
                    $this->allowedActions['PunchOut'] = false;

                    $post = $this->form->getValues();

                    if (!$this->employeeId) {
                        $empData = $post['employeeName'];
                        $this->employeeId = $empData['empId'];
                    }

                    if (!$this->date) {
                        $this->date = $post['date'];
                    }

					if(isset($_POST['attType'])){
						if($_POST['attType']=='DempAtt'){
							 $this->city = $post['city'];
						}
					}
				
                    if ($this->employeeId) {
                        $this->showEdit = true;
                    }

                    $isPaging = $request->getParameter('hdnAction') == 'search' ? 1 : $request->getParameter('pageNo', 1);
                    $pageNumber = $isPaging;
                    $noOfRecords = sfConfig::get('app_items_per_page');
                    $offset = ($pageNumber >= 1) ? (($pageNumber - 1) * $noOfRecords) : ($request->getParameter('pageNo', 1) - 1) * $noOfRecords;

                    $empRecords = array();
                    if (!$this->employeeId) {
					//                        $empRecords = $this->employeeService->getEmployeeList('firstName', 'ASC', false);
                        $empRecords = UserRoleManagerFactory::getUserRoleManager()->getAccessibleEntities('Employee'); 
						//getAccessibleEmployees   //getEmployeeList
                        $count = count($empRecords);
                    }
                    else{
                        $empRecords = $this->employeeService->getEmployee($this->employeeId);
                        $empRecords = array($empRecords);
                        $count = 1;
                    }

                    $records = array();
				 
					foreach ($empRecords as $employee){
						$hasRecords = false;
						if($_POST['attType']=='DempAtt'){
						   	include_once('/var/www/orangehrm/classes/db.php'); 
							$userObj = new Database();
							include_once('/var/www/orangehrm/classes/XLClasses/PHPExcel.php');
							$start = 0;
							// Create new PHPExcel object
							$objPHPExcel = new PHPExcel();
							// Create a first sheet, representing sales data
							$objPHPExcel->setActiveSheetIndex(0);
							//
							$from = $post['date'] . " " . "00:" . "00:" . "00";
	       					$end = $post['date2'] . " " . "23:" . "59:" . "59";
							
							$currentDate=date('Y-m-d');
							
							$date_1 = strtotime($post['date']);
							$date_2 = strtotime($post['date2']);
							$total_report_days = ($date_2-$date_1)/(60*60*24);
							$total_report_days = $total_report_days + 1; 

							$datediff = strtotime($end)  - strtotime($from);
							$totalDays= floor($datediff/(60*60*24));
						      
							// Adjusting headers start
							$objPHPExcel->getActiveSheet()->setCellValue('A1', 'S.#')
									  ->setCellValue('B1', "Name")
									  ->setCellValue('C1', "DOJ")
									  ->setCellValue('D1',"E.Code/ID")
									  ->setCellValue('E1',"Center")
									  ->setCellValue('F1',"Designation");
								   
							
							$alpha='F';
							$nextDay=$post['date'];
							
							$nextDay2=strtotime($nextDay);
							$nextDay2=date("D-d-M Y", $nextDay2);
							
							$arrayStore=array();
							for($ij=0; $ij<=$totalDays;$ij++)
							{
								$alpha++;
								$objPHPExcel->getActiveSheet()->setCellValue($alpha."1", $nextDay2);
								$arrayStore[$ij][0]=$alpha;
								$arrayStore[$ij][1]=$nextDay;
								$date = strtotime("+1 day", strtotime($nextDay));
						    	$nextDay=date("Y-m-d", $date); 
								$nextDay2=strtotime($nextDay);
								$nextDay2=date("D-d-M Y", $nextDay2);
							}
							 
							 
							$bravo= $alpha;
							$bravo++; 

							$IsOne=$bravo++;
							$IsTwo=$bravo++;
							$IsThree=$bravo++; 
							$IsFive=$bravo++;
							$IsSix=$bravo++;
							$IsSeven=$bravo++;
							$IsEight=$bravo++;
							$IsNine=$bravo++;
							$IsTen=$bravo++;
							$IsElev=$bravo++;	  
							$IsTwel=$bravo++;	  
							$IsThir=$bravo++;	  

						    $objPHPExcel->getActiveSheet()->setCellValue($IsOne.'1',"Total Present")
									  ->setCellValue($IsTwo.'1',"Total Absents")
									  ->setCellValue($IsThree.'1',"Total Late Arrivals") 
									  ->setCellValue($IsFive.'1',"Total Paid Leaves")
									  ->setCellValue($IsSix.'1',"Total Un Paid Leaves")
									  ->setCellValue($IsSeven.'1',"Total Half Days")
									  ->setCellValue($IsEight.'1',"Total Off Days")
									  ->setCellValue($IsNine.'1',"Total Days")
									  ->setCellValue($IsTen.'1',"Total Report Days")
									  ->setCellValue($IsElev.'1',"Approved Extra Hours")
									  ->setCellValue($IsTwel.'1',"Total Hours On Premises")
									  ->setCellValue($IsThir.'1',"Total Hours At Home");
							// Adjusting headers end

						  	// $finalCol=$IsEight."1";	
						    $finalCol=$IsThir."1";	 
							$objPHPExcel->getActiveSheet()->getStyle('A1:'.$finalCol)->getFill()->applyFromArray(
							array(
									'type' => PHPExcel_Style_Fill::FILL_SOLID,
									'color' => array('rgb' => '580623')
								)
							);
							$styleArray = array(
									'font'  => array(
									'bold'  => true,
									'color' => array('rgb' => 'FFFFFF'),
									'size'  => 13,
							));
							$i=1;
							$r=$i+1;
							$objPHPExcel->getActiveSheet()->getStyle('A1:'.$finalCol)->applyFromArray($styleArray);		
							$objPHPExcel->getActiveSheet()->getStyle('A1:'.$finalCol)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

						
							 ////////////////////////////////
							 /* Rafaqat - Report is gotten by non-admin user he can see  only his suboridinates records.  */
							$subordinates_and = "";
							if($_SESSION['isAdmin'] == "No"){
								$emp_ids = "0"; // jsut initialization to save from DB error
								$subordinates = $userObj->getTableData("hs_hr_emp_reportto","","erep_sup_emp_number = '".$_SESSION['empNumber']."'","erep_sub_emp_number","","");
								if(count($subordinates)){
								   $sub_employees = array();
								   foreach($subordinates as $item){
									  $sub_employees[] = $item['erep_sub_emp_number'];
								   }
								   $emp_ids = implode(",",$sub_employees);
								}
								$subordinates_and =  " AND emp_number IN (".$emp_ids.")"; 
							}
							/* Sub Ordinate handling ends here */
						  
							if($_POST['city']!='all'){
								//$numberOfEmp = $userObj->getTableData("hs_hr_employee","emp_firstname ASC","custom34='".$_POST['city']."' AND custom30='Active' ".$subordinates_and."","emp_number,emp_firstname,emp_lastname,emp_middle_name,custom4,employee_id,custom77,custom34,custom31","","");
								
								//$numberOfEmp = $userObj->getTableData("hs_hr_employee","emp_firstname ASC","custom34='".$_POST['city']."' AND custom30 != 'Active' ".$subordinates_and."","emp_number,emp_firstname,emp_lastname,emp_middle_name,custom4,employee_id,custom77,custom34,custom31","","");
								
								
								/**** We have to Pick non-active (Resigned, Terminated)
								 employees too which have at least one attendace records between two give dates)  ****/			
						 		 $query = "SELECT 
								emp.emp_number, emp.emp_firstname, 
								emp.emp_lastname, emp.emp_middle_name,
								emp.custom4,emp.employee_id,emp.custom77,
								emp.custom34,emp.custom31, emp.custom30, emp.custom40
								    FROM 
								hs_hr_employee as emp, ohrm_attendance_record as att
									WHERE 
								emp.emp_number = att.employee_id AND
								emp.custom34='".$_POST['city']."' AND emp.custom30='Active' 
								".$subordinates_and."
									OR
									(emp.custom34='".$_POST['city']."' AND emp.custom30 != 'Active' AND att.employee_id=emp.emp_number AND 
									  att.punch_in_user_time  BETWEEN '".$from."' AND '".$end."'
									  
									  ".$subordinates_and."
									)
									GROUP BY emp.emp_number
									ORDER BY emp.emp_firstname ASC
								"; 
							
								$numberOfEmp = $userObj->execQuery($query);	
								
							}
							else
							{
								//$numberOfEmp = $userObj->getTableData("hs_hr_employee","emp_firstname ASC","custom30='Active' ".$subordinates_and."","emp_number,emp_firstname,emp_lastname,emp_middle_name,custom4,employee_id,custom77,custom34,custom31","","");
								//$numberOfEmp = $userObj->getTableData("hs_hr_employee","emp_firstname ASC","1 AND custom30 != 'Active' ".$subordinates_and."","emp_number,emp_firstname,emp_lastname,emp_middle_name,custom4,employee_id,custom77,custom34,custom31","","");
							
								/**** We have to Pick non-active (Resigned, Terminated)
								 employees too which have at least one attendace records between two give dates)  ****/	
								$query = "SELECT 
								emp.emp_number, emp.emp_firstname, 
								emp.emp_lastname, emp.emp_middle_name,
								emp.custom4,emp.employee_id,emp.custom77,
								emp.custom34,emp.custom31, emp.custom30, emp.custom40
								    FROM 
								hs_hr_employee as emp, ohrm_attendance_record as att
								WHERE 
								  emp.emp_number = att.employee_id AND
								  emp.custom30='Active'  ".$subordinates_and."
									OR
									(emp.custom30 != 'Active' AND att.employee_id=emp.emp_number AND 
									  att.punch_in_user_time  BETWEEN '".$from."' AND '".$end."'
									  
									  ".$subordinates_and."
									) 
									GROUP BY emp.emp_number 
									ORDER BY emp.emp_firstname ASC
								";
								$numberOfEmp = $userObj->execQuery($query);	
							}
			
							$aBefore=$IsThir;
			
							$weekDays=array();	
							foreach ($numberOfEmp as $numOfEmp){
						
								$workShift = $userObj->getTableData("ohrm_employee_work_shift","","emp_number=".$numOfEmp['emp_number'],"work_shift_id","","1");		
								if(count($workShift)){
									$workShiftTime = $userObj->getTableData("ohrm_work_shift","","id=".$workShift[0]['work_shift_id'],"HOUR(start_time) as start_hour, start_time,hours_per_day,start_day,end_day","","1"); 
									 
									if($workShiftTime[0]["start_day"] == "Monday" && $workShiftTime[0]["end_day"] == "Saturday"){
										 
										 $weekDays = array('Sun'); 
									} 
									else if($workShiftTime[0]["start_day"] == "Tuesday" && $workShiftTime[0]["end_day"] == "Saturday"){
										$weekDays = array('Sun','Mon'); 
									} 
									else{
										$weekDays = array('Sat','Sun');
									}
								}
								 //echo '<pre>';print_r($weekDays);exit;
								 
								$name= trim($numOfEmp['emp_firstname']." ".$numOfEmp['emp_middle_name']." ".$numOfEmp['emp_lastname']);
								$status = $numOfEmp['custom30']!='Active'? " (".$numOfEmp['custom30'].")":'Active';
								
									//$status = " (".$status.")";
								 
								$doj2=strtotime($numOfEmp['custom4']);
								$doj2=date("D-d-M Y", $doj2);
								 
								 
							    $objPHPExcel->getActiveSheet()->setCellValue('A'.$r, $i)
											->setCellValue('B'.$r, $name)
											->setCellValue('C'.$r, $doj2)
											->setCellValue('D'.$r, $numOfEmp['employee_id'])
											->setCellValue('E'.$r, $numOfEmp['custom34'])
											->setCellValue('F'.$r, $numOfEmp['custom31']);

								$totalAbsents=0;
								$totalLeaves=0;
								$totalOffDays=0;
								$totalPresents=0;
								$totalLateArrivals=0;
								$totalPaidLeaves=0;
								$totalUnPaidLeaves=0;
								$totalHalfDays=0;
								$totalWorkingHours=0;
								$tPresent=array();
								$dateDone=array();
								$tHDAYS=array();
								$totalHours=0;
								$totalDaysExcel=0;
								$totalMin=0;
								$total_time =0;
								$alpha='F';
								$AttendanceRecord = $userObj->getTableData("ohrm_attendance_record","","(punch_in_user_time  BETWEEN '".$from."' AND '".$end."') AND employee_id='".$numOfEmp['emp_number']."'","employee_id,punch_in_user_time,punch_out_user_time","",""); 
						 
								if(count($workShift)){
									/* Extra Time Management*/
									$workShiftTime = $userObj->getTableData("ohrm_work_shift","","id=".$workShift[0]['work_shift_id'],"HOUR(start_time) as start_hour, start_time,hours_per_day","","1");  							
									/* Call adjustExtraHours() function   
									if(count($workShiftTime)>0){ 
										$compensation_values = $this->adjustExtraHours($numOfEmp['emp_number'],$AttendanceRecord,$workShiftTime[0]['start_time'],$workShiftTime[0]['hours_per_day'],$post["date"],$post["date2"]);	
									} */
								}
							
								$atInc=0;	
								$attendanceDates = array() ; // array to contain days where user marked Attendance
								//Section 1: Check Attendence  for each employee
								foreach ($AttendanceRecord as $atend){ 	
									$atInc++;
									$punchIn=$atend['punch_in_user_time'];
									$punchOut=$atend['punch_out_user_time'];
									$punchInExp=explode(" ",$punchIn);
											 
									if($punchIn==NULL || $punchOut==NULL){
										$total_time = 'Incomplete'; 
									}
									else
									{
										$start_date = new DateTime($punchIn);
										$toDate=new DateTime($punchOut);
										$since_start = $start_date->diff($toDate);
										$days= $since_start->d;
										$hours= $since_start->h; 
										$minutes= $since_start->i;
										$totalHours+=$hours;
										$totalMin+=$minutes;
										$totalDaysExcel+=$days;

							 			if(count($workShift)>0){ 
											$workShiftTime = $userObj->getTableData("ohrm_work_shift","","id=".$workShift[0]['work_shift_id'],"HOUR(start_time) as start_hour, start_time,hours_per_day","","1");  			 
											$workShiftTime2 = $userObj->getTableData("ohrm_attendance_record","","employee_id='".$numOfEmp['emp_number']."' and punch_in_user_time='".$punchIn."'","shift_start_time","","");			
											if(count($workShiftTime)>0){

												$wsT = $workShiftTime2[0]['shift_start_time'];
												$wsT2 = $workShiftTime2[0]['shift_start_time'];
												$wsT = date('H:i:s', strtotime($wsT.' + 15 minutes') );
												//echo $punchInExp[1];
												if($punchInExp[1]>$wsT){ 

													$sign='LA';

													if(isset($compensation_values["late_arrival"][$punchInExp[0]])){
														$sign=$compensation_values["late_arrival"][$punchInExp[0]];
														$totalPresents++;
														$tPresent[]=$punchInExp[0];
													}
															
													$totalLateArrivals++;
												}
												else{
													$sign="P";
												}
											}
											else{
												 $sign="P";
											}
										}
									 	else{
											$sign="P";
										}

										if($days==0){  	
											/* Logic change for half day  */
										    /* If a person spends less than 72% of time then it is half day. */
											if($wsT2=='00:00:00'){
												$sign="P";
											}
											
											$value = ((($hours+$minutes/60)/$workShiftTime[0]['hours_per_day'])*100);
											
											if($value < 67 && $value > 17)
											{   
												$value = ((($hours+$minutes/60)/$workShiftTime[0]['hours_per_day'])*100);
												if($sign=='LA') 
												{
													$totalLateArrivals--;
												}
												if($value!=0 && $value<=67)
												{  
													if($leave['leave_type_id']==4):
														$sign='UHD';
													else:
														$sign='HD';
													endif;

													if(isset($compensation_values["half_days"][$punchInExp[0]]))
													{
														$sign = $compensation_values["half_days"][$punchInExp[0]];
													}
												}
												 
												
												if(!in_array($punchInExp[0],$tHDAYS))
												{
													$tHDAYS[]=$punchInExp[0];
													$totalHalfDays++; 
												} 	
											} /* If user remains in office less 17% time than will marked as Absent */
											else if($value < 17){   
													$sign='A';
													$totalAbsents++;	
											}
											
											if($sign=='LA'):
												$chTShiftLA = date('H:i:s', strtotime($punchInExp[1].' + 0 minutes') );
												//$chTShiftLA=$workShiftTime[0]['hours_per_day'] - 15/60;
												if($chTShiftLA>=$workShiftTime[0]['start_hour']):
													$sign="LA";
													$totalLateArrivals++;
												endif;
											endif;
											$total_time= $sign." ( ".$hours." hour(s) and ".$minutes." minute(s) )";
											/*** Mark that person marked attendance on this  day ***/ 
											$attendanceDates[$punchInExp[0]] = $total_time ;
										}
										else{   
											if($sign=='LA'):
												$chTShiftLA = date('H:i:s', strtotime($punchInExp[1].' + 0 minutes') );
												//$chTShiftLA=$workShiftTime[0]['hours_per_day'] - 15/60;
												if($chTShiftLA>=$workShiftTime[0]['start_hour'] || $days!=0):
													$sign="LA";
													$totalLateArrivals++;
												endif;
												/*$chTShiftLA=$workShiftTime[0]['hours_per_day'] - 15/60;
												if($chTShiftLA<=$hours || $days!=0):
													$sign="P";
												endif;*/
											endif;
											$total_time=$sign." ( ".$days." day(s) ,". $hours." hour(s) and ".$minutes." minute(s) )";
									 		/*** Mark that person marked attendance on this  day ***/
											$attendanceDates[$punchInExp[0]] = $total_time ;
										} 
									
										if(!in_array($punchInExp[0],$tPresent) && $sign=='P'){
											 $totalPresents++;
											 $tPresent[]=$punchInExp[0];
										}
								  	}  
									 			
								  	$dateDone[]=$punchInExp[0];
								  	$countSArr=count($arrayStore); 
								  	for($ij=0; $ij<$countSArr; $ij++){   
										if($arrayStore[$ij][1]==$punchInExp[0]){ 
											$chGaHoli=explode("-",$punchInExp[0]); 
									 		/* Night Shift Public Holidays */
											if(isset($workShiftTime[0]['start_hour']) && $workShiftTime[0]['start_hour']  > 17 )  // 17 means 5:00 PM
											{     
												if($chGaHoli[1]=='9' && $chGaHoli[2]=='5'){
													$total_time="OFF  :: labour day";
													$totalOffDays+=1;
												}
												else if($chGaHoli[1]=='11' && $chGaHoli[2]=='24'){
													 $total_time="OFF  :: Thanksgiving Day";
													 $totalOffDays+=1;
												}
												else if($chGaHoli[1]=='5' && $chGaHoli[2]=='30'){ 
													$total_time="OFF  :: Memorial Day";
													$totalOffDays+=1;
												}
												else if($chGaHoli[1]=='12' && $chGaHoli[2]=='25'){ 
													$total_time="OFF  :: Christmas Day";
													$totalOffDays+=1; 
												}
												else if($chGaHoli[1]=='7' && $chGaHoli[2]=='4'){
													$total_time="OFF  :: Independence Day";
													$totalOffDays+=1; 
													  
												}
												else if($chGaHoli[1]=='3' && $chGaHoli[2]=='25'){
													$total_time="OFF  :: Good Friday";
													$totalOffDays+=1; 
												}
												else if($chGaHoli[1]=='1' && $chGaHoli[2]=='1'){
													$total_time="OFF  :: New Year's Day";
													$totalOffDays+=1; 	  
												}
												/*** New added - 11-03-2015 ***/
												else if($chGaHoli[1]=='2' && $chGaHoli[2]=='15'){
													$total_time="OFF  :: Washington's Birthday";
													$totalOffDays+=1;
												}
										 	}
											else{    // Day shift Public Holidays
												if($chGaHoli[1]=='5' && $chGaHoli[2]=='1'){
													$total_time="OFF  :: labour day";
													$totalOffDays+=1;
												}
												else if($chGaHoli[1]=='2' && $chGaHoli[2]=='5'){
													$total_time="OFF  :: Kashmir Day";
													$totalOffDays+=1; 
												}
												else if($chGaHoli[1]=='1' && $chGaHoli[2]=='1'){
													$total_time="OFF  :: New Year's Day";
													$totalOffDays+=1; 
												}
												else if($chGaHoli[1]=='8' && $chGaHoli[2]=='14'){
													$total_time="OFF  :: Independence day";
													$totalOffDays+=1;
												}
												else if($chGaHoli[1]=='12' && $chGaHoli[2]=='25'){
													$total_time="OFF  :: Quaid-e-Azam";
													$totalOffDays+=1; 
												}
												else if($chGaHoli[1]=='10' && $chGaHoli[2]=='11'){
													$total_time="OFF  :: Ashura Day 1";
													$totalOffDays+=1; 
												}
												else if($chGaHoli[1]=='10' && $chGaHoli[2]=='12'){
													$total_time="OFF  :: Ashura Day 2";
													$totalOffDays+=1; 
												}
												/*** New added -11-03-2015 ***/
												else if($chGaHoli[1]=='3' && $chGaHoli[2]=='23'){
													$total_time="OFF  :: Pakistan Day";
													$totalOffDays+=1; 
												}
											}

											if (!preg_match('/minute/',$total_time)  && in_array($arrayStore[$ij][1],$tPresent)){    
												$totalPresents-=1;   
											}	


											if (!preg_match('/HD/',$total_time) && in_array($arrayStore[$ij][1],$tHDAYS)){ 
												$totalHalfDays-=1; 
											}

															
								          	/*** If employee is not active (resigned/termionated)
										  	Then we have to mark him/her 
										  	(terminated/resigned on those dates after he
										  	has gone) ***/	
										   	if($status !="Active"){
										   		if(strtotime($arrayStore[$ij][1]) > strtotime($numOfEmp['custom40']) ){
													$total_time = $status;
												}
										   }
																 
											$objPHPExcel->getActiveSheet()->setCellValue($arrayStore[$ij][0].$r, $total_time);			
										} 
									} 
					 			}  
					 			// Section 1: ATTENDENCE RECORD END
								
								/*if($numOfEmp['emp_number']==135):		  
									echo $totalPresents;
									die();
								endif;*/


								$LeaveRecord = $userObj->getTableData("ohrm_leave","","emp_number='".$numOfEmp['emp_number']."' AND (status=2 OR status=3) AND `date` BETWEEN '".$from."' AND '".$end."'","length_days,status,date,leave_type_id,emp_number","",""); 
					 
								//$total_time=0;  //Set to initial
								//Section 2 foreach leaves  start 
								
								/* if($numOfEmp['emp_number']==100):
									echo "<pre>";
									print_r($LeaveRecord);
								endif; */

								foreach ($LeaveRecord as $leave){
									$fromL = $leave['date'] . " " . "00:" . "00:" . "00";
	       							$endL = $leave['date'] . " " . "23:" . "59:" . "59";
									$AttendanceRecord = $userObj->getTableData("ohrm_attendance_record","","(punch_in_user_time  BETWEEN '{$fromL}' AND '{$endL}') AND employee_id='{$numOfEmp['emp_number']}'","employee_id,punch_in_user_time,punch_out_user_time","",""); 
									if( $leave['status']==4 || $leave['status']==5 || $leave['date']>$currentDate ):
										continue;
									endif;
									//$AttendanceRecord>0 || $leave['date']>$currentDate ||
									
									$time1 = new DateTime($AttendanceRecord[0]['punch_in_user_time']);
									$time2 = new DateTime($AttendanceRecord[0]['punch_out_user_time']);
									
									$interval = $time1->diff($time2);
									$hd = $interval->format('%d');
									$hd2 = $interval->format('%h');
									$hd3 = $interval->format('%i');
									 if($hd==0)
                                    {
                                        //$total_time2 = " ( ".$hd2." hour(s) and ".$hd3." minute(s) )";
          								$total_time = " ( ".$hd2." hour(s) and ".$hd3." minute(s) )"; // BILAL
                                    }
                                    else
                                    {
                                        //$total_time2 = " ( ".$hd." day(s) ,". $hd2." hour(s) and ".$hd3." minute(s) )";
          								$total_time = " ( ".$hd." day(s) ,". $hd2." hour(s) and ".$hd3." minute(s) )"; // BILAL
                                    }


									if($leave['length_days']==0){

										if($leave['status']==2 || $leave['status']==3){ 
											if(preg_match('/LA/',$total_time)){ 
												$totalLateArrivals--;
											}  

											if($leave['leave_type_id']==4):
												$total_time='L'; 
												$totalUnPaidLeaves++;
											else:
												$total_time='PL'; 
												$totalPaidLeaves++; 
											endif;
										}
										else if($leave['date']<=$currentDate){
											if(preg_match('/LA/',$total_time)){ 
												$totalLateArrivals--;
											}
											$total_time='A';
											if(isset($compensation_values['absents'][$leave['date']])){
												$total_time = $compensation_values['absents'][$leave['date']];										
											}
											
											//$totalAbsents++; 
											if($leave['status']!=3 || $leave['status']!=2){  // to be discussed
												$totalAbsents++; 
											}
										 }
										else{
											$total_time='';
										} 
									}
									else if($leave['length_days']==1){
										// If user applied for leave and not approved and he marked
										// attendace then attendance status (Late, Half Day etc) will be considered  
										//  && !isset($attendanceDates[$leave['date']])
										
										/*if($numOfEmp['emp_number']==100):
											echo "1<pre>";
											print_r($total_time2);
										endif;*/
										if($leave['status']!=3 && $leave['status']!=2){  // to be discussed
											$totalAbsents++; 
											$total_time='A';
										}
										elseif(($leave['status']==3 || $leave['status']==2)){
											if($leave['leave_type_id']==4):
												$total_time='L';
												$totalUnPaidLeaves++;
											else:	
												$total_time='PL';
												$totalPaidLeaves++;
											endif; 
										}
										elseif(($leave['status']!=3 || $leave['status']!=2) && $attendanceDates[$leave['date']]){
										}		
									}
									else{
										/* if($numOfEmp['emp_number']==100):
											echo "<pre>";
											print_r($LeaveRecord);
										endif; */

										if(($leave['status']==2 || $leave['status']==3) && preg_match('/minute/',$total_time)){ 
											if(preg_match('/LA/',$total_time)){
												$total_time=str_replace('LA', '', $total_time);
												$totalLateArrivals--;
											}
											else if(preg_match('/HD/',$total_time)){
												$total_time=str_replace('HD', '', $total_time);
											 
											}
											
											/*$AttendanceRecord5 = $userObj->getTableData("ohrm_attendance_record","","Date(punch_in_user_time)='{$leave['date']}'  AND employee_id='{$numOfEmp['emp_number']}'","employee_id,punch_in_user_time,punch_out_user_time","","");
											
											
											$time1 = new DateTime($AttendanceRecord5[0]['punch_in_user_time']);
											$time2 = new DateTime($AttendanceRecord5[0]['punch_out_user_time']);
											
											$interval = $time1->diff($time2);
											$hd = $interval->format('%d');
											$hd2 = $interval->format('%h');
											$hd3 = $interval->format('%i');
											if($hd==0)
											{
												$total_time2 = " ( ".$hd2." hour(s) and ".$hd3." minute(s) )";
											}
											else 
											{
												$total_time2 = " ( ".$hd." day(s) ,". $hd2." hour(s) and ".$hd3." minute(s) )";
											}*/
											$total_time=str_replace('P', '', $total_time); 
											if($leave['leave_type_id']==4):
												$total_time='UHD '.$total_time;
											else:
												$total_time='HD '.$total_time;
											endif;

										

											$tHDAYS[]=$leave['date'];
											$totalHalfDays++; 
										}
										elseif($leave['date']<=$currentDate){  
											 $total_time='A';
											if(isset($compensation_values['absents'][$leave['date']])){
												$total_time = $compensation_values['absents'][$leave['date']];										
											}
										   	//$totalAbsents++; 
											if($leave['status']!=3 || $leave['status']!=2){  // to be discussed
												$totalAbsents++; 
											}
										} 
									  	else{
											$total_time='';
										}
									}

									
								  	$dateDone[]=$leave['date']; 
							 	  	$countSArr=count($arrayStore); 
								  	for($ij=0; $ij<$countSArr;$ij++){   
								 
										if($arrayStore[$ij][1]==$leave['date'] && $arrayStore[$ij][1]<=$currentDate){  
										
											$chGaHoli=explode("-",$leave['date']);  
											if(isset($workShiftTime[0]['start_hour']) && $workShiftTime[0]['start_hour']  < 17 )  // 17 means 5:00 PM
											{ 
												if($chGaHoli[1]=='5' && $chGaHoli[2]=='1'){
												$total_time="OFF  :: labour day";
												$totalOffDays+=1;
												}
												else if($chGaHoli[1]=='2' && $chGaHoli[2]=='5'){
													$total_time="OFF  :: Kashmir Day";
													$totalOffDays+=1; 
												}
												else if($chGaHoli[1]=='1' && $chGaHoli[2]=='1'){
													$total_time="OFF  :: New Year's Day";
													$totalOffDays+=1; 
												}
												else if($chGaHoli[1]=='8' && $chGaHoli[2]=='14'){
													$total_time="OFF  :: Independence day";
													$totalOffDays+=1;
												}
												else if($chGaHoli[1]=='12' && $chGaHoli[2]=='25'){
													$total_time="OFF  :: Quaid-e-Azam";
													$totalOffDays+=1; 
												}
												else if($chGaHoli[1]=='10' && $chGaHoli[2]=='11'){
													$total_time="OFF  :: Ashura Day 1";
													$totalOffDays+=1; 
												}
												else if($chGaHoli[1]=='10' && $chGaHoli[2]=='12'){
													$total_time="OFF  :: Ashura Day 2";
													$totalOffDays+=1; 
												}
												/*** New added -11-03-2015 ***/
												else if($chGaHoli[1]=='03' && $chGaHoli[2]=='23'){
													$total_time="OFF  :: Pakistan Day";
													$totalOffDays+=1; 
												}
											}
											else if (isset($workShiftTime[0]['start_hour']) && $workShiftTime[0]['start_hour']  > 17){
												if($chGaHoli[1]=='9' && $chGaHoli[2]=='5'){
												$total_time="OFF  :: labour day";
												$totalOffDays+=1;
												}
												else if($chGaHoli[1]=='11' && $chGaHoli[2]=='24'){
													 $total_time="OFF  :: Thanksgiving Day";
													 $totalOffDays+=1;
												}
												else if($chGaHoli[1]=='5' && $chGaHoli[2]=='30'){ 
													$total_time="OFF  :: Memorial Day";
													$totalOffDays+=1;
												}
												else if($chGaHoli[1]=='12' && $chGaHoli[2]=='25'){ 
													$total_time="OFF  :: Christmas Day";
													$totalOffDays+=1; 
												}
												else if($chGaHoli[1]=='7' && $chGaHoli[2]=='4'){
													$total_time="OFF  :: Independence Day";
													$totalOffDays+=1; 
													  
												}
												else if($chGaHoli[1]=='3' && $chGaHoli[2]=='25'){
													$total_time="OFF  :: Good Friday";
													$totalOffDays+=1; 
												}
												else if($chGaHoli[1]=='1' && $chGaHoli[2]=='1'){
													$total_time="OFF  :: New Year's Day";
													$totalOffDays+=1; 	  
												}
												/*** New added - 11-03-2015 ***/
												else if($chGaHoli[1]=='2' && $chGaHoli[2]=='15'){
													$total_time="OFF  :: Washington's Birthday";
													$totalOffDays+=1;
												}	
												}
											 
											if (!preg_match('/minute/',$total_time)  && in_array($arrayStore[$ij][1],$tPresent)){    
												 $totalPresents-=1;  
											}	 
										
										 	if (!preg_match('/HD/',$total_time)  && in_array($arrayStore[$ij][1],$tHDAYS)){ 
												 $totalHalfDays-=1;  
											}
											
										 	//if(!in_array($arrayStore[$ij][1],$dateDone) ){
												//If employee is not active (resigned/termionated)
												//Then we have to mark him/her 
												//(terminated/resigned on those dates after he
												//has gone) 
											 
												if($status !="Active"){
													if(strtotime($arrayStore[$ij][1]) > strtotime($numOfEmp['custom40']) ){
														$total_time = $status;
													}
												}
												
												/*if($numOfEmp['emp_number']==100 && $leave['date']=='2015-11-11'):
													echo $total_time.'<br/>';
													die();
												endif; */

												$objPHPExcel->getActiveSheet()->setCellValue($arrayStore[$ij][0].$r, $total_time);
										 	//}
										} 				   
									} 								   
								}   
								//  Section 2: end
							/*	if($numOfEmp['emp_number']==100):
									die('hmmm');
								endif;*/
								$workShiftTime = $userObj->getTableData("ohrm_work_shift","","id='".$workShift[0]['work_shift_id']."'","HOUR(start_time) as start_hour, start_time,hours_per_day","","1");  							
								$qry11 = "SELECT * FROM ohrm_adhoc_holidays WHERE  (shift_id = '".$workShift[0]['work_shift_id']."' OR FIND_IN_SET(".$numOfEmp['emp_number'].",employee_nos)) ";
								$adhoc_holidays = $userObj->getResumes($qry11);
								 
								$countSArr=count($arrayStore); 
								$isHoliday = "";

								/// Section 3: Fill all the remaining days		
							  	for($ij=0; $ij<$countSArr;$ij++){   
							  		if(!in_array($arrayStore[$ij][1],$dateDone)){  
								  		if($arrayStore[$ij][1]<=$currentDate){
								  			$chGaHoli=explode("-",$arrayStore[$ij][1]); 
											$timestamp = strtotime($arrayStore[$ij][1]);
								  				$IsWeek= date("D", $timestamp);

								  				if (in_array($IsWeek, $weekDays)){ 
								  					$total_time='OFF :'.$IsWeek;
								  					$totalOffDays+=1; 
								  					$isHoliday = "yes";
								  				}
								  				else if($arrayStore[$ij][1]<=$currentDate){      
								  					$total_time='A';
								  					if(isset($compensation_values['absents'][$arrayStore[$ij][1]]))
								  					{
								  						$total_time = $compensation_values['absents'][$arrayStore[$ij][1]];										
								  					}
															//if($numOfEmp['emp_number']==441) {echo "Four"; }
								  					$totalAbsents+=1;   
								  				}
								  				else{
								  					$total_time=''; 
								  				}
											//echo $workShiftTime[0]['start_hour'].'<br>';
											if(isset($workShiftTime[0]['start_hour']) && $workShiftTime[0]['start_hour']  < 17 )  // 17 means 5:00 PM
											{ 
												if($chGaHoli[1]=='5' && $chGaHoli[2]=='1'){
												$total_time="OFF  :: labour day";
												$totalOffDays+=1;
												}
												else if($chGaHoli[1]=='2' && $chGaHoli[2]=='5'){
													$total_time="OFF  :: Kashmir Day";
													$totalOffDays+=1; 
												}
												else if($chGaHoli[1]=='1' && $chGaHoli[2]=='1'){
													$total_time="OFF  :: New Year's Day";
													$totalOffDays+=1; 
												}
												else if($chGaHoli[1]=='8' && $chGaHoli[2]=='14'){
													$total_time="OFF  :: Independence day";
													$totalOffDays+=1;
												}
												else if($chGaHoli[1]=='12' && $chGaHoli[2]=='25'){
													$total_time="OFF  :: Quaid-e-Azam";
													$totalOffDays+=1; 
												}
												else if($chGaHoli[1]=='10' && $chGaHoli[2]=='11'){
													$total_time="OFF  :: Ashura Day 1";
													$totalOffDays+=1; 
												}
												else if($chGaHoli[1]=='10' && $chGaHoli[2]=='12'){
													$total_time="OFF  :: Ashura Day 2";
													$totalOffDays+=1; 
												}
												/*** New added -11-03-2015 ***/
												else if($chGaHoli[1]=='03' && $chGaHoli[2]=='23'){
													$total_time="OFF  :: Pakistan Day";
													$totalOffDays+=1; 
												}
											}
											else if (isset($workShiftTime[0]['start_hour']) && $workShiftTime[0]['start_hour']  > 17){
												if($chGaHoli[1]=='9' && $chGaHoli[2]=='5'){
												$total_time="OFF  :: labour day";
												$totalOffDays+=1;
												}
												else if($chGaHoli[1]=='11' && $chGaHoli[2]=='24'){
													 $total_time="OFF  :: Thanksgiving Day";
													 $totalOffDays+=1;
												}
												else if($chGaHoli[1]=='5' && $chGaHoli[2]=='30'){ 
													$total_time="OFF  :: Memorial Day";
													$totalOffDays+=1;
												}
												else if($chGaHoli[1]=='12' && $chGaHoli[2]=='25'){ 
													$total_time="OFF  :: Christmas Day";
													$totalOffDays+=1; 
												}
												else if($chGaHoli[1]=='7' && $chGaHoli[2]=='4'){
													$total_time="OFF  :: Independence Day";
													$totalOffDays+=1; 
													  
												}
												else if($chGaHoli[1]=='3' && $chGaHoli[2]=='25'){
													$total_time="OFF  :: Good Friday";
													$totalOffDays+=1; 
												}
												else if($chGaHoli[1]=='1' && $chGaHoli[2]=='1'){
													$total_time="OFF  :: New Year's Day";
													$totalOffDays+=1; 	  
												}
												/*** New added - 11-03-2015 ***/
												else if($chGaHoli[1]=='2' && $chGaHoli[2]=='15'){
													$total_time="OFF  :: Washington's Birthday";
													$totalOffDays+=1;
												}	
												}
												//else{	 
								  				
								  			//}

								  			$record_date =  strtotime($chGaHoli[0]."-".$chGaHoli[1]."-".$chGaHoli[2]);
								  			if(1)
								  			{  
								  				foreach($adhoc_holidays as $item){   //print_r($adhoc_holidays);
												 	if($record_date >=strtotime($item['from_date']) &&  $record_date<=strtotime($item['to_date'])){
												 		$adhoc_holiday = "Yes";
												 		$total_time="OFF  :Adhoc Holiday";
												 		$totalOffDays+=1;
												 	}
												}
											}

											if (!preg_match('/minute/',$total_time)  && in_array($arrayStore[$ij][1],$tPresent)){    
												$totalPresents-=1;   
											}	

											if (!preg_match('/HD/',$total_time)  && in_array($arrayStore[$ij][1],$tHDAYS)){ 
												$totalHalfDays-=1;    
											}		
		 
											/*** If employee is not active (resigned/termionated)
											Then we have to mark him/her 
											(terminated/resigned on those dates after he
											has gone) ***/	
										   if($status !="Active"){
										   		if(strtotime($arrayStore[$ij][1]) > strtotime($numOfEmp['custom40']) ){
													$total_time = $status;
												}
										   }
								  
								  			$objPHPExcel->getActiveSheet()->setCellValue($arrayStore[$ij][0].$r, $total_time);
										}
									} 
					  			}    
					   			//Section 3: end
								$countSArr=count($arrayStore); 

								//Section 4: Now put records for specific day
								for($ij=0; $ij<$countSArr;$ij++){   
									if($arrayStore[$ij][1]==$punchInExp[0]  && !in_array($arrayStore[$ij][1],$tHDAYS)){ 
										if (!preg_match('/minute/',$total_time) && in_array($arrayStore[$ij][1],$tPresent)){
														//$totalPresents-=1;    // commented 24-10-2014
										}	

										if(preg_match('/OFF/',$total_time)){
											$timestamp = strtotime($arrayStore[$ij][1]);
											$IsWeek= date("D", $timestamp);
											  
											if (!in_array($IsWeek, $weekDays) && $adhoc_holiday!="yes"){ 
													
												if($arrayStore[$ij][1]<=$currentDate){  
													$total_time='A';
													if(isset($compensation_values['absents'][$arrayStore[$ij][1]]))
													{
														$total_time = $compensation_values['absents'][$arrayStore[$ij][1]];										
													}
															//$totalAbsents++;  // NEW ADDED-Commented as it creates bugs
												}
												else{
														 $total_time=''; 
												}	
												//s$totalAbsents+=1;  
											} 
										}

										if(!in_array($arrayStore[$ij][1],$tPresent) && !preg_match('/minute/',$total_time) && !in_array($arrayStore[$ij][1],$dateDone)   ){ 
												/*** If employee is not active (resigned/termionated)
												Then we have to mark him/her 
												(terminated/resigned on those dates after he
												has gone) ***/	
											    if($status !="Active"){
											   		if(strtotime($arrayStore[$ij][1]) > strtotime($numOfEmp['custom40']) )
													{
														$total_time = $status;
													}
											    }

												$objPHPExcel->getActiveSheet()->setCellValue($arrayStore[$ij][0].$r, $total_time);
										}

									} 
								}   
								// Section 4: end
								 
							 	$totalDaysC=$totalDays-($totalOffDays-1);
								 
								$objPHPExcel->getActiveSheet()->setCellValue($IsOne.$r, $totalPresents+$totalHalfDays+$totalLateArrivals);
								$objPHPExcel->getActiveSheet()->setCellValue($IsTwo.$r, $totalAbsents); //$totalAbsents
								$objPHPExcel->getActiveSheet()->setCellValue($IsThree.$r, $totalLateArrivals); 
								// $objPHPExcel->getActiveSheet()->setCellValue($IsFour.$r, $totalLeaves);
								$objPHPExcel->getActiveSheet()->setCellValue($IsFive.$r, $totalPaidLeaves);
								$objPHPExcel->getActiveSheet()->setCellValue($IsSix.$r, $totalUnPaidLeaves);
								$objPHPExcel->getActiveSheet()->setCellValue($IsSeven.$r, $totalHalfDays); 
								$objPHPExcel->getActiveSheet()->setCellValue($IsEight.$r, $totalOffDays);
								$objPHPExcel->getActiveSheet()->setCellValue($IsNine.$r, $totalDaysC);
								$objPHPExcel->getActiveSheet()->setCellValue($IsTen.$r, $total_report_days);

								$extWorkHr = "SELECT SUM(extra_hours) AS EXTHR FROM ohrm_extra_working_hours WHERE  emp_number={$numOfEmp['emp_number']} AND status=1 AND (work_date BETWEEN '".$from."' AND '".$end."')";
								$approvedExtHour = $userObj->getResumes($extWorkHr);
 								if(count($approvedExtHour)>0):
 									$approvedExtHour=($approvedExtHour[0]['EXTHR']=='')?0:$approvedExtHour[0]['EXTHR'];
									$hours = floor($approvedExtHour / 60);
    								$minutes = ($approvedExtHour % 60);
 									$mintoHour=date('H:i', mktime(0,$approvedExtHour)); 
									$mintoHour=explode(':', $mintoHour); 
									$approvedExtHour=$hours.' hours and '.$minutes.' minutes';
 								else:
 									$approvedExtHour=0;
 								endif;
								$objPHPExcel->getActiveSheet()->setCellValue($IsElev.$r, $approvedExtHour);

								$mintoHour=date('H:i', mktime(0,$totalMin)); 
								$mintoHour=explode(':', $mintoHour);
								$totalDaysExcel=$totalDaysExcel*24;
								$twh=$totalHours+$mintoHour[0]+$totalDaysExcel;
								$totalWorkingHours=$twh.' hours and '.$mintoHour[1].' minutes'; 

								$objPHPExcel->getActiveSheet()->setCellValue($IsTwel.$r, $totalWorkingHours);

								$extWorkHr = "SELECT SUM(extra_hours) AS EXTHR FROM ohrm_extra_working_hours WHERE  emp_number={$numOfEmp['emp_number']} AND (work_date BETWEEN '".$from."' AND '".$end."')";
								$totalExtHour = $userObj->getResumes($extWorkHr);
 								if(count($totalExtHour)>0):
 									$totalExtHour=($totalExtHour[0]['EXTHR']=='')?0:$totalExtHour[0]['EXTHR'];
									$hours = floor($totalExtHour / 60);
    								$minutes = ($totalExtHour % 60);
 									$mintoHour=date('H:i', mktime(0,$totalExtHour)); 
									$mintoHour=explode(':', $mintoHour); 
									$totalExtHour=$hours.' hours and '.$minutes.' minutes'; 
 								else:
 									$totalExtHour=0;
 								endif;
								$objPHPExcel->getActiveSheet()->setCellValue($IsThir.$r, $totalExtHour);


								if($i % 2 == 0){						  
									$objPHPExcel->getActiveSheet()->getStyle('A'.$r.':'.$aBefore.$r)->getFill()->applyFromArray(
									array(
											'type' => PHPExcel_Style_Fill::FILL_SOLID,
											'color' => array('rgb' => 'EEEEEE')
										)
									);
									
									$objPHPExcel->getDefaultStyle()->getAlignment()
																	->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
								}
								else{
									$objPHPExcel->getDefaultStyle()->getAlignment()
																	->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
								}
								
								$i++; 
								$r++;			
							}  	 
					
							///////////////////////////////////////////////
											 
							$t = $r+3; 
							$objPHPExcel->getActiveSheet()->setCellValue('C'.$t, 'Total Records:')
														  ->setCellValue('E'.$t, count($numberOfEmp)); 
							$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(10);
							$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(40);
							$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(40);
							$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(40);
							$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(40);
							$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(40);
							
							$alpha='F';
							for($i=0; $i<=$totalDays;$i++)
							{ 
								$alpha++;  
								$objPHPExcel->getActiveSheet()->getColumnDimension($alpha)->setWidth(40); 
							} 
							
							 
							$objPHPExcel->getActiveSheet()->getColumnDimension($IsOne)->setWidth(40);
							$objPHPExcel->getActiveSheet()->getColumnDimension($IsTwo)->setWidth(40);
							$objPHPExcel->getActiveSheet()->getColumnDimension($IsThree)->setWidth(40);
							//$objPHPExcel->getActiveSheet()->getColumnDimension($IsFour)->setWidth(40);
							$objPHPExcel->getActiveSheet()->getColumnDimension($IsFive)->setWidth(40);
							$objPHPExcel->getActiveSheet()->getColumnDimension($IsSix)->setWidth(40);
							$objPHPExcel->getActiveSheet()->getColumnDimension($IsSeven)->setWidth(40);
							$objPHPExcel->getActiveSheet()->getColumnDimension($IsEight)->setWidth(40);
							$objPHPExcel->getActiveSheet()->getColumnDimension($IsNine)->setWidth(40);
							$objPHPExcel->getActiveSheet()->getColumnDimension($IsTen)->setWidth(40);
							$objPHPExcel->getActiveSheet()->getColumnDimension($IsElev)->setWidth(40);
							$objPHPExcel->getActiveSheet()->getColumnDimension($IsTwel)->setWidth(40);
							$objPHPExcel->getActiveSheet()->getColumnDimension($IsThir)->setWidth(40);

							// Add conditional formatting
							$objConditional1 = new PHPExcel_Style_Conditional();
							$objConditional1->setConditionType(PHPExcel_Style_Conditional::CONDITION_CELLIS)
											->setOperatorType(PHPExcel_Style_Conditional::OPERATOR_BETWEEN)
											->addCondition('200')
											->addCondition('400');
							$objConditional1->getStyle()->getFont()->getColor()->setARGB(PHPExcel_Style_Color::COLOR_YELLOW);
							$objConditional1->getStyle()->getFont()->setBold(true);
							$objConditional1->getStyle()->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_CURRENCY_EUR_SIMPLE);
							
							$objConditional2 = new PHPExcel_Style_Conditional();
							$objConditional2->setConditionType(PHPExcel_Style_Conditional::CONDITION_CELLIS)
											->setOperatorType(PHPExcel_Style_Conditional::OPERATOR_LESSTHAN)
											->addCondition('0');
							$objConditional2->getStyle()->getFont()->getColor()->setARGB(PHPExcel_Style_Color::COLOR_RED);
							$objConditional2->getStyle()->getFont()->setItalic(true);
							$objConditional2->getStyle()->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_CURRENCY_EUR_SIMPLE);
							
							$objConditional3 = new PHPExcel_Style_Conditional();
							$objConditional3->setConditionType(PHPExcel_Style_Conditional::CONDITION_CELLIS)
											->setOperatorType(PHPExcel_Style_Conditional::OPERATOR_GREATERTHANOREQUAL)
											->addCondition('0');
							$objConditional3->getStyle()->getFont()->getColor()->setARGB(PHPExcel_Style_Color::COLOR_GREEN);
							$objConditional3->getStyle()->getFont()->setItalic(true);
							$objConditional3->getStyle()->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_CURRENCY_EUR_SIMPLE);
							
							$conditionalStyles = $objPHPExcel->getActiveSheet()->getStyle('B2')->getConditionalStyles();
							array_push($conditionalStyles, $objConditional1);
							array_push($conditionalStyles, $objConditional2);
							array_push($conditionalStyles, $objConditional3);
							
							$objPHPExcel->getDefaultStyle()
								->getAlignment()
								->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
							
						  
							// Set fonts
							$objPHPExcel->getActiveSheet()->getStyle('A1:'.$aBefore."1")->getFont()->setBold(true);
							
							$styleArray1 = array(
								'font'  => array(
									'bold'  => true,
									'color' => array('rgb' => '000000'),
									'size'  => 12,
								));
							
							$objPHPExcel->getActiveSheet()->getStyle('E'.$t.':'.$aBefore.$t)->applyFromArray($styleArray1);	 
							$objPHPExcel->getActiveSheet()->getPageSetup()->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_PORTRAIT);
							$objPHPExcel->getActiveSheet()->getPageSetup()->setPaperSize(PHPExcel_Worksheet_PageSetup::PAPERSIZE_A4);
								
							
							$city=$_POST['city'];
							
						
							
							// Rename worksheet
							//$objPHPExcel->getActiveSheet()->setTitle(date('y-m-d h-i-s').$city.'AttReport');
								
							// Set active sheet index to the first sheet, so Excel opens this as the first sheet
							$objPHPExcel->setActiveSheetIndex(0);
							
								/*			echo $city."hm,mm";*/
							// exit;	
							$dir = '/var/www/orangehrm/reports/';
							$fileName = date('y-m-d h-i-s').$city.'AttReport'.'.xls'; 
							$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
							$objWriter->save($dir.$fileName);
								
							function force_download($file,$dir)
							{
								if ((isset($file)) && (file_exists($dir.$file)))
								{ //if start
									header("Content-type: application/force-download"); 
									header('Content-Disposition: inline; filename="' . $dir.$file . '"'); 
									header("Content-Transfer-Encoding: Binary"); 
									header("Content-length: ".filesize($dir.$file)); 
									header('Content-Type: application/octet-stream'); 
									header('Content-Disposition: attachment; filename="'.$file.'"'); 
									readfile("$dir$file"); 
								}
								else
								{ 
									echo "Sorry! not found on server";
								} 
							}
								
							force_download($fileName,$dir);
							exit; 
								//   from  ,,,  Order by ,,, WHERE ,,, select ,,, 
					    }
					    else{
						    $attendanceRecords = $employee->getAttendanceRecord();
							$searchRecords = true;  // says that this is search query
							include_once('/var/www/orangehrm/classes/db.php'); 
							$userObj = new Database();
					    }
							
							 
					    $total = 0;
					    foreach ($attendanceRecords as $attendance) {
					    	$from = $this->date . " " . "00:" . "00:" . "00";
					    	$end = $this->date2 . " " . "23:" . "59:" . "59";



							  /***  We have to filter Atttendance records of Employee who 
							  belong to given city  ***/
							  if(isset($searchRecords)  && $searchRecords==true  &&  $_POST['city']!='all' )
							  {
							  	$emp_detail  = $userObj->getTableData("hs_hr_employee","","custom34='".$_POST['city']."' AND emp_number=".$attendance["employeeId"]."","custom34","","");
							  	if(!count($emp_detail))  { continue; }

							  }

							  /**** We have to apply date2 filter too  ****/
							  if(isset($searchRecords)  && $searchRecords==true && isset($_POST['attendance']['date2'] ) && $_POST['attendance']['date2'] !="" )
							  {   
							  	if(strtotime(date("Y-m-d",strtotime($attendance['punchInUserTime']))) > strtotime($_POST['attendance']['date2']))
							  	{
							  		continue;	
							  	}

							  }

							  if (strtotime($attendance->getPunchInUserTime()) >= strtotime($from) && strtotime($attendance->getPunchInUserTime()) <= strtotime($end)) {
							  	if ($attendance->getPunchOutUtcTime()) {
							  		$total = $total + round((strtotime($attendance->getPunchOutUtcTime()) - strtotime($attendance->getPunchInUtcTime())) / 3600, 2);
							  	}
							  	$records[] = $attendance;
							  	$hasRecords = true;
							  }
							}

							if ($hasRecords) {
								$last = end($records);
								$last->setTotal($total);
							} else {
								$attendance = new AttendanceRecord();
								$attendance->setEmployee($employee);
								$attendance->setTotal('---');
								$records[] = $attendance;
							}
						}

						$params = array();
						$this->parmetersForListCompoment = $params;

						$rolesToExclude = array();
						$rolesToInclude = array();

						if ($this->employeeId == $loggedInEmpNumber && $userRoleManager->essRightsToOwnWorkflow()) {
							$rolesToInclude = array('ESS');
						}

						$actions = array(PluginWorkflowStateMachine::ATTENDANCE_ACTION_EDIT_PUNCH_OUT_TIME, PluginWorkflowStateMachine::ATTENDANCE_ACTION_EDIT_PUNCH_IN_TIME);
						$actionableStates = $userRoleManager->getActionableStates(WorkflowStateMachine::FLOW_ATTENDANCE, 
							$actions, $rolesToExclude, $rolesToInclude, array('Employee' => $this->employeeId));
						$recArray = array();

	                    if ($records != null) {
	                        if ($actionableStates != null) {
	                            foreach ($actionableStates as $state) {
	                                foreach ($records as $record) {
	                                    if ($state == $record->getState()) {
	                                            $this->allowedActions['Edit'] = true;
	                                        break;
	                                    }
	                                }
	                            }
	                        }

	                        $actions = array(PluginWorkflowStateMachine::ATTENDANCE_ACTION_DELETE);
	                        $actionableStates = $userRoleManager->getActionableStates(WorkflowStateMachine::FLOW_ATTENDANCE, 
	                            $actions, $rolesToExclude, $rolesToInclude, array('Employee' => $this->employeeId));

	                        if ($actionableStates != null) {
	                            foreach ($actionableStates as $state) {
	                                foreach ($records as $record) {
	                                    if ($state == $record->getState()) {
	                                            $this->allowedActions['Delete'] = true;
	                                        break;
	                                    }
	                                }
	                            }
	                        }

	                        foreach ($records as $record) {
	                            $this->allowedToDelete[] = $userRoleManager->isActionAllowed(WorkflowStateMachine::FLOW_ATTENDANCE, $record->getState(), PluginWorkflowStateMachine::ATTENDANCE_ACTION_DELETE, array(), array(), array('Employee' => $this->employeeId));
	                            $recArray[] = $record;
	                        }
	                    } 
	                    else {
	                        $attendanceRecord = null;
	                    }

	                    /** 
	                     * TODO: Following code looks overly complicated. Simplify
	                     */
	                    $actions = array(PluginWorkflowStateMachine::ATTENDANCE_ACTION_PROXY_PUNCH_IN, PluginWorkflowStateMachine::ATTENDANCE_ACTION_PROXY_PUNCH_OUT);
	                    $allowedActionsList = array();
	                    $actionableStates = $userRoleManager->getActionableStates(WorkflowStateMachine::FLOW_ATTENDANCE, 
	                    $actions, $rolesToExclude, $rolesToInclude, array('Employee' => $this->employeeId));

	                    if ($actionableStates != null) {
	                        if (!empty($recArray)) {
	                            $lastRecordPunchOutTime = $recArray[count($records) - 1]->getPunchOutUserTime();
	                            if (empty($lastRecordPunchOutTime)) {
	                                $attendanceRecord = "";
	                            } else {
	                                $attendanceRecord = null;
	                            }
	                        }

	                        foreach ($actionableStates as $actionableState) {
	  
	                            $allowedActionsArray = $userRoleManager->getAllowedActions(WorkflowStateMachine::FLOW_ATTENDANCE, 
	                                $actionableState, array(), array(), array('Employee' => $this->employeeId));
	                            
	                            if (!is_null($allowedActionsArray)) {

	                                $allowedActionsList = array_unique(array_merge(array_keys($allowedActionsArray), $allowedActionsList));
	                            }
	                        }

	                        if ((is_null($attendanceRecord)) && (in_array(WorkflowStateMachine::ATTENDANCE_ACTION_PROXY_PUNCH_IN, $allowedActionsList))) {
	                                $this->allowedActions['PunchIn'] = true;
	                        }
	                        if ((!is_null($attendanceRecord)) && (in_array(WorkflowStateMachine::ATTENDANCE_ACTION_PROXY_PUNCH_OUT, $allowedActionsList))) {
	                                $this->allowedActions['PunchOut'] = true;
	                        }
	                    }
	                    if ($this->employeeId == '') {
	                        $this->showEdit = FALSE;
	                    }
	                    
						 
	                    $this->_setListComponent($records, $noOfRecords, $pageNumber, $count, $this->showEdit, $this->allowedActions);
	                }
            	}
        	}
    	}

    private function _setListComponent($records, $noOfRecords, $pageNumber, $count = null, $showEdit = null, $allowedActions = null) {

        $configurationFactory = new AttendanceRecordHeaderFactory();
        $userRoleManager = $this->getContext()->getUserRoleManager();
        $loggedInEmpNumber = $this->getUser()->getEmployeeNumber();

        $notSelectable = array();
        foreach ($records as $record) {
            if (!$userRoleManager->isActionAllowed(WorkflowStateMachine::FLOW_ATTENDANCE, 
                    $record->getState(), WorkflowStateMachine::ATTENDANCE_ACTION_DELETE, 
                    array(), array(), array('Employee' => $this->employeeId))) {          
                $notSelectable[] = $record->getId();
            }
        }

        $buttons = array();
        $canSelect = false;
        if (isset($allowedActions)) {
            if (isset($showEdit) && $showEdit) {
                if ($allowedActions['Edit']) :
                    $buttons['Edit'] = array('label' => __('Edit'), 'type' => 'button',);
                endif;
                if ($allowedActions['PunchIn']) :
                    $buttons['PunchIn'] = array('label' => __('Add Attendance Records'), 'type' => 'button', 'class' => 'punch');
                endif;
                if ($allowedActions['PunchOut']) :
                    $buttons['PunchOut'] = array('label' => __('Add Attendance Records'), 'type' => 'button', 'class' => 'punch');
                endif;
            }
            if ($allowedActions['Delete']) :
                $canSelect = true;
                $buttons['Delete'] = array('label' => __('Delete'),
                    'type' => 'submit',
                    'data-toggle' => 'modal',
                    'data-target' => '#dialogBox',
                    'class' => 'delete');
            endif;
        }
        $configurationFactory->setRuntimeDefinitions(array(
            'buttons' => $buttons,
            'unselectableRowIds' => $notSelectable,
            'hasSelectableRows' => $canSelect
        ));

        ohrmListComponent::setActivePlugin('orangehrmAttendancePlugin');
        ohrmListComponent::setConfigurationFactory($configurationFactory);
        ohrmListComponent::setListData($records);
        ohrmListComponent::setPageNumber($pageNumber);
        ohrmListComponent::setItemsPerPage($noOfRecords);
        ohrmListComponent::setNumberOfRecords($count);
    }
    
}

