<?php use_javascript(plugin_web_path('orangehrmAdminPlugin', 'js/workShiftSuccess')); ?>
<style type="text/css">
.timepicker
{
	width:111px !important;
}

</style>
<div id="workShift" class="box" <?php echo $hideForm ? "style='display:none'" : "";?> >
    
    <div class="head">
        <h1 id="workShiftHeading"><?php echo __("Work Shift"); ?></h1>
    </div>
    
    <div class="inner">

        <?php include_partial('global/form_errors', array('form' => $form)); ?>
        
        <form name="frmWorkShift" id="frmWorkShift" method="post" action="<?php echo url_for('admin/workShift'); ?>" >

            <?php echo $form['_csrf_token']; ?>
            <?php echo $form->renderHiddenFields(); ?>
            
            <fieldset>
                
                <ol>                    
                    <li>
                        <?php
					 
						 echo $form['name']->renderLabel(); ?>
                        <?php echo $form['name']->render(); ?>
                    </li>
                    <li>
                        <?php echo $form['workHours']->renderLabel(); ?>
                        <?php echo $form['workHours']->render(); ?>
                    </li>   
                    <li>
                        <label for="workShift_workDays">Work Days</label>  
                                              
                        <label  for="workShift_workDays_from" class="time_range_label">From</label> 
                        <select name="workDaysFrom" class="timepicker valid"  id="workDaysFrom"> 
                           <option selected="selected" value="">--Select--</option>
                            <option value="Monday">Monday</option>
                            <option value="Tuesday">Tuesday</option> 
                            <option value="Wednesday">Wednesday</option> 
                            <option value="Thursday">Thursday</option> 
                            <option value="Friday">Friday</option> 
                            <option value="Saturday">Saturday</option> 
                            <option value="Sunday">Sunday</option> 
                         </select> 

						<label for="workShift_workDays_to" class="time_range_label">To</label> 
                        <select name="workDaysTo"class="timepicker valid"  id="workDaysTo"> 
                        	<option selected="selected" value="">--Select--</option>
                            <option value="Monday">Monday</option>
                            <option value="Tuesday">Tuesday</option> 
                            <option value="Wednesday">Wednesday</option> 
                            <option value="Thursday">Thursday</option> 
                            <option value="Friday">Friday</option> 
                            <option value="Saturday">Saturday</option> 
                            <option value="Sunday">Sunday</option> 
                        </select> 
                        
             </li>              
                    <p id="selectManyTable">
                        <table border="0" style="width:700px;" class="">
                            <tbody>
                                <tr>
                                    <td width="35%" style="font-weight:bold; height: 20px">
                                        <?php echo __("Available Employees"); ?>
                                    </td>
                                    <td width="30%"></td>
                                    <td width="35%" style="font-weight:bold;"><?php echo __("Assigned Employees"); ?></td>
                                </tr>
                                <tr>
                                    <td>
                                        <?php echo $form['availableEmp']->render(array("class" => "selectMany", "size" => 10, "style" => "width: 300px")); ?>	
                                    </td>
                                    <td align="center" style="vertical-align: middle" width="20%">
                                        <a href="#" class="" id="btnAssignEmployee"><?php echo __("Add"). " >>"; ?></a><br /><br />
                                        <a href="#" class="delete" id="btnRemoveEmployee"><?php echo __("Remove") . " <<"; ?></a>
                                    </td>
                                    <td>
                                        <?php echo $form['assignedEmp']->render(array("class" => "selectMany", "size" => 10, "style" => "width: 300px")); ?>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </p>
                    <li class="required">
                        <em>*</em> <?php echo __(CommonMessages::REQUIRED_FIELD); ?>
                    </li>                    
                </ol>
                
                <p>
                    <input type="button" class="" name="btnSave" id="btnSave" value="<?php echo __("Save"); ?>"/>
                    <input type="button" class="reset" name="btnCancel" id="btnCancel" value="<?php echo __("Cancel"); ?>"/>
                </p>
                
            </fieldset>
            
        </form>
        
    </div>
    
</div>


<!-- Download Employee Shift Div--->
<div id="down_emp_shifts_div" class="box" style="display:none;">
        <div class="head">
                <h1 id="workShiftHeading"> Download Employee Work Shifts</h1>
         </div>
       <div class="inner">  
         <form action="<?php echo url_for('admin/workShift'); ?>" method="post">
               <fieldset>
                
                <ol>                    
				 <li id="shift_city">
                 <input type="hidden" name="shift_report" value="yes"  />
                        <label for="city">City:</label>
                        <select id="shift_city" name="shift_city">
                         	 <option value="all" selected="selected">All</option>
                             <option value="Islamabad">Islamabad</option>
                             <option value="Lahore">Lahore</option>
                             <option value="Karachi">Karachi</option>
                        </select>
 				
					</li>
                 </ol>
                    </fieldset>
               <p>
                    <input type="submit" class="" name="down_shift_report" id="down_shift_report" value="Download"/>
                    <input type="button" class="reset" name="down_shift_cancel" id="down_shift_cancel" value="<?php echo __("Cancel"); ?>"/>
                </p>   
         </form>
         </div>  <!--inner-->
</div>




<div id="customerList">
    <?php include_component('core', 'ohrmList', $parmetersForListCompoment); ?>
</div>

<!-- Confirmation box HTML: Begins -->
<div class="modal hide" id="deleteConfModal">
    <div class="modal-header">
        <a class="close" data-dismiss="modal">×</a>
        <h3><?php echo __('OrangeHRM - Confirmation Required'); ?></h3>
    </div>
    <div class="modal-body">
        <p><?php echo __(CommonMessages::DELETE_CONFIRMATION); ?></p>
    </div>
    <div class="modal-footer">
        <input type="button" class="btn" data-dismiss="modal" id="dialogDeleteBtn" value="<?php echo __('Ok'); ?>" />
        <input type="button" class="btn reset" data-dismiss="modal" value="<?php echo __('Cancel'); ?>" />
    </div>
</div>
<!-- Confirmation box HTML: Ends -->

<script type="text/javascript">
	var employeeList = <?php echo $form->getEmployeeListAsJson();?>;
	var workShiftList = <?php echo $form->getWorkShiftListAsJson();?>;
        
        var defaultStartTime = '<?php echo $default['start_time'];?>';
        var defaultEndTime = '<?php echo $default['end_time'];?>';

	var workShiftInfoUrl = "<?php echo url_for("admin/getWorkShiftInfoJson?id="); ?>";
	var workShiftEmpInfoUrl = "<?php echo url_for("admin/getWorkShiftEmpInfoJson?id="); ?>";

	var lang_Required = '<?php echo __(ValidationMessages::REQUIRED); ?>';
	var lang_exceed50Charactors = '<?php echo __(ValidationMessages::TEXT_LENGTH_EXCEEDS, array('%amount%' => 50)); ?>';
	var lang_addWorkShift = "<?php echo __("Add Work Shift"); ?>";
	var lang_editWorkShift = "<?php echo __("Edit Work Shift"); ?>";
	var lang_nameAlreadyExist = '<?php echo __(ValidationMessages::ALREADY_EXISTS); ?>';
        var lang_FromTimeLessThanToTime = "<?php echo __('From time should be less than To time'); ?>";
</script>


<script>
    /***  Code for Employee Shoft Download Functionality ***/
	$("#down_emp_shifts_btn").click(function() {
		$("#down_emp_shifts_div").show();
		$(".top").hide();
	});
	$("#down_shift_cancel").click(function() {
		$("#down_emp_shifts_div").hide();
		$(".top").show();
	});
</script>