<?php

/**
 * OrangeHRM is a comprehensive Human Resource Management (HRM) System that captures
 * all the essential functionalities required for any enterprise.
 * Copyright (C) 2006 OrangeHRM Inc., http://www.orangehrm.com
 *
 * OrangeHRM is free software; you can redistribute it and/or modify it under the terms of
 * the GNU General Public License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * OrangeHRM is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this program;
 * if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA
 */
class workShiftAction extends sfAction {

    private $workShiftService;

    public function getWorkShiftService() {
        if (is_null($this->workShiftService)) {
            $this->workShiftService = new WorkShiftService();
            $this->workShiftService->setWorkShiftDao(new WorkShiftDao());
        }
        return $this->workShiftService;
    }

    /**
     * @param sfForm $form
     * @return
     */
    public function setForm(sfForm $form) {
        if (is_null($this->form)) {
            $this->form = $form;
        }
    }

    public function execute($request) {

        /*** if isset($_POST["shift_report"]) then downloadEmpShiftsReport() will be called  ***/
		if(isset($_POST["shift_report"])){
			$this->downloadEmpShiftsReport();
		}
	   
	    $usrObj = $this->getUser()->getAttribute('user');
        if (!$usrObj->isAdmin()) {
            $this->redirect('pim/viewPersonalDetails');
        }

        $this->setForm(new WorkShiftForm());

        $workShiftList = $this->getWorkShiftService()->getWorkShiftList();
        $this->_setListComponent($workShiftList);
        $params = array();
        $this->parmetersForListCompoment = $params;
        $hideForm = true;

        if ($request->isMethod('post')) {
            $this->form->bind($request->getParameter($this->form->getName()));
            if ($this->form->isValid()) {
                $this->form->save();
                $this->getUser()->setFlash('success', __(TopLevelMessages::SAVE_SUCCESS));
                $this->redirect('admin/workShift');
            } else {
                $hideForm = false;
            }
        }

        $this->hideForm = $hideForm;
        $this->default = $this->getWorkShiftService()->getWorkShiftDefaultStartAndEndTime();
    }

    private function _setListComponent($workShiftList) {

        $configurationFactory = new WorkShiftHeaderFactory();
        ohrmListComponent::setConfigurationFactory($configurationFactory);
        ohrmListComponent::setListData($workShiftList);
    }
	
	
	
	/**** Function to download Employee Work Shift records  ****/
	function downloadEmpShiftsReport() 
	{
		include_once('/var/www/orangehrm/classes/db.php'); 
		include_once('/var/www/orangehrm/classes/XLClasses/PHPExcel.php');
	   $objPHPExcel = new PHPExcel();
	   $dbObj = new Database();
		$cityAnd = "";
		if($_POST["shift_city"]!="all"){
			$cityAnd = " AND emp.custom34='".$_POST["shift_city"]."'";	
		}
		
		$query = "SELECT
				emp.emp_firstname,emp.emp_lastname,emp.emp_number,emp.custom34,ws.name,ws.start_time,ws.end_time,
				ws.start_day,ws.end_day, ws.hours_per_day FROM hs_hr_employee as emp 
				LEFT JOIN ohrm_employee_work_shift as ews 
				ON
				emp.emp_number = ews.emp_number LEFT  JOIN ohrm_work_shift as ws 
				ON 
			   ews.work_shift_id = ws.id 
				WHERE  
				emp.custom30 = 'Active' ".$cityAnd." ORDER BY emp.emp_firstname ASC"; 
		$employee_shifts = $dbObj->execQuery($query);	
		
		$objPHPExcel->setActiveSheetIndex(0);
		$objPHPExcel->getActiveSheet()->setCellValue('A1', 'S.#')
							  ->setCellValue('B1', "Employee Name")
							  ->setCellValue('C1', "Employee Number")
							  ->setCellValue('D1',"City")
							  ->setCellValue('E1',"Shift Name")
							  ->setCellValue('F1',"Shift Start Time")
							  ->setCellValue('G1',"Shift End Time")
							  ->setCellValue('H1',"Shift Duration")
							  ->setCellValue('I1',"Work Days");
							  
							  
		$objPHPExcel->getActiveSheet()->getStyle('A1:I1')->getFill()->applyFromArray(
					array(
							'type' => PHPExcel_Style_Fill::FILL_SOLID,
							'color' => array('rgb' => '000000'),
							'bold' =>true
						)
					);
					
					$objPHPExcel->getDefaultStyle()->getAlignment()
													->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);	
													
		
		$styleArray = array(
    'font'  => array(
        'bold'  => true,
        'color' => array('rgb' => 'EEEEE'),
    ));
		$objPHPExcel->getActiveSheet()->getStyle('A1:I1')->applyFromArray($styleArray);
		
	 $alignment = array(
        'alignment' => array(
            'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
        )
    );

    $objPHPExcel->getActiveSheet()->getStyle("A1:I1")->applyFromArray($alignment);	
																	  
							  
		$index = 2;
		foreach($employee_shifts as $item)
		{
		   $empName = $item["emp_firstname"]." ".$item["emp_lastname"];
		   $empNumber = $item["emp_number"]; 
		   $city = $item["custom34"];
		   $shiftName  = $item["name"];
		   $startTime = $shiftName!=""? date("g:i a",strtotime($item["start_time"])):"-";
		   $endTime = $shiftName!=""? date("g:i a",strtotime($item["end_time"])):"-";
		   $duration = $shiftName!=""? $item["hours_per_day"]." Hours":"-";
		   $workDays = $shiftName!=""? $item["start_day"]." - ".$item["end_day"]:"-";
		   
		   $objPHPExcel->getActiveSheet()->setCellValue('A'.$index, ($index-1))
							  ->setCellValue('B'.$index, $empName)
							  ->setCellValue('C'.$index, $empNumber)
							  ->setCellValue('D'.$index,$city)
							  ->setCellValue('E'.$index,$shiftName)
							  ->setCellValue('F'.$index,$startTime)
							  ->setCellValue('G'.$index,$endTime)
							  ->setCellValue('H'.$index,$duration)
							  ->setCellValue('I'.$index,$workDays); 
							  
							  
				if($index % 2 == 0)
				{						  
					$objPHPExcel->getActiveSheet()->getStyle('A'.$index.':I'.$index)->getFill()->applyFromArray(
					array(
							'type' => PHPExcel_Style_Fill::FILL_SOLID,
							'color' => array('rgb' => 'EEEEEE')
						)
					);
					
					$objPHPExcel->getDefaultStyle()->getAlignment()
													->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
				}
				else
				{
					$objPHPExcel->getDefaultStyle()->getAlignment()
													->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
				}
							  
							  
			$index++;				  	
		}
		
		
		$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(10);
		$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(40);
		$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(30);
		$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(30);
		$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(40);
		$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(20);
		$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(30);
		$objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(30);
		$objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(40);
		
	
		                $dir = '/var/www/orangehrm/reports/';
						$fileName = 'employee_shoft_report'.'.xls'; 
						$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
						$objWriter->save($dir.$fileName);
						
						function force_download($file,$dir)
						{
							if ((isset($file)) && (file_exists($dir.$file)))
							{ //if start
								header("Content-type: application/force-download"); 
								header('Content-Disposition: inline; filename="' . $dir.$file . '"'); 
								header("Content-Transfer-Encoding: Binary"); 
								header("Content-length: ".filesize($dir.$file)); 
								header('Content-Type: application/octet-stream'); 
								header('Content-Disposition: attachment; filename="'.$file.'"'); 
								readfile("$dir$file"); 
							}
							else
							{ 
								echo "Sorry! not found on server";
							} 
						}
						
					force_download($fileName,$dir);
						exit; 
		
		
	} //downloadEmpWorkShifts

}

