<?php

/**
 * OrangeHRM is a comprehensive Human Resource Management (HRM) System that captures
 * all the essential functionalities required for any enterprise.
 * Copyright (C) 2006 OrangeHRM Inc., http://www.orangehrm.com
 *
 * OrangeHRM is free software; you can redistribute it and/or modify it under the terms of
 * the GNU General Public License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * OrangeHRM is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this program;
 * if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA
 */
class saveSystemUserAction extends sfAction {

    private $systemUserService;

    public function getSystemUserService() {        
        if (is_null($this->systemUserService)) {
            $this->systemUserService = new SystemUserService();
        }
        return $this->systemUserService;
    }    
    
    public function setSystemUserService($systemUserService) {
        $this->systemUserService = $systemUserService;
    }

    /**
     * @param sfForm $form
     * @return
     */
    public function setForm(sfForm $form) {
        if (is_null($this->form)) {
            $this->form = $form;
        }
    }

    /**
     *
     * @return sfForm 
     */
    public function getForm() {
        return $this->form;
    }

    public function execute($request) {
        
        /* For highlighting corresponding menu item */
        $request->setParameter('initialActionName', 'viewSystemUsers');

        $this->userId = $request->getParameter('userId');
        $values = array('userId' => $this->userId, 'sessionUser' => $this->getUser()->getAttribute('user'));
        $this->setForm(new SystemUserForm(array(), $values));

        if ($request->getParameter('userId')) {
            $userRoleManager = $this->getContext()->getUserRoleManager();
            $accessible = $userRoleManager->isEntityAccessible('SystemUser', $request->getParameter('userId'));

            if (!$accessible) {
                $this->forward(sfConfig::get('sf_secure_module'), sfConfig::get('sf_secure_action'));
            }
        }

        if ($request->isMethod('post')) {
			
			include_once('/var/www/orangehrm/classes/db.php'); 
			$userObj = new Database();
			
			/* If employee name is sent empty and employee id is sent then we have to get Employee Name  */
			/*  As we are customizing Ohrms default coding and it is working eith Employee name not employee id  */
			if($_POST["systemUser"]["employeeName"]["empName"]==""  || trim($_POST["systemUser"]["employeeName"]["empName"])=="Type for hints...")
			{  
			   $where = "employee_id=".$_POST["systemUser"]["employeeId"]; 
			   $userData=$userObj->getTableData('hs_hr_employee','',$where,'emp_number, emp_firstname, emp_middle_name, emp_lastname',1,'');
			   
			   $f_name = $userData[0]['emp_firstname']." ";
			   $mid_name = $userData[0]['emp_middle_name']!=""?$userData[0]['emp_middle_name']." ":"";
			   $l_name = $userData[0]['emp_lastname'];
			   $full_name = $f_name.$mid_name.$l_name;
			   
			   /***  Customize POSTED array as to include employee name and empNumber  ***/
			  $_POST["systemUser"]["employeeName"]["empName"] = $full_name;
			  $_POST["systemUser"]["employeeName"]["empId"] = $userData[0]['emp_number'];
				
			}
			
			/* We unset POSTED employeeId as it is not accepted in default implementation of Orange HRM */
			 unset($_POST["systemUser"]["employeeId"]);  // new code
			 
			 /* Re- Arrange  form=>systemUser with new values*/
			 $request->setParameter('systemUser', $_POST["systemUser"]);  // new code
			
			

            $this->form->bind($request->getParameter($this->form->getName()));
            if ($this->form->isValid()) {
                
                $userId = $this->form->getValue('userId');
                $userRoleModified = false;
                if (!empty($userId)) {
                    $user = $this->getSystemUserService()->getSystemUser($userId);
                    if ($user instanceof SystemUser) {
                        $newRoleId = $this->form->getValue('userType');
                        $userRoleModified = $newRoleId != $user->getUserRoleId();
                    }
                }
            
                $savedUser = $this->form->save();
                if ($savedUser instanceof SystemUser) { // sets flash values for admin/viewSystemUsers pre filter for further actions if needed
                    $this->getUser()->setFlash("new.user.id", $savedUser->getId()); //
                    $this->getUser()->setFlash("new.user.role.id", $savedUser->getUserRoleId());
                    $this->getUser()->setFlash("new.user.edited", $this->form->edited);
                    $this->getUser()->setFlash("new.user.role.modified", $userRoleModified);
                }                

                if ($this->form->edited) {
                    $this->getUser()->setFlash('success', __(TopLevelMessages::UPDATE_SUCCESS));
                } else {

                    $this->getUser()->setFlash('success', __(TopLevelMessages::SAVE_SUCCESS));
                }
                $this->redirect('admin/viewSystemUsers');
            }
        }
    }

}