<?php 
include_once('/var/www/orangehrm/classes/excel_reader/PHPExcel/IOFactory.php');  



/**
 * OrangeHRM is a comprehensive Human Resource Management (HRM) System that captures
 * all the essential functionalities required for any enterprise.
 * Copyright (C) 2006 OrangeHRM Inc., http://www.orangehrm.com
 *
 * OrangeHRM is free software; you can redistribute it and/or modify it under the terms of
 * the GNU General Public License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * OrangeHRM is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this program;
 * if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA
 */
class pimCsvImportAction extends baseCsvImportAction {

	/**
	 * @param sfForm $form
	 * @return
	 */
	public function setForm(sfForm $form) {
		if (is_null($this->form)) {
			$this->form = $form;
		}
	}

	public function corrVariable($var){
		if(strlen($var)==0):
			return '';
		endif;

		if($var=='Y' || $var=='y'):
			return 'Yes';
		elseif($var=='N' || $var=='n'):
			return 'No';
		else:
			$var=strtolower($var);
			return ucfirst($var);
		endif;
	}

	public function corrDate($date){
		if(strlen($date)<8):
			return '';
		endif;
		
		return  date("Y-m-d", strtotime($date));
	}
 
	public function chIsNull($val,$isUp){
		if($isUp==1 && (!isset($val) || $val=='') ){
			return false; 
		}
		else{
			return true;
		}
	}

	public function execute($request) { 
		$this->setForm(new PimCsvImportForm());
		if ($request->isMethod('post')) {  
			$this->form->bind($request->getParameter($this->form->getName()), $request->getFiles($this->form->getName()));
			$file = $request->getFiles($this->form->getName());
			 

			if ($_FILES['pimCsvImport']['size'] > 1024000 || $_FILES == null):
           	 	$this->getUser()->setFlash('csvimport.warning', __('Failed to Import: File Size Exceeded'));
				$this->redirect('admin/pimCsvImport');
			else:

				include_once('/var/www/orangehrm/classes/db.php'); 
				$userObj = new Database(); 

				$objPHPExcel = PHPExcel_IOFactory::load($_FILES["pimCsvImport"]["tmp_name"]);  
				$sheetData = $objPHPExcel->getActiveSheet()->toArray(null,true,true,true);  
				if(count($sheetData)>1):
					$totalRec=$userObj->getTableData('hs_hr_employee','emp_number DESC','','emp_number','1','');
					$nEmpNum=$totalRec[0]['emp_number']+1;
					$i=0;
					foreach($sheetData as $shData):
						$isUpdate=0;
						if($i==0): 
							$i++;
							continue;
						endif;
						  
						$name=explode(' ',$shData['H']);  
						if($name[0]=='' || $name[1]==''):
							continue;
						endif;
						 
 						$employeeId=trim($shData['F']);
						if(empty($employeeId) || $employeeId==''):
							$employeeId=$nEmpNum;
						else: 
							$totalRec=$userObj->getTableData('hs_hr_employee','',"employee_id='{$employeeId}'",'emp_number','','');
							if(count($totalRec)>0):
								$isUpdate=1;
							endif;
						endif;
 
 						$data=array();
 						//$data['emp_number']=$nEmpNum;
 						
 						if($isUpdate==0):
 							$data['employee_id']=$employeeId;
 						endif;

 						if($this->chIsNull($name[1],$isUpdate)):
							$data['emp_lastname']=$name[1];
							$data['emp_lastname'].=(isset($name[2]))?' '.$name[2]:'';
 						endif;
 						
 						if($this->chIsNull($name[0],$isUpdate)):
							$data['emp_firstname']=$name[0];
 						endif;
 						
 						if($this->chIsNull($shData['B'],$isUpdate)):
							$data['custom2']=$shData['B']; //ID Card Issued
 						endif;

 						if($this->chIsNull($shData['C'],$isUpdate)):
							$data['custom79']=$this->corrVariable($shData['C']); //Insurance Form (Y/N)
 						endif;

 						if($this->chIsNull($shData['D'],$isUpdate)):
							$data['custom80']=$this->corrVariable($shData['D']); //Insurance Card (Y/N)
 						endif;

 						if($this->chIsNull($shData['E'],$isUpdate)):
							$data['custom81']=$shData['E']; //Insured Employees As Per Finance
 						endif;
 						
 						if($this->chIsNull($employeeId,$isUpdate)):
							$data['custom7']=$employeeId; //Emp. ID
 						endif;

 						if($this->chIsNull($shData['G'],$isUpdate)):
							$data['custom5']=$shData['G']; //Prefix
 						endif;

 						if($this->chIsNull($shData['H'],$isUpdate)):
							$data['custom6']=$shData['H']; //Name
 						endif;

 						if($this->chIsNull($shData['I'],$isUpdate)):
							$data['custom8']=$shData['I']; //S/o, W/o, D/o 
 						endif;

 						if($this->chIsNull($shData['J'],$isUpdate)):
							$data['custom4']=$this->corrDate($shData['J']); //Date Of Joining
 						endif;

 					 	if($this->chIsNull($shData['K'],$isUpdate)):
							$data['custom82']=$this->corrDate($shData['K']); //First Joining Date (For Rejoined)
 						endif;
 						
 						if($this->chIsNull($shData['L'],$isUpdate)):
							$data['custom30']=$shData['L']; //Status
 						endif;

 						if($this->chIsNull($shData['M'],$isUpdate)):
							$data['custom34']=$shData['M']; //Location
 						endif;

 						if($this->chIsNull($shData['O'],$isUpdate)):
							$data['custom54']=$shData['O']; //Confirmation Period
 						endif;
 						//$data['custom95']=$this->corrVariable($shData['N']); //Probition Period Completed Yes / No
 						if($this->chIsNull($shData['P'],$isUpdate)):
							$data['custom31']=$shData['P']; //Designation
 						endif;

 						if($this->chIsNull($shData['Q'],$isUpdate)):
							$data['custom32']=$shData['Q']; //Job Description
 						endif;

 						if($this->chIsNull($shData['R'],$isUpdate)):
							$data['custom33']=$shData['R']; //Department   --DROPD
 						endif;

 						if($this->chIsNull($shData['S'],$isUpdate)):
							$data['custom74']=$shData['S']; //Primary Project
 						endif;

 						if($this->chIsNull($shData['T'],$isUpdate)):
							$data['custom83']=$shData['T']; //Secondary Project
 						endif;

 						if($this->chIsNull($shData['U'],$isUpdate)):
							$data['custom84']=$shData['U']; //Tertiary Project 
 						endif;

 						if($this->chIsNull($shData['V'],$isUpdate)):
							$data['custom77']=$this->corrVariable($shData['V']); //Working Shift   --DROPD
 						endif;

 						if($this->chIsNull($shData['W'],$isUpdate)):
							$data['custom78']=$shData['W']; //Pseudo
 						endif;

 						if($this->chIsNull($shData['X'],$isUpdate)):
							$data['custom35']=$shData['X']; //Official Email ID
 						endif;

 						if($this->chIsNull($shData['Y'],$isUpdate)):
							$data['custom85']=$shData['Y']; //Official Medflow ID
 						endif;

 						if($this->chIsNull($shData['Z'],$isUpdate)):
							$data['custom72']=$shData['Z']; //Official Skype ID
 						endif;
 						
 						if($this->chIsNull($shData['AA'],$isUpdate)):
							$data['custom86']=$shData['AA']; //HRM ID
 						endif;
 						
 						if($this->chIsNull($shData['AB'],$isUpdate)):
							$data['custom18']=$shData['AB']; //Address
 						endif;

 						if($this->chIsNull($shData['AC'],$isUpdate)):
							$data['custom9']=$this->corrVariable($shData['AC']); //Gender
 						endif;

 						if($this->chIsNull($shData['AD'],$isUpdate)):
							$data['custom11']=$this->corrVariable($shData['AD']); //Marital Status
 						endif;
 						
 						if($this->chIsNull($shData['AE'],$isUpdate)):
							$data['custom26']=$this->corrDate($shData['AE']); //Offer letter Issued On
 						endif;

 						if($this->chIsNull($shData['AF'],$isUpdate)):
							$data['custom27']=$this->corrDate($shData['AF']); //Receiving Received On
 						endif;

 						if($this->chIsNull($shData['AG'],$isUpdate)):
							$data['custom28']=$this->corrDate($shData['AG']); //Appointment Letter issued on
 						endif;

 						if($this->chIsNull($shData['AH'],$isUpdate)):
							$data['custom29']=$this->corrDate($shData['AH']); //Appt Letter Received (Receiving)
 						endif;

 						if($this->chIsNull($shData['AI'],$isUpdate)):
							$data['custom16']=$shData['AI']; //Home Telephone #
 						endif;

 						if($this->chIsNull($shData['AJ'],$isUpdate)):
							$data['custom17']=$shData['AJ']; //Cell #
 						endif;

 						if($this->chIsNull($shData['AK'],$isUpdate)):
							$data['custom21']=$shData['AK']; //Emergency # 
 						endif;

 						if($this->chIsNull($shData['AL'],$isUpdate)):
							$data['custom12']=$shData['AL']; //D.O.B
 						endif;
 						
 						if($this->chIsNull($shData['AM'],$isUpdate)):
							$data['custom10']=$shData['AM']; //Age
 						endif;

 						if($this->chIsNull($shData['AN'],$isUpdate)):
							$data['custom40']=$this->corrDate($shData['AN']); //Date Of Separation
 						endif;

 						if($this->chIsNull($shData['AO'],$isUpdate)):
							$data['custom88']=$this->corrVariable($shData['AO']); //Prior Notice (Y/N)
 						endif; 
 						//$data['custom94']=$shData['AP']; //Completed 30 Days After Assessement
 						if($this->chIsNull($shData['AQ'],$isUpdate)):
							$data['custom87']=$shData['AQ']; //Separation Reason
 						endif;

 						if($this->chIsNull($shData['AR'],$isUpdate)):
							$data['custom89']=$this->corrVariable($shData['AR']); //Exit Interview (Y/N)
 						endif;
 						
 						if($this->chIsNull($shData['AS'],$isUpdate)):
							$data['custom13']=$this->corrVariable($shData['AS']); //Religion
 						endif;
 						
 						if($this->chIsNull($shData['AT'],$isUpdate)):
							$data['custom42']=$shData['AT']; //Qualification (Last Degree)
 						endif;
 						
 						if($this->chIsNull($shData['AU'],$isUpdate)){
	 						if (filter_var($shData['AU'], FILTER_VALIDATE_FLOAT)){
	     						$passDate=intval($shData['AU']);
	     					}
	     					else{
	     						$passDate=$shData['AU'];
	 						}

	 						$data['custom43']=$passDate; //Passing Date
 						}

 						if($this->chIsNull($shData['AV'],$isUpdate)):
							$data['custom44']=$shData['AV']; //CGPA / DIV/ %	
 						endif;

 						if($this->chIsNull($shData['AW'],$isUpdate)):
							$data['custom45']=$shData['AW']; //Institute
 						endif;
 						
 						if($this->chIsNull($shData['AX'],$isUpdate)):
							$data['custom36']=$shData['AX']; //Last Employer
 						endif;

 						if($this->chIsNull($shData['AY'],$isUpdate)):
							$data['custom90']=$shData['AY']; //Last Employer Address
 						endif; 
 						//$data['custom91']=$shData['AZ']; //PAID LEAVES
 						if($this->chIsNull($shData['BA'],$isUpdate)):
							$data['custom22']=$shData['BA']; //Tilte of Account
 						endif;
 						
 						if($this->chIsNull($shData['BB'],$isUpdate)):
							$data['custom23']=$shData['BB']; //Account Number
 						endif;

 						if($this->chIsNull($shData['BC'],$isUpdate)):
							$data['custom24']=$shData['BC']; //Branch Address
 						endif;
 						
 						if($this->chIsNull($shData['BD'],$isUpdate)):
							$data['custom25']=$shData['BD']; //Branch Code
 						endif;

 						if($this->chIsNull($shData['BE'],$isUpdate)):
							$data['custom14']=$shData['BE']; //cnic #
 						endif;

 						if($this->chIsNull($shData['BG'],$isUpdate)):
							$data['custom120']=$this->corrDate($shData['BG']); //Suspension 1
 						endif;

 						if($this->chIsNull($shData['BH'],$isUpdate)):
							$data['custom121']=$this->corrDate($shData['BH']); //Suspension 1
 						endif;

 						if($this->chIsNull($shData['BI'],$isUpdate)):
							$data['custom122']=$shData['BI']; //Suspension 1
 						endif;

 						if($this->chIsNull($shData['BJ'],$isUpdate)):
							$data['custom123']=$this->corrDate($shData['BJ']); //Suspension 2
 						endif;

 						if($this->chIsNull($shData['BK'],$isUpdate)):
							$data['custom124']=$this->corrDate($shData['BK']); //Suspension 2
 						endif;

 						if($this->chIsNull($shData['BL'],$isUpdate)):
							$data['custom125']=$shData['BL']; //Suspension 2
 						endif;

 						if($this->chIsNull($shData['BM'],$isUpdate)):
							$data['custom126']=$this->corrDate($shData['BM']); //Suspension 3
 						endif;

 						if($this->chIsNull($shData['BN'],$isUpdate)):
							$data['custom127']=$this->corrDate($shData['BN']); //Suspension 3
 						endif;

 						if($this->chIsNull($shData['BO'],$isUpdate)):
							$data['custom128']=$shData['BO']; //Suspension 3
 						endif;

 						if($this->chIsNull($shData['BP'],$isUpdate)):
							$data['custom129']=$this->corrDate($shData['BP']); //Suspension 4
 						endif;

 						if($this->chIsNull($shData['BQ'],$isUpdate)):
							$data['custom130']=$this->corrDate($shData['BQ']); //Suspension 4
 						endif;

 						if($this->chIsNull($shData['BR'],$isUpdate)):
							$data['custom131']=$shData['BR']; //Suspension 4
 						endif;

 						/*
 						if($this->chIsNull($shData['BG'],$isUpdate)){   
	 						$susLetter=explode(')',$shData['BG']); //No of Suspension Letter Issued- Dated
	 						$susDates=explode(',',$susLetter[1]);
	 						$cust=120;
	 						$ij=0;
	 						for($ij;$ij<count($susDates);$ij++){
	 							if($ij==4){
	 								break;
	 							}
	 							$data["custom{$cust}"]=$this->corrDate($susDates[$ij]);
	 							$cust=$cust+3; 
	 						}
 						}*/

 						if($this->chIsNull($shData['BF'],$isUpdate)){ 
	 						$warLetter=explode(')',$shData['BF']); //No of Warning Letter Issued- Dated
	 						$warDates=explode(',',$warLetter[1]);
	 						$cust=100;
	 						$ij=0;
	 						for($ij;$ij<count($warDates);$ij++){
	 							if($ij==4){
	 								break;
	 							}
	 							$data["custom{$cust}"]=$this->corrDate($warDates[$ij]);
	 							$cust=$cust+2; 
	 						}
	 					}

	 					if($this->chIsNull($shData['BS'],$isUpdate)):
							$data['custom20']=$shData['BS']; //Personal Data form
 						endif;

 						if($this->chIsNull($shData['BT'],$isUpdate)):
							$data['custom15']=$shData['BT']; //CNIC
 						endif;

 						if($this->chIsNull($shData['BU'],$isUpdate)):
							$data['custom47']=$this->corrVariable($shData['BU']); //Pics (Y/N)
 						endif;

 						if($this->chIsNull($shData['BV'],$isUpdate)):
							$data['custom92']=$this->corrVariable($shData['BV']); //Last Academic (Y/N)
 						endif;

 						if($this->chIsNull($shData['BW'],$isUpdate)):
							$data['custom48']=$this->corrVariable($shData['BW']); //CV (Y/N)
 						endif;

 						if($this->chIsNull($shData['BX'],$isUpdate)):
							$data['custom49']=$this->corrVariable($shData['BX']); //Acceptance of Resignation from previous Employer / Clearence Letter
 						endif;

 						if($this->chIsNull($shData['BY'],$isUpdate)):
							$data['custom50']=$this->corrVariable($shData['BY']); //Stamped Papers
 						endif; 
 						//$data['custom51']=$shData['BO']; //No.of Documents Missing 
 						if($this->chIsNull($shData['CA'],$isUpdate)):
							$data['custom19']=$shData['CA']; //Personal Email Addresses
 						endif;
 						
 						if($this->chIsNull($shData['CB'],$isUpdate)):
							$data['custom52']=$shData['CB']; //Hiring in replacement of 
 						endif;

 						if($this->chIsNull($shData['CC'],$isUpdate)):
							$data['custom93']=$shData['CC']; //Remarks
 						endif;

 						if($this->chIsNull($shData['CD'],$isUpdate)):
							$data['custom38']=$shData['CD']; //PREVIOUS DEPARTMENT
 						endif;

 						if($this->chIsNull($shData['CE'],$isUpdate)):
							$data['custom39']=$shData['CE']; //Previous SALARY
 						endif;

 						if($this->chIsNull($shData['CF'],$isUpdate)):
							$data['custom200']=$this->corrDate($shData['CF']); //01st APPRAISAL DATE
 						endif;

 						if($this->chIsNull($shData['CG'],$isUpdate)):
							$data['custom202']=$shData['CG']; //01st INCREASED SALARY AMOUNT
 						endif;
 						
 						if($this->chIsNull($shData['CH'],$isUpdate)):
							$data['custom203']=$this->corrDate($shData['CH']); //2nd APPRAISAL DATE
 						endif;
 						
 						if($this->chIsNull($shData['CI'],$isUpdate)):
							$data['custom205']=$shData['CI']; //2nd INCREASED SALARY AMOUNT
 						endif;

 						if($this->chIsNull($shData['CJ'],$isUpdate)):
							$data['custom206']=$this->corrDate($shData['CJ']); //3rd APPRAISAL DATE
 						endif;

 						if($this->chIsNull($shData['CK'],$isUpdate)):
							$data['custom208']=$shData['CK']; //3rd INCREASED SALARY AMOUNT
 						endif;
 						
 						if($this->chIsNull($shData['CL'],$isUpdate)):
							$data['custom209']=$this->corrDate($shData['CL']); //4TH APPRAISAL DATE
 						endif;

 						if($this->chIsNull($shData['CM'],$isUpdate)):
							$data['custom211']=$shData['CM']; //4th INCREASED SALARY AMOUNT
 						endif;

 						if($this->chIsNull($shData['CN'],$isUpdate)):
							$data['custom212']=$this->corrDate($shData['CN']); //5TH APPRAISAL DATE
 						endif;

 						if($this->chIsNull($shData['CO'],$isUpdate)):
							$data['custom214']=$shData['CO']; //5th INCREASED SALARY AMOUNT
 						endif;

 						if($this->chIsNull($shData['CP'],$isUpdate)):
							$data['custom215']=$this->corrDate($shData['CP']); //6TH APPRAISAL DATE
 						endif;

 						if($this->chIsNull($shData['CQ'],$isUpdate)):
							$data['custom217']=$shData['CQ']; //6th INCREASED SALARY AMOUNT
 						endif;

 						if($this->chIsNull($shData['CR'],$isUpdate)):
							$data['custom218']=$this->corrDate($shData['CR']); //7TH APPRAISAL DATE
 						endif;
 						
 						if($this->chIsNull($shData['CS'],$isUpdate)):
							$data['custom220']=$shData['CS']; //7th INCREASED SALARY AMOUNT
 						endif;

 						if($this->chIsNull($shData['CT'],$isUpdate)):
							$data['custom60']=$shData['CT']; //TRANSPORT ALLOWANCE
 						endif;

 						if($this->chIsNull($shData['CU'],$isUpdate)):
							$data['custom58']=$shData['CU']; //Hired Salary
 						endif;

 						if($this->chIsNull($shData['CV'],$isUpdate)):
							$data['custom56']=$shData['CV']; //Present Salary 
 						endif;

 						if($this->chIsNull($shData['CW'],$isUpdate)):
							$data['custom57']=$shData['CW']; //Salary in words 
 						endif; 
 
 						if($this->chIsNull($shData['CY'],$isUpdate) && $this->chIsNull($shData['CZ'],$isUpdate) && $isUpdate==1){
							// Update supervisor data
							$subOrdinateId=$totalRec[0]['emp_number'];
							$supervisorData=$userObj->getTableData('hs_hr_employee','',"employee_id='{$shData['CY']}'",'emp_number','','');
							$supervisorId=$supervisorData[0]['emp_number']; 
							$superRecord=$userObj->getTableData('hs_hr_emp_reportto','',"erep_sup_emp_number='{$supervisorId}' AND erep_sub_emp_number='{$subOrdinateId}'",'erep_reporting_mode','','');
							if(count($superRecord)>0){
								$supData=array(); 
								if($shData['CZ']=='Direct'){
									$dType=1;
								}
								else{
									$dType=2;
								}

								$supData['erep_reporting_mode']=$dType;
								$userObj->update('hs_hr_emp_reportto',$supData,"erep_sup_emp_number='{$supervisorId}' AND erep_sub_emp_number='{$subOrdinateId}'"); 
								//echo $subOrdinateId.' hmmmm '.$supervisorId.'<br/>';
							}
							else{
								$supData=array();
								$supData['erep_sup_emp_number']=$supervisorId;
								$supData['erep_sub_emp_number']=$subOrdinateId;
								if($shData['CZ']=='Direct'){
									$dType=1;
								}
								else{
									$dType=2;
								}
								$supData['erep_reporting_mode']=$dType;
								$userObj->insertTableData('hs_hr_emp_reportto',$supData); 
							}
 						}
 
 						if($this->chIsNull($shData['DA'],$isUpdate)):
							$data['custom96']=$shData['DA']; //Company transport availing
 						endif; 

 						if($this->chIsNull($shData['DB'],$isUpdate)):
							$data['custom97']=intval($shData['DB']); //Van number
 						endif;  

 						if($this->chIsNull($shData['DC'],$isUpdate)):
							$data['custom98']=$shData['DC']; //Van timing 
 						endif; 

 						if($this->chIsNull($shData['DD'],$isUpdate)):
							$data['custom99']=$shData['DD']; //Driver name 
 						endif; 

 						/*echo $isUpdate;
 						echo "<pre>";
 						print_r($data);
 						exit;*/
 						if($isUpdate==1){
 							$userObj->update('hs_hr_employee',$data,"employee_id='{$employeeId}'"); 
 						}
 						else{
 							$subOrdinateId=$userObj->insertTableData('hs_hr_employee',$data); 

 							if($this->chIsNull($shData['CY'],$isUpdate) && $this->chIsNull($shData['CZ'],$isUpdate)){
	 							
	 							$supervisorData=$userObj->getTableData('hs_hr_employee','',"employee_id='{$shData['CY']}'",'emp_number','','');
								$supervisorId=$supervisorData[0]['emp_number'];

								$supData=array();
								$supData['erep_sup_emp_number']=$supervisorId;
								$supData['erep_sub_emp_number']=$subOrdinateId;
								if($shData['CZ']=='Direct'){
									$dType=1;
								}
								else{
									$dType=2;
								}
								$supData['erep_reporting_mode']=$dType;
								$userObj->insertTableData('hs_hr_emp_reportto',$supData); 
							}
 						}
 
 						$i++;
					endforeach; 
 				endif; 
 				$i--;		


 				//die('123');

			    if($i>0):

                   $this->getUser()->setFlash('csvimport.success', __('Number of Records Imported').": ".$i);
			    else:
                    $this->getUser()->setFlash('csvimport.warning', __('Failed to Import: No Compatible Records'));
			    endif; 
				$this->redirect('admin/pimCsvImport'); 

			endif;
		}
	}  

}

