<?php

/**
 * BaseLeaveType
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 * 
 * @property integer $id
 * @property string $name
 * @property boolean $exclude_in_reports_if_no_entitlement
 * @property integer $deleted
 * @property integer $operational_country_id
 * @property OperationalCountry $OperationalCountry
 * @property Doctrine_Collection $LeaveEntitlement
 * @property Doctrine_Collection $LeaveAdjustment
 * @property Doctrine_Collection $Leave
 * @property Doctrine_Collection $LeaveRequest
 * 
 * @method integer             getId()                                   Returns the current record's "id" value
 * @method string              getName()                                 Returns the current record's "name" value
 * @method boolean             getExcludeInReportsIfNoEntitlement()      Returns the current record's "exclude_in_reports_if_no_entitlement" value
 * @method integer             getDeleted()                              Returns the current record's "deleted" value
 * @method integer             getOperationalCountryId()                 Returns the current record's "operational_country_id" value
 * @method OperationalCountry  getOperationalCountry()                   Returns the current record's "OperationalCountry" value
 * @method Doctrine_Collection getLeaveEntitlement()                     Returns the current record's "LeaveEntitlement" collection
 * @method Doctrine_Collection getLeaveAdjustment()                      Returns the current record's "LeaveAdjustment" collection
 * @method Doctrine_Collection getLeave()                                Returns the current record's "Leave" collection
 * @method Doctrine_Collection getLeaveRequest()                         Returns the current record's "LeaveRequest" collection
 * @method LeaveType           setId()                                   Sets the current record's "id" value
 * @method LeaveType           setName()                                 Sets the current record's "name" value
 * @method LeaveType           setExcludeInReportsIfNoEntitlement()      Sets the current record's "exclude_in_reports_if_no_entitlement" value
 * @method LeaveType           setDeleted()                              Sets the current record's "deleted" value
 * @method LeaveType           setOperationalCountryId()                 Sets the current record's "operational_country_id" value
 * @method LeaveType           setOperationalCountry()                   Sets the current record's "OperationalCountry" value
 * @method LeaveType           setLeaveEntitlement()                     Sets the current record's "LeaveEntitlement" collection
 * @method LeaveType           setLeaveAdjustment()                      Sets the current record's "LeaveAdjustment" collection
 * @method LeaveType           setLeave()                                Sets the current record's "Leave" collection
 * @method LeaveType           setLeaveRequest()                         Sets the current record's "LeaveRequest" collection
 * 
 * @package    orangehrm
 * @subpackage model\leave\base
 * @author     Your name here
 * @version    SVN: $Id: Builder.php 7490 2010-03-29 19:53:27Z jwage $
 */
abstract class BaseLeaveType extends sfDoctrineRecord
{
    public function setTableDefinition()
    {
        $this->setTableName('ohrm_leave_type');
        $this->hasColumn('id', 'integer', 4, array(
             'type' => 'integer',
             'fixed' => 0,
             'unsigned' => true,
             'primary' => true,
             'autoincrement' => true,
             'length' => 4,
             ));
        $this->hasColumn('name', 'string', 50, array(
             'type' => 'string',
             'fixed' => 0,
             'unsigned' => false,
             'primary' => false,
             'notnull' => true,
             'autoincrement' => false,
             'length' => 50,
             ));
        $this->hasColumn('exclude_in_reports_if_no_entitlement', 'boolean', null, array(
             'type' => 'boolean',
             ));
        $this->hasColumn('deleted', 'integer', 1, array(
             'type' => 'integer',
             'fixed' => 0,
             'unsigned' => false,
             'primary' => false,
             'default' => '0',
             'notnull' => true,
             'autoincrement' => false,
             'length' => 1,
             ));
        $this->hasColumn('operational_country_id', 'integer', 4, array(
             'type' => 'integer',
             'fixed' => 0,
             'unsigned' => true,
             'primary' => false,
             'notnull' => false,
             'autoincrement' => false,
             'length' => 4,
             ));
    }

    public function setUp()
    {
        parent::setUp();
        $this->hasOne('OperationalCountry', array(
             'local' => 'operational_country_id',
             'foreign' => 'id'));

        $this->hasMany('LeaveEntitlement', array(
             'local' => 'id',
             'foreign' => 'leave_type_id'));

        $this->hasMany('LeaveAdjustment', array(
             'local' => 'id',
             'foreign' => 'leave_type_id'));

        $this->hasMany('Leave', array(
             'local' => 'id',
             'foreign' => 'leave_type_id'));

        $this->hasMany('LeaveRequest', array(
             'local' => 'id',
             'foreign' => 'leave_type_id'));
    }
}