<?php

/**
 * BaseLeaveEntitlement
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 * 
 * @property integer $id
 * @property integer $emp_number
 * @property decimal $no_of_days
 * @property decimal $days_used
 * @property integer $leave_type_id
 * @property timestamp $from_date
 * @property timestamp $to_date
 * @property timestamp $credited_date
 * @property string $note
 * @property integer $entitlement_type
 * @property integer $deleted
 * @property integer $created_by_id
 * @property string $created_by_name
 * @property LeaveType $LeaveType
 * @property Employee $Employee
 * @property SystemUser $SystemUser
 * @property LeaveEntitlementType $LeaveEntitlementType
 * @property Doctrine_Collection $leave
 * 
 * @method integer              getId()                   Returns the current record's "id" value
 * @method integer              getEmpNumber()            Returns the current record's "emp_number" value
 * @method decimal              getNoOfDays()             Returns the current record's "no_of_days" value
 * @method decimal              getDaysUsed()             Returns the current record's "days_used" value
 * @method integer              getLeaveTypeId()          Returns the current record's "leave_type_id" value
 * @method timestamp            getFromDate()             Returns the current record's "from_date" value
 * @method timestamp            getToDate()               Returns the current record's "to_date" value
 * @method timestamp            getCreditedDate()         Returns the current record's "credited_date" value
 * @method string               getNote()                 Returns the current record's "note" value
 * @method integer              getEntitlementType()      Returns the current record's "entitlement_type" value
 * @method integer              getDeleted()              Returns the current record's "deleted" value
 * @method integer              getCreatedById()          Returns the current record's "created_by_id" value
 * @method string               getCreatedByName()        Returns the current record's "created_by_name" value
 * @method LeaveType            getLeaveType()            Returns the current record's "LeaveType" value
 * @method Employee             getEmployee()             Returns the current record's "Employee" value
 * @method SystemUser           getSystemUser()           Returns the current record's "SystemUser" value
 * @method LeaveEntitlementType getLeaveEntitlementType() Returns the current record's "LeaveEntitlementType" value
 * @method Doctrine_Collection  getLeave()                Returns the current record's "leave" collection
 * @method LeaveEntitlement     setId()                   Sets the current record's "id" value
 * @method LeaveEntitlement     setEmpNumber()            Sets the current record's "emp_number" value
 * @method LeaveEntitlement     setNoOfDays()             Sets the current record's "no_of_days" value
 * @method LeaveEntitlement     setDaysUsed()             Sets the current record's "days_used" value
 * @method LeaveEntitlement     setLeaveTypeId()          Sets the current record's "leave_type_id" value
 * @method LeaveEntitlement     setFromDate()             Sets the current record's "from_date" value
 * @method LeaveEntitlement     setToDate()               Sets the current record's "to_date" value
 * @method LeaveEntitlement     setCreditedDate()         Sets the current record's "credited_date" value
 * @method LeaveEntitlement     setNote()                 Sets the current record's "note" value
 * @method LeaveEntitlement     setEntitlementType()      Sets the current record's "entitlement_type" value
 * @method LeaveEntitlement     setDeleted()              Sets the current record's "deleted" value
 * @method LeaveEntitlement     setCreatedById()          Sets the current record's "created_by_id" value
 * @method LeaveEntitlement     setCreatedByName()        Sets the current record's "created_by_name" value
 * @method LeaveEntitlement     setLeaveType()            Sets the current record's "LeaveType" value
 * @method LeaveEntitlement     setEmployee()             Sets the current record's "Employee" value
 * @method LeaveEntitlement     setSystemUser()           Sets the current record's "SystemUser" value
 * @method LeaveEntitlement     setLeaveEntitlementType() Sets the current record's "LeaveEntitlementType" value
 * @method LeaveEntitlement     setLeave()                Sets the current record's "leave" collection
 * 
 * @package    orangehrm
 * @subpackage model\leave\base
 * @author     Your name here
 * @version    SVN: $Id: Builder.php 7490 2010-03-29 19:53:27Z jwage $
 */
abstract class BaseLeaveEntitlement extends sfDoctrineRecord
{
    public function setTableDefinition()
    {
        $this->setTableName('ohrm_leave_entitlement');
        $this->hasColumn('id', 'integer', 4, array(
             'type' => 'integer',
             'fixed' => 0,
             'unsigned' => false,
             'primary' => true,
             'autoincrement' => true,
             'length' => 4,
             ));
        $this->hasColumn('emp_number', 'integer', 7, array(
             'type' => 'integer',
             'fixed' => 0,
             'unsigned' => false,
             'primary' => false,
             'autoincrement' => false,
             'length' => 7,
             ));
        $this->hasColumn('no_of_days', 'decimal', 6, array(
             'type' => 'decimal',
             'scale' => false,
             'primary' => false,
             'notnull' => true,
             'autoincrement' => false,
             'length' => 6,
             ));
        $this->hasColumn('days_used', 'decimal', 4, array(
             'type' => 'decimal',
             'fixed' => 0,
             'primary' => false,
             'notnull' => false,
             'autoincrement' => false,
             'length' => 4,
             'scale' => '2',
             ));
        $this->hasColumn('leave_type_id', 'integer', 4, array(
             'type' => 'integer',
             'fixed' => 0,
             'unsigned' => true,
             'primary' => false,
             'notnull' => true,
             'autoincrement' => false,
             'length' => 4,
             ));
        $this->hasColumn('from_date', 'timestamp', 25, array(
             'type' => 'timestamp',
             'fixed' => 0,
             'unsigned' => false,
             'primary' => false,
             'notnull' => true,
             'autoincrement' => false,
             'length' => 25,
             ));
        $this->hasColumn('to_date', 'timestamp', 25, array(
             'type' => 'timestamp',
             'fixed' => 0,
             'unsigned' => false,
             'primary' => false,
             'notnull' => false,
             'autoincrement' => false,
             'length' => 25,
             ));
        $this->hasColumn('credited_date', 'timestamp', 25, array(
             'type' => 'timestamp',
             'fixed' => 0,
             'unsigned' => false,
             'primary' => false,
             'notnull' => false,
             'autoincrement' => false,
             'length' => 25,
             ));
        $this->hasColumn('note', 'string', 255, array(
             'type' => 'string',
             'fixed' => 0,
             'unsigned' => false,
             'primary' => false,
             'notnull' => false,
             'autoincrement' => false,
             'length' => 255,
             ));
        $this->hasColumn('entitlement_type', 'integer', 4, array(
             'type' => 'integer',
             'fixed' => 0,
             'unsigned' => false,
             'primary' => false,
             'notnull' => true,
             'autoincrement' => false,
             'length' => 4,
             ));
        $this->hasColumn('deleted', 'integer', 1, array(
             'type' => 'integer',
             'fixed' => 0,
             'unsigned' => false,
             'primary' => false,
             'default' => '0',
             'notnull' => true,
             'autoincrement' => false,
             'length' => 1,
             ));
        $this->hasColumn('created_by_id', 'integer', 10, array(
             'type' => 'integer',
             'fixed' => 0,
             'unsigned' => false,
             'primary' => false,
             'notnull' => false,
             'autoincrement' => false,
             'length' => 10,
             ));
        $this->hasColumn('created_by_name', 'string', 255, array(
             'type' => 'string',
             'fixed' => 0,
             'unsigned' => false,
             'primary' => false,
             'notnull' => false,
             'autoincrement' => false,
             'length' => 255,
             ));
    }

    public function setUp()
    {
        parent::setUp();
        $this->hasOne('LeaveType', array(
             'local' => 'leave_type_id',
             'foreign' => 'id'));

        $this->hasOne('Employee', array(
             'local' => 'emp_number',
             'foreign' => 'emp_number'));

        $this->hasOne('SystemUser', array(
             'local' => 'created_by_id',
             'foreign' => 'id'));

        $this->hasOne('LeaveEntitlementType', array(
             'local' => 'entitlement_type',
             'foreign' => 'id'));

        $this->hasMany('Leave as leave', array(
             'refClass' => 'LeaveLeaveEntitlement',
             'local' => 'entitlement_id',
             'foreign' => 'leave_id'));
    }
}