# LogViewer [![Packagist License][badge_license]](LICENSE.md) [![For Laravel 5][badge_laravel]][link-github-repo]

[![Travis Status][badge_build]][link-travis]
[![Coverage Status][badge_coverage]][link-scrutinizer]
[![Scrutinizer Code Quality][badge_quality]][link-scrutinizer]
[![SensioLabs Insight][badge_insight]][link-insight]
[![Github Issues][badge_issues]][link-github-issues]

[![Packagist][badge_package]][link-packagist]
[![Packagist Release][badge_release]][link-packagist]
[![Packagist Downloads][badge_downloads]][link-packagist]

*By [ARCANEDEV&copy;](http://www.arcanedev.net/)*

This package allows you to manage and keep track of each one of your logs files.

 > **NOTE: You can also use LogViewer as an API.**

Official documentation for LogViewer can be found at the [_docs folder](_docs/0.Home.md).

Feel free to check out the [releases](https://github.com/ARCANEDEV/LogViewer/releases), [license](LICENSE.md), and [contribution guidelines](CONTRIBUTING.md).

## Features

  - A great Log viewer API.
  - Laravel `5.0 | 5.1 | 5.2 | 5.3 | 5.4` are supported.
  - Ready to use (Views, Routes, controllers &hellip; Out of the box) [Note: No need to publish assets]
  - View, paginate, filter, download and delete logs.
  - Load a custom logs storage path.
  - Localized log levels.
  - Logs menu/tree generator.
  - Grouped logs by dates and levels.
  - Customized log levels icons (font awesome by default).
  - Works great with big logs !!
  - Well documented package (IDE Friendly).
  - Well tested (100% code coverage with maximum code quality).

## Table of contents

1. [Requirements](_docs/1.Requirements.md)
2. [Installation and Setup](_docs/2.Installation-and-Setup.md)
3. [Configuration](_docs/3.Configuration.md)
4. [Usage](_docs/4.Usage.md)
5. [Extras](_docs/5.Extras.md)
6. [FAQ](_docs/6.FAQ.md)

### Supported localizations

 > Dear artisans, i'm counting on you to help me out to add more translations ( ^_^)b

| Local   | Language              |
|---------|-----------------------|
| `ar`    | Arabic                |
| `bg`    | Bulgarian             |
| `de`    | German                |
| `en`    | English               |
| `es`    | Spanish               |
| `et`    | Estonian              |
| `fa`    | Farsi                 |
| `fr`    | French                |
| `hu`    | Hungarian             |
| `hy`    | Armenian              |
| `it`    | Italian               |
| `ko`    | Korean                |
| `nl`    | Dutch                 |
| `pl`    | Polish                |
| `pt-BR` | Brazilian Portuguese  |
| `ro`    | Romanian              |
| `ru`    | Russian               |
| `sv`    | Swedish               |
| `th`    | Thai                  |
| `tr`    | Turkish               |
| `zh`    | Chinese (Simplified)  |
| `zh-TW` | Chinese (Traditional) |

## Contribution

Any ideas are welcome. Feel free to submit any issues or pull requests, please check the [contribution guidelines](CONTRIBUTING.md).

## Security

If you discover any security related issues, please email arcanedev.maroc@gmail.com instead of using the issue tracker.

## Credits

- [ARCANEDEV][link-author]
- [All Contributors][link-contributors]

## PREVIEW

![Dashboard](https://raw.githubusercontent.com/ARCANEDEV/LogViewer/master/_screenshots/1-dashboard.jpg)
![Logs list](https://raw.githubusercontent.com/ARCANEDEV/LogViewer/master/_screenshots/2-logs-list.jpg)
![Single log](https://raw.githubusercontent.com/ARCANEDEV/LogViewer/master/_screenshots/3-single-log.jpg)

[badge_laravel]:      https://img.shields.io/badge/For-Laravel%205.x-orange.svg?style=flat-square
[badge_license]:      https://img.shields.io/packagist/l/arcanedev/log-viewer.svg?style=flat-square
[badge_build]:        https://img.shields.io/travis/ARCANEDEV/LogViewer.svg?style=flat-square
[badge_coverage]:     https://img.shields.io/scrutinizer/coverage/g/ARCANEDEV/LogViewer.svg?style=flat-square
[badge_quality]:      https://img.shields.io/scrutinizer/g/ARCANEDEV/LogViewer.svg?style=flat-square
[badge_insight]:      https://img.shields.io/sensiolabs/i/d6b4587a-e00d-4dac-98db-f979731fdc4d.svg?style=flat-square
[badge_issues]:       https://img.shields.io/github/issues/ARCANEDEV/LogViewer.svg?style=flat-square
[badge_package]:      https://img.shields.io/badge/package-arcanedev/log--viewer-blue.svg?style=flat-square
[badge_release]:      https://img.shields.io/packagist/v/arcanedev/log-viewer.svg?style=flat-square
[badge_downloads]:    https://img.shields.io/packagist/dt/arcanedev/log-viewer.svg?style=flat-square

[link-author]:        https://github.com/arcanedev-maroc
[link-github-repo]:   https://github.com/ARCANEDEV/LogViewer
[link-github-issues]: https://github.com/ARCANEDEV/LogViewer/issues
[link-contributors]:  https://github.com/ARCANEDEV/LogViewer/graphs/contributors
[link-packagist]:     https://packagist.org/packages/arcanedev/log-viewer
[link-travis]:        https://travis-ci.org/ARCANEDEV/LogViewer
[link-scrutinizer]:   https://scrutinizer-ci.com/g/ARCANEDEV/LogViewer/?branch=master
[link-insight]:       https://insight.sensiolabs.com/projects/d6b4587a-e00d-4dac-98db-f979731fdc4d
