<?php $__env->startSection('title', trans('Leads Management')); ?>

<?php $__env->startSection('after-styles'); ?>
    <?php echo e(Html::style("css/backend/plugin/datatables/dataTables.bootstrap.min.css")); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-header'); ?>
    <h1>
        <?php echo e(trans('Leads Management')); ?>

        <small><?php echo e(trans('labels.backend.contacts.active')); ?></small>
    </h1>
<?php $__env->stopSection(); ?>
<?php if($count == 0): ?>
<?php $__env->startSection('content'); ?>
    <div class="box box-success">
        <div class="box-header with-border">
            <h3 class="box-title"><?php echo e(trans('labels.backend.contacts.active')); ?></h3>

            <div class="box-tools pull-right">
            </div><!--box-tools pull-right-->
        </div><!-- /.box-header -->

        <div class="box-body">
            <div class="table-responsive">
                <table id="leads-table" class="table table-condensed table-hover">
                    <thead>
                    <tr>
                        <th><?php echo e(trans('First Name')); ?></th>
                        <th><?php echo e(trans('Last Name')); ?></th>
                        <th><?php echo e(trans('Phone')); ?></th>
                        <th><?php echo e(trans('Email')); ?></th>
                        <?php if(!access()->hasRole('Administrator')): ?>
                            <th><?php echo e(trans('labels.general.actions')); ?></th>
                        <?php endif; ?>

                    </tr>
                    </thead>
                </table>
            </div><!--table-responsive-->
        </div><!-- /.box-body -->
    </div><!--box-->

<?php $__env->stopSection(); ?>

<?php $__env->startSection('after-scripts'); ?>
    <?php echo e(Html::script("js/backend/plugin/datatables/jquery.dataTables.min.js")); ?>

    <?php echo e(Html::script("js/backend/plugin/datatables/dataTables.bootstrap.min.js")); ?>


    <script>
        $(function () {
            $('#leads-table').DataTable({
                processing: true,
                serverSide: true,
                ajax: {
                    url: '<?php echo e(route("admin.customers.contactget.get")); ?>',
                    type: 'get'
                },
                columns: [
                    {data: 'id', name: '<?php echo e(config('ubereat.contacts')); ?>.id'},

                    {data: 'fname', name: '<?php echo e(config('ubereat.contacts')); ?>.fname', render: $.fn.dataTable.render.text()},
                    {data: 'lname', name: '<?php echo e(config('ubereat.contacts')); ?>.lname'},
                    {data: 'pphone', name: '<?php echo e(config('ubereat.contacts')); ?>.pphone'},
                    {data: 'email', name: '<?php echo e(config('ubereat.contacts')); ?>.email'},
                        <?php if(!access()->hasRole('Administrator')): ?>
                    {
                        data: 'actions', name: 'actions', searchable: false, sortable: false
                    }
                    <?php endif; ?>
                ],
                order: [[0, "asc"]],
                searchDelay: 500
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php else: ?>
<?php $__env->startSection('content'); ?>
    <div class="box box-success">
        <div class="box-header with-border">
            <h3 class="box-title"><?php echo e(trans('labels.backend.contacts.active')); ?></h3>

            <div class="box-tools pull-right">
            </div><!--box-tools pull-right-->
        </div><!-- /.box-header -->

        <div class="box-body">
            <div class="table-responsive">
                <table id="contacts-table" class="table table-condensed table-hover">
                    <thead>
                    <?php $__currentLoopData = $settings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $setting): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <th><?php echo str_replace('general.', '', $setting->key) ?></th>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <th><?php echo app('translator')->getFromJson('Action'); ?></th>
                    </thead>
                </table>
            </div><!--table-responsive-->
        </div><!-- /.box-body -->
    </div><!--box-->

<?php $__env->stopSection(); ?>

<?php $__env->startSection('after-scripts'); ?>
    <?php echo e(Html::script("js/backend/plugin/datatables/jquery.dataTables.min.js")); ?>

    <?php echo e(Html::script("js/backend/plugin/datatables/dataTables.bootstrap.min.js")); ?>


    <script>
        $(function () {
            $('#contacts-table').DataTable({
                processing: true,
                serverSide: true,
                ajax: {
                    url: '<?php echo e(route("admin.customers.leadsget.get")); ?>',
                    type: 'get'
                },
                columns: [
                        <?php $__currentLoopData = $settings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $setting): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    {
                        data: '<?php echo str_replace('general.', '', $setting->key) ?>',
                        name: '<?php echo e(config('ubereat.contacts')); ?>.<?php echo str_replace('general.', '', $setting->key) ?>',
                        render: $.fn.dataTable.render.text()
                    },
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    {
                        data: 'actions', name: 'actions', searchable: false, sortable: false
                    }
                ],
                order: [[0, "asc"]],
                searchDelay: 500
            });
        });
    </script>
<?php $__env->stopSection(); ?>
<?php endif; ?>

<?php echo $__env->make('backend.layouts.app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>