<!doctype html>
<html lang="<?php echo e(app()->getLocale()); ?>">
    <head>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

        <title><?php echo $__env->yieldContent('title', app_name()); ?></title>

        <!-- Meta -->
        <meta name="description" content="<?php echo $__env->yieldContent('meta_description', 'Iceworm'); ?>">
        <meta name="author" content="<?php echo $__env->yieldContent('meta_author', 'Sohaib Zaidi'); ?>">
        <?php echo $__env->yieldContent('meta'); ?>

        <link rel="stylesheet" type="text/css" href="<?php echo e(asset('style/css/bootstrap.min.css')); ?>"/>
        <link rel="stylesheet" type="text/css" href="<?php echo e(asset('style/css/bootstrap-select.min.css')); ?>"/>
        <link rel="stylesheet" type="text/css" href="<?php echo e(asset('style/css/font-awesome.min.css')); ?>"/>
        <link rel="stylesheet" type="text/css" href="<?php echo e(asset('style/css/elegant.css')); ?>"/>
        <link rel="stylesheet" type="text/css" href="<?php echo e(asset('style/css/owl.carousel.css')); ?>"/>
        <link rel="stylesheet" type="text/css" href="<?php echo e(asset('style/css/animate.css')); ?>"/>
        <link rel="stylesheet" type="text/css" href="<?php echo e(asset('style/css/theme.css')); ?>"/>


        <?php echo $__env->yieldContent('before-styles'); ?>
        <!-- Check if the language is set to RTL, so apply the RTL layouts -->
        <!-- Otherwise apply the normal LTR layouts -->


        <?php echo $__env->yieldContent('after-styles'); ?>

        <!-- Scripts -->
        <script>
            window.Laravel = <?php echo json_encode([
                'csrfToken' => csrf_token(),
            ]); ?>
        </script>
    </head>
    <body id="app-layout">
    <?php $user = Auth::user(); ?>
    <?php if($user ==NULL): ?>
        <?php echo $__env->make('frontend.includes.home.header', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
    <?php else: ?>
        <?php echo $__env->make('frontend.includes.home.f_head', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
        <?php endif; ?>
        <div id="app">
            <?php echo $__env->make('includes.partials.logged-in-as', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>


                <?php echo $__env->make('includes.partials.messages', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
                <?php echo $__env->yieldContent('content'); ?>
            
        </div><!--#app-->

        <!-- Scripts -->
        <?php echo $__env->yieldContent('before-scripts'); ?>

        <?php echo $__env->yieldContent('after-scripts'); ?>
    <?php echo Html::script('style/js/jquery-2.2.4.min.js'); ?>

    <?php echo Html::script('style/js/bootstrap.min.js'); ?>

    <?php echo Html::script('style/js/bootstrap-select.min.js'); ?>

    <?php echo Html::script('style/js/owl.carousel.min.js'); ?>

    <?php echo Html::script('style/js/jquery.sticky.js'); ?>

    <?php echo Html::script('style/js/wow.min.js'); ?>

    <?php echo Html::script('style/js/jquery.countdown.min.js'); ?>

    <?php echo Html::script('style/js/theme-ajax-mail.js'); ?>

    <?php echo Html::script('style/js/data.binder.js'); ?>

    <?php echo Html::script('style/js/theme.js'); ?>



    <?php echo $__env->make('frontend.includes.home.footer', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
    </body>
</html>
