<?php $__env->startSection('title', trans('labels.backend.title.agents.agents')); ?>
<?php $__env->startSection('after-styles'); ?>
    <?php echo e(Html::style("css/backend/plugin/datatables/dataTables.bootstrap.min.css")); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('page-header'); ?>
    
    <h1>
        <?php echo e(trans('labels.backend.title.agents.agents')); ?>

        <small><?php echo e(trans('labels.backend.title.promo.active')); ?></small>
    </h1>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="box box-success">
        <div class="box-header with-border">
            <h3 class="box-title"><?php echo e(trans('labels.backend.title.promo.active')); ?></h3>
            <div class="box-tools pull-right">
                
            </div><!--box-tools pull-right-->
        </div><!-- /.box-header -->
        <div class="box-body">
            <div class="table-responsive">
                <table id="agents-table" class="table table-condensed table-hover">
                    <thead>
                    <tr>
                        <th><?php echo e(trans('First Name')); ?></th>
                        <th><?php echo e(trans('Last Name')); ?></th>
                        <th><?php echo e(trans('Phone')); ?></th>
                        <th><?php echo e(trans('Mobile')); ?></th>
                        <th><?php echo e(trans('Email')); ?></th>
                        <th><?php echo e(trans('Agency')); ?></th>
                        <th><?php echo e(trans('Status')); ?></th>
                        <?php if(!access()->hasRole('Administrator')): ?>
                            <th><?php echo e(trans('labels.general.actions')); ?></th>
                        <?php endif; ?>
                    </tr>
                    </thead>
                </table>
            </div><!--table-responsive-->
        </div><!-- /.box-body -->
    </div><!--box-->

<?php $__env->stopSection(); ?>
<?php $__env->startSection('after-scripts'); ?>
    <?php echo e(Html::script("js/backend/plugin/datatables/jquery.dataTables.min.js")); ?>

    <?php echo e(Html::script("js/backend/plugin/datatables/dataTables.bootstrap.min.js")); ?>


    <script>
        $(function () {
            $('#agents-table').DataTable({
                processing: true,
                serverSide: true,
                ajax: {
                    url: '<?php echo e(route("admin.superadmin.agents.get")); ?>',
                    type: 'get'
                },
                columns: [
                    {
                        data: 'first_name',
                        name: '<?php echo e(config('iceworm.dx_agents')); ?>.first_name',
                        render: $.fn.dataTable.render.text()
                    },
                    {data: 'last_name', name: '<?php echo e(config('iceworm.dx_agents')); ?>.last_name'},
                    {data: 'phone', name: '<?php echo e(config('iceworm.dx_agents')); ?>.phone'},
                    {data: 'mobile', name: '<?php echo e(config('iceworm.dx_agents')); ?>.mobile'},
                    {data: 'email', name: '<?php echo e(config('iceworm.dx_agents')); ?>.email'},
                    {data: 'agency_id', name: '<?php echo e(config('iceworm.dx_agents')); ?>.agency_id'},
                    {data: 'status', name: '<?php echo e(config('iceworm.dx_agents')); ?>.status'},
                        <?php if(!access()->hasRole('Administrator')): ?>
                    {
                        data: 'actions', name: 'actions', searchable: false, sortable: false
                    }
                    <?php endif; ?>
                ],
                order: [[0, "asc"]],
                searchDelay: 100
            });
        });
    </script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('backend.layouts.app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>