<?php $__env->startSection('title', trans('Invoice')); ?>

<?php $__env->startSection('after-styles'); ?>
    <?php echo e(Html::style("css/backend/plugin/datatables/dataTables.bootstrap.min.css")); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-header'); ?>
    <h1>
        <?php echo e(trans('Invoice')); ?>

        <small><?php echo e(trans('labels.backend.title.promo.active')); ?></small>
    </h1>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <div class="col-md-12">
        <?php echo e(Form::open(['route' => 'admin.superadmin.get', 'class' => '', 'role' => 'form', 'method' => 'get' , 'enctype' => 'multipart/form-data'])); ?>

        <?php echo e(Form::selectGroupFullWidth('agency_id', trans('Agency'), 'info', $agency, null, [])); ?>

        <?php echo e(Form::textGroup('startdate', trans('Start Date'), 'calendar', ['placeholder' => trans('Start Date')])); ?>

        <?php echo e(Form::textGroup('enddate', trans('End Date'), 'calendar', ['placeholder' => trans('End Date')])); ?>

    </div>

    <div class="col-md-12">
        <div class="box box-success">
            <div class="box box-info">
                <div class="box-body">
                    <div class="pull-left">
                    </div><!--pull-left-->
                    <div class="pull-right">
                        <?php echo e(Form::submit(trans('Get Invoice'), ['class' => 'btn btn-success btn-md'])); ?>

                    </div><!--pull-right-->
                    <div class="clearfix"></div>
                </div><!-- /.box-body -->
            </div>
        </div>
    </div>
    <?php echo e(Form::close()); ?>

    <?php if($check==1): ?>
        <legend class="scheduler-border"><?php echo e(trans('Agency Details')); ?></legend>
        <div class="col-md-12">
            <div class="box box-success">
                <div class="box-body">
                    <table class="table table-hover" style="margin-top: 10px;">
                        <thead>
                        <tr>
                            <th>Agency Name</th>
                            <th>Phone</th>
                            <th>Email</th>
                            <th>Website</th>
                        </tr>
                        </thead>
                        <tbody>
                        <tr>
                            <td><?php echo e($agencydetails->agency_name); ?></td>
                            <td><?php echo e($agencydetails->phone); ?></td>
                            <td><?php echo e($agencydetails->email); ?></td>
                            <td><?php echo e($agencydetails->website); ?></td>
                        </tr>
                        </tbody>
                    </table>
                    <legend class="scheduler-border"><?php echo e(trans('Agents')); ?></legend>
                    <div class="col-md-6">
                        <div class="col-md-6">
                            
                            <div class="table-responsive">
                                <table class="table table-hover" style="margin-top: 10px;">
                                    <?php $__currentLoopData = $agents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $agent): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <th><?php echo e($agent->first_name); ?> <?php echo e($agent->last_name); ?></th>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </table>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="col-md-6">
                            
                            <div class="table-responsive">
                                <table class="table table-hover" style="margin-top: 10px;">
                                    <?php $__currentLoopData = $agents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $agent): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <th><?php echo e($agent->email); ?></th>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </table>
                            </div>
                        </div>
                    </div>
                    <legend class="scheduler-border"><?php echo e(trans('Transfers')); ?></legend>
                    <div class="col-md-12">
                        <div class="col-md-12">
                            
                            <div class="table-responsive">
                                <table class="table table-hover" style="margin-top: 10px;">
                                    
                                    <tr>
                                        <th>Total Numbers of Transfers: <?php echo e($transfers); ?></th>
                                    </tr>
                                    
                                </table>
                            </div>
                        </div>
                    </div>
                    <legend class="scheduler-border"><?php echo e(trans('Account Balance')); ?></legend>
                    <div class="col-md-6">
                        <div class="col-md-6">
                            
                            <div class="table-responsive">
                                <table class="table table-hover" style="margin-top: 10px;">
                                    
                                    <tr>
                                        <th>Total Account Blance
                                            is: USD <?php echo e($balance->balance); ?></th>
                                    </tr>
                                    
                                </table>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('after-scripts'); ?>

    <script>
        $('.invoice').click(function() {
            window.print();
        });
    </script>
    <script>
        $(document).ready(function () {
            $("#agency_id").select2({
                placeholder: "<?php echo e(trans('Select Agency', ['field' => trans('Agency')])); ?>"
            });
        });
    </script>

    <script>
        $(function () {
            $("#startdate").datepicker();
        });
    </script>

    <script>
        $(function () {
            $("#enddate").datepicker();
        });
    </script>

    <?php echo e(Html::script("js/backend/plugin/datatables/jquery.dataTables.min.js")); ?>

    <?php echo e(Html::script("js/backend/plugin/datatables/dataTables.bootstrap.min.js")); ?>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>