<?php $__env->startSection('title', trans('Wallet Management')); ?>

<?php $__env->startSection('after-styles'); ?>
    <?php echo e(Html::style("css/backend/plugin/datatables/dataTables.bootstrap.min.css")); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-header'); ?>
    <h1>
        <?php echo e(trans('Wallet Management')); ?>

        <small><?php echo e(trans('labels.backend.currency.active')); ?></small>
    </h1>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="box box-success">
        <div class="box-header with-border">
            <h3 class="box-title"><?php echo e(trans('labels.backend.currency.active')); ?></h3>
            <div class="box-tools pull-right">
                <?php echo $__env->make('backend.superadmin.currency.includes.partials.currency-header-buttons', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
            </div>
        </div>
        <div class="box-body">
            <div class="table-responsive">
                <table id="currency-table" class="table table-condensed table-hover">
                    <thead>
                    <tr>
                        <th><?php echo e(trans('Agency Name')); ?></th>
                        <th><?php echo e(trans('labels.backend.currency.table.currency_code')); ?></th>
                        <th><?php echo e(trans('Amount')); ?></th>
                        <th><?php echo e(trans('labels.backend.currency.table.created_at')); ?></th>
                    </tr>
                    </thead>
                </table>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('after-scripts'); ?>
    <?php echo e(Html::script("js/backend/plugin/datatables/jquery.dataTables.min.js")); ?>

    <?php echo e(Html::script("js/backend/plugin/datatables/dataTables.bootstrap.min.js")); ?>


    <script>
        $(function () {
            $('#currency-table').DataTable({
                processing: true,
                serverSide: true,
                ajax: {
                    url: '<?php echo e(route("admin.superadmin.currencyget.get")); ?>',
                    type: 'get'
                },
                columns: [
                    {data: 'agency_id', name: '<?php echo e(config('ubereat.currency')); ?>.agency_id'},
                    {
                        data: 'currency_code',
                        name: '<?php echo e(config('ubereat.currency')); ?>.currency_code',
                        render: $.fn.dataTable.render.text()
                    },
                    {data: 'amount', name: '<?php echo e(config('ubereat.currency')); ?>.amount'},
                    {data: 'created_at', name: '<?php echo e(config('ubereat.currency')); ?>.created_at'},
                ],
                order: [[0, "desc"]],
                searchDelay: 500
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>