<?php
//use App\Http\Controllers\Backend\Customers\Validleads\ValidleadsController;
/**
 * Global Routes
 * Routes that are used between both frontend and backend.
 */

// Switch between the included languages
Route::get('lang/{lang}', 'LanguageController@swap');
Route::get('usama', function (){
    phpinfo();
});
//Route::get('/contacts', 'ContactsController@get');

//Route::get('/home', 'HomeController@index')->name('home');

Route::get('/contacts', 'ContactsController@get');
Route::get('/unread/message', 'Backend\DashboardController@getUnreadMessageCount');
Route::get('/conversation/{id}', 'ContactsController@getMessagesFor');
Route::post('/conversation/send', 'ContactsController@send');
/* ----------------------------------------------------------------------- */

/*
 * Frontend Routes
 * Namespaces indicate folder structure
 */
Route::group(['namespace' => 'Frontend', 'as' => 'frontend.'], function () {
    includeRouteFiles(__DIR__.'/Frontend/');
});


/* ----------------------------------------------------------------------- */

//Route::get('agentop/{id}', [ValidleadsController::class, 'mydata'])->name('agentop');
//Route::get('agencyop/{id}', [ValidleadsController::class, 'mydataagencyop'])->name('agencyop');

Route::get('checkout', array('as' => 'paypal.paywithpaypal','uses' => 'PaypalController@payWithPaypal',));
Route::get('paypal', array('as' => 'payment.status','uses' => 'PaypalController@getPaymentStatus',));

Route::get('mercado','MercadoPagoController@getCreatePreference')->name('mercado');

// Route for stripe payment form.
Route::get('stripe', 'FrontendController@check')->name('stripform');




// Get Route For Show Payment Form
Route::get('paywithrazorpay', 'RazorpayController@payWithRazorpay')->name('paywithrazorpay');
// Post Route For Makw Payment Request
Route::post('payment', 'RazorpayController@payment')->name('payment');


/*
 * Backend Routes
 * Namespaces indicate folder structure
 */



Route::group(['namespace' => 'Backend', 'prefix' => 'admin', 'as' => 'admin.', 'middleware' => 'admin'], function () {
    /*
     * These routes need view-backend permission
     * (good if you want to allow more than one group in the backend,
     * then limit the backend features by different roles or permissions)
     *
     * Note: Administrator has all permissions so you do not have to specify the administrator role everywhere.
     */
    includeRouteFiles(__DIR__.'/Backend/');
});
