<?php

use Illuminate\Http\Request;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/
Route::post('login','ApiController@login')->name('login');



Route::post('password_reset','ApiController@password_reset')->name('password_reset');

Route::group(['middleware' => ['web', 'auth']], function(){

    Route::get('/vehicle', 'ApiController@vehicle');

});


Route::post('profile_update','ApiController@profile_update')->name('profile_update');

Route::get('get_job/{id}/{user_id}','ApiController@get_job')->name('get_job');

Route::get('save_device/{device_id}/{user_id}','ApiController@save_device')->name('save_device');

Route::get('job_completed/{id}/{job_completed}','ApiController@job_completed')->name('job_completed');

Route::get('get_data','ApiController@get_data')->name('get_data');

Route::get('assign_job/{id}','ApiController@assign_job')->name('assign_job');

Route::get('get_profile/{id}','ApiController@get_profile')->name('get_profile');

