<?php

/**
 * Frontend Controllers
 * All route names are prefixed with 'frontend.'.
 */
Route::get('/', 'FrontendController@index')->name('index');
Route::get('macros', 'FrontendController@macros')->name('macros');
Route::get('contact', 'ContactController@index')->name('contact');
Route::post('contact/send', 'ContactController@send')->name('contact.send');

/*
 * These frontend controllers require the user to be logged in
 * All route names are prefixed with 'frontend.'
 */

Route::get('about','FrontendController@about')->name('about');
Route::get('tracking','FrontendController@tracking')->name('tracking');
Route::get('pricing','FrontendController@pricing')->name('pricing');
Route::get('contact','FrontendController@contact')->name('contact');
Route::get('blog','FrontendController@blog')->name('blog');
Route::get('pages','FrontendController@pages')->name('pages');
Route::get('signup','FrontendController@signup')->name('signup');
Route::get('register/{id}', 'FrontendController@showRegistrationForm')->name('register');
Route::get('sms','FrontendController@sms')->name('sms');
Route::get('sms_post','FrontendController@sms_post')->name('sms.post');
Route::get('payment_selection','FrontendController@payment_method')->name('payment_selection');
Route::get('payment_method','FrontendController@payments')->name('payment_method');
Route::get('check','FrontendController@check')->name('check');

Route::get('thankyou','FrontendController@thankyou')->name('thankyou');

Route::post('paywithauthorize','AuthorizenetController@Card')->name('paywithauthorize');

Route::post('paypal','PaypalController@postPaymentWithpaypal')->name('paypal.paypal');

Route::post('stripe', 'StripeController@postPaymentWithStripe')->name('paywithstripe');

Route::group(['middleware' => 'auth'], function () {
    Route::group(['namespace' => 'User', 'as' => 'user.'], function () {
        /*
         * User Dashboard Specific
         */
        Route::get('dashboard', 'DashboardController@index')->name('dashboard');

        /*
         * User Account Specific
         */
        Route::get('account', 'AccountController@index')->name('account');

        /*
         * User Profile Specific
         */
        Route::patch('profile/update', 'ProfileController@update')->name('profile.update');
    });
});
