@extends('frontend.layouts.app')

@section('content')

    <!-- Content Wrapper -->
    <article>
        <!-- Breadcrumb -->
        <section class="theme-breadcrumb pad-50">
            <div class="theme-container container ">
                <div class="row pb-100"></div>
                <div class="row">
                    <ol class="breadcrumb-menubar list-inline">
                        <li><a href="{{ route('frontend.index') }}" class="gray-clr">Home</a></li>
                        <li class="active">Pricing</li>
                    </ol>
                    <div class="col-md-12 pull-left">
                        <div class="title-wrap text-center">
                            <h2 class="section-title no-margin">Choose a Plan </h2><br>
                            <p class="fs-16 no-margin">No commitment, no hidden charges and no complications;
                                simple and transparent pricing. Your business is unique and our pricing structure is
                                flexible. Let's get started.</p>
                        </div>
                    </div>

                </div>
            </div>
        </section>
        <div class="container">
            <div class="row pb-50">
                @foreach($plans as $key=>$plan)
                    <div class="col-md-4 wow slideInUp" data-wow-offset="50" data-wow-delay=".30s">
                        <div class="pricing-box clrbg-before clrbg-after transition">
                            <div class="title-wrap text-center">
                                @if($currency_position->value=='left')
                                    @if($currency_space->value=='1')
                                        <h2 class="section-title fs-36">{{$currency_symbol->value}} {{$plan->price, $decimal_places->value}}</h2>
                                    @else
                                        <h2 class="section-title fs-36">{{$currency_symbol->value}}{{$plan->price, $decimal_places->value}}</h2>
                                    @endif
                                @else
                                    <h2 class="section-title fs-36">{{$plan->price}}{{$currency_symbol->value}}</h2>
                                @endif
                                <p>{{$plan->type}}</p>
                                <div class="btn-1">{{$plan->plan_name}}</div>
                            </div>
                            <div class="price-content">
                                <ul class="title-2">
                                    @if($currency_position->value=='left')
                                        @if($currency_space->value=='1')
                                            <li> Promo Price: <span class="gray-clr">{{$currency_symbol->value}} {{$plan->promoprice, $decimal_places->value}}</span></li>
                                        @else
                                            <li> Promo Price: <span class="gray-clr">{{$currency_symbol->value}} {{$plan->promoprice, $decimal_places->value}}</span></li>
                                        @endif
                                    @else
                                        <li> Promo Price: <span class="gray-clr">{{$plan->promoprice}}{{$currency_symbol->value}}</span></li>
                                    @endif
                                    <li> Drivers Allowed: <span class="gray-clr">{{$plan->drivercount}}</span> </li>
                                    <li> SMS Limit: <span class="gray-clr">{{$plan->smslimit}}</span> </li>
                                    {{--<li> Expiry Date: <span class="gray-clr">{{$plan->expiry}}</span> </li>--}}
                                </ul>
                            </div>
                            <div class="order">
                                <a href="{{ route('frontend.register',$plan->id) }}" class="title-1 theme-clr"> <span class="transition"> SignUp now </span> <i class="arrow_right fs-26"></i> </a>
                            </div>
                            <div class="pricing-hover clrbg-before clrbg-after transition"></div>
                        </div>
                        <div class="row pb-50"></div>
                    </div>
                @endforeach
            </div>
        </div>
        <!-- /.Pricing & Plans -->
    </article>
    <!-- /.Content Wrapper -->

    @include('frontend.includes.model.login_popup')

@endsection