@extends('frontend.layouts.app')

@section('content')
    <div class="container">
        <div class="row">
            <div class="row pb-100"></div>
            <div class="row pb-50"></div>
            <div class="col-md-4 col-md-offset-4">
                @if($message = Session::get('error'))
                    <div class="alert alert-danger alert-dismissible fade in" role="alert">
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">×</span>
                        </button>
                        <strong>Error!</strong> {{ $message }}
                    </div>
                @endif
                {!! Session::forget('error') !!}
                @if($message = Session::get('success'))
                    <div class="alert alert-info alert-dismissible fade in" role="alert">
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">×</span>
                        </button>
                        <strong>Success!</strong> {{ $message }}
                    </div>
                @endif
                {!! Session::forget('success') !!}
                <div class="panel panel-default">
                    <div class="panel-heading">Pay With Razorpay</div>
                    <div class="col-md-12">
                        <div class="col-md-6">
                            Plan:
                        </div>
                        <div class="col-md-6">
                            {{$plan->plan_name}}
                        </div>
                    </div>
                    <div class="col-md-12">
                        <div class="col-md-6">
                            Description:
                        </div>
                        <div class="col-md-6">
                            {{$plan->description}}
                        </div>
                    </div>
                    <div class="col-md-12">
                        <div class="col-md-6">
                            Price:
                        </div>
                        <div class="col-md-6">
                            Rs.{{$currency_symbol->value}} {{$plan->price}}
                        </div>
                    </div>
                    <div class="col-md-12">
                        <div class="col-md-6">
                            Your sms Limit:
                        </div>
                        <div class="col-md-6">
                            {{$plan->smslimit}}
                        </div>
                    </div>
                    <div class="col-md-12">
                        <div class="col-md-6">
                            Expiry Date:
                        </div>
                        <div class="col-md-6">
                            {{$plan->expiry}}
                        </div>
                    </div>
                    <div class="row">

                    </div>
                    <div class="panel-body text-center">
                        <form action="{!!route('payment')!!}" method="POST" >
                            <!-- Note that the amount is in paise = 50 INR -->
                            <script
                                    src="https://checkout.razorpay.com/v1/checkout.js"
                                    data-key="{{$rezorpay_key->value}}"
                                    {{--"rzp_test_YY5HNIJUE3gwyx"--}}
                                    data-amount="{{$plan->price}}00"
                                    data-currency="INR"
                                    data-buttontext="Pay with Razorpay: Rs.{{$currency_symbol->value}} {{$plan->price}}"
                                    data-name="{{$user->first_name}} {{$user->last_name}}"
                                    data-description="{{$plan->description}}"
                                    data-image="{{asset('style/img/logo-black.png')}}"
                                    data-email="support@razorpay.com"
                                    data-theme.color="#151515"
                            ></script>
                            <input type="hidden" value="Hidden Element" name="hidden">
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection