@extends('backend.layouts.app')
@section ('title', trans('labels.backend.gen_settings.smsgateway.title'))

@section('page-header')
    <h1>

        <small>{{ trans('labels.backend.gen_settings.smsgateway.title') }}</small>
    </h1>
@endsection
@section('after-styles')
    <link type="text/css" rel="stylesheet" href="{{asset('css/backend/plugin/nestedtabs/easy-responsive-tabs.css')}}">
@endsection
@section('content')

    <div class="box box-success">
        <div class="box-header with-border">
            <h3 class="box-title">{{ trans('labels.backend.gen_settings.smsgateway.title') }}</h3>

        </div><!-- /.box-header -->

        <div class="box-body">
            <div class="form-group">

                <div class="row">
                    {!! Form::model($setting, [
                        'method' => 'PATCH',
                        'url' => ['admin/superadmin/settings'],
                        'class' => 'setting-form',
                        'files' => true,
                        'role' => 'form'
                    ]) !!}

                    <div class="col-sm-12">
                        <div class="nav-tabs-custom">
                            <ul class="nav nav-tabs">
                                <li class="active"><a href="#smssettings" data-toggle="tab" aria-expanded="true">{{ trans('labels.backend.gen_settings.smsgateway.title1') }}</a></li>
                            </ul>
                            <div class="tab-content">
                                <div class="tab-pane tab-margin active" id="smssettings">
                                    <fieldset class="scheduler-border">
                                        <legend class="scheduler-border">{{ trans('labels.backend.gen_settings.smsgateway.title1') }}</legend>
                                        <div class="control-group">
                                            <div class="col-lg-12">
                                                <h4>
                                                    {{ Form::radio('twilio', 'Twilio') }}&nbsp;&nbsp;Twilio&nbsp;&nbsp;
                                                    {{ Form::radio('twilio', 'Nexmo') }}&nbsp;&nbsp;Nexmo
                                                </h4>
                                                <br>
                                            </div>
                                            <div class="col-md-12">
                                                <h4>Twilio</h4>
                                            </div>
                                            {{ Form::textGroup('sms_gateway.sender_id', trans('validation.attributes.backend.sms.sender_id'), 'id-card-o') }}
                                            {{ Form::textGroup('sms_gateway.account_sid', trans('validation.attributes.backend.sms.account_sid'), 'id-card') }}
                                            {{ Form::textGroup('sms_gateway.auth_token', trans('validation.attributes.backend.sms.auth_token'), 'btc') }}
                                            <div class="col-md-12">
                                                <h4>Nexmo</h4>
                                            </div>
                                            {{ Form::textGroup('sms_gateway.sender', trans('validation.attributes.backend.sms.sender'), 'info') }}
                                            {{ Form::textGroup('sms_gateway.key', trans('validation.attributes.backend.sms.key'), 'key') }}
                                            {{ Form::textGroup('sms_gateway.secret', trans('validation.attributes.backend.sms.secret'), 'user-secret') }}

                                             {{--{{ Form::radioGroup('sms_gateway.use_curl', trans('validation.attributes.backend.sms.use_curl')) }} --}}
                                             {{--{{ Form::radioGroup('sms_gateway.use_unicode', trans('validation.attributes.backend.sms.use_unicode')) }} --}}
                                        </div>
                                    </fieldset>
                                </div>
                                <div class="setting-buttons clearfix">
                                    <div class="form-group no-margin">
                                        {!! Form::button('<span class="fa fa-save"></span> &nbsp;' . trans('general.save'), ['type' => 'submit', 'class' => 'btn btn-success']) !!}
                                        <a href="{{ URL::previous() }}" class="btn btn-default"><span class="fa fa-times-circle"></span> &nbsp;{{ trans('general.cancel') }}</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    {!! Form::close() !!}
                </div>
            </div><!--form control-->
        </div><!-- /.box-body -->
    </div><!--box-->

@endsection

@section('after-scripts')

    <script>
        var text_yes = '{{ trans('general.yes') }}';
        var text_no = '{{ trans('general.no') }}';

        $(document).ready(function() {
           // debugger;
            $('#company_logo').fancyfile({
                text  : '{{ trans('general.form.select.file') }}',
                style : 'btn-default',
                placeholder : '<?php echo $setting->pull('company_logo'); ?>'
            });

            $("#date_format").select2({
                placeholder: "{{ trans('general.form.select.field', ['field' => trans('settings.localisation.date.format')]) }}"
            });

            $("#date_separator").select2({
                placeholder: "{{ trans('general.form.select.field', ['field' => trans('settings.localisation.date.separator')]) }}"
            });

            $("#timezone").select2({
                placeholder: "{{ trans('general.form.select.field', ['field' => trans('settings.localisation.timezone')]) }}"
            });

            $("#default_account").select2({
                placeholder: "{{ trans('general.form.select.field', ['field' => trans('settings.default.account')]) }}"
            });

            $("#default_currency").select2({
                placeholder: "{{ trans('general.form.select.field', ['field' => trans('settings.default.currency')]) }}"
            });

            $("#default_tax").select2({
                placeholder: "{{ trans('general.form.select.field', ['field' => trans('settings.default.tax')]) }}"
            });

            $("#default_payment_method").select2({
                placeholder: "{{ trans('general.form.select.field', ['field' => trans('settings.default.payment')]) }}"
            });

            $("#default_locale").select2({
                placeholder: "{{ trans('general.form.select.field', ['field' => trans('settings.default.language')]) }}"
            });

            $("#admin_theme").select2({
                placeholder: "{{ trans('general.form.select.field', ['field' => trans('settings.appearance.theme')]) }}"
            });

            $("#email_protocol").select2({
                placeholder: "{{ trans('general.form.select.field', ['field' => trans('settings.email.protocol')]) }}"
            });

            $("#list_limit").select2({
                placeholder: "{{ trans('general.form.select.field', ['field' => trans('settings.appearance.list_limit')]) }}"
            });

            $("#session_handler").select2({
                placeholder: "{{ trans('general.form.select.field', ['field' => trans('settings.system.session.handler')]) }}"
            });



            $('#invoice_logo').fancyfile({
                text  : '{{ trans('general.form.select.file') }}',
                style : 'btn-default',
                placeholder : '<?php echo $setting->pull('invoice_logo'); ?>'
            });

            $("select[name='email_protocol']").on('change', function() {
                var selection = $(this).val();

                if (selection == 'mail' || selection == 'log') {
                    $("input[name='email_sendmail_path']").prop('disabled', true);
                    $("input[name='email_smtp_host']").prop('disabled', true);
                    $("input[name='email_smtp_username']").prop('disabled', true);
                    $("input[name='email_smtp_password']").prop('disabled', true);
                    $("input[name='email_smtp_port']").prop('disabled', true);
                    $("select[name='email_smtp_encryption']").prop('disabled', true);
                }
                else if(selection == 'sendmail') {
                    $("input[name='email_sendmail_path']").prop('disabled', false);
                    $("input[name='email_smtp_host']").prop('disabled', true);
                    $("input[name='email_smtp_username']").prop('disabled', true);
                    $("input[name='email_smtp_password']").prop('disabled', true);
                    $("input[name='email_smtp_port']").prop('disabled', true);
                    $("select[name='email_smtp_encryption']").prop('disabled', true);
                }
                else if (selection == 'smtp') {
                    $("input[name='email_sendmail_path']").prop('disabled', true);
                    $("input[name='email_smtp_host']").prop('disabled', false);
                    $("input[name='email_smtp_username']").prop('disabled', false);
                    $("input[name='email_smtp_password']").prop('disabled', false);
                    $("input[name='email_smtp_port']").prop('disabled', false);
                    $("select[name='email_smtp_encryption']").prop('disabled', false);
                }
            });

            $("select[name='email_protocol']").trigger('change');
        });
    </script>
@stop
