@extends ('backend.layouts.app')

@section ('title', trans('Agency') . ' | ' . trans('labels.backend.title.plan.create'))
{{--{{dd('opkodkaopsd')}}--}}
@section('page-header')
    <h1>
        {{ trans('Agency Management') }}
        <small>{{ trans('labels.backend.title.plan.create') }}</small>
    </h1>
@endsection

@section('content')
    {{ Form::open(['route' => 'admin.superadmin.plans.store', 'class' => '', 'role' => 'form', 'method' => 'post' , 'enctype' => 'multipart/form-data']) }}

    <div class="box box-success">
        <div class="box-header with-border">
            <h3 class="box-title">{{ trans('labels.backend.title.plan.create') }}</h3>
            <div class="box-tools pull-right">
                @include('backend.superadmin.plans.includes.partials.plans-header-buttons')
            </div>
        </div>
        <div class="box-body">
            <div class="control-group">
                {{ Form::textGroup('agency_name', trans('Agency Name'), 'info', ['placeholder' => trans('Agency Name')]) }}
                {{ Form::textGroup('phone', trans('Phone'), 'phone', ['placeholder' => trans('Phone')]) }}
                {{ Form::textGroup('email', trans('Emial'), 'envelope', ['placeholder' => trans('Email')]) }}
                {{ Form::textGroup('website', trans('Website'), 'globe', ['placeholder' => trans('Website')]) }}
                {{ Form::textGroup('transection_price', trans('Transection Price'), 'money', ['placeholder' => trans('Transection Price')]) }}
            </div>
        </div>
    </div>
        <div class="box box-info">
            <div class="box-body">
                <div class="pull-left">
                    {{ link_to_route('admin.superadmin.plans.index', trans('buttons.general.cancel'), [], ['class' => 'btn btn-danger btn-md']) }}
                </div>
                
                <div class="pull-right">
                    {{ Form::submit(trans('buttons.general.crud.create'), ['class' => 'btn btn-success btn-md']) }}
                </div>
                <div class="clearfix"></div>
            </div>
        </div>
    {{ Form::close() }}
@stop

@section('after-scripts')

    <script>
        var text_yes = '{{ trans('general.yes') }}';
        var text_no = '{{ trans('general.no') }}';

        $(document).ready(function() {

            $("#type").select2({
                placeholder: "{{ trans('Day', ['field' => trans('general.generalstrings.type')]) }}"
            });

            $("#drivercount").select2({
                placeholder: "{{ trans('validation.attributes.backend.plan.numberofdriver', ['field' => trans('validation.attributes.backend.plan.numberofdriver')]) }}"});
            
            
            $("#allowedtask").select2({
                placeholder: "{{ trans('validation.attributes.backend.plan.allowedtask', ['field' => trans('validation.attributes.backend.plan.allowedtask')]) }}"});

            $("#status").select2({
                placeholder: "{{ trans('Published', ['field' => trans('general.generalstrings.status')]) }}"
            });
        });
    </script>

@stop
