<aside class="main-sidebar">

    <!-- sidebar: style can be found in sidebar.less -->

    <section class="sidebar">

        <!-- Sidebar user panel (optional) -->

        <div class="user-panel">

            <div class="pull-left image">

                <img src="{{ access()->user()->picture }}" class="img-circle" alt="User Image" />

            </div><!--pull-left-->

            <div class="pull-left info">

                <p>{{ access()->user()->full_name }}</p>

                <!-- Status -->

                <a href="#"><i class="fa fa-circle text-success"></i> {{ trans('strings.backend.general.status.online') }}</a>

            </div><!--pull-left-->

        </div><!--user-panel-->



        <!-- search form (Optional) -->

        <!-- Sidebar Menu -->

        <ul class="sidebar-menu">

            @if(access()->hasRole('Administrator'))

            <li class="{{ active_class(Active::checkUriPattern('admin/dashboard')) }}">

                <a href="{{ route('admin.dashboard') }}">

                    <i class="fa fa-dashboard"></i>

                    <span>{{ trans('menus.backend.sidebar.dashboard') }}</span>

                </a>

            </li>
            @role(1)

                <li class="{{ active_class(Active::checkUriPattern('admin/access/user*')) }}">

                    <a href="{{ route('admin.access.user.index') }}">

                        <i class="fa fa-circle-o"></i>

                        <span>{{ trans('labels.backend.access.users.management') }}</span>



                        @if ($pending_approval > 0)

                            <span class="label label-danger pull-right">{{ $pending_approval }}</span>

                        @endif

                    </a>

                </li>

            <li class="{{ active_class(Active::checkUriPattern('admin/superadmin/plans')) }}">

                <a href="{{ route('admin.superadmin.plans.index') }}">

                    <i class="fa fa-cog" aria-hidden="true"></i>

                    <span>{{ trans('Agencies') }}</span>

                </a>

            </li>

            <li class="{{ active_class(Active::checkUriPattern('admin/superadmin/currency')) }}">

            <a href="{{ route('admin.superadmin.currency.index') }}">

            <i class="fa fa-cog" aria-hidden="true"></i>

            <span>{{ trans('Wallet') }}</span>

            </a>

            </li>

            <li class="{{ active_class(Active::checkUriPattern('admin/superadmin/agents')) }}">

                <a href="{{ route('admin.superadmin.agents.index') }}">

                    <i class="fa fa-user-secret" aria-hidden="true"></i>

                    <span>{{ trans('menus.backend.sidebar.agents') }}</span>

                </a>

            </li>

            <li class="{{ active_class(Active::checkUriPattern('admin/superadmin/leads')) }}">

                <a href="{{ route('admin.superadmin.leads.index') }}">

                    <i class="fa fa-file" aria-hidden="true"></i>

                    <span>{{ trans('Import File') }}</span>

                </a>

            </li>

                <li class="{{ active_class(Active::checkUriPattern('admin/superadmin/reports')) }}">

                    <a href="{{ route('admin.superadmin.reports.index') }}">

                        <i class="fa fa-circle-o"></i>

                        <span>{{ trans('menus.backend.sidebar.report') }}</span>

                    </a>

                </li>

            @endif

            @endauth



            @if(!access()->hasRole('Administrator') && access()->hasRole('Caller'))

                <li class="{{ active_class(Active::checkUriPattern('admin/dashboard')) }}">

                    <a href="{{ route('admin.dashboard') }}">

                        <i class="fa fa-dashboard"></i>

                        <span>{{ trans('menus.backend.sidebar.dashboard') }}</span>

                    </a>

                </li>

                <li class="{{ active_class(Active::checkUriPattern('admin/customers/agents')) }}">

                    <a href="{{ route('admin.customers.agents.index') }}">

                        <i class="fa fa-user-o" aria-hidden="true"></i>

                        <span>{{ trans('Agents') }}</span>

                    </a>

                </li>

                <li class="{{ active_class(Active::checkUriPattern('admin/customers/leads')) }}">

                    <a href="{{ route('admin.customers.leads.index') }}">

                        <i class="fa-address-book" aria-hidden="true"></i>

                        <span>{{ trans('Unverified Leads') }}</span>

                    </a>

                </li>

                <li class="{{ active_class(Active::checkUriPattern('admin/customers/validleads')) }}">

                    <a href="{{ route('admin.customers.validleads.index') }}">

                        <i class="fa-address-book" aria-hidden="true"></i>

                        <span>{{ trans('verified Leads') }}</span>

                    </a>

                </li>

                <li class="{{ active_class(Active::checkUriPattern('admin/customers/settings')) }}">

                    <a href="{{ route('admin.customers.settings.index') }}">

                        <i class="fa-address-book" aria-hidden="true"></i>

                        <span>{{ trans('Setting') }}</span>

                    </a>

                </li>

            @endif



            @if(!access()->hasRole('Administrator') && access()->hasRole('Agent'))

                <li class="{{ active_class(Active::checkUriPattern('admin/dashboard')) }}">

                    <a href="{{ route('admin.dashboard') }}">

                        <i class="fa fa-dashboard"></i>

                        <span>{{ trans('menus.backend.sidebar.dashboard') }}</span>

                    </a>

                </li>

                <li class="{{ active_class(Active::checkUriPattern('admin/agents/leads')) }}">

                    <a href="{{ route('admin.agents.leads.index') }}">

                        <i class="fa-address-book" aria-hidden="true"></i>

                        <span>{{ trans('My Leads') }}</span>

                    </a>

                </li>

                @endif

            <li class="{{ active_class(Active::checkUriPattern('admin/agents/leads')) }}">

                <a href="{{ URL::route('admin.superadmin.chat') }}"

                   onclick="window.open('{{ URL::route('admin.superadmin.chat') }}',

                           'newwindow',

                           'width=700,height=700');

                           return false;"

                ><i class="fa fa-comments-o" aria-hidden="true"></i> Chat NOW</a>

            </li>

        </ul><!-- /.sidebar-menu -->

    </section><!-- /.sidebar -->



</aside>