@extends('backend.layouts.app')

@section('page-header')
    <h1>
        {{ app_name() }}
        <small></small>
    </h1>
@endsection

@section('content')

    @if(access()->hasRole('Caller'))

    <section class="content">
        <!-- Small boxes (Stat box) -->
        <div class="row">
            <div class="col-lg-3 col-xs-6">
                <!-- small box -->
                <div class="small-box bg-aqua">
                    <div class="inner">
                        <h3>{{$unvarifyleads}}</h3>

                        <p>Total Number of Unvarefied Leads</p>
                    </div>
                    <div class="icon">
                        <i class="ion ion-bag"></i>
                    </div>
                </div>
            </div>
            <!-- ./col -->
            <div class="col-lg-3 col-xs-6">
                <!-- small box -->
                <div class="small-box bg-green">
                    <div class="inner">
                        <h3>{{$validleads}}</h3>
                        {{--<sup style="font-size: 20px">%</sup>--}}
                        <p>Total Numbers of Valid Leads</p>
                    </div>
                    <div class="icon">
                        <i class="ion ion-stats-bars"></i>
                    </div>
                </div>
            </div>
            <!-- ./col -->

            <div class="col-lg-3 col-xs-6">
                <!-- small box -->
                <div class="small-box bg-red">
                    <div class="inner">
                        <h3>{{$transfers}}</h3>

                        <p>Total Numbers of Leads Transfers</p>
                    </div>
                    <div class="icon">
                        <i class="ion ion-pie-graph"></i>
                    </div>
                </div>
            </div>
            <!-- ./col -->
        </div>
        <div class="row">
            <!-- Left col -->
            <section class="col-lg-12 connectedSortable">
                <!-- Custom tabs (Charts with tabs)-->
                <center>
                    {!! $chart->html() !!}
                </center>
            </section>
        </div>
    </section>
@endif
    @if(access()->hasRole('Agent'))

        <section class="content">
            <!-- Small boxes (Stat box) -->
            <div class="row">
                <div class="col-lg-3 col-xs-6">
                    <!-- small box -->
                    <div class="small-box bg-aqua">
                        <div class="inner">
                            <h3>{{$transfers}}</h3>

                            <p>Total Number of My Leads</p>
                        </div>
                        <div class="icon">
                            <i class="ion ion-bag"></i>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row">
                <!-- Left col -->
                <section class="col-lg-12 connectedSortable">
                    <!-- Custom tabs (Charts with tabs)-->
                    <center>
                        {!! $chart->html() !!}
                    </center>
                </section>
            </div>

        </section>
    @endif


@endsection
@section('after-scripts')
{{--    @if(access()->hasRole('Agent'))--}}
    {!! Charts::scripts() !!}
    {!! $chart->script() !!}
    {{--@endif--}}
@endsection

