@extends ('backend.layouts.app')

@section ('title', trans('Leads Management') . ' | ' . trans('Details'))

@section('page-header')
    <h1>
        {{ trans('Leads Management') }}
        <small>{{ trans('') }}</small>
    </h1>
@endsection
{{--{{dd($result)}}--}}
@section('content')
{{--    {{ Form::model($result, ['route' => ['admin.customers.leads.update', $result->id], 'class' => '', 'role' => 'form', 'method' => 'PATCH']) }}--}}

    <div class="box box-success">
        <div class="box-header with-border">
            <h3 class="box-title">{{ trans('Validate') }}</h3>

            <div class="box-tools pull-right">
                {{--@include('backend.customers.leads.includes.partials.contacts-header-buttons')--}}
            </div><!--box-tools pull-right-->
        </div><!-- /.box-header -->

        <div class="box-body">
            <div class="control-group">
                <div class="col-md-6">
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <tr>
                                <th>@lang('First Name')</th>
                                <td>{{ $result->fname }}</td>
                            </tr>
                            <tr>
                                <th>@lang('Last Name')</th>
                                <td>{{ $result->lname }}</td>
                            </tr>
                            <tr>
                                <th>@lang('Primary Phone')</th>
                                <td>{{ $result->pphone }}</td>
                            </tr>
                            <tr>
                                <th>@lang('Secondry Phone')</th>
                                <td>{{ $result->sphone }}</td>
                            </tr>
                            <tr>
                                <th>@lang('Email')</th>
                                <td>{{ $result->email }}</td>
                            </tr>
                            <tr>
                                <th>@lang('Address')</th>
                                <td>{{ $result->address }}</td>
                            </tr>
                            <tr>
                                <th>@lang('City')</th>
                                <td>{{ $result->city }}</td>
                            </tr>
                            <tr>
                                <th>@lang('State')</th>
                                <td>{{ $result->state }}</td>
                            </tr>
                            <tr>
                                <th>@lang('Zip')</th>
                                <td>{{ $result->zip }}</td>
                            </tr>
                            <tr>
                                <th>@lang('Gender')</th>
                                <td>{{ $result->gender }}</td>
                            </tr>
                            <tr>
                                <th>@lang('Birthday')</th>
                                <td>{{ $result->birthdate }}</td>
                            </tr>
                            <tr>
                                <th>@lang('Age')</th>
                                <td>{{ $result->age }}</td>
                            </tr>
                            <tr>
                                <th>@lang('Self Assessed Credit')</th>
                                <td>{{ $result->self_assessed_credit }}</td>
                            </tr>
                            <tr>
                                <th>@lang('Home Type')</th>
                                <td>{{ $result->home_type }}</td>
                            </tr>
                            <tr>
                                <th>@lang('Year Built')</th>
                                <td>{{ $result->year_built }}</td>
                            </tr>
                            <tr>
                                <th>@lang('Square Feet')</th>
                                <td>{{ $result->square_feet }}</td>
                            </tr>
                            <tr>
                                <th>@lang('Bedrooms')</th>
                                <td>{{ $result->bedrooms }}</td>
                            </tr>
                            <tr>
                                <th>@lang('Bathrooms')</th>
                                <td>{{ $result->bathrooms }}</td>
                            </tr>
                            <tr>
                                <th>@lang('Construction Type')</th>
                                <td>{{ $result->construction_type }}</td>
                            </tr>
                            <tr>
                                <th>@lang('Roof Surface')</th>
                                <td>{{ $result->roof_surface }}</td>
                            </tr>
                            <tr>
                                <th>@lang('Foundation Type')</th>
                                <td>{{ $result->foundation_type }}</td>
                            </tr>
                            <tr>
                                <th>@lang('Exterior Walls')</th>
                                <td>{{ $result->exterior_walls }}</td>
                            </tr>
                            <tr>
                                <th>@lang('Garage Type')</th>
                                <td>{{ $result->garage_type }}</td>
                            </tr>
                            <tr>
                                <th>@lang('Total Stories')</th>
                                <td>{{ $result->total_stories }}</td>
                            </tr>
                            <tr>
                                <th>@lang('Electrical System')</th>
                                <td>{{ $result->electrical_system }}</td>
                            </tr>
                            <tr>
                                <th>@lang('Fire Places')</th>
                                <td>{{ $result->fireplaces }}</td>
                            </tr>
                            <tr>
                                @if($result->isvalidated == 1)
                                <th>@lang('Validate')</th>
                                <td>Valid Lead</td>
                                    @endif
                            </tr>


                        </table>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <tr>
                                <th>@lang('Pool')</th>
                                <td>{{ $result->pool }}</td>
                            </tr>
                            <tr>
                                <th>@lang('Patio Deck')</th>
                                <td>{{ $result->patio_deck }}</td>
                            </tr>
                            <tr>
                                <th>@lang('Alarm')</th>
                                <td>{{ $result->alarm }}</td>
                            </tr>
                            <tr>
                                <th>@lang('Central AC')</th>
                                <td>{{ $result->central_ac }}</td>
                            </tr>
                            <tr>
                                <th>@lang('Dead Bolt')</th>
                                <td>{{ $result->dead_bolt }}</td>
                            </tr>
                            <tr>
                                <th>@lang('Smoke Detector')</th>
                                <td>{{ $result->smoke_detector }}</td>
                            </tr>
                            <tr>
                                <th>@lang('Fire Extinguisher')</th>
                                <td>{{ $result->fire_extinguisher }}</td>
                            </tr>
                            <tr>
                                <th>@lang('Smoker in Home')</th>
                                <td>{{ $result->smoker_in_home }}</td>
                            </tr>
                            <tr>
                                <th>@lang('Dog in Home')</th>
                                <td>{{ $result->dog_in_home }}</td>
                            </tr>
                            <tr>
                                <th>@lang('Near Fire Station')</th>
                                <td>{{ $result->near_fire_station }}</td>
                            </tr>
                            <tr>
                                <th>@lang('Near Fire Hydrant')</th>
                                <td>{{ $result->near_fire_hydrant }}</td>
                            </tr>
                            <tr>
                                <th>@lang('Currently Insured')</th>
                                <td>{{ $result->currently_insured }}</td>
                            </tr>
                            <tr>
                                <th>@lang('Current Carrier')</th>
                                <td>{{ $result->current_carrier }}</td>
                            </tr>
                            <tr>
                                <th>@lang('Residence Coverage Amount')</th>
                                <td>{{ $result->residence_coverage_amount }}</td>
                            </tr>
                            <tr>
                                <th>@lang('Personal Property Amount')</th>
                                <td>{{ $result->personal_property_amount }}</td>
                            </tr>
                            <tr>
                                <th>@lang('Personal Liability Amount')</th>
                                <td>{{ $result->personal_liability_amount }}</td>
                            </tr>
                            <tr>
                                <th>@lang('Deductible Amount')</th>
                                <td>{{ $result->deductible_amount }}</td>
                            </tr>
                            <tr>
                                <th>@lang('Years Continuously Covered')</th>
                                <td>{{ $result->years_continuously_covered }}</td>
                            </tr>
                            <tr>
                                <th>@lang('Policy Expiration')</th>
                                <td>{{ $result->policy_expiration }}</td>
                            </tr>
                            <tr>
                                <th>@lang('Property Address')</th>
                                <td>{{ $result->property_address }}</td>
                            </tr>
                            <tr>
                                <th>@lang('Property City')</th>
                                <td>{{ $result->property_city }}</td>
                            </tr>
                            <tr>
                                <th>@lang('Property State')</th>
                                <td>{{ $result->property_state }}</td>
                            </tr>
                            <tr>
                                <th>@lang('Property Zip')</th>
                                <td>{{ $result->property_zip }}</td>
                            </tr>
                            <tr>
                                <th>@lang('Property Use')</th>
                                <td>{{ $result->property_use }}</td>
                            </tr>
                            <tr>
                                <th>@lang('Home Value')</th>
                                <td>{{ $result->home_value }}</td>
                            </tr>
                            @if($result->isverfied == 1)
                            <tr>
                                <th>@lang('Verified')</th>
                                <td>Verified Lead</td>
                            </tr>
                                @endif
                        </table>
                    </div>
                </div>
            </div>
        </div><!-- /.box-body -->
    </div><!--box-->

    <div class="box box-info">
        <div class="box-body">
            <div class="pull-left">
                {{ link_to_route('admin.customers.leads.index', trans('Back'), [], ['class' => 'btn btn-danger btn-md']) }}
            </div><!--pull-left-->
            <div class="clearfix"></div>
        </div><!-- /.box-body -->
    </div><!--box-->
@stop