@extends ('backend.layouts.app')

@section ('title', trans('Leads Management'))

@section('after-styles')
    {{ Html::style("css/backend/plugin/datatables/dataTables.bootstrap.min.css") }}
@stop

@section('page-header')
    <h1>
        {{ trans('Leads Management') }}
        <small>{{ trans('labels.backend.contacts.active') }}</small>
    </h1>
@endsection

@section('content')
    <div class="box box-success">
        <div class="box-header with-border">
            <h3 class="box-title">{{ trans('labels.backend.contacts.active') }}</h3>

            <div class="box-tools pull-right">
                {{--                @include('backend.customers.leads.includes.partials.contacts-header-buttons')--}}
            </div><!--box-tools pull-right-->
        </div><!-- /.box-header -->

        <div class="box-body">
            <div class="table-responsive">
                <table id="contacts-table" class="table table-condensed table-hover">
                    <thead>
                    <tr>
                        {{--                        <th>{{ trans('labels.backend.contacts.table.id') }}</th>--}}
                        <th>{{ trans('First Name') }}</th>
                        <th>{{ trans('Last Name') }}</th>
                        <th>{{ trans('Phone') }}</th>
                        <th>{{ trans('Email') }}</th>
                        {{--                        <th>{{ trans('labels.backend.contacts.table.status') }}</th>--}}

                        <th>{{ trans('labels.general.actions') }}</th>
                    </tr>
                    </thead>
                </table>
            </div><!--table-responsive-->
        </div><!-- /.box-body -->
    </div><!--box-->

@stop

@section('after-scripts')
    {{ Html::script("js/backend/plugin/datatables/jquery.dataTables.min.js") }}
    {{ Html::script("js/backend/plugin/datatables/dataTables.bootstrap.min.js") }}

    <script>
        $(function() {
            $('#contacts-table').DataTable({
                processing: true,
                serverSide: true,
                ajax: {
                    url: '{{ route("admin.customers.tasksget.get") }}',
                    type: 'get'
                },
                columns: [
                        {{--{data: 'id', name: '{{config('ubereat.contacts')}}.id'},--}}
                    {data: 'fname', name: '{{config('ubereat.contacts')}}.fname', render: $.fn.dataTable.render.text()},
                    {data: 'lname', name: '{{config('ubereat.contacts')}}.lname'},
                    {data: 'pphone', name: '{{config('ubereat.contacts')}}.pphone'},
                    {data: 'email', name: '{{config('ubereat.contacts')}}.email'},
                        {{--{data: 'status', name: '{{config('ubereat.contacts')}}.status'},--}}
                    {data: 'actions', name: 'actions', searchable: false, sortable: false}
                ],
                order: [[0, "asc"]],
                searchDelay: 500
            });
        });
    </script>
@stop
