@extends ('backend.layouts.app')
@section ('title', trans('labels.backend.tasks.management') . ' | ' . trans('labels.backend.title.promo.create'))
@section('page-header')
    <h1>
        {{ trans('Task') }}
        <small>{{ trans('labels.backend.title.promo.create') }}</small>
    </h1>
@endsection
@section('content')
    {{ Form::open(['route' => 'admin.customers.tasks.store', 'class' => '', 'role' => 'form', 'method' => 'post' , 'enctype' => 'multipart/form-data']) }}
    <div class="box box-success">
        <div class="box-header with-border">
            <h3 class="box-title">{{ trans('labels.backend.title.promo.create') }}</h3>
            <div class="box-tools pull-right">
            </div>
        </div><!-- /.box-header -->
        <div class="box-body">
            @if($sms <= 10)
                {{ Form::label('name', 'Your SMS Limit about to end') }}
                &nbsp;&nbsp;&nbsp;&nbsp;
                {{ Form::label('name', 'Your Remaining SMS') }}
                <b>{{$sms}}</b>
                @endif
            <div class=" col-sm-12">
                <div class="control-group col-sm-6">
                    {{ Form::textGroup('phone', trans('validation.attributes.backend.tasks.customer_number'), 'mobile', ['placeholder' => trans('validation.attributes.backend.tasks.customer_number')]) }}
                    {{ Form::textGroup('restaurant_name', trans('validation.attributes.backend.tasks.restaurant_name'), 'info', ['placeholder' => trans('validation.attributes.backend.tasks.restaurant_name')]) }}
                    {{ Form::textGroupFullWidth('datepicker', trans('validation.attributes.backend.tasks.datepicker'), 'calendar', ['placeholder' => trans('validation.attributes.backend.tasks.datepicker')]) }}
                    {{ Form::textGroupFullWidth('delivery_address', trans('validation.attributes.backend.tasks.delivery_address'), 'map-marker', ['placeholder' => trans('validation.attributes.backend.tasks.delivery_address')]) }}
                </div>
                <div class="control-group col-sm-6">
                <div class="">
                    <div >

                <style>
                #map {
                height:400px;
                width: 100%;
                position: fixed;
                float:left;
                margin-left:15px;}

                </style>

                <div id="map"></div>
                </div><!-- /.box-header -->

                </div><!--box-->
                </div>
            </div></div>
        <div class="box-body">
            <div class=" col-sm-12">
                <div class="control-group col-sm-6">
                    @if($disable_contact_task->value==0)
                    {{ Form::selectGroupFullWidth('mydata', trans('validation.attributes.backend.tasks.cus_name'), 'info', $fullname, null, []) }}
                    @endif
                    {{ Form::textGroup('cus_phone', trans('validation.attributes.backend.tasks.customer_number'), 'mobile', ['placeholder' => trans('validation.attributes.backend.tasks.customer_number')]) }}
                    {{ Form::textGroup('cus_name', trans('validation.attributes.backend.tasks.name'), 'info', ['placeholder' => trans('validation.attributes.backend.tasks.name')]) }}
                    {{ Form::textGroup('cus_address', trans('validation.attributes.backend.tasks.delivery_address'), 'map-marker', ['placeholder' => trans('validation.attributes.backend.tasks.delivery_address')]) }}
                    {{ Form::selectGroup('team', trans('validation.attributes.backend.tasks.select_team'), 'info', $teams, null, []) }}
                </div>
                    <div class="control-group col-sm-6">
                        <div class="">
                            <div >
                                <style>
                                    #map2 {
                                        height:400px;
                                        width: 100%;
                                        position: fixed;
                                        float:left;
                                        margin-left:15px;
                                        background: #b3ffcc;
                                    }
                                </style>
                                <div id="map2">   </div>
                            </div><!-- /.box-header -->
                        </div><!--box-->
                    </div>
            </div>
        </div>
    </div>
    <div class="box box-info">
        <div class="box-body">
            <div class="pull-left">
            </div><!--pull-left-->
            <div class="pull-right">
                {{ Form::submit(trans('buttons.general.crud.create'), ['class' => 'btn btn-success btn-md']) }}
            </div><!--pull-right-->
            <div class="clearfix"></div>
        </div><!-- /.box-body -->
    </div><!--box-->

    {{ Form::close() }}
@stop

@section('after-scripts')
    <script>
        $(function(){
            $('#mydata').on('change',function(){

                console.log($(this).val());
                var id= $(this).val();


                $.ajax({
                    method: "GET",
                    url: '{{url('admin/customers/infoget') }}'+'/'+id
                }).done(function( msg ) {

                    $('#cus_phone').val(msg.phone);
                    $('#cus_name').val(msg.fullname);
                    $('#cus_address').val(msg.address);
                    var lat=(msg.lat);
                    var lng=(msg.lng);
                    initMap(lat , lng);
                });
            });

            function initMap(lat , lng) {
                console.log(lat);
                console.log(lng);
                var uluruu = new google.maps.LatLng(lat , lng);
                var map2 = new google.maps.Map(document.getElementById('map2'), {
                    zoom: 14,
                    center: uluruu
                });
                var marker = new google.maps.Marker({
                    position: uluruu,
                    map: map2
                });
            }
        });


    </script>

    <script>

        function initMap() {
            var uluru = {lat: 51.50775, lng: -0.1271647};
            var map = new google.maps.Map(document.getElementById('map'), {
                zoom: 14,
                center: uluru
            });
            var marker = new google.maps.Marker({
                position: uluru,
                map: map
            });
            var uluruu = {lat: 31.5204, lng: 74.3587};
            var map2 = new google.maps.Map(document.getElementById('map2'), {
                zoom: 14,
                center: uluruu
            });
            var marker = new google.maps.Marker({
                position: uluruu,
                map: map2
            });
        }
    </script>
    <script async defer
            src="https://maps.googleapis.com/maps/api/js?key=AIzaSyBCB8tfTQN4OuUd2ah42psnG5gZlDKgv7o&callback=initMap">
    </script>

    <script>
        var text_yes = '{{ trans('general.yes') }}';
        var text_no = '{{ trans('general.no') }}';

        $(document).ready(function() {

            $("#mydata").select2({
                placeholder: "{{ trans('Select form Contacts', ['field' => trans('general.generalstrings.type')]) }}"
            });
            $("#team").select2({
                placeholder: "{{ trans('Team Members', ['field' => trans('general.generalstrings.type')]) }}",

            });
            $("#loaction_accuracy").select2({
                placeholder: "{{ trans('Set Location Accuracy for Driver app', ['field' => trans('general.generalstrings.type')]) }}"
            });

        });
    </script>

    <script>
        $( function() {
            $( "#datepicker" ).datepicker();
        } );
    </script>

    {{ Html::script("js/backend/plugin/datatables/jquery.dataTables.min.js") }}
    {{ Html::script("js/backend/plugin/datatables/dataTables.bootstrap.min.js") }}

        <script></script>
@stop