@extends('backend.layouts.app')
@section ('title', trans('labels.backend.settings'))
@section('page-header')

    <h1>

        <small>{{ trans('labels.backend.set.title') }}</small>
    </h1>
@endsection
@section('content')

    <div class="box box-success">
        <div class="box-header with-border">
            <h3 class="box-title">{{ trans('labels.backend.set.title') }}</h3>

        </div><!-- /.box-header -->

        <div class="box-body">
            <div class="form-group">

                <div class="row">
                    {!! Form::model($setting, [
                        'method' => 'PATCH',
                        'url' => ['admin/customers/settings'],
                        'class' => 'setting-form',
                        'files' => true,
                        'role' => 'form'
                    ]) !!}
                    {{--{{dd($setting)}}--}}
                    <div class="col-sm-12">
                        <div class="nav-tabs-custom">
                            <ul class="nav nav-tabs">
                                <li class="active"><a href="#company" data-toggle="tab" aria-expanded="true">{{ trans('labels.backend.settings') }}</a></li>
                            </ul>

                            <div class="tab-content">
                                <div class="tab-pane tab-margin active" id="company">
                                    <fieldset class="scheduler-border">
                                        <legend class="scheduler-border">{{ trans('labels.backend.set.general_settings') }}</legend>
                                        <div class="control-group">
                                            {{ Form::radioGroup('fname', trans('First Name')) }}
                                            {{ Form::radioGroup('lname', trans('Last Name')) }}
                                            {{ Form::radioGroup('pphone', trans('Primary Phone')) }}
                                            {{ Form::radioGroup('sphone', trans('Secondary Phone')) }}
                                            {{ Form::radioGroup('email', trans('Email')) }}
                                            {{ Form::radioGroup('address', trans('Address')) }}
                                            {{ Form::radioGroup('city', trans('City')) }}
                                            {{ Form::radioGroup('state', trans('State')) }}
                                            {{ Form::radioGroup('zip', trans('Zip')) }}
                                            {{ Form::radioGroup('gender', trans('Gender')) }}
                                            {{ Form::radioGroup('birthday', trans('Birthday')) }}
                                            {{ Form::radioGroup('age', trans('Age')) }}
                                            {{ Form::radioGroup('self_assessed_credit', trans('Self Assessed Credit')) }}
                                            {{ Form::radioGroup('home_type', trans('Home Type')) }}
                                            {{ Form::radioGroup('year_built', trans('Year Built')) }}
                                            {{ Form::radioGroup('square_feet', trans('Square Feet')) }}
                                            {{ Form::radioGroup('bedrooms', trans('Bedrooms')) }}
                                            {{ Form::radioGroup('bathrooms', trans('Bathrooms')) }}
                                            {{ Form::radioGroup('construction_type', trans('Construction Type')) }}
                                            {{ Form::radioGroup('roof_surface', trans('Roof Surface')) }}
                                            {{ Form::radioGroup('foundation_type', trans('Foundation Type')) }}
                                            {{ Form::radioGroup('exterior_walls', trans('Exterior Walls')) }}
                                            {{ Form::radioGroup('garage_type', trans('Garage Type')) }}
                                            {{ Form::radioGroup('total_stories', trans('Total Stories')) }}
                                            {{ Form::radioGroup('electrical_system', trans('Electrical System')) }}
                                            {{ Form::radioGroup('fireplaces', trans('Fire Places')) }}
                                            {{ Form::radioGroup('pool', trans('Pool')) }}
                                            {{ Form::radioGroup('patio_deck', trans('Patio Deck')) }}
                                            {{ Form::radioGroup('alarm', trans('Alarm')) }}
                                            {{ Form::radioGroup('central_ac', trans('Central AC')) }}
                                            {{ Form::radioGroup('dead_bolt', trans('Dead Bolt')) }}
                                            {{ Form::radioGroup('smoke_detector', trans('Smoke Detector')) }}
                                            {{ Form::radioGroup('fire_extinguisher', trans('Fire Extinguisher')) }}
                                            {{ Form::radioGroup('smoker_in_home', trans('Smoke in Home')) }}
                                            {{ Form::radioGroup('dog_in_home', trans('Dog in Home')) }}
                                            {{ Form::radioGroup('near_fire_station', trans('Near Fire Station')) }}
                                            {{ Form::radioGroup('near_fire_hydrant', trans('Near Fire Hydrant')) }}
                                            {{ Form::radioGroup('currently_insured', trans('Currently Insured')) }}
                                            {{ Form::radioGroup('current_carrier', trans('Current Carrier')) }}
                                            {{ Form::radioGroup('residence_coverage_amount', trans('Residence Coverage Amount')) }}
                                            {{ Form::radioGroup('personal_property_amount', trans('Personal Property Amount')) }}
                                            {{ Form::radioGroup('personal_liability_amount', trans('Personal Liability Amount')) }}
                                            {{ Form::radioGroup('deductible_amount', trans('Deductible Amount')) }}
                                            {{ Form::radioGroup('years_continuously_covered', trans('Years Continuously Covered')) }}
                                            {{ Form::radioGroup('policy_expiration', trans('Policy Expiration')) }}
                                            {{ Form::radioGroup('property_address', trans('Property Address')) }}
                                            {{ Form::radioGroup('property_city', trans('Property City')) }}
                                            {{ Form::radioGroup('property_state', trans('Property State')) }}
                                            {{ Form::radioGroup('property_zip', trans('Property Zip')) }}
                                            {{ Form::radioGroup('property_use', trans('Property Use')) }}
                                            {{ Form::radioGroup('home_value', trans('Home Value')) }}
                                            {{ Form::radioGroup('isverfied', trans('Varified')) }}
                                            {{ Form::radioGroup('status', trans('Status')) }}

                                        </div>
                                    </fieldset>
                                    {{--<fieldset class="scheduler-border">--}}
                                        {{--<legend class="scheduler-border">{{ trans('validation.attributes.backend.settings.app_settings') }}</legend>--}}
                                        {{--<div class="control-group">--}}
                                            {{--{{ Form::radioGroup('enabled_notes', trans('validation.attributes.backend.settings.enabled_notes')) }}--}}
                                            {{--{{ Form::radioGroup('enabled_signature', trans('validation.attributes.backend.settings.enabled_signature')) }}--}}
                                            {{--{{ Form::radioGroup('enabled_add_phototake_picture', trans('validation.attributes.backend.settings.enabled_add')) }}--}}
                                            {{--{{ Form::radioGroup('enabled_resize_picture', trans('validation.attributes.backend.settings.enabled_resize_picture')) }}--}}

                                            {{--<div class="form-group">--}}
                                                {{--&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;{{ Form::label('image_resize', trans('validation.attributes.backend.settings.image_resize')) }}<br>--}}
                                                {{--<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;{{ Form::label('image_resize', trans('validation.attributes.backend.settings.resize')) }}--}}
                                            {{--</div>--}}
                                            {{--<div class="col-lg-6">--}}
                                                {{--{{ Form::textGroup('width', trans('validation.attributes.backend.settings.width'),'text-width') }}--}}
                                        {{--</div>--}}
                                            {{--<div class="col-lg-6">--}}
                                                 {{--{{ Form::textGroup('height', trans('validation.attributes.backend.settings.height'),'text-height') }}--}}
                                            {{--</div>--}}
                                        {{--</div>--}}
                                        {{--<div class="col-sm-12">--}}
                                        {{--{{ Form::textGroup('Device_Vibration', trans('validation.attributes.backend.settings.device_vibration'),'bolt') }}<br><br><br><br>--}}
                                        {{--{{ Form::label('image_resize', trans('validation.attributes.backend.settings.default_3000')) }}<br><br>--}}

                                        {{--</div>--}}
                                    {{--</fieldset>--}}
                                    {{--<fieldset class="scheduler-border">--}}
                                        {{--<legend class="scheduler-border">{{ trans('validation.attributes.backend.settings.localize_calendar') }}</legend>--}}
                                        {{--<div class="control-group">--}}

                                            {{--{{ Form::selectGroup('language', trans('settings.language.encryption'), 'language', $language, null, []) }}--}}

                                        {{--</div>--}}
                                    {{--</fieldset>--}}

                                    {{--<fieldset class="scheduler-border">--}}
                                        {{--<legend class="scheduler-border">{{ trans('validation.attributes.backend.settings.agents_tracking_options') }}</legend>--}}
                                        {{--<div class="control-group">--}}
                                            {{--<div class="col-lg-12">--}}
                                                {{--<div class="col-sm-6">--}}
                                                    {{--<h4>--}}
                                                        {{--Tracking Option 1&nbsp;&nbsp; {{ Form::radio('tracking_option', 'validation.attributes.backend.settings.tracking_option_1') }}--}}
                                                    {{--</h4>--}}
                                                    {{--<i>{{ Form::label('image_resize', trans('validation.attributes.backend.settings.resize_picture')) }}</i><br><br>--}}

                                                    {{--<h4>Tracking Option 2&nbsp;&nbsp; {{ Form::radio('tracking_option', 'tracking_option_2') }}</h4>--}}

                                                    {{--<i>{{ Form::label('image_resize', trans('validation.attributes.backend.settings.this_options')) }}</i>--}}
                                                    {{--<br>--}}
                                                    {{--<i>{{ Form::label('image_resize', trans('validation.attributes.backend.settings.the_app')) }}</i><br><br>--}}
                                                    {{--<br>--}}
                                                {{--</div>--}}
                                                {{--<div class="control-group">--}}
                                                    {{--<div class="col-lg-12">--}}
                                                        {{--<div class="col-sm-6">--}}
                                                            {{--{{ Form::radioGroup('records_agents_location', trans('validation.attributes.backend.settings.records_agents_location')) }}--}}
                                                            {{--<i>{{ Form::label('records_agents_location', trans('validation.attributes.backend.settings.this_will')) }}</i>--}}
                                                        {{--</div>--}}
                                                        {{--<div class="col-sm-6">--}}
                                                            {{--{{ Form::radioGroup('disabled_background_tracking', trans('validation.attributes.backend.settings.disabled_background_tracking')) }}--}}
                                                            {{--{{ Form::label('image_resize', trans('validation.attributes.backend.settings.this_options_will')) }}--}}
                                                            {{--{{ Form::label('image_resize', trans('validation.attributes.backend.settings.app_is')) }}<br><br>--}}
                                                        {{--</div>--}}
                                                    {{--</div>--}}
                                                    {{--<div class="col-sm-12">--}}
                                                        {{--{{ Form::textGroup('track_interval', trans('validation.attributes.backend.settings.track_interval'), 'clock-o') }}--}}
                                                        {{--<br><br><br><br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;--}}
                                                        {{--{{ Form::label('image_resize', trans('validation.attributes.backend.settings.in_seconds')) }}<br><br>--}}
                                                    {{--</div>--}}
                                                {{--</div>--}}
                                            {{--</div>--}}
                                        {{--</div>--}}
                                    {{--</fieldset>--}}

                                    {{--<fieldset class="scheduler-border">--}}
                                        {{--<legend class="scheduler-border">{{ trans('validation.attributes.backend.settings.task_critical_options') }}</legend>--}}
                                        {{--<div class="control-group">--}}
                                            {{--<i>{{ Form::label('image_resize', trans('validation.attributes.backend.settings.set_critical')) }}</i><br>--}}

                                            {{--{{ Form::radioGroup('critical_options_enabled', trans('validation.attributes.backend.settings.enabled')) }}--}}
                                            {{--{{ Form::textGroup('minutes', trans('validation.attributes.backend.settings.minutes'), 'clock-o') }}--}}
                                            {{--&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;--}}
                                            {{--<i>{{ Form::label('image_resize', trans('validation.attributes.backend.settings.default_is_5_minutes')) }}</i><br>--}}
                                        {{--</div>--}}
                                    {{--</fieldset>--}}

                                    {{--<fieldset class="scheduler-border">--}}
                                        {{--<legend class="scheduler-border">{{ trans('Map Settings') }}</legend>--}}
                                        {{--<div class="control-group">--}}
                                            {{--{{ Form::radioGroup('include_offline_driver_on_map', trans('validation.attributes.backend.settings.include_offline_driver_on_map')) }}--}}
                                            {{--{{ Form::radioGroup('hide_pickup_task', trans('validation.attributes.backend.settings.hide_pickup_task')) }}--}}
                                            {{--{{ Form::radioGroup('hide_delivery_task', trans('validation.attributes.backend.settings.hide_delivery_task')) }}--}}
                                            {{--{{ Form::radioGroup('hide_successful_task', trans('validation.attributes.backend.settings.hide_successful_task')) }}--}}
                                            {{--{{ Form::radioGroup('disabled_map_auto_refresh', trans('validation.attributes.backend.settings.disabled_map_auto_refresh')) }}--}}
                                            {{--{{Form::selectGroup('country', trans('Default Map Country'), 'flag', $countries, null, []) }}--}}
                                            {{--{{ Form::textareaGroup('map_style', trans('validation.attributes.backend.settings.map_style')) }}--}}
                                        {{--</div>--}}
                                    {{--</fieldset>--}}

                                <div class="setting-buttons clearfix">
                                    <div class="form-group no-margin">
                                        <br>{!! Form::button('<span class="fa fa-save"></span> &nbsp;' . trans('general.save'), ['type' => 'submit', 'class' => 'btn btn-success']) !!}
                                        <a href="{{ URL::previous() }}" class="btn btn-default"><span class="fa fa-times-circle"></span> &nbsp;{{ trans('general.cancel') }}</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    {!! Form::close() !!}
                </div>
            </div><!--form control-->
        </div><!-- /.box-body -->
    </div><!--box-->
</div>
@endsection


@section('after-scripts')

    <script>
        var text_yes = '{{ trans('general.yes') }}';
        var text_no = '{{ trans('general.no') }}';

        $(document).ready(function() {
            // debugger;
            $('#desktop_logo').fancyfile({
                text  : '{{ trans('general.form.select.file') }}',
                style : 'btn-default',
                placeholder : '<?php echo $setting->pull('desktop_logo'); ?>'
            });

            $("#timezone").select2({
                placeholder: "{{ trans('Change Time Zone', ['field' => trans('Change Time Zone')]) }}"
            });
            $("#language").select2({
                placeholder: "{{ trans('Change Language', ['field' => trans('Change Language')]) }}"
            });
            $("#country").select2({
                placeholder: "{{ trans('general.form.select.field', ['field' => trans('validation.attributes.backend.settings.country')]) }}"
            });

            $("#currency_position").select2({
                placeholder: "{{ trans('general.form.select.field', ['field' => trans('settings.localisation.date.format')]) }}"
            });

        });
    </script>

@stop
