@extends ('backend.layouts.app')

@section ('title', trans('labels.backend.agents.title') . ' | ' . trans('labels.backend.agents.create'))

@section('page-header')
    <h1>
        {{ trans('labels.backend.title.agents.agents') }}
        <small>{{ trans('labels.backend.agents.create') }}</small>
    </h1>
@endsection

@section('content')
    {{ Form::open(['route' => 'admin.customers.agents.store', 'class' => '', 'role' => 'form', 'method' => 'post' , 'enctype' => 'multipart/form-data']) }}
    <div class="box box-success">
        <div class="box-header with-border">
            <h3 class="box-title">{{ trans('labels.backend.agents.create') }}</h3>
            <div class="box-tools pull-right">
                @include('backend.customers.agents.includes.partials.agents-header-buttons')
            </div>
        </div><!-- /.box-header -->

        <div class="box-body">
            <div class="control-group">
                {{ Form::textGroup('first_name', trans('labels.backend.agents.first_name'), 'info', ['placeholder' => trans('labels.backend.agents.first_name')]) }}
                {{ Form::textGroup('last_name', trans('labels.backend.agents.last_name'), 'info', ['placeholder' => trans('labels.backend.agents.last_name')]) }}
                {{ Form::textGroup('email', trans('labels.backend.agents.email'), 'envelope', ['placeholder' => trans('labels.backend.agents.email')]) }}
                {{ Form::passwordGroup('password', trans('labels.backend.agents.password'), 'key', ['placeholder' => trans('labels.backend.agents.password')]) }}
                {{ Form::selectGroup('team_id', trans('labels.backend.agents.team_id'), 'users',$team, null,[]) }}
                {{ Form::textGroup('phone', trans('labels.backend.agents.phone'), 'phone', ['placeholder' => trans('labels.backend.agents.phone')]) }}
                {{ Form::selectGroup('transport_type_id', trans('labels.backend.agents.transport_type'), 'caret-down', ['1'=>'Truck','2'=>'Car','3'=>'Bike','4'=>'Bicycle','5'=>'Scooter','6'=>'Walk'], null, []) }}
                {{ Form::textGroup('transport_description', trans('labels.backend.agents.transport_des'), 'file-text', ['placeholder' => trans('labels.backend.agents.transport_des')]) }}
                {{ Form::textGroup('licence_plate', trans('labels.backend.agents.licence_plate'), 'car', ['placeholder' => trans('labels.backend.agents.licence_plate')]) }}
                {{ Form::textGroup('color', trans('labels.backend.agents.color'), 'paint-brush', ['placeholder' => trans('labels.backend.agents.color')]) }}
                {{ Form::textGroup('address', trans('labels.backend.agents.address'), 'home', ['placeholder' => trans('labels.backend.agents.address')]) }}
                {{ Form::selectGroup('status', trans('labels.backend.agents.status'), 'caret-down', ['1'=>'Active','2'=>'Pending for approval','3'=>'Suspended','4'=>'Blocked'], null, []) }}
            </div><!--form control-->
        </div><!-- /.box-body -->
    </div><!--box-->
    <div class="box box-info">
        <div class="box-body">
            <div class="pull-left">
                {{ link_to_route('admin.customers.agents.index', trans('buttons.general.cancel'), [], ['class' => 'btn btn-danger btn-md']) }}
            </div><!--pull-left-->
            <div class="pull-right">
                {{ Form::submit(trans('buttons.general.crud.create'), ['class' => 'btn btn-success btn-md']) }}
            </div><!--pull-right-->
            <div class="clearfix"></div>
        </div><!-- /.box-body -->
    </div><!--box-->
    {{ Form::close() }}
@stop

@section('after-scripts')

    <script>
        var text_yes = '{{ trans('general.yes') }}';
        var text_no = '{{ trans('general.no') }}';

        $(document).ready(function() {


            $("#status").select2({
                placeholder: "{{ trans('Status', ['field' => trans('general.generalstrings.type')]) }}"
            });
            $("#transport_type_id").select2({
                placeholder: "{{ trans('Transport Type', ['field' => trans('Transport Type')]) }}"
            });
            $("#team_id").select2({
                placeholder: "{{ trans('Select Team', ['field' => trans('Select Team')]) }}"
            });

        });
    </script>

@stop