<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Labels Language Lines
    |--------------------------------------------------------------------------
    |
    | The following language lines are used in labels throughout the system.
    | Regardless where it is placed, a label can be listed here so it is easily
    | found in a intuitive way.
    |
    */

    'general' => [
        'all'     => 'All',
        'yes'     => 'Yes',
        'no'      => 'No',
        'custom'  => 'Custom',
        'actions' => 'Actions',
        'active'  => 'Active',

        'buttons' => [
            'save'   => 'Save',
            'update' => 'Update',
        ],

        'hide'              => 'Hide',
        'inactive'          => 'Inactive',
        'none'              => 'None',
        'show'              => 'Show',
        'toggle_navigation' => 'Toggle Navigation',
    ],

    'backend' =>[

        'task_created'=>[
            'created'       =>'New Job Created',
        ],

        'customers'=>[
            'create'        =>'Create',
            'edit'          =>'Edit',

        ],
        'reports'=>[
            'time'              =>'Time',
            'team'              =>'Team',
            'driver'            =>'Driver',
            'total_jobs'        =>'Completed Jobs',
            'paid'              =>'Paid / Unpaid',
            'current'           =>'ID',
            'id'            =>'Agent Id',
            'name'          =>'Name',
            'distance'      =>'Distance',
            'pay_rate'      =>'Pay Rate',
            'total'         =>'Total Payment',
            'table'             =>[

                'sucessfull'    =>'Sucessfull Task',
                'failed'        =>'Failed Task',
                'cancelled'     =>'Cancelled Task',
                'total'         =>'Total Task',
            ],

        ],

        'notifications'=>[
            'triggers'=>[
                'task_created'              =>'TASK_CREATED',
                'request_received'          =>'REQUEST_RECEIVED',
                'driver_started'            =>'DRIVER_STARTED',
                'driver_arrived'            =>'DRIVER_ARRIVED',
                'successful'                =>'SUCCESSFUL',
                'failed'                    =>'FAILED',
                'notes'                     =>'NOTES',
                'update_notes'              =>'UPDATE_NOTES',
                'signature'                 =>'SIGNATURE',
                'photo'                     =>'PHOTO',
                'assign_task'               =>'ASSIGN_TASK',
                'update_task'               =>'UPDATE_TASK',
                'deleted_task'              =>'DELETED_TASK',
                'failed_auto_assign'        =>'FAILED_AUTO_ASSIGN',
            ],
            'tabs'=>[
                'pickup'                        =>'Customer Pickup Notifications',
                'delivery'                      =>'Customer Delivery Notifications',
                'driver_notification'           =>'Driver Notifications',
                'auto_assign_notification'      =>'Auto assign Notifications',
            ],
            'title'                     =>'Notifications',
            'active'                    =>'Active',
            'head_line'                 =>'Customer Pickup Notifications',
            'task'                      =>'Notifications - PICKUP_TASK_CREATED',
            'request_received'          =>'Notifications - PICKUP_REQUEST_RECEIVED',
            'driver_started'            =>'Notifications - PICKUP_DRIVER_STARTED',
            'driver_arrived'            =>'Notifications - PICKUP_DRIVER_ARRIVED',
            'successful'                =>'Notifications - PICKUP_SUCCESSFUL',
            'failed'                    =>'Notifications - PICKUP_FAILED',
            'notes'                     =>'Notifications - PICKUP_NOTES',
            'update_notes'              =>'Notifications - PICKUP_UPDATE_NOTES',
            'signature'                 =>'Notifications - PICKUP_SIGNATURE',
            'photo'                     =>'Notifications - PICKUP_PHOTO',
            'delivery_task'             =>'Notifications - DELIVERY_TASK_CREATED',
            'delivery_request_receive'  =>'Notifications - DELIVERY_REQUEST_RECEIVED',
            'delivery_driver_started'   =>'Notifications - DELIVERY_DRIVER_STARTED',
            'delivery_driver_arrived'   =>'Notifications - DELIVERY_DRIVER_ARRIVED',
            'delivery_successful'       =>'Notifications - DELIVERY_SUCCESSFUL',
            'delivery_failed'           =>'Notifications - DELIVERY_FAILED',
            'delivery_notes'            =>'Notifications - DELIVERY_NOTES',
            'delivery_update_notes'     =>'Notifications - DELIVERY_UPDATE_NOTES',
            'delivery_signature'        =>'Notifications - DELIVERY_SIGNATURE',
            'delivery_photo'            =>'Notifications - DELIVERY_PHOTO',
            'driver_assign_task'        =>'Notifications - ASSIGN_TASK',
            'driver_update_task'        =>'Notifications - UPDATE_TASK',
            'driver_deleted_task'       =>'Notifications - CANCEL_TASK',
            'failed_auto_assign'        =>'Notifications - FAILED_AUTO_ASSIGN',


        ],

        'services'=>[
            'head_linee'    =>'Check the services that you offered',
            'title'         =>'Services',
        ],

        'upload_tasks'=>[
            'title'         =>'Upload Tasks',
            'active'        =>'Active',
        ],

        'pushlogs'=>[
            'title'         =>'Push Logs',
            'active'        =>'Active',
            'table'=>[
                'id'        =>'ID',
                'driver_id' =>'Driver ID',
                'title'     =>'Title',
                'message'   =>'Message',
                'type'      =>'Type',
                'device'    =>'Device',
                'status'    =>'Status',
            ],
        ],

        'sms'=>[
            'title'     =>'SMS Logs',
            'active'    =>'Active',
            'table'=>[
                'id'            =>'ID',
                'mobile_no'     =>'Mobile Number',
                'message'       =>'Message',
                'provider'      =>'Provider',
                'status'        =>'Status',
                'created_at'    =>'Date',
            ],
        ],
        'send_bulk'=>[
            'title'         =>'Send Bulk Push',
            'active'        =>'Active',
        ],
        'push_broadcast'=>[
            'logs'          =>'Push Broadcast Logs',
            'active'        =>'Active',
            'table'=>[
                'id'            =>'ID',
                'team'          =>'Teams',
                'push_title'    =>'Push Title',
                'push_message'  =>'Push Message',
                'status'        =>'Status',
            ],
        ],
        'push'=>[
            'logs'      =>'Push Logs',
            'active'    =>'Active',
            'table'=>[
                'id'        =>'ID',
                'driver_id' =>'Driver ID',
                'title'     =>'Title',
                'message'   =>'Message',
                'type'      =>'Type',
                'device'    =>'Device',
                'status'    =>'Status',
            ],
        ],
        'email'=>[
            'logs'      =>'Email Logs',
            'active'    =>'Active',


            'table'=>[
                'id'                =>'ID',
                'email_address'     =>'Email Address',
                'subject'           =>'Subject',
                'message'           =>'Message',
                'status'            =>'Status',
                'date'              =>'Date',
            ],
        ],
        'assignment'=>[
            'title'     =>'Assignment',
        ],
        'tasks'=>[
            'management'        =>'Tasks',
            'active'            =>'Active',
            'create'            =>'Create',

            'table'=>[
                'id'                =>'ID',
                'task_type'         =>'Task Type',
                'description'       =>'Description',
                'driver_name'       =>'Driver Name',
                'name'              =>'Name',
                'delivery_address'  =>'Delivery Address',
                'delivery_date'     =>'Delivery Date',
                'ratings'           =>'Rattings',
                'ratings_comments'  =>'Rattings Comments',
                'status'            =>'Status',
            ],
        ],
            'agents'=>[
                'title'             =>'Agents',
                'create'            =>'Create',
                'edit'              =>'Edit',
                'first_name'        =>'First Name',
                'last_name'         =>'Last Name',
                'email'             =>'Email',
                'password'          =>'Password',
                'phone'             =>'Phone',
                'transport_type'    =>'Transport Type',
                'transport_des'     =>'Transport Description',
                'licence_plate'     =>'Licence Plate',
                'color'             =>'Color',
                'status'            =>'Status',
                'team_id'           =>'Assign to Team',
                'select_driver'     =>'Select Driver',
                'date'              =>'Select Date',
                'address'           =>'Address',
        ],
        'set'=>[
            'title'                 =>'Settings',
            'general_settings'      =>'General Settings',
        ],
        'settings'                  =>'Settings',

        'contacts'=>[
            'table'=>[
                'id'        =>'ID',
                'name'      =>'Name',
                'email'     =>'Email',
                'phone'     =>'Phone',
                'address'   =>'Address',
                'status'    =>'Status',
            ],

            'management'        =>'Contacts Management',
            'active'            =>'Active',
            'edit'              =>'Edit',
            'create'            =>'Create',
        ],
        'languages'=>[
            'title'     =>'Manage Language',
            'lang'      =>'Select Language',
        ],
        'templates'=>[
            'welcome_signup'                =>'Welcome Signup',
            'approved_account'              =>'Approved Account',
            'forgot_password'               =>'Forgot Password',
            'signup_verification_sms'       =>'Signup Verification SMS',
            'signup_verification_email'     =>'Signup Verification Email',
        ],

        'mobile'=>[
            'title'     =>'Mobile Settings',
            'mobile'    =>'Mobile API URL',

        ],
        'gen_settings'=>[

            'smsgateway'=>[
                'title'     =>'SMS Gateway',
                'title1'    =>'SMS Settings',

            ],

            'title'             =>'General Settings',
            'title2'            =>'Website Information',
            'tab'               =>'Delivery Express Settings',
            'title3'            =>'Mail Settings',
            'title4'            =>'Google Settings',
            'title5'            =>'Follow Us',
            'title6'            =>'Signup Settings',
            'title7'            =>'Time Settings',
            'title8'            =>'Currency Settings',
            'title9'            =>'Promo Codes',
            'android_settings'  =>'Android Settings',
            'ios_settings'      =>'iOS Settings',


        ],
        'corn'=>[
            'jobs'      =>'CornJobs',
            'active'    =>'Active',
        ],
        'template'=>[
            'temp'          =>'Template',
            'management'    =>'Template Management',
            'active'        =>'Active',
        ],
        'payment_gateway'=>[
            'paymentgateway'    =>'Payment Gateway',
            'active'            =>'Active',
        ],
        'seo'=>[
            'title'     =>'Seo',
            'active'    =>'Active',
            'home'      =>'Homepage Seo',

        ],
        'smsgateway'=>[
            'sms'       =>'Sms Gateway',
            'active'    =>'Active',
        ],
        'currency'=>[
            'table'=>[
                'id'                =>'ID',
                'currency_code'     =>'Currency Code',
                'currency_symbol'   =>'Currency Symbol',
                'status'            =>'Status',
                'created_at'        =>'Created At',
            ],

            'cur'           =>'Currency',
            'management'    =>'Currency Management',
            'active'        =>'Active',
            'create'        =>'Create',
            'edit'          =>'Edit',
        ],
        'payment'=>[

            'paypal'        =>'Paypal',
            'stripe'        =>'Stripe',
            'mercadopago'   =>'Mercadopago',
            'razorpay'      =>'RazorPay',
            'authorizenet'  =>'Authorize.net',

        ],

        'title'=>[
            'customers' =>[
                'Totaldriver'       => 'Total Drivers',
                'teams'             => 'Teams',
              'team_name'           => 'Team Name',
              'team_members'        => 'Team Members',
              'loaction_accuracy'   => 'Set Location Accuracy for Driver app',
              'loc_accuracy'        => 'Location Accuracy',

                'task'=>[
                  'id'              => 'Task ID',
                  'type'            => 'Task Type',
                  'description'     => 'Description',
                  'drivername'      => 'Driver Name',
                  'name'            => 'Name',
                  'address'         => 'Address',
                  'deliverydate'    => 'Delivery Date',
                  'ratings'         => 'Ratings',
                  'ratingscomments' => 'Ratings Comments',
                  'status'          => 'Status',


                ],
            ],

            'services' =>[
                'title'         => 'Services',
                'create'        => 'Create' ,
                'edit'          => 'Edit' ,
            ],
            'agents' =>[

                'agents'        => 'Agents',
                'table'         =>[
                    'id'        => 'ID',
                    'name'      => 'Name',
                    'user_name' =>'User Name',
                    'email'     =>'Email',
                    'phone'     =>'Phone',
                    'team'      =>'Team',
                    'device'    =>'Device',
                    'status'    =>'Status',

                ],

            ],
            'promo'=>[
                'table'=>[
                    'id'            =>'ID',
                    'promo_code'    =>'Promo Code',
                    'type'          =>'Type',
                    'dis'           =>'Discount',
                    'exp'           =>'Expiration',
                    'status'        =>'Status',
                ],

                'promo'         =>'Promo Code',
                'create'        =>'Create',
                'code'          =>'Promo Code',
                'edit'          =>'edit',
                'active'        =>'Active',
	            'track'         =>'Agent Track Back',
	            'reports'       =>'Reports'
            ],
            'payment'=>[

                'title'     =>'Payments Gateway',

            ],
            'plan'=>[
                'pl'            =>'Plans',
                'active'        =>'Active',
                'edit'          =>'Edit',
                'management'    =>'Plan Management',
                'create'        =>'Create',


                'table'=>[
                    'id'            =>'ID',
                    'plan_name'     =>'Plan Name',
                    'dis'           =>'Description',
                    'type'          =>'Type',
                    'price'         =>'Price',
                    'status'        =>'Status',
                ],

            ],
            'service'=>[



                'table'=>[
                    'id'            =>'ID',
                    'servicename'   =>'Service Name',
                    'dis'           =>'Description',
                    'type'          =>'Type',
                    'price'         =>'Price',
                    'status'        =>'Status',
                ],

            ],
            'page'=>[
                'table'=>[
                    'id'            =>'ID',
                    'name'          =>'Name',
                    'page_title'    =>'Page Title',
                    'page_slug'     =>'Slug',
                    'page_status'   =>'Status',
                    'content'       =>'Content',
                    'page_created'  =>'Date',
                ],
                'pl'            =>'Page',
                'active'        =>'Active',
                'edit'          =>'Edit',
                'management'    =>'Page Management',
                'create'        =>'Create',
            ],
        ],
        'access' => [
            'roles' => [
                'create'     => 'Create Role',
                'edit'       => 'Edit Role',
                'management' => 'Role Management',

                'table' => [
                    'number_of_users' => 'Number of Users',
                    'permissions'     => 'Permissions',
                    'role'            => 'Role',
                    'sort'            => 'Sort',
                    'total'           => 'role total|roles total',
                ],
            ],

            'users' => [
                'active'              => 'Active Users',
                'all_permissions'     => 'All Permissions',
                'change_password'     => 'Change Password',
                'change_password_for' => 'Change Password for :user',
                'create'              => 'Create User',
                'deactivated'         => 'Deactivated Users',
                'deleted'             => 'Deleted Users',
                'edit'                => 'Edit User',
                'management'          => 'User Management',
                'no_permissions'      => 'No Permissions',
                'no_roles'            => 'No Roles to set.',
                'permissions'         => 'Permissions',

                'table' => [
                    'confirmed'      => 'Confirmed',
                    'created'        => 'Created',
                    'email'          => 'E-mail',
                    'id'             => 'ID',
                    'last_updated'   => 'Last Updated',
                    'name'           => 'Name',
                    'first_name'     => 'First Name',
                    'last_name'      => 'Last Name',
                    'no_deactivated' => 'No Deactivated Users',
                    'no_deleted'     => 'No Deleted Users',
                    'roles'          => 'Roles',
                    'social' => 'Social',
                    'total'          => 'user total|users total',
                ],

                'tabs' => [
                    'titles' => [
                        'overview' => 'Overview',
                        'history'  => 'History',
                    ],

                    'content' => [
                        'overview' => [
                            'avatar'       => 'Avatar',
                            'confirmed'    => 'Confirmed',
                            'created_at'   => 'Created At',
                            'deleted_at'   => 'Deleted At',
                            'email'        => 'E-mail',
                            'last_updated' => 'Last Updated',
                            'name'         => 'Name',
                            'first_name'   => 'First Name',
                            'last_name'    => 'Last Name',
                            'status'       => 'Status',
                        ],
                    ],
                ],

                'view' => 'View User',
            ],
        ],
    ],

    'frontend' => [

        'auth' => [
            'login_box_title'    => 'Login',
            'login_button'       => 'Login',
            'login_with'         => 'Login with :social_media',
            'register_box_title' => 'Register',
            'register_button'    => 'Register',
            'remember_me'        => 'Remember Me',
        ],

        'contact' => [
            'box_title'     => 'Contact Us',
            'button'        => 'Send Information',
        ],

        'passwords' => [
            'forgot_password'                 => 'Forgot Your Password?',
            'reset_password_box_title'        => 'Reset Password',
            'reset_password_button'           => 'Reset Password',
            'send_password_reset_link_button' => 'Send Password Reset Link',
        ],

        'macros' => [
            'country' => [
                'alpha'   => 'Country Alpha Codes',
                'alpha2'  => 'Country Alpha 2 Codes',
                'alpha3'  => 'Country Alpha 3 Codes',
                'numeric' => 'Country Numeric Codes',
            ],

            'macro_examples' => 'Macro Examples',

            'state' => [
                'mexico' => 'Mexico State List',
                'us'     => [
                    'us'       => 'US States',
                    'outlying' => 'US Outlying Territories',
                    'armed'    => 'US Armed Forces',
                ],
            ],

            'territories' => [
                'canada' => 'Canada Province & Territories List',
            ],

            'timezone' => 'Timezone',
        ],

        'user' => [
            'passwords' => [
                'change' => 'Change Password',
            ],

            'profile' => [
                'avatar'             => 'Avatar',
                'created_at'         => 'Created At',
                'edit_information'   => 'Edit Information',
                'email'              => 'E-mail',
                'last_updated'       => 'Last Updated',
                'name'               => 'Name',
                'first_name'         => 'First Name',
                'last_name'          => 'Last Name',
                'update_information' => 'Update Information',
            ],
        ],

    ],
];
