@extends('frontend.layouts.app')
@section('title', app_name() . ' | Payment Details')
@section('content')
    <div class="container">
        <div class="row">
            <div class="row pb-100"></div>
            <div class="row pb-50"></div>
            <div class="col-md-8 col-md-offset-2">
                <div class="panel panel-default">
                    @if ($message = Session::get('success'))
                        <div class="custom-alerts alert alert-success fade in">
                            <button type="button" class="close" data-dismiss="alert" aria-hidden="true"></button>
                            {!! $message !!}
                        </div>
                        <?php Session::forget('success');?>
                    @endif
                    @if ($message = Session::get('error'))
                        <div class="custom-alerts alert alert-danger fade in">
                            <button type="button" class="close" data-dismiss="alert" aria-hidden="true"></button>
                            {!! $message !!}
                        </div>
                        <?php Session::forget('error');?>
                    @endif
                    <div class="panel-heading">Your Plan Details</div>
                    <div class="panel-body">
                        <form class="form-horizontal" method="POST" id="payment-form" role="form" action="{!! URL::route('frontend.paypal.paypal') !!}" >
                            {{ csrf_field() }}
                            <div class="form-group{{ $errors->has('name') ? ' has-error' : '' }}">
                                <div class="col-md-12">
                                    <div class="col-md-6">
                                <label for="name">Plan Name: </label>
                                    </div>
                                    <div class="col-md-6">
                                        {{$plan->plan_name}}
                                    </div>
                                    </div>
                                    <div class="col-md-6">
                                    <input id="name" type="hidden" class="form-control" name="name" value="{{$plan->plan_name}}" autofocus>
                                        @if ($errors->has('name'))
                                        <span class="help-block">
                                        <strong>{{ $errors->first('name') }}</strong>
                                    </span>
                                    @endif
                                </div>
                            </div>
                            <div class="form-group{{ $errors->has('quantity') ? ' has-error' : '' }}">
                                <div class="col-md-12">
                                    <div class="col-md-6">
                                        <label for="name">Description: </label>
                                    </div>
                                    <div class="col-md-6">
                                        {{$plan->description}}
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <input id="quantity" type="hidden" class="form-control" name="quantity" value="1" autofocus>
                                    @if ($errors->has('quantity'))
                                        <span class="help-block">
                                        <strong>{{ $errors->first('quantity') }}</strong>
                                    </span>
                                    @endif
                                </div>
                            </div>
                            <div class="form-group{{ $errors->has('quantity') ? ' has-error' : '' }}">
                                <div class="col-md-12">
                                    <div class="col-md-6">
                                        <label for="name">Expiry Date: </label>
                                    </div>
                                    <div class="col-md-6">
                                        {{$plan->expiry}}
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <input id="quantity" type="hidden" class="form-control" name="quantity" value="1" autofocus>
                                    @if ($errors->has('quantity'))
                                        <span class="help-block">
                                        <strong>{{ $errors->first('quantity') }}</strong>
                                    </span>
                                    @endif
                                </div>
                            </div>
                            <div class="form-group{{ $errors->has('amount') ? ' has-error' : '' }}">
                                <div class="col-md-12">
                                        <div class="col-md-6">
                                            <label for="name">Plan Price: </label>
                                        </div>
                                        <div class="col-md-6">
                                            {{$plan->price}}
                                        </div>
                                    </div>
                                <div class="col-md-6">
                                    <input id="amount" type="hidden" class="form-control" name="amount" value="{{$plan->price}}" autofocus>
                                    @if ($errors->has('amount'))
                                        <span class="help-block">
                                        <strong>{{ $errors->first('amount') }}</strong>
                                    </span>
                                    @endif
                                </div>
                            </div>
                            <div class="box box-info">
                                <div class="box-body">
                                    <div class="pull-left">
                                        {{ link_to_route('frontend.pricing', trans('Skip'), [], ['class' => 'btn btn-danger btn-md']) }}
                                    </div><!--pull-left-->
                                    <div class="pull-right">
                                        {{ Form::submit(trans('Confirm'), ['class' => 'btn btn-success btn-md']) }}
                                    </div><!--pull-right-->
                                    <div class="clearfix"></div>
                                </div><!-- /.box-body -->
                            </div><!--box-->

                        </form>
                            </div>
                            </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection