@extends('frontend.layouts.app')
@section('content')
    <div class="container">
        <div class="row pb-100"></div>
        <div class="row pb-100"></div>
        <div class="row pb-50"></div>
        <div class="row">
            <div class="col-md-8 col-md-offset-2">
                    @if ($message = Session::get('success'))
                        <div class="custom-alerts alert alert-success fade in">
                            <button type="button" class="close" data-dismiss="alert" aria-hidden="true"></button>
                            {!! $message !!}
                        </div>
                        <?php Session::forget('success');?>
                    @endif
                    @if ($message = Session::get('error'))
                        <div class="custom-alerts alert alert-danger fade in">
                            <button type="button" class="close" data-dismiss="alert" aria-hidden="true"></button>
                            {!! $message !!}
                        </div>
                        <?php Session::forget('error');?>
                    @endif
                        <form class="form-horizontal" method="POST" id="payment-form" role="form" action="{!! URL::route('frontend.paywithauthorize') !!}" >
                            {{ csrf_field() }}
                            <div class="form-group{{ $errors->has('card_no') ? ' has-error' : '' }}">
                                <label for="card_no" class="col-md-4 control-label">Card No</label>
                                <div class="col-md-6">
                                    <input id="card_no" type="text" class="form-control" name="card_no" placeholder="123xxxxxxxxxx759" value="{{ old('card_no') }}" autofocus>
                                    @if ($errors->has('card_no'))
                                        <span class="help-block">
                                        <strong>{{ $errors->first('card_no') }}</strong>
                                    </span>
                                    @endif
                                </div>
                            </div>
                            <div class="form-group{{ $errors->has('ccExpiryMonth') ? ' has-error' : '' }}">
                                <label for="ccExpiryMonth" class="col-md-4 control-label">Expiry Date</label>
                                <div class="col-md-6">
                                    <input id="exp_date" type="text" class="form-control" name="exp_date" placeholder="2020-12" value="{{ old('exp_date') }}" autofocus>
                                    @if ($errors->has('ccExpiryMonth'))
                                        <span class="help-block">
                                        <strong>{{ $errors->first('ccExpiryMonth') }}</strong>
                                    </span>
                                    @endif
                                </div>
                            </div>
                            <div class="form-group{{ $errors->has('ccExpiryYear') ? ' has-error' : '' }}">
                                <label for="ccExpiryYear" class="col-md-4 control-label">ZIP Code</label>
                                <div class="col-md-6">
                                    <input id="zip" type="text" class="form-control" name="zip" placeholder="15975" value="{{ old('ccExpiryYear') }}" autofocus>
                                    @if ($errors->has('ccExpiryYear'))
                                        <span class="help-block">
                                        <strong>{{ $errors->first('card_code') }}</strong>
                                    </span>
                                    @endif
                                </div>
                            </div>
                            <div class="form-group{{ $errors->has('cvvNumber') ? ' has-error' : '' }}">
                                <label for="cvvNumber" class="col-md-4 control-label">CVV No.</label>
                                <div class="col-md-6">
                                    <input id="card_code" type="text" class="form-control" name="card_code" placeholder="CVV" value="{{ old('cvvNumber') }}" autofocus>
                                    @if ($errors->has('card_code'))
                                        <span class="help-block">
                                        <strong>{{ $errors->first('card_code') }}</strong>
                                    </span>
                                    @endif
                                </div>
                            </div>
                            <div class="form-group{{ $errors->has('amount') ? ' has-error' : '' }}">
                                <label for="name"><b>Plan Price: {{$currency_symbol->value}} {{$plan->price}}</b></label>
                                {{--<label for="amount" class="col-md-4 control-label">Amount</label>--}}
                                <div class="col-md-6">
                                    <input id="amount" type="hidden" class="form-control" name="amount" value="{{$plan->price}}" autofocus>
                                    <input id="plan_id" type="hidden" class="form-control" name="plan_id" value="{{$plan->id}}" >
                                    {{--<input id="amount" type="text" class="form-control" name="amount" value="{{ old('amount') }}" autofocus>--}}
                                    @if ($errors->has('amount'))
                                        <span class="help-block">
                                        <strong>{{ $errors->first('amount') }}</strong>
                                    </span>
                                    @endif
                                </div>
                            </div>
                            <style>
                                .btn{
                                    background-color: #F6AB36;
                                    width: 130px;
                                }
                                #butt{
                                    position: relative;
                                    margin-left: 115px;
                                }
                            </style>
                            <div class="form-group">
                                <div class="col-md-6 col-md-offset-4">
                                    <div id="butt">
                                        {{ Form::submit(trans('Confirm'), ['class' => 'btn']) }}
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
    <div class="row pb-100"></div>
@endsection