<!doctype html>
<html lang="{{ app()->getLocale() }}">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>@yield('title', app_name())</title>

    <!-- Meta -->
    <meta name="description" content="@yield('meta_description', 'Laravel 5 Boilerplate')">
    <meta name="author" content="@yield('meta_author', 'Anthony Rappa')">
    @yield('meta')

    <link rel="stylesheet" type="text/css" href="{{asset('style/css/bootstrap.min.css')}}"/>
    <link rel="stylesheet" type="text/css" href="{{asset('style/css/bootstrap-select.min.css')}}"/>
    <link rel="stylesheet" type="text/css" href="{{asset('style/css/font-awesome.min.css')}}"/>
    <link rel="stylesheet" type="text/css" href="{{asset('style/css/elegant.css')}}"/>
    <link rel="stylesheet" type="text/css" href="{{asset('style/css/owl.carousel.css')}}"/>
    <link rel="stylesheet" type="text/css" href="{{asset('style/css/animate.css')}}"/>
    <link rel="stylesheet" type="text/css" href="{{asset('style/css/theme.css')}}"/>


@yield('before-styles')
<!-- Check if the language is set to RTL, so apply the RTL layouts -->
    <!-- Otherwise apply the normal LTR layouts -->



@yield('after-styles')

<!-- Scripts -->
    <script>
        window.Laravel = <?php echo json_encode([
            'csrfToken' => csrf_token(),
        ]); ?>
    </script>
</head>
<body id="app-layout">

<div id="app">
    @include('includes.partials.logged-in-as')


    @include('includes.partials.messages')
    @yield('content')

</div><!--#app-->

<!-- Scripts -->
@yield('before-scripts')

@yield('after-scripts')
{!! Html::script('style/js/jquery-2.2.4.min.js') !!}
{!! Html::script('style/js/bootstrap.min.js') !!}
{!! Html::script('style/js/bootstrap-select.min.js') !!}
{!! Html::script('style/js/owl.carousel.min.js') !!}
{!! Html::script('style/js/jquery.sticky.js') !!}
{!! Html::script('style/js/wow.min.js') !!}
{!! Html::script('style/js/jquery.countdown.min.js') !!}
{!! Html::script('style/js/theme-ajax-mail.js') !!}
{!! Html::script('style/js/data.binder.js') !!}
{!! Html::script('style/js/theme.js') !!}


</body>
</html>
