@extends ('backend.layouts.app')

@section ('title', trans('labels.backend.seo.title'))

@section('page-header')
    <h1>
        {{ trans('labels.backend.seo.title') }}
        <small>{{ trans('labels.backend.seo.active') }}</small>
    </h1>
@endsection

@section('content')
    <div class="box box-success">
        <div class="box-header with-border">
            <h3 class="box-title">{{ trans('labels.backend.seo.active') }}</h3>
        </div>
        <div class="box-body">
            <div class="form-group">
                <div class="col-sm-12">
                    <div class="nav-tabs-custom">
                        <ul class="nav nav-tabs">
                            <li class="active"><a href="#company" data-toggle="tab" aria-expanded="true">{{ trans('labels.backend.seo.title') }}</a></li>
                        </ul>

                        <div class="tab-content">
                            <div class="tab-pane tab-margin active" id="company">
                                {{ Form::open(['route' => 'admin.superadmin.seo.store', 'class' => 'form-horizontal', 'role' => 'form', 'method' => 'post']) }}
                                <fieldset class="scheduler-border">
                                    <legend class="scheduler-border">{{ trans('labels.backend.seo.home') }}</legend>
                                    <div class="control-group">
                                        <div class="form-group">
                                            <div class="col-lg-12">
                                                {{ Form::textGroup('seo_seo_title', trans('validation.attributes.backend.seo.seo_title'), 'info') ,['placeholder' => trans('validation.attributes.backend.seo.seo_title')]}}
                                            </div>
                                            <div class="col-lg-12">
                                                {{ Form::textGroup('seo_keywords', trans('validation.attributes.backend.seo.keywords'), 'file-text',['placeholder' => trans('validation.attributes.backend.seo.keywords')]) }}
                                            </div>
                                            <div class="col-lg-12">
                                                {{ Form::textareaGroup('seo_meta_description', trans('validation.attributes.backend.seo.meta_description'),'', ['placeholder' => trans('validation.attributes.backend.seo.meta_description')]) }}
                                            </div>
                                        </div>
                                    </div>
                                    <legend class="scheduler-border">{{ trans('validation.attributes.backend.seo.price_page_seo') }}</legend>
                                    <div class="control-group">
                                        <div class="form-group">
                                            <div class="col-lg-12">
                                                {{ Form::textGroup('seo_seo_title2', trans('validation.attributes.backend.seo.title'), 'info',['placeholder' => trans('validation.attributes.backend.seo.title')]) }}
                                            </div>
                                            <div class="col-lg-12">
                                                {{ Form::textGroup('pricepage_seo_keywords', trans('validation.attributes.backend.seo.keywords'), 'file-text',['placeholder' => trans('validation.attributes.backend.seo.meta_description')]) }}
                                            </div>
                                            <div class="col-lg-12">
                                                {{ Form::textareaGroup('seo_price_meta_description', trans('validation.attributes.backend.seo.meta_description'),'', ['placeholder' => trans('validation.attributes.backend.seo.meta_description')]) }}
                                            </div>
                                        </div>
                                        <div class="setting-buttons clearfix">
                                            <div class="form-group no-margin">
                                                {!! Form::button('<span class="fa fa-save"></span> &nbsp;' . trans('general.save'), ['type' => 'submit', 'class' => 'btn btn-success']) !!}
                                                <a href="{{ URL::previous() }}" class="btn btn-default"><span class="fa fa-times-circle"></span> &nbsp;{{ trans('general.cancel') }}</a>
                                            </div>
                                        </div>
                                    </div>
                                </fieldset>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection