@extends ('backend.layouts.app')

@section ('title', trans('labels.backend.payment_gateway.paymentgateway'))


@section('page-header')
    <h1>
        {{ trans('labels.backend.payment_gateway.paymentgateway') }}
        <small>{{ trans('labels.backend.payment_gateway.active') }}</small>
    </h1>
@endsection
@section('content')
    <div class="box box-success">
        <div class="box-header with-border">
            <h3 class="box-title">{{ trans('labels.backend.payment_gateway.paymentgateway') }}</h3>
        </div>

    <div class="box-body">
        <div class="form-group">
            <div class="col-sm-12">
                <div class="nav-tabs-custom">
                    <ul class="nav nav-tabs">
                        <li class="active"><a href="#paypal" data-toggle="tab" aria-expanded="true">{{ trans('labels.backend.payment.paypal') }}</a></li>
                        <li><a href="#stripe" data-toggle="tab" aria-expanded="true">{{ trans('labels.backend.payment.stripe') }}</a></li>
                        <li><a href="#mercadopago" data-toggle="tab" aria-expanded="true">{{ trans('labels.backend.payment.mercadopago') }}</a></li>
                        <li><a href="#razorpay" data-toggle="tab" aria-expanded="true">{{ trans('labels.backend.payment.razorpay') }}</a></li>
                        <li><a href="#authorizenet" data-toggle="tab" aria-expanded="true">{{ trans('labels.backend.payment.authorizenet') }}</a></li>

                    </ul>

                    <div class="tab-content">

                        <div class="tab-pane tab-margin active" id="paypal">
                       {!! Form::model($setting, [
                       'method' => 'PATCH',
                       'url' => ['admin/superadmin/settings'],
                       'class' => 'setting-form',
                       'files' => true,
                       'role' => 'form'
                        ]) !!}

                            <fieldset class="scheduler-border">
                                <div class="control-group">

                                        <div class="col-lg-4">
                                            {{ Form::radioGroup('paymentgateway_enable_paypal', trans('validation.attributes.backend.payment-gateway.enable')) }}
                                        </div>
                                        <div class="col-lg-12"><h4>
                                            {{ Form::radio('paymentgateway_paypal', 'Sandbox') }}&nbsp;&nbsp;Sandbox&nbsp;&nbsp;
                                            {{ Form::radio('paymentgateway_paypal', 'Live') }}&nbsp;&nbsp;Live</h4>
                                            <br>
                                        </div>
                                    <div class="form-group">
                                        <h4>{{ Form::label('paymentgateway_sandbox', trans('validation.attributes.backend.payment-gateway.sandbox'), ['class' => 'col-lg-2 control-label']) }}</h4>
                                        <div class="col-lg-12">
                                            <br>{{ Form::textGroup('paymentgateway_paypal_user', trans('validation.attributes.backend.payment-gateway.paypal_user'), 'user') ,['placeholder' => trans('validation.attributes.backend.payment-gateway.paypal_user')]}}
                                        </div>
                                        <div class="col-lg-12">
                                            {{ Form::textGroup('paymentgateway_paypal_pass', trans('validation.attributes.backend.payment-gateway.paypal_pass'), 'key',['placeholder' => trans('validation.attributes.backend.payment-gateway.paypal_pass')]) }}
                                        </div>
                                        <div class="col-lg-12">
                                            {{ Form::textGroup('paymentgateway_paypal_signature', trans('validation.attributes.backend.payment-gateway.paypal_signature'), 'pencil',['placeholder' => trans('validation.attributes.backend.payment-gateway.paypal_signature')]) }}
                                        </div>
                                        <div class="form-group">
                                            <h4>{{ Form::label('paymentgateway_live', trans('validation.attributes.backend.payment-gateway.live1'), ['class' => 'col-lg-2 control-label']) }}</h4>
                                            <div class="col-lg-12">
                                                <br>{{ Form::textGroup('paymentgateway_live_paypal_user', trans('validation.attributes.backend.payment-gateway.paypal_user'), 'user',['placeholder' => trans('validation.attributes.backend.payment-gateway.paypal_user')]) }}
                                            </div>
                                            <div class="col-lg-12">
                                                {{ Form::passwordGroup('paymentgateway_live_paypal_pass', trans('validation.attributes.backend.payment-gateway.paypal_pass'), 'key',['placeholder' => trans('validation.attributes.backend.payment-gateway.paypal_user')]) }}
                                            </div>
                                            <div class="col-lg-12">
                                                {{ Form::textGroup('paymentgateway_live_paypal_signature', trans('validation.attributes.backend.payment-gateway.paypal_signature'), 'pencil',['placeholder' => trans('validation.attributes.backend.payment-gateway.paypal_signature')]) }}
                                            </div>
                                            <div class="col-lg-4">
                                                <div class="setting-buttons clearfix">
                                                    <div class="form-group no-margin">
                                                        {!! Form::button('<span class="fa fa-save"></span> &nbsp;' . trans('general.save'), ['type' => 'submit', 'class' => 'btn btn-success']) !!}
                                                        <a href="{{ URL::previous() }}" class="btn btn-default"><span class="fa fa-times-circle"></span> &nbsp;{{ trans('general.cancel') }}</a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </fieldset>
                            {{ Form::Close() }}
                        </div>

                        <div class="tab-pane tab-margin" id="stripe">
                            <div class="scheduler-border">
                                <div class="control-group">
                                    {!! Form::model($setting, [
                                      'method' => 'PATCH',
                                      'url' => ['admin/superadmin/settings'],
                                      'class' => 'setting-form',
                                      'files' => true,
                                      'role' => 'form'
                                    ]) !!}
                                    <fieldset class="scheduler-border">
                                        <div class="control-group">
                                            <div class="col-lg-4">
                                                {{ Form::radioGroup('paymentgateway_enable_stripe', trans('validation.attributes.backend.payment-gateway.stripe_enable')) }}
                                            </div>
                                            <div class="col-lg-12"><h4>
                                                    {{ Form::radio('paymentgateway_stripe', 'Sandbox') }}&nbsp;&nbsp;Sandbox&nbsp;&nbsp;
                                                    {{ Form::radio('paymentgateway_stripe', 'Live') }}&nbsp;&nbsp;Live</h4>
                                            </div>
                                            <div class="form-group">
                                                <h4>{{ Form::label('paymentgateway_sandbox', trans('validation.attributes.backend.payment-gateway.sandbox'), ['class' => 'col-lg-2 control-label']) }}
                                                </h4>
                                                <div class="col-lg-12">
                                                    <br>{{ Form::textGroup('paymentgateway_test_secret_key', trans('validation.attributes.backend.payment-gateway.test_secret_key'), 'key') ,['placeholder' => trans('validation.attributes.backend.payment-gateway.test_secret_key')]}}
                                                </div>
                                                <div class="col-lg-12">
                                                    {{ Form::textGroup('paymentgateway_test_publishable_key', trans('validation.attributes.backend.payment-gateway.test_publishable_key'), 'key',['placeholder' => trans('validation.attributes.backend.payment-gateway.test_publishable_key')]) }}
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <h4>{{ Form::label('paymentgateway_live', trans('validation.attributes.backend.payment-gateway.live'), ['class' => 'col-lg-2 control-label']) }}</h4>
                                                <div class="col-lg-12">
                                                    <br>{{ Form::textGroup('paymentgateway_live_test_secret_key', trans('validation.attributes.backend.payment-gateway.test_secret_key'), 'key',['placeholder' => trans('validation.attributes.backend.payment-gateway.test_secret_key')]) }}
                                                </div>
                                                <div class="col-lg-12">
                                                    {{ Form::textGroup('paymentgateway_live_test_publishable_key', trans('validation.attributes.backend.payment-gateway.test_publishable_key'), 'key',['placeholder' => trans('validation.attributes.backend.payment-gateway.test_publishable_key')]) }}
                                                </div>
                                                <div class="col-lg-12">
                                                    <div class="setting-buttons clearfix">
                                                        <div class="form-group no-margin">
                                                            {!! Form::button('<span class="fa fa-save"></span> &nbsp;' . trans('general.save'), ['type' => 'submit', 'class' => 'btn btn-success']) !!}
                                                            <a href="{{ URL::previous() }}" class="btn btn-default"><span class="fa fa-times-circle"></span> &nbsp;{{ trans('general.cancel') }}</a>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </fieldset>
                                    {{ Form::Close() }}
                                </div>
                            </div>
                        </div>

                        <div class="tab-pane tab-margin" id="mercadopago">
                            {!! Form::model($setting, [
                              'method' => 'PATCH',
                              'url' => ['admin/superadmin/settings'],
                              'class' => 'setting-form',
                              'files' => true,
                              'role' => 'form'
                            ]) !!}
                            <fieldset class="scheduler-border">
                                <div class="control-group">
                                    <div class="col-lg-4">
                                            {{ Form::radioGroup('paymentgateway.enable_mercadopago', trans('validation.attributes.backend.payment-gateway.enable_mercadopago')) }}
                                    </div>
                                    <div class="col-lg-12"><h4>
                                            {{ Form::radio('paymentgateway_mercadopago', 'Sandbox') }}&nbsp;&nbsp;Sandbox&nbsp;&nbsp;
                                            {{ Form::radio('paymentgateway_mercadopago', 'Live') }}&nbsp;&nbsp;Live</h4>
                                    </div>
                                    <div class="form-group">
                                        <div class="col-lg-12">
                                            <br>{{ Form::textGroup('paymentgateway_client_id', trans('validation.attributes.backend.payment-gateway.client_id'), 'id-card') ,['placeholder' => trans('validation.attributes.backend.payment-gateway.client_id')]}}
                                        </div>
                                        <div class="col-lg-12">
                                            {{ Form::textGroup('paymentgateway_client_secret', trans('validation.attributes.backend.payment-gateway.client_secret'), 'user-secret',['placeholder' => trans('validation.attributes.backend.payment-gateway.client_secret')]) }}
                                        </div>
                                        <div class="col-lg-12">
                                            <div class="setting-buttons clearfix">
                                                <div class="form-group no-margin">
                                                    {!! Form::button('<span class="fa fa-save"></span> &nbsp;' . trans('general.save'), ['type' => 'submit', 'class' => 'btn btn-success']) !!}
                                                    <a href="{{ URL::previous() }}" class="btn btn-default"><span class="fa fa-times-circle"></span> &nbsp;{{ trans('general.cancel') }}</a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </fieldset>
                            {{ Form::Close() }}
                        </div>

                        <div class="tab-pane tab-margin" id="razorpay">
                            {!! Form::model($setting, [
                              'method' => 'PATCH',
                              'url' => ['admin/superadmin/settings'],
                              'class' => 'setting-form',
                              'files' => true,
                              'role' => 'form'
                            ]) !!}
                            <fieldset class="scheduler-border">
                                <div class="control-group">
                                    <div class="col-lg-4">
                                            {{ Form::radioGroup('paymentgateway_enable_razorpay', trans('validation.attributes.backend.payment-gateway.enable_razorpay')) }}
                                    </div>
                                    <div class="col-lg-12"><h4>
                                            {{ Form::radio('paymentgateway_razor', 'Sandbox') }}&nbsp;&nbsp;Sandbox&nbsp;&nbsp;
                                            {{ Form::radio('paymentgateway_razor', 'Live') }}&nbsp;&nbsp;Live</h4>
                                    </div>
                                    <div class="form-group">
                                        <div class="col-lg-12">
                                            <br>{{ Form::textGroup('paymentgateway_key_id', trans('validation.attributes.backend.payment-gateway.key_id'), 'id-card') ,['placeholder' => trans('validation.attributes.backend.payment-gateway.key_id')]}}
                                        </div>
                                        <div class="col-lg-12">
                                            {{ Form::textGroup('paymentgateway_key_secret', trans('validation.attributes.backend.payment-gateway.key_secret'), 'user-secret',['placeholder' => trans('validation.attributes.backend.payment-gateway.key_secret')]) }}
                                        </div>
                                        <div class="col-lg-12">
                                            <div class="setting-buttons clearfix">
                                                <div class="form-group no-margin">
                                                    {!! Form::button('<span class="fa fa-save"></span> &nbsp;' . trans('general.save'), ['type' => 'submit', 'class' => 'btn btn-success']) !!}
                                                    <a href="{{ URL::previous() }}" class="btn btn-default"><span class="fa fa-times-circle"></span> &nbsp;{{ trans('general.cancel') }}</a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </fieldset>
                            {{ Form::Close() }}
                        </div>

                        <div class="tab-pane tab-margin" id="authorizenet">
                            {!! Form::model($setting, [
                              'method' => 'PATCH',
                              'url' => ['admin/superadmin/settings'],
                              'class' => 'setting-form',
                              'files' => true,
                              'role' => 'form'
                            ]) !!}
                            <fieldset class="scheduler-border">
                                <div class="control-group">
                                    <div class="col-lg-4">
                                            {{ Form::radioGroup('paymentgateway.enable_authorized', trans('validation.attributes.backend.payment-gateway.enable_authorized')) }}
                                    </div>
                                    <div class="col-lg-12"><br><h4>
                                            {{ Form::radio('paymentgateway_authorize', 'Sandbox') }}&nbsp;&nbsp;Sandbox&nbsp;&nbsp;
                                            {{ Form::radio('paymentgateway_authorize', 'Live') }}&nbsp;&nbsp;Live</h4>
                                    </div>
                                    <div class="form-group">
                                        <div class="col-lg-12">
                                            <br>{{ Form::textGroup('paymentgateway_api_login_id', trans('validation.attributes.backend.payment-gateway.api_login-id'), 'id-card') ,['placeholder' => trans('validation.attributes.backend.payment-gateway.api_login-id')]}}
                                        </div>
                                        <div class="col-lg-12">
                                            {{ Form::textGroup('paymentgateway_transaction_key' , trans('validation.attributes.backend.payment-gateway.transaction_key'), 'key',['placeholder' => trans('validation.attributes.backend.payment-gateway.transaction_key')]) }}
                                        </div>
                                        <div class="col-lg-12">
                                            <div class="setting-buttons clearfix">
                                                <div class="form-group no-margin">
                                                    {!! Form::button('<span class="fa fa-save"></span> &nbsp;' . trans('general.save'), ['type' => 'submit', 'class' => 'btn btn-success']) !!}
                                                    <a href="{{ URL::previous() }}" class="btn btn-default"><span class="fa fa-times-circle"></span> &nbsp;{{ trans('general.cancel') }}</a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </fieldset>
                            {{ Form::Close() }}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    </div>

@endsection

@section('after-scripts')
    {{ Html::script("/js/backend/plugin/bootstrap-fancyfile.js") }}


    <script>
        var text_yes = '{{ trans('general.yes') }}';
        var text_no = '{{ trans('general.no') }}';

        $(document).ready(function() {

            $('#company_logo').fancyfile({
                text  : '{{ trans('general.form.select.file') }}',
                style : 'btn-default',
                placeholder : '<?php echo $setting->pull('company_logo'); ?>'
            });

            $("#date_format").select2({
                placeholder: "{{ trans('general.form.select.field', ['field' => trans('settings.localisation.date.format')]) }}"
            });

            $("#date_separator").select2({
                placeholder: "{{ trans('general.form.select.field', ['field' => trans('settings.localisation.date.separator')]) }}"
            });

            $("#timezone").select2({
                placeholder: "{{ trans('general.form.select.field', ['field' => trans('settings.localisation.timezone')]) }}"
            });

            $("#default_account").select2({
                placeholder: "{{ trans('general.form.select.field', ['field' => trans('settings.default.account')]) }}"
            });

            $("#default_currency").select2({
                placeholder: "{{ trans('general.form.select.field', ['field' => trans('settings.default.currency')]) }}"
            });

            $("#default_tax").select2({
                placeholder: "{{ trans('general.form.select.field', ['field' => trans('settings.default.tax')]) }}"
            });

            $("#default_payment_method").select2({
                placeholder: "{{ trans('general.form.select.field', ['field' => trans('settings.default.payment')]) }}"
            });

            $("#default_locale").select2({
                placeholder: "{{ trans('general.form.select.field', ['field' => trans('settings.default.language')]) }}"
            });

            $("#admin_theme").select2({
                placeholder: "{{ trans('general.form.select.field', ['field' => trans('settings.appearance.theme')]) }}"
            });

            $("#email_protocol").select2({
                placeholder: "{{ trans('general.form.select.field', ['field' => trans('settings.email.protocol')]) }}"
            });

            $("#list_limit").select2({
                placeholder: "{{ trans('general.form.select.field', ['field' => trans('settings.appearance.list_limit')]) }}"
            });

            $("#session_handler").select2({
                placeholder: "{{ trans('general.form.select.field', ['field' => trans('settings.system.session.handler')]) }}"
            });



            $('#invoice_logo').fancyfile({
                text  : '{{ trans('general.form.select.file') }}',
                style : 'btn-default',
                placeholder : '<?php echo $setting->pull('invoice_logo'); ?>'
            });

            $("select[name='email_protocol']").on('change', function() {
                var selection = $(this).val();

                if (selection == 'mail' || selection == 'log') {
                    $("input[name='email_sendmail_path']").prop('disabled', true);
                    $("input[name='email_smtp_host']").prop('disabled', true);
                    $("input[name='email_smtp_username']").prop('disabled', true);
                    $("input[name='email_smtp_password']").prop('disabled', true);
                    $("input[name='email_smtp_port']").prop('disabled', true);
                    $("select[name='email_smtp_encryption']").prop('disabled', true);
                }
                else if(selection == 'sendmail') {
                    $("input[name='email_sendmail_path']").prop('disabled', false);
                    $("input[name='email_smtp_host']").prop('disabled', true);
                    $("input[name='email_smtp_username']").prop('disabled', true);
                    $("input[name='email_smtp_password']").prop('disabled', true);
                    $("input[name='email_smtp_port']").prop('disabled', true);
                    $("select[name='email_smtp_encryption']").prop('disabled', true);
                }
                else if (selection == 'smtp') {
                    $("input[name='email_sendmail_path']").prop('disabled', true);
                    $("input[name='email_smtp_host']").prop('disabled', false);
                    $("input[name='email_smtp_username']").prop('disabled', false);
                    $("input[name='email_smtp_password']").prop('disabled', false);
                    $("input[name='email_smtp_port']").prop('disabled', false);
                    $("select[name='email_smtp_encryption']").prop('disabled', false);
                }
            });

            $("select[name='email_protocol']").trigger('change');
        });
    </script>
@stop
