@extends('backend.layouts.app')
@section ('title', trans('labels.backend.gen_settings.title'))
@section('page-header')
    <h1>

        <small>{{ trans('labels.backend.gen_settings.title') }}</small>
    </h1>
@endsection
@section('content')
    <div class="box box-success">
        <div class="box-header with-border">
            <h3 class="box-title">{{ trans('labels.backend.gen_settings.title') }}</h3>

        </div><!-- /.box-header -->

        <div class="box-body">
            <div class="form-group">

                <div class="row">
                    {!! Form::model($setting, [
                        'method' => 'PATCH',
                        'url' => ['admin/superadmin/settings'],
                        'class' => 'setting-form',
                        'files' => true,
                        'role' => 'form'
                    ]) !!}

                    <?php
                    //    var_dump($setting["use_smtp"]);
                     //   die();
                    ?>



                    <div class="col-sm-12">
                        <div class="nav-tabs-custom">
                            <ul class="nav nav-tabs">
                                <li class="active"><a href="#company" data-toggle="tab" aria-expanded="true">{{ trans('labels.backend.gen_settings.tab') }}</a></li>
                            </ul>

                            <div class="tab-content">
                                <div class="tab-pane tab-margin active" id="company">
                                    <fieldset class="scheduler-border">
                                        <legend class="scheduler-border">{{ trans('labels.backend.gen_settings.title2') }}</legend>
                                        <div class="control-group">

                                            {{ Form::textGroup('company_name', trans('validation.attributes.backend.settings.company_name'), 'info') }}
                                            {{ Form::textGroup('company_address', trans('validation.attributes.backend.settings.company_address'), 'id-card-o') }}
                                            {{ Form::textGroup('contact_no', trans('validation.attributes.backend.settings.contact_no'), 'mobile') }}
                                            {{ Form::textGroup('email', trans('validation.attributes.backend.settings.email'), 'envelope') }}
                                            {{ Form::selectGroup('country', trans('validation.attributes.backend.settings.country'), 'flag', $countries, null, []) }}
                                            {{ Form::textareaGroup('custom_footer', trans('validation.attributes.backend.settings.custom_footer')) }}
                                            {{ Form::fileGroup('desktop_logo', trans('validation.attributes.backend.settings.upload_logo')) }}
                                        </div>
                                    </fieldset>

                                    {{--<fieldset class="scheduler-border">--}}
                                        {{--<legend class="scheduler-border">{{ trans('labels.backend.gen_settings.title3') }}</legend>--}}
                                        {{--<div class="control-group">--}}
                                             {{--{{ Form::radioGroup('use_php_mail', trans('validation.attributes.backend.settings.use_php_mail'),null,$setting["use_php_mail"]) }}--}}
                                            {{--{{ Form::radioGroup('use_smtp', trans('validation.attributes.backend.settings.use_smtp')) }}--}}
                                            {{--{{ Form::textGroup('email_global_sender', trans('validation.attributes.backend.settings.email_global_sender'), 'info') }}--}}
                                        {{--</div>--}}
                                    {{--</fieldset>--}}

                                    <fieldset class="scheduler-border">
                                        <legend class="scheduler-border">{{ trans('labels.backend.gen_settings.title4') }}</legend>
                                        <div class="control-group">
                                            {{ Form::textGroup('api_key', trans('validation.attributes.backend.settings.api_key'), 'key') }}
                                            {{ Form::textGroup('push_api_key', trans('validation.attributes.backend.settings.push_api_key'), 'key') }}
                                        </div>
                                    </fieldset>

                                    <fieldset class="scheduler-border">
                                        <legend class="scheduler-border">{{ trans('labels.backend.gen_settings.title5') }}</legend>
                                        <div class="control-group">
                                            {{ Form::textGroup('facebook', trans('validation.attributes.backend.settings.facebook'), 'facebook') }}
                                            {{ Form::textGroup('google', trans('validation.attributes.backend.settings.google'), 'google-plus') }}
                                            {{ Form::textGroup('twitter', trans('validation.attributes.backend.settings.twitter'), 'twitter') }}

                                        </div>
                                    </fieldset>

                                    <fieldset class="scheduler-border">
                                        <legend class="scheduler-border">{{ trans('labels.backend.gen_settings.title6') }}</legend>
                                        <div class="control-group">
                                            {{ Form::radioGroup('enable_signup_verification', trans('validation.attributes.backend.settings.enable_signup_verification')) }}
                                            {{ Form::radioGroup('signup_needs_admin_approval', trans('validation.attributes.backend.settings.signup_needs_admin_approval')) }}
                                            {{--{{ Form::radioGroup('use_email', trans('validation.attributes.backend.settings.use_email')) }}--}}
                                            {{--{{ Form::radioGroup('use_sms', trans('validation.attributes.backend.settings.use_sms')) }}--}}
                                        </div>
                                    </fieldset>

                                    <fieldset class="scheduler-border">
                                        <legend class="scheduler-border">{{ trans('labels.backend.gen_settings.title7') }}</legend>
                                        <div class="control-group">
                                            {{ Form::selectGroup('timezone', trans('validation.attributes.backend.settings.timezone'), 'globe', $timezones, null, []) }}
                                        </div>
                                    </fieldset>

                                    <fieldset class="scheduler-border">
                                        <legend class="scheduler-border">{{ trans('labels.backend.gen_settings.title8') }}</legend>
                                        <div class="control-group">
                                            {{ Form::textGroup('default_currency', trans('validation.attributes.backend.settings.default_currency'), 'money') }}
                                            {{ Form::selectGroup('currency_position', trans('validation.attributes.backend.settings.currency_position'), 'caret-down', ['left'=>'Left','right'=>'Right'], null, []) }}
                                            {{ Form::textGroup('decimal_places', trans('validation.attributes.backend.settings.decimal_places'), 'map-marker') }}
                                            {{ Form::radioGroup('add_space_between_currency', trans('validation.attributes.backend.settings.add_space_between_currency&price')) }}
                                        </div>
                                    </fieldset>

                                    <fieldset class="scheduler-border">
                                        <legend class="scheduler-border">
                                            {{ trans('labels.backend.gen_settings.title9') }}</legend>
                                        <div class="control-group">
                                            {{ Form::radioGroup('enable_promo_code', trans('validation.attributes.backend.settings.enable_promo_code')) }}
                                        </div>
                                    </fieldset>
                                </div>
                                <div class="setting-buttons clearfix">
                                    <div class="form-group no-margin">
                                        {!! Form::button('<span class="fa fa-save"></span> &nbsp;' . trans('general.save'), ['type' => 'submit', 'class' => 'btn btn-success']) !!}

                                        <a href="{{ URL::previous() }}" class="btn btn-default"><span class="fa fa-times-circle"></span> &nbsp;{{ trans('general.cancel') }}</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    {!! Form::close() !!}
                </div>
            </div><!--form control-->
        </div><!-- /.box-body -->
    </div><!--box-->

@endsection

@section('after-scripts')
    <script>
        var text_yes = '{{ trans('general.yes') }}';
        var text_no = '{{ trans('general.no') }}';

        $(document).ready(function() {

            $('#desktop_logo').fancyfile({
                text  : '{{ trans('general.form.select.file') }}',
                style : 'btn-default',
                placeholder : '<?php echo $setting->pull('desktop_logo'); ?>'
            });

            $("#timezone").select2({
                placeholder: "{{ trans('general.form.select.field', ['field' => trans('Time Zone')]) }}"
            });
            $("#country").select2({
                placeholder: "{{ trans('general.form.select.field', ['field' => trans('validation.attributes.backend.settings.country')]) }}"
            });

            $("#currency_position").select2({
                placeholder: "{{ trans('general.form.select.field', ['field' => trans('Currency Position')]) }}"
            });
        });
    </script>

@stop
