@extends ('backend.layouts.app')

@section ('title', trans('Invoice'))

@section('after-styles')
    {{ Html::style("css/backend/plugin/datatables/dataTables.bootstrap.min.css") }}
@stop

@section('page-header')
    <h1>
        {{ trans('Invoice') }}
        <small>{{ trans('labels.backend.title.promo.active') }}</small>
    </h1>
@endsection

@section('content')

    <div class="col-md-12">
        {{ Form::open(['route' => 'admin.superadmin.get', 'class' => '', 'role' => 'form', 'method' => 'get' , 'enctype' => 'multipart/form-data']) }}
        {{ Form::selectGroupFullWidth('agency_id', trans('Agency'), 'info', $agency, null, []) }}
        {{ Form::textGroup('startdate', trans('Start Date'), 'calendar', ['placeholder' => trans('Start Date')]) }}
        {{ Form::textGroup('enddate', trans('End Date'), 'calendar', ['placeholder' => trans('End Date')]) }}
    </div>

    <div class="col-md-12">
        <div class="box box-success">
            <div class="box box-info">
                <div class="box-body">
                    <div class="pull-left">
                    </div><!--pull-left-->
                    <div class="pull-right">
                        {{ Form::submit(trans('Get Invoice'), ['class' => 'btn btn-success btn-md']) }}
                    </div><!--pull-right-->
                    <div class="clearfix"></div>
                </div><!-- /.box-body -->
            </div>
        </div>
    </div>
    {{ Form::close() }}
    @if($check==1)
        <legend class="scheduler-border">{{ trans('Agency Details') }}</legend>
        <div class="col-md-12">
            <div class="box box-success">
                <div class="box-body">
                    <table class="table table-hover" style="margin-top: 10px;">
                        <thead>
                        <tr>
                            <th>Agency Name</th>
                            <th>Phone</th>
                            <th>Email</th>
                            <th>Website</th>
                        </tr>
                        </thead>
                        <tbody>
                        <tr>
                            <td>{{$agencydetails->agency_name}}</td>
                            <td>{{$agencydetails->phone}}</td>
                            <td>{{$agencydetails->email}}</td>
                            <td>{{$agencydetails->website}}</td>
                        </tr>
                        </tbody>
                    </table>
                    <legend class="scheduler-border">{{ trans('Agents') }}</legend>
                    <div class="col-md-6">
                        <div class="col-md-6">
                            {{--<a class="btn btn-info btn-sm mb-1" href="{{ route('admin.agent.downloadpdf') }}">Details</a>--}}
                            <div class="table-responsive">
                                <table class="table table-hover" style="margin-top: 10px;">
                                    @foreach($agents as $agent)
                                        <tr>
                                            <th>{{$agent->first_name}} {{$agent->last_name}}</th>
                                        </tr>
                                    @endforeach
                                </table>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="col-md-6">
                            {{--<a class="btn btn-info btn-sm mb-1" href="{{ route('admin.agent.downloadpdf') }}">Details</a>--}}
                            <div class="table-responsive">
                                <table class="table table-hover" style="margin-top: 10px;">
                                    @foreach($agents as $agent)
                                        <tr>
                                            <th>{{$agent->email}}</th>
                                        </tr>
                                    @endforeach
                                </table>
                            </div>
                        </div>
                    </div>
                    <legend class="scheduler-border">{{ trans('Transfers') }}</legend>
                    <div class="col-md-12">
                        <div class="col-md-12">
                            {{--<a class="btn btn-info btn-sm mb-1" href="{{ route('admin.agent.downloadpdf') }}">Details</a>--}}
                            <div class="table-responsive">
                                <table class="table table-hover" style="margin-top: 10px;">
                                    {{--@foreach($agents as $agent)--}}
                                    <tr>
                                        <th>Total Numbers of Transfers: {{$transfers}}</th>
                                    </tr>
                                    {{--@endforeach--}}
                                </table>
                            </div>
                        </div>
                    </div>
                    <legend class="scheduler-border">{{ trans('Account Balance') }}</legend>
                    <div class="col-md-6">
                        <div class="col-md-6">
                            {{--<a class="btn btn-info btn-sm mb-1" href="{{ route('admin.agent.downloadpdf') }}">Details</a>--}}
                            <div class="table-responsive">
                                <table class="table table-hover" style="margin-top: 10px;">
                                    {{--                                    @foreach($agents as $agent)--}}
                                    <tr>
                                        <th>Total Account Blance
                                            is: USD {{$balance->balance}}</th>
                                    </tr>
                                    {{--@endforeach--}}
                                </table>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    @endif
@stop

@section('after-scripts')

    <script>
        $('.invoice').click(function() {
            window.print();
        });
    </script>
    <script>
        $(document).ready(function () {
            $("#agency_id").select2({
                placeholder: "{{ trans('Select Agency', ['field' => trans('Agency')]) }}"
            });
        });
    </script>

    <script>
        $(function () {
            $("#startdate").datepicker();
        });
    </script>

    <script>
        $(function () {
            $("#enddate").datepicker();
        });
    </script>

    {{ Html::script("js/backend/plugin/datatables/jquery.dataTables.min.js") }}
    {{ Html::script("js/backend/plugin/datatables/dataTables.bootstrap.min.js") }}

@stop
