@extends ('backend.layouts.app')

@section ('title', trans('Agencies'))

@section('after-styles')
    {{ Html::style("css/backend/plugin/datatables/dataTables.bootstrap.min.css") }}
@stop

@section('page-header')
    <h1>
        {{ trans('Agencies Management') }}
        <small>{{ trans('Active') }}</small>
    </h1>
@endsection

@section('content')
    <div class="box box-success">
        <div class="box-header with-border">
            <h3 class="box-title">{{ trans('Active') }}</h3>
            <div class="box-tools pull-right">
                @include('backend.superadmin.plans.includes.partials.plans-header-buttons')
            </div>
        </div>
        <div class="box-body">
            <div class="table-responsive">
                <table id="plan-table" class="table table-condensed table-hover">
                    <thead>
                    <tr>
                        <th>{{ trans('Agency Name') }}</th>
                        <th>{{ trans('Phone') }}</th>
                        <th>{{ trans('Email') }}</th>
                        <th>{{ trans('Website') }}</th>
                        <th>{{ trans('Balance') }}</th>
                        <th>{{ trans('labels.backend.title.plan.table.status') }}</th>
                        <th>{{ trans('labels.general.actions') }}</th>
                    </tr>
                    </thead>
                </table>
            </div>
        </div>
    </div>
@endsection

@section('after-scripts')
    {{ Html::script("js/backend/plugin/datatables/jquery.dataTables.min.js") }}
    {{ Html::script("js/backend/plugin/datatables/dataTables.bootstrap.min.js") }}
    {{ Html::script('js/dataTable.js') }}
    <script>
        $(function() {
            $('#plan-table').DataTable({
                processing: true,
                serverSide: true,
                ajax: {
                    url: '{{ route("admin.superadmin.pln.get") }}',
                    type: 'get'
                },
                columns: [
                    {data: 'agency_name', name: '{{config('tables.agency_table')}}.agency_name', render: $.fn.dataTable.render.text()},
                    {data: 'phone', name: '{{config('tables.agency_table')}}.phone'},
                    {data: 'email', name: '{{config('tables.agency_table')}}.email'},
                    {data: 'website', name: '{{config('tables.agency_table')}}.website'},
                    {data: 'balance', name: '{{config('tables.agency_table')}}.balance'},
                    {data: 'status', name: '{{config('tables.agency_table')}}.status'},
                    {data: 'actions', name: 'actions', searchable: false, sortable: false}
                ],
                order: [[0, "asc"]],
                searchDelay: 100,
                dom: 'lBfrtip',
                buttons: {
                    buttons: [
                        { extend: 'copy', className: 'copyButton',  exportOptions: {columns: [ 0, 1, 2, 3 ]  }},
                        { extend: 'csv', className: 'csvButton',  exportOptions: {columns: [ 0, 1, 2, 3 ]  }},
                        { extend: 'excel', className: 'excelButton',  exportOptions: {columns: [ 0, 1, 2, 3 ]  }},
                        { extend: 'pdf', className: 'pdfButton',  exportOptions: {columns: [ 0, 1, 2, 3 ]  }},
                        { extend: 'print', className: 'printButton',  exportOptions: {columns: [ 0, 1, 2, 3 ]  }}
                    ]
                }
            });
            Backend.DataTableSearch.init(dataTable);
        });
    </script>
@endsection

