@extends ('backend.layouts.app')

@section ('title', trans('Agency') . ' | ' . trans('labels.backend.title.plan.edit'))

@section('page-header')
    <h1>
        {{ trans('Agency Management') }}
        <small>{{ trans('') }}</small>
    </h1>
@endsection

@section('content')
    {{ Form::model($plan, ['route' => ['admin.superadmin.plans.update', $plan], 'class' => '', 'role' => 'form', 'method' => 'PATCH']) }}

    <div class="box box-success">
        <div class="box-header with-border">
            <h3 class="box-title">{{ trans('labels.backend.title.plan.edit') }}</h3>

            <div class="box-tools pull-right">
                @include('backend.superadmin.plans.includes.partials.plans-header-buttons')
            </div>
        </div>
        <div class="box-body">
            <div class="control-group">
                {{ Form::textGroup('agency_name', trans('Agency Name'), 'info', ['placeholder' => trans('Agency Name')]) }}
                {{ Form::textGroup('phone', trans('Phone'), 'phone', ['placeholder' => trans('Phone')]) }}
                {{ Form::textGroup('email', trans('Email'), 'envelope', ['placeholder' => trans('Email')]) }}
                {{ Form::textGroup('website', trans('Website'), 'globe', ['placeholder' => trans('Website')]) }}
                {{ Form::textGroup('transection_price', trans('Transection Price'), 'money', ['placeholder' => trans('Transection Price')]) }}
                {{ Form::selectGroup('country', trans('Country'), 'flag', $countries, [$plan->country], []) }}
                {{ Form::selectGroup('state', trans('State'), 'flag', $states, [$plan->state], []) }}
                {{ Form::selectGroup('city', trans('City'), 'flag', $cities, [$plan->city], []) }}
                {{ Form::textGroup('address', trans('Address'), 'envelope', ['placeholder' => trans('Address')]) }}
                {{ Form::textGroup('zip_code', trans('Zip Code'), 'envelope', ['placeholder' => trans('Zip Code')]) }}
                {{ Form::selectGroup('status', trans('validation.attributes.backend.plan.status'), 'caret-down', ['1'=>'Active','0'=>'Deactivate'],  $plan->status, []) }}
            </div>
        </div>
    </div>
    <div class="box box-info">
        <div class="box-body">
            <div class="pull-left">
                {{ link_to_route('admin.superadmin.plans.index', trans('buttons.general.cancel'), [], ['class' => 'btn btn-danger btn-md']) }}
            </div>

            <div class="pull-right">
                {{ Form::submit(trans('buttons.general.crud.update'), ['class' => 'btn btn-success btn-md']) }}
            </div>
            <div class="clearfix"></div>
        </div>
    </div>
    {{ Form::close() }}
@stop

@section('after-scripts')
    {{ Html::script('js/backend/access/users/script.js') }}

    <script>
        $(function () {
            $('#state').on('change', function () {
                var id = $(this).val();
                $.ajax({
                    method: "GET",
                    url: '{{url('admin/superadmin/cities') }}' + '/' + id,
                    type: "html"
                }).done(function (data) {
                    $('#city').html(data.html);
                }).fail(function(error) {
                    console.log(error);
                });
            });

            $('#country').on('change', function () {
                var id = $(this).val();
                $.ajax({
                    method: "GET",
                    url: '{{url('admin/superadmin/states') }}' + '/' + id,
                    type: "html"
                }).done(function (data) {
                    $('#state').html(data.html);
                    $('#city').html('');
                }).fail(function(error) {
                    console.log(error);
                });
            });
        });
    </script>

    <script>

        var text_yes = '{{ trans('general.yes') }}';
        var text_no = '{{ trans('general.no') }}';

        $(document).ready(function () {

            $("#type").select2({
                placeholder: "{{ trans('Day', ['field' => trans('settings.localisation.date.format')]) }}"
            });

            $("#status").select2({
                placeholder: "{{ trans('Published', ['field' => trans('settings.localisation.date.format')]) }}"
            });
        });
    </script>
@stop
