@extends ('backend.layouts.app')

@section ('title', trans('Agency') . ' | ' . trans('labels.backend.title.plan.create'))
{{--{{dd('opkodkaopsd')}}--}}
@section('page-header')
    <h1>
        {{ trans('Agency Management') }}
        <small>{{ trans('labels.backend.title.plan.create') }}</small>
    </h1>

<style>
    .StripeElement {
        box-sizing: border-box;

        height: 40px;

        padding: 10px 12px;

        border: 1px solid transparent;
        border-radius: 4px;
        background-color: white;

        box-shadow: 0 1px 3px 0 #e6ebf1;
        -webkit-transition: box-shadow 150ms ease;
        transition: box-shadow 150ms ease;
    }

    .StripeElement--focus {
        box-shadow: 0 1px 3px 0 #cfd7df;
    }

    .StripeElement--invalid {
        border-color: #fa755a;
    }

    .StripeElement--webkit-autofill {
         background-color: #fefde5 !important;
    }
</style>
@endsection

@section('content')
    <div class="box box-info">
        <div class="box-header with-border">
            <h3 class="box-title">Credit or debit card</h3>
        </div>
        <div class="box-body">
            <div class="control-group">
                <form action="/charge" method="post" id="payment-form">
                    <div class="form-group form-row col-md-6">
                        <div id="card-element">
                        <!-- A Stripe Element will be inserted here. -->
                        </div>

                        <!-- Used to display form errors. -->
                        <div id="card-errors" role="alert"></div>
                    </div>
                    <div class="form-group form-row col-md-6">
                        <button id="verify_card_button" class="btn btn-info btn-md">Verify</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    {{ Form::open(['onsubmit' => 'return validateForm()', 'route' => 'admin.superadmin.plans.store', 'class' => '', 'role' => 'form', 'method' => 'post' , 'enctype' => 'multipart/form-data']) }}
    <div class="box box-success">
        <div class="box-header with-border">
            <h3 class="box-title">{{ trans('labels.backend.title.plan.create') }}</h3>
            <div class="box-tools pull-right">
                @include('backend.superadmin.plans.includes.partials.plans-header-buttons')
            </div>
        </div>
        <div class="box-body">
            <div class="control-group">
                {{ Form::textGroup('first_name', trans('First Name'), 'user', ['placeholder' => trans('First Name')]) }}
                {{ Form::textGroup('last_name', trans('Last Name'), 'user', ['placeholder' => trans('Last Name')]) }}
                {{ Form::textGroup('agency_name', trans('Agency Name'), 'info', ['placeholder' => trans('Agency Name')]) }}
                {{ Form::textGroup('phone', trans('Phone'), 'phone', ['placeholder' => trans('Phone')]) }}
                {{ Form::textGroup('email', trans('Email'), 'envelope', ['placeholder' => trans('Email')]) }}
                {{ Form::passwordGroup('password', trans('Password'), 'secret', ['placeholder' => trans('Password')]) }}
                {{ Form::textGroup('website', trans('Website'), 'globe', ['placeholder' => trans('Website')]) }}
                {{ Form::textGroup('transection_price', trans('Transaction Price'), 'money', ['placeholder' => trans('Transection Price')]) }}
                {{ Form::selectGroup('country', trans('validation.attributes.backend.settings.country'), 'flag', $countries, $selected, []) }}
                {{ Form::selectGroup('state', trans('State'), 'flag', $states, '', []) }}
                {{ Form::selectGroup('city', trans('City'), 'flag', [],'' , []) }}
                {{ Form::textGroup('address', trans('Address'), 'envelope', ['placeholder' => trans('Address')]) }}
                {{ Form::textGroup('zip_code', trans('Zip Code'), 'envelope', ['placeholder' => trans('Zip Code')]) }}
                <input type="hidden" id="stripeToken" name="stripeToken" value="" />
                <div id="alert" class="form-group col-md-10">
                </div>
            </div>
        </div>
    </div>
        <div class="box box-info">
            <div class="box-body">
                <div class="pull-left">
                    {{ link_to_route('admin.superadmin.plans.index', trans('buttons.general.cancel'), [], ['class' => 'btn btn-danger btn-md']) }}
                </div>
                
                <div class="pull-right">
                    {{ Form::submit(trans('buttons.general.crud.create'), ['class' => 'btn btn-success btn-md']) }}
                </div>
                <div class="clearfix"></div>
            </div>
        </div>
    {{ Form::close() }}
@stop

@section('after-scripts')
    <script src="https://js.stripe.com/v3/"></script>
    <script>
    function validateForm() {
        var token = $('#stripeToken').val();
        var alert = '';
        if(!!token) {
            $('#alert').html(alert);
            return true;
        }
        alert += '<div class="alert alert-danger">' +
                        "Please verify Your Credit Card First" +
                        '<button type="button" class="close" data-dismiss="alert" aria-label="Close">' +
                            '<span aria-hidden="true">&times;</span>' +
                        '</button>' +
                    '</div>';
        $('#alert').html(alert);
        return false;
    }
    </script>
    <script>
    // Create a Stripe client.
    var stripe = Stripe('{{ env("STRIPE_KEY") }}');

    // Create an instance of Elements.
    var elements = stripe.elements();

    // Custom styling can be passed to options when creating an Element.
    // (Note that this demo uses a wider set of styles than the guide below.)
    var style = {
        base: {
            color: '#32325d',
            fontFamily: '"Helvetica Neue", Helvetica, sans-serif',
            fontSmoothing: 'antialiased',
            fontSize: '16px',
            '::placeholder': {
            color: '#aab7c4'
            }
        },
        invalid: {
            color: '#fa755a',
            iconColor: '#fa755a'
        }
    };

    // Create an instance of the card Element.
    var card = elements.create('card', {style: style});

    // Add an instance of the card Element into the `card-element` <div>.
    card.mount('#card-element');

    // Handle real-time validation errors from the card Element.
    card.addEventListener('change', function(event) {
        var displayError = document.getElementById('card-errors');
        if (event.error) {
            displayError.textContent = event.error.message;
        } else {
            displayError.textContent = '';
        }
    });

    // Handle form submission.
    var form = document.getElementById('payment-form');
    form.addEventListener('submit', function(event) {
        event.preventDefault();
        $('#verify_card_button').text('Verifying...').attr('disabled', 'true');
        stripe.createToken(card).then(function(result) {
            if (result.error) {
                // Inform the user if there was an error.
                var errorElement = document.getElementById('card-errors');
                errorElement.textContent = result.error.message;
            } else {
                // Send the token to your server.
                stripeTokenHandler(result.token);
            }
        });
    });

    // Submit the form with the token ID.
    function stripeTokenHandler(token) {
        // Insert the token ID into the form so it gets submitted to the server
        var form = document.getElementById('payment-form');
        $('#stripeToken').val(token.id);
        $('#alert').html('');
        $('#verify_card_button').text('Verified').removeClass('btn-info').addClass('btn-success').attr('disabled', 'true');
        // Submit the form
        // form.submit();
    }

    </script>
    <script>
        $(function () {
            $('#state').on('change', function () {
                console.log($(this).val());
                var id = $(this).val();
                $.ajax({
                    method: "GET",
                    url: '{{url('admin/superadmin/cities') }}' + '/' + id,
                    type: "html"
                }).done(function (data) {
                    $('#city').html(data.html);
                }).fail(function(error) {
                    console.log(error);
                });
            });

            $('#country').on('change', function () {
                console.log($(this).val());
                var id = $(this).val();
                $.ajax({
                    method: "GET",
                    url: '{{url('admin/superadmin/states') }}' + '/' + id,
                    type: "html"
                }).done(function (data) {
                    $('#state').html(data.html);
                }).fail(function(error) {
                    console.log(error);
                });
            });
        });
    </script>

    <script>
        var text_yes = '{{ trans('general.yes') }}';
        var text_no = '{{ trans('general.no') }}';

        $(document).ready(function() {
            $("#type").select2({
                placeholder: "{{ trans('Day', ['field' => trans('general.generalstrings.type')]) }}"
            });
            $("#drivercount").select2({
                placeholder: "{{ trans('validation.attributes.backend.plan.numberofdriver', ['field' => trans('validation.attributes.backend.plan.numberofdriver')]) }}"});
            $("#country").select2({
                placeholder: "{{ trans('Please Select', ['field' => trans('Please Select')]) }}"});
            $("#city").select2({
                placeholder: "{{ trans('Select Country First', ['field' => trans('general.generalstrings.status')]) }}"
            });
        });
    </script>

@stop
