@extends ('backend.layouts.app')

@section ('title', trans('Wallet Management'))

@section('after-styles')
    {{ Html::style("css/backend/plugin/datatables/dataTables.bootstrap.min.css") }}
@stop

@section('page-header')
    <h1>
        {{ trans('Wallet Management') }}
        <small>{{ trans('labels.backend.currency.active') }}</small>
    </h1>
@endsection

@section('content')
    <div class="box box-success">
        <div class="box-header with-border">
            <h3 class="box-title">{{ trans('labels.backend.currency.active') }}</h3>
            <div class="box-tools pull-right">
                @include('backend.superadmin.currency.includes.partials.currency-header-buttons')
            </div>
        </div>
        <div class="box-body">
            <div class="table-responsive">
                <table id="currency-table" class="table table-condensed table-hover">
                    <thead>
                    <tr>
                        <th>{{ trans('Agency Name') }}</th>
                        <th>{{ trans('labels.backend.currency.table.currency_code') }}</th>
                        <th>{{ trans('Amount') }}</th>
                        <th>{{ trans('labels.backend.currency.table.created_at') }}</th>
                    </tr>
                    </thead>
                </table>
            </div>
        </div>
    </div>

@stop

@section('after-scripts')
    {{ Html::script("js/backend/plugin/datatables/jquery.dataTables.min.js") }}
    {{ Html::script("js/backend/plugin/datatables/dataTables.bootstrap.min.js") }}

    <script>
        $(function () {
            $('#currency-table').DataTable({
                processing: true,
                serverSide: true,
                ajax: {
                    url: '{{ route("admin.superadmin.currencyget.get") }}',
                    type: 'get'
                },
                columns: [
                    {data: 'agency_id', name: '{{config('ubereat.currency')}}.agency_id'},
                    {
                        data: 'currency_code',
                        name: '{{config('ubereat.currency')}}.currency_code',
                        render: $.fn.dataTable.render.text()
                    },
                    {data: 'amount', name: '{{config('ubereat.currency')}}.amount'},
                    {data: 'created_at', name: '{{config('ubereat.currency')}}.created_at'},
                ],
                order: [[0, "desc"]],
                searchDelay: 500
            });
        });
    </script>
@stop
