@extends ('backend.layouts.app')

@section ('title', trans('labels.backend.currency.management') . ' | ' . trans('labels.backend.currency.edit'))

@section('page-header')
    <h1>
        {{ trans('labels.backend.currency.management') }}
        <small>{{ trans('') }}</small>
    </h1>
@endsection

@section('content')
    {{ Form::model($currency, ['route' => ['admin.superadmin.currency.update', $currency], 'class' => '', 'role' => 'form', 'method' => 'PATCH']) }}

    <div class="box box-success">
        <div class="box-header with-border">
            <h3 class="box-title">{{ trans('labels.backend.currency.edit') }}</h3>
            <div class="box-tools pull-right">
                @include('backend.superadmin.currency.includes.partials.currency-header-buttons')
            </div>
        </div>
        <div class="box-body">
            <div class="control-group">
                {{ Form::textGroup('currency_code', trans('validation.attributes.backend.currency.currency_code'), 'info', ['placeholder' => trans('validation.attributes.backend.currency.currency_code')]) }}
                {{ Form::textGroup('currency_symbol', trans('validation.attributes.backend.currency.currency_symbol'), 'usd', ['placeholder' => trans('validation.attributes.backend.currency.currency_symbol')]) }}
                {{ Form::selectGroup('status', trans('validation.attributes.backend.plan.status'), 'caret-down', ['1'=>'Published','0'=>'Pending','2'=>'Draft'], null, []) }}
            </div>
        </div>
    </div>
    <div class="box box-info">
        <div class="box-body">
            <div class="pull-left">
                {{ link_to_route('admin.superadmin.currency.index', trans('buttons.general.cancel'), [], ['class' => 'btn btn-danger btn-md']) }}
            </div>
            <div class="pull-right">
                {{ Form::submit(trans('buttons.general.crud.update'), ['class' => 'btn btn-success btn-md']) }}
            </div>
            <div class="clearfix"></div>
        </div>
    </div>
    {{ Form::close() }}
@stop

@section('after-scripts')
    {{ Html::script('js/backend/access/users/script.js') }}
    <script>
        $(document).ready(function() {


            $("#type").select2({
                placeholder: "{{ trans('Day', ['field' => trans('settings.localisation.date.format')]) }}"
            });

            $("#status").select2({
                placeholder: "{{ trans('Published', ['field' => trans('settings.localisation.date.format')]) }}"
            });

        });
    </script>
@stop
