@extends ('backend.layouts.app')

@section ('title', trans('Wallet Management') . ' | ' . trans('labels.backend.currency.create'))

@section('page-header')
    <h1>
        {{ trans('Wallet Management') }}
        <small>{{ trans('labels.backend.currency.create') }}</small>
    </h1>
@endsection

@section('content')
{{--    {{ Form::open(['route' => 'admin.superadmin.currency.store', 'class' => '', 'role' => 'form', 'method' => 'post' , 'enctype' => 'multipart/form-data']) }}--}}

    <div class="box box-success">
        <div class="box-header with-border">
            <h3 class="box-title">{{ trans('labels.backend.currency.create') }}</h3>
            <div class="box-tools pull-right">
                @include('backend.superadmin.currency.includes.partials.currency-header-buttons')
            </div>
        </div>
        <div class="box-body">
            <div class="control-group">
                {{ Form::selectGroup('payment_method', trans('Payment Method'), 'caret-down', ['1'=>'Cash','2'=>'Credit Card'], []) }}
{{--                {{ Form::textGroup('amount', trans('Amount'), 'usd', ['placeholder' => trans('Amount')]) }}--}}
            </div>
        </div>
    </div>
    {{--<div class="box box-info">--}}
        {{--<div class="box-body">--}}
            {{--<div class="pull-left">--}}
                {{--{{ link_to_route('admin.superadmin.plans.index', trans('buttons.general.cancel'), [], ['class' => 'btn btn-danger btn-md']) }}--}}
            {{--</div>--}}
            {{--<div class="pull-right">--}}
                {{--{{ Form::submit(trans('buttons.general.crud.create'), ['class' => 'btn btn-success btn-md']) }}--}}
            {{--</div>--}}
            {{--<div class="clearfix"></div>--}}
        {{--</div>--}}
    {{--</div>--}}
    {{ Form::close() }}
    <div id="menual" style="display: none;">
    {{ Form::open(['route' => 'admin.superadmin.currency.store', 'class' => '', 'role' => 'form', 'method' => 'post' , 'enctype' => 'multipart/form-data']) }}

    <div class="box box-success">
        {{--<div class="box-header with-border">--}}
            {{--<h3 class="box-title">{{ trans('labels.backend.currency.create') }}</h3>--}}
            {{--<div class="box-tools pull-right">--}}
                {{--@include('backend.superadmin.currency.includes.partials.currency-header-buttons')--}}
            {{--</div>--}}
        {{--</div>--}}
        <div class="box-body">
            <div class="control-group">
                {{ Form::hidden('currency_code', 'USD') }}
                {{ Form::selectGroup('agency_id', trans('Agency'), 'users',$agency, null,[]) }}
                {{ Form::textGroup('amount', trans('Amount'), 'usd', ['placeholder' => trans('Amount')]) }}
            </div>
        </div>
    </div>
    <div class="box box-info">
        <div class="box-body">
            <div class="pull-left">
                {{ link_to_route('admin.superadmin.plans.index', trans('buttons.general.cancel'), [], ['class' => 'btn btn-danger btn-md']) }}
            </div>
            <div class="pull-right">
                {{ Form::submit(trans('buttons.general.crud.create'), ['class' => 'btn btn-success btn-md']) }}
            </div>
            <div class="clearfix"></div>
        </div>
    </div>
    {{ Form::close() }}
    </div>

    <div class="container" id="cardd" style="display: none;">
        <div class="row pb-100"></div>
        <div class="row pb-100"></div>
        <div class="row pb-50"></div>
        <div class="row">

            <form class="form-horizontal" method="POST" id="payment-form" role="form" action="{!! URL::route('frontend.paywithstripe') !!}" >
                {{ csrf_field() }}
                <div class="form-group{{ $errors->has('agency_id') ? ' has-error' : '' }}"><br>
                    <label for="card_no" class="col-md-4 control-label">Select Agency</label>
                    <div class="col-md-6">
                        {{ Form::selectGroup('agency_id', trans('Agency'), 'users',$agency, null,[]) }}
                        @if ($errors->has('agency_id'))
                            <span class="help-block">
                                        <strong>{{ $errors->first('agency_id') }}</strong>
                                    </span>
                        @endif
                    </div>
                </div>

                <div class="form-group{{ $errors->has('card_no') ? ' has-error' : '' }}"><br>
                    <label for="card_no" class="col-md-4 control-label">Card No</label>
                    <div class="col-md-6">
                        <input id="card_no" type="text" class="form-control" name="card_no" value="{{ old('card_no') }}" autofocus>
                        @if ($errors->has('card_no'))
                            <span class="help-block">
                                        <strong>{{ $errors->first('card_no') }}</strong>
                                    </span>
                        @endif
                    </div>
                </div>
                <div class="form-group{{ $errors->has('ccExpiryMonth') ? ' has-error' : '' }}">
                    <label for="ccExpiryMonth" class="col-md-4 control-label">Expiry Month</label>
                    <div class="col-md-6">
                        <input id="ccExpiryMonth" type="text" class="form-control" name="ccExpiryMonth" value="{{ old('ccExpiryMonth') }}" autofocus>
                        @if ($errors->has('ccExpiryMonth'))
                            <span class="help-block">
                                        <strong>{{ $errors->first('ccExpiryMonth') }}</strong>
                                    </span>
                        @endif
                    </div>
                </div>
                <div class="form-group{{ $errors->has('ccExpiryYear') ? ' has-error' : '' }}">
                    <label for="ccExpiryYear" class="col-md-4 control-label">Expiry Year</label>
                    <div class="col-md-6">
                        <input id="ccExpiryYear" type="text" class="form-control" name="ccExpiryYear" value="{{ old('ccExpiryYear') }}" autofocus>
                        @if ($errors->has('ccExpiryYear'))
                            <span class="help-block">
                                        <strong>{{ $errors->first('ccExpiryYear') }}</strong>
                                    </span>
                        @endif
                    </div>
                </div>
                <div class="form-group{{ $errors->has('cvvNumber') ? ' has-error' : '' }}">
                    <label for="cvvNumber" class="col-md-4 control-label">CVV No.</label>
                    <div class="col-md-6">
                        <input id="cvvNumber" type="text" class="form-control" name="cvvNumber" value="{{ old('cvvNumber') }}" autofocus>
                        @if ($errors->has('cvvNumber'))
                            <span class="help-block">
                                        <strong>{{ $errors->first('cvvNumber') }}</strong>
                                    </span>
                        @endif
                    </div>
                </div>
                <div class="form-group{{ $errors->has('amount') ? ' has-error' : '' }}">
                    <label for="cvvNumber" class="col-md-4 control-label">Amount</label>
                    <div class="col-md-6">
                        <input id="amount" type="text" class="form-control" name="amount" value="{{ old('amount') }}" autofocus>
                        @if ($errors->has('amount'))
                            <span class="help-block">
                                        <strong>{{ $errors->first('amount') }}</strong>
                                    </span>
                        @endif
                    </div>
                </div>
                <div id="msg">
                    {{--<div class="form-group{{ $errors->has('amount') ? ' has-error' : '' }}">--}}
                        {{--<div class="col-md-6">--}}
                            {{--<input id="amount" type="hidden" class="form-control" name="amount" autofocus>--}}
                        {{--</div>--}}
                    {{--</div>--}}

                    <style>
                        .btn{
                            background-color: #F6AB36;
                            width: 130px;
                        }
                        #butt{
                            position: relative;
                            margin-left: -100px;
                        }
                    </style>
                    <div class="form-group">
                        <div class="col-md-6 col-md-offset-4">
                            <div id="butt">
                                {{ Form::submit(trans('Confirm'), ['class' => 'btn']) }}
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
    </div>
    <div class="row pb-100"></div>


@stop
@section('after-scripts')

    <script>
        $(document).ready(function () {

            $('#payment_method').on('change', function() {
                if (this.value == '2') {
                    $("#cardd").show();
                    $("#menual").hide();
                }
                 else if(this.value == '1') {
                    $("#menual").show();
                    $("#cardd").hide();
                }
//                else
//                    $("#cardd").hide();
            }).trigger("change");

        });
    </script>

    <script>
        var text_yes = '{{ trans('general.yes') }}';
        var text_no = '{{ trans('general.no') }}';

        $(document).ready(function() {


            $("#type").select2({
                placeholder: "{{ trans('Day', ['field' => trans('general.generalstrings.type')]) }}"
            });

            $("#drivercount").select2({
                placeholder: "{{ trans('validation.attributes.backend.plan.numberofdriver', ['field' => trans('validation.attributes.backend.plan.numberofdriver')]) }}"});


            $("#allowedtask").select2({
                placeholder: "{{ trans('validation.attributes.backend.plan.allowedtask', ['field' => trans('validation.attributes.backend.plan.allowedtask')]) }}"});

            $("#status").select2({
                placeholder: "{{ trans('Published', ['field' => trans('general.generalstrings.status')]) }}"
            });


        });
    </script>

@stop
