@extends ('backend.layouts.app')

@section ('title', trans('Leads Management') . ' | ' . trans('Verified'))

@section('page-header')
    <h1>
        {{ trans('Leads Management') }}
        <small>{{ trans('') }}</small>
    </h1>
@endsection

@section('content')

    {{ Form::model($result, ['route' => ['admin.customers.validleads.update', $result->id], 'class' => '', 'role' => 'form', 'method' => 'PATCH']) }}
    <div class="box box-success">
        <div class="box-header with-border">
            <h3 class="box-title">{{ trans('Transfer') }}</h3>
            <div class="box-tools pull-right">
            </div><!--box-tools pull-right-->
        </div><!-- /.box-header -->
        <div class="row mt-4 mb-4">
            <div class="col">
                {{ Form::selectGroup('agent_id', trans('Agent'), 'users',$agents, null,[]) }}
            </div><!--col-->
        </div><!--row-->
        <div class="box box-info">
            <div class="box-body">
                <div class="pull-left">
                    <a href="{{ URL::route('admin.superadmin.chat') }}"
                       onclick="window.open('{{ URL::route('admin.superadmin.chat') }}',
                               'newwindow',
                               'width=700,height=700');
                               return false;"
                       class="btn btn-success btn-md">Chat NOW</a>
                </div><!--pull-left-->
                <div class="clearfix"></div>
            </div><!-- /.box-body -->
        </div><!--box-->
        <hr>
        <div class="row mt-4 mb-4">
            <div class="col">
                {{ Form::textGroup('first_name', trans('First Name'), 'users', ['placeholder' => trans('First Name'),'readonly' => 'true']) }}
                {{ Form::textGroup('last_name', trans('Last Name'), 'users', ['placeholder' => trans('Last Name'),'readonly' => 'true']) }}
                {{ Form::textGroup('phone', trans('Phone'), 'phone', ['placeholder' => trans('Phone'),'readonly' => 'true']) }}
                {{ Form::textGroup('mobile', trans('Mobile'), 'mobile', ['placeholder' => trans('Mobile'),'readonly' => 'true']) }}
                {{ Form::textGroup('email', trans('Email'), 'envelope', ['placeholder' => trans('Email'),'readonly' => 'true']) }}
                {{ Form::textGroup('agency', trans('Agency Name'), 'user', ['placeholder' => trans('Email'),'readonly' => 'true']) }}
            </div><!--col-->
        </div><!--row-->
        <div class="row mt-4 mb-4">
            <div class="col">
                {{ Form::label('head_line', trans('Which data to transfer ?')) }}<br>
            </div>
        </div>
        <div class="row mt-4 mb-4">
            <div class="col">
                <?php $count = 0 ?>
                @foreach($table as $key=>$tab)
                    <?php $count++ ?>
                    @if($count >= 7 && $count < 53)
                        <div class="col-sm-4">
                            {{ Form::checkbox('services[]',$tab) }}&nbsp;&nbsp;<?php echo str_replace('_', ' ', $tab) ?>
                        </div>
                    @endif
                @endforeach
            </div>
        </div>
    </div><!--card-body-->
    <div class="box box-info">
        <div class="box-body">
            <div class="pull-left">
                {{ link_to_route('admin.customers.leads.index', trans('buttons.general.cancel'), [], ['class' => 'btn btn-danger btn-md']) }}
            </div><!--pull-left-->
            <div class="pull-right">
                {{ Form::submit(trans('Transfer'), ['class' => 'btn btn-success btn-md']) }}
            </div><!--pull-right-->
            <div class="clearfix"></div>
        </div><!-- /.box-body -->
    </div><!--box-->
    {{ Form::close() }}
@stop

@section('after-scripts')

    <script>
        $(function () {
            $('#agent_id').on('change', function () {
                console.log($(this).val());
                var id = $(this).val();
                $.ajax({
                    method: "GET",
                    url: '{{url('admin/customers/infoget') }}' + '/' + id
                }).done(function (msg) {
                    $('#first_name').val(msg.first_name);
                    $('#last_name').val(msg.last_name);
                    $('#phone').val(msg.phone);
                    $('#mobile').val(msg.mobile);
                    $('#email').val(msg.email);
                    $('#agency').val(msg.agency);
                });
            });
        });
    </script>
    <script>
        var text_yes = '{{ trans('general.yes') }}';
        var text_no = '{{ trans('general.no') }}';
        $(document).ready(function () {
            $("#agent_id").select2({
                placeholder: "{{ trans('Agent', ['field' => trans('Agent')]) }}"
            });
        });
    </script>
@stop