@extends ('backend.layouts.app')

@section ('title', trans('Leads Management'))
{{--{{dd($count)}}--}}
@section('after-styles')
    {{ Html::style("css/backend/plugin/datatables/dataTables.bootstrap.min.css") }}
@stop

@section('page-header')
    <h1>
        {{ trans('Leads Management') }}
        <small>{{ trans('labels.backend.contacts.active') }}</small>
    </h1>
@endsection
@if ($count == 0)
@section('content')
    <div class="box box-success">
        <div class="box-header with-border">
            <h3 class="box-title">{{ trans('labels.backend.contacts.active') }}</h3>

            <div class="box-tools pull-right">
            </div><!--box-tools pull-right-->
        </div><!-- /.box-header -->

        <div class="box-body">
            <div class="table-responsive">
                <table id="leads-table" class="table table-condensed table-hover">
                    <thead>
                    <tr>
                        <th>{{ trans('First Name') }}</th>
                        <th>{{ trans('Last Name') }}</th>
                        <th>{{ trans('Phone') }}</th>
                        <th>{{ trans('Email') }}</th>
                        @if(!access()->hasRole('Administrator'))
                            <th>{{ trans('labels.general.actions') }}</th>
                        @endif

                    </tr>
                    </thead>
                </table>
            </div><!--table-responsive-->
        </div><!-- /.box-body -->
    </div><!--box-->

@stop

@section('after-scripts')
    {{ Html::script("js/backend/plugin/datatables/jquery.dataTables.min.js") }}
    {{ Html::script("js/backend/plugin/datatables/dataTables.bootstrap.min.js") }}

    <script>
        $(function () {
            $('#leads-table').DataTable({
                processing: true,
                serverSide: true,
                ajax: {
                    url: '{{ route("admin.customers.contactget.get") }}',
                    type: 'get'
                },
                columns: [
                    {data: 'id', name: '{{config('ubereat.contacts')}}.id'},

                    {data: 'fname', name: '{{config('ubereat.contacts')}}.fname', render: $.fn.dataTable.render.text()},
                    {data: 'lname', name: '{{config('ubereat.contacts')}}.lname'},
                    {data: 'pphone', name: '{{config('ubereat.contacts')}}.pphone'},
                    {data: 'email', name: '{{config('ubereat.contacts')}}.email'},
                        @if(!access()->hasRole('Administrator'))
                    {
                        data: 'actions', name: 'actions', searchable: false, sortable: false
                    }
                    @endif
                ],
                order: [[0, "asc"]],
                searchDelay: 500
            });
        });
    </script>
@stop

@else
@section('content')
    <div class="box box-success">
        <div class="box-header with-border">
            <h3 class="box-title">{{ trans('labels.backend.contacts.active') }}</h3>

            <div class="box-tools pull-right">
            </div><!--box-tools pull-right-->
        </div><!-- /.box-header -->

        <div class="box-body">
            <div class="table-responsive">
                <table id="contacts-table" class="table table-condensed table-hover">
                    <thead>
                    @foreach($settings as $setting)
                        <th><?php echo str_replace('general.', '', $setting->key) ?></th>
                    @endforeach
                    <th>@lang('Action')</th>
                    </thead>
                </table>
            </div><!--table-responsive-->
        </div><!-- /.box-body -->
    </div><!--box-->

@stop

@section('after-scripts')
    {{ Html::script("js/backend/plugin/datatables/jquery.dataTables.min.js") }}
    {{ Html::script("js/backend/plugin/datatables/dataTables.bootstrap.min.js") }}

    <script>
        $(function () {
            $('#contacts-table').DataTable({
                processing: true,
                serverSide: true,
                ajax: {
                    url: '{{ route("admin.customers.leadsget.get") }}',
                    type: 'get'
                },
                columns: [
                        @foreach($settings as $setting)
                    {
                        data: '<?php echo str_replace('general.', '', $setting->key) ?>',
                        name: '{{config('ubereat.contacts')}}.<?php echo str_replace('general.', '', $setting->key) ?>',
                        render: $.fn.dataTable.render.text()
                    },
                        @endforeach
                    {
                        data: 'actions', name: 'actions', searchable: false, sortable: false
                    }
                ],
                order: [[0, "asc"]],
                searchDelay: 500
            });
        });
    </script>
@stop
@endif
